/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Property;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.HvacUtil;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.PointListEditor;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Pair;

public class DuctEditor
implements ModelObjectDialog.IEditor<HvacDuct> {
    private final PyroMod d_domain;
    private final guiTextField d_nameFld;
    private final guiTextField d_fyi;
    private final guiTextField d_networkId;
    private final ValueField<UnitDouble> d_areaFld;
    private final ValueField<UnitDouble> d_perimeterFld;
    private final ValueField<UnitDouble> d_diaFld;
    private final guiRadioButton d_autoLenRB;
    private final guiRadioButton d_fixedLenRB;
    private final ValueField<UnitDouble> d_lengthFld;
    private final guiRadioButton d_circularBtn;
    private final guiRadioButton d_nonCircularBtn;
    private final guiComboBox<HvacNode> d_fromNodeCB;
    private final guiComboBox<HvacNode> d_toNodeCB;
    private final guiLabel d_flare1;
    private final guiLabel d_flare2;
    private final PointListEditor d_waypointEditor;
    private final guiPanel d_waypointPnl;
    private final guiPanel d_flowPnl;
    private final ValueField<UnitDouble> d_forwardLossFld;
    private final ValueField<UnitDouble> d_reverseLossFld;
    private final guiComboBox<HvacDuct.FrictionType> d_roughnessTypeCB;
    private final ValueField<UnitDouble> d_roughFld;
    private final guiComboBox<IFlowDevcEditor> d_flowDevcEditorCB;
    private guiPanel d_dlgPanel;
    private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;
    private static final Composite.IObjectProp<HvacDuct, UnitDouble> volflowProp = new Composite.AObjectProp<HvacDuct, UnitDouble>(HvacDuct.class){

        @Override
        public Object get(HvacDuct obj) {
            return ((UnitDouble)obj.getVolflow().val).abs();
        }

        @Override
        public void set(HvacDuct obj, UnitDouble prop) {
            obj.setVolflow(new TimeBasedValue<UnitDouble>(prop, obj.getVolflow().func));
        }
    };
    private static final Composite.IObjectProp<HvacDuct, TimeFunction> volflowRampProp = new Composite.AObjectProp<HvacDuct, TimeFunction>(HvacDuct.class){

        @Override
        public Object get(HvacDuct obj) {
            return obj.getVolflow().func;
        }

        @Override
        public void set(HvacDuct obj, TimeFunction prop) {
            obj.setVolflow(new TimeBasedValue<UnitDouble>((UnitDouble)obj.getVolflow().val, prop));
        }
    };
    private static final StandardProp<String> fyiProp = new StandardProp<String>(HvacComponent::getDesc, HvacComponent::setDesc);
    private static final GenericProp<String> networkIdProp = new GenericProp("NETWORK_ID");
    private static final GenericProp<UnitDouble> lossProp = new GenericProp("LOSS");
    private static final GenericProp<UnitDouble> lengthProp = new GenericProp("LENGTH");
    private static final GenericProp<HvacDuct.Shape> shapeProp = new GenericProp("opt_shape");
    private static final GenericProp<UnitDouble> areaProp = new GenericProp("AREA");
    private static final GenericProp<UnitDouble> diamProp = new GenericProp("DIAMETER");
    private static final GenericProp<UnitDouble> perimProp = new GenericProp("PERIMETER");
    private static final GenericProp<UnitDouble> roughnessProp = new GenericProp("ROUGHNESS");
    private static final GenericProp<HvacDuct.FrictionType> roughTypeProp = new GenericProp("opt_friction_type");
    private static final GenericProp<HvacDuct.AirflowObj> airflowProp = new GenericProp("opt_none_damper_fan");
    private static final ReverseVolFlowProp revVolFlowProp = new ReverseVolFlowProp();
    private static final GenericProp<Boolean> revProp = new GenericProp("REVERSE");
    private static GenericProp<HvacAircoil> aircoilProp = new GenericProp("AIRCOIL_ID");
    private static final GenericProp<HvacFan> fanProp = new GenericProp("FAN_ID");
    private static final Composite.IObjectProp<HvacDuct, ControlBridge> ctrlProp = ControlSelPnl.getControlProp(HvacDuct.class);

    public DuctEditor(PyroMod mod, guiTextField nameFld) {
        this.d_dlgPanel = new guiPanel(){
            private static final long serialVersionUID = 9115036219863490523L;

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return DuctEditor.this.validateData((Component)DuctEditor.this.d_dlgPanel, Collections.emptyList(), showWarn, allowModify);
            }
        };
        this.d_domain = mod;
        this.d_nameFld = nameFld;
        this.d_networkId = new guiTextField();
        this.d_networkId.setToolTipText(Intl.intl("HVAC duct Network ID"));
        this.d_fyi = new guiTextField();
        this.d_fyi.setToolTipText(Intl.intl("FYI"));
        this.d_roughnessTypeCB = new guiComboBox<HvacDuct.FrictionType>(HvacDuct.FrictionType.values());
        this.d_roughnessTypeCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof HvacDuct.FrictionType) {
                    this.setText(((HvacDuct.FrictionType)((Object)value)).displayName);
                }
                return this;
            }
        });
        this.d_roughFld = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_roughFld.setNullAllowed(true);
        this.d_roughnessTypeCB.addItemListener(e -> {
            HvacDuct.FrictionType type = this.d_roughnessTypeCB.getSelectedItem();
            boolean showField = type != null && type.equals((Object)HvacDuct.FrictionType.EXPLICIT);
            this.d_roughFld.setEnabled(showField);
            this.d_roughFld.setVisible(showField);
            if (this.d_roughFld.getParent() != null) {
                this.d_roughFld.getParent().validate();
            }
        });
        this.d_roughnessTypeCB.setSelectedItem((Object)HvacDuct.FrictionType.EXPLICIT);
        this.d_circularBtn = new guiRadioButton(Intl.intl("Circular"));
        this.d_nonCircularBtn = new guiRadioButton(Intl.intl("Non-circular"));
        new guiButtonGroup(this.d_circularBtn, this.d_nonCircularBtn);
        guiLabel areaLbl = new guiLabel(Intl.intl("Area:"));
        this.d_areaFld = ValueFields.udFld(UnitSystem.getSource(79));
        guiLabel diaLbl = new guiLabel(Intl.intl("Diameter:"));
        this.d_diaFld = ValueFields.udFld(UnitSystem.getSource(0));
        guiLabel perLbl = new guiLabel(Intl.intl("Perimeter:"));
        this.d_perimeterFld = ValueFields.udFld(UnitSystem.getSource(0));
        LinkStatus.link((AbstractButton)this.d_nonCircularBtn, areaLbl, this.d_areaFld, perLbl, this.d_perimeterFld);
        LinkStatus.link((AbstractButton)this.d_circularBtn, diaLbl, this.d_diaFld);
        Stream.of(this.d_areaFld, this.d_diaFld, this.d_perimeterFld).forEach(fld -> fld.setNullAllowed(true));
        this.d_autoLenRB = new guiRadioButton(Intl.intl("Automatic"));
        this.d_autoLenRB.setToolTipText(Intl.intl("Length is calculated as the distance between the connected nodes."));
        this.d_fixedLenRB = new guiRadioButton(Intl.intl("Fixed:"));
        this.d_lengthFld = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_lengthFld.setNullAllowed(true);
        LinkStatus.link((AbstractButton)this.d_fixedLenRB, this.d_lengthFld);
        new guiButtonGroup(this.d_autoLenRB, this.d_fixedLenRB);
        this.d_fromNodeCB = new PyroComboBox<HvacNode>(mod.getObstructions(), HvacNode.class);
        this.d_flare1 = new guiLabel(PyroGuiUtil.loadPyroSimIcon("bad.png"));
        this.d_flare1.setToolTipText(Intl.intl("Node must be unique."));
        this.d_toNodeCB = new PyroComboBox<HvacNode>(mod.getObstructions(), HvacNode.class);
        this.d_flare2 = new guiLabel(PyroGuiUtil.loadPyroSimIcon("bad.png"));
        this.d_flare2.setToolTipText(Intl.intl("Node must be unique."));
        ItemListener flareListener = e -> this.updateValidationFlares();
        this.d_fromNodeCB.addItemListener(flareListener);
        this.d_toNodeCB.addItemListener(flareListener);
        ItemListener autoLenLnr = e -> {
            if (e.getStateChange() != 1) {
                return;
            }
            if (!this.d_dlgPanel.validateData(false, false)) {
                return;
            }
            this.updateAutoLbl();
        };
        this.d_fromNodeCB.addItemListener(autoLenLnr);
        this.d_toNodeCB.addItemListener(autoLenLnr);
        this.d_forwardLossFld = ValueFields.udFld(UnitSystem.getSource(28));
        this.d_reverseLossFld = ValueFields.udFld(UnitSystem.getSource(28));
        Stream.of(this.d_forwardLossFld, this.d_reverseLossFld).forEach(fld -> fld.setNullAllowed(true));
        final CardLayout flowDevcLayout = new CardLayout();
        List<guiPanel> flowDevcEditors = Arrays.asList(new NoDevcPnl(), new DamperPnl(mod), new BasicFanPnl(mod), new AircoilPnl(mod), new FanPnl(mod));
        final guiPanel flowDevcPnl = new guiPanel(flowDevcLayout);
        for (IFlowDevcEditor iFlowDevcEditor : flowDevcEditors) {
            flowDevcPnl.add((Component)iFlowDevcEditor.getPanel(), iFlowDevcEditor.toString());
        }
        this.d_flowDevcEditorCB = new guiComboBox();
        this.d_flowDevcEditorCB.setModel(new DefaultComboBoxModel(new Vector<guiPanel>(flowDevcEditors)){
            private static final long serialVersionUID = -3777719222507922189L;

            @Override
            public void setSelectedItem(Object anObject) {
                IFlowDevcEditor editor;
                if (anObject instanceof IFlowDevcEditor && !(editor = (IFlowDevcEditor)anObject).getPanel().isEnabled()) {
                    return;
                }
                super.setSelectedItem(anObject);
            }
        });
        this.d_flowDevcEditorCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() != 1) {
                    return;
                }
                IFlowDevcEditor editor = (IFlowDevcEditor)e.getItem();
                flowDevcLayout.show(flowDevcPnl, editor.toString());
            }
        });
        this.d_flowDevcEditorCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 3922086684266902999L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                IFlowDevcEditor editor = (IFlowDevcEditor)value;
                if (editor != null) {
                    this.setEnabled(editor.getPanel().isEnabled());
                }
                return this;
            }
        });
        GridBagHelper gbProps = new GridBagHelper(this.d_dlgPanel, false);
        gbProps.addFilledRow(new TitleSeparator(Intl.intl("Length")));
        gbProps.addIdentRow(this.d_autoLenRB, 0);
        gbProps.addIdentRow(this.d_fixedLenRB, this.d_lengthFld, 0);
        gbProps.addFilledRow(new TitleSeparator(Intl.intl("Shape")));
        gbProps.indent();
        gbProps.addRow(this.d_circularBtn, 0);
        gbProps.addIdentRow(diaLbl, this.d_diaFld, 0);
        gbProps.addRow(this.d_nonCircularBtn, 0);
        gbProps.addIdentRow(areaLbl, this.d_areaFld, 0);
        gbProps.addIdentRow(perLbl, this.d_perimeterFld, 0);
        gbProps.finalizeRows();
        this.d_waypointEditor = new PointListEditor(false, 30);
        this.d_waypointPnl = new guiPanel();
        GridBagHelper gridBagHelper = new GridBagHelper(this.d_waypointPnl, true);
        gridBagHelper.addRow(this.d_waypointEditor, new double[]{1.0, 1.0}, new int[]{0, 0});
        gridBagHelper.finalizeRows();
        guiLabel fwdLossLbl = PyroGuiUtil.label(Intl.intl("Foward Loss:"), Intl.intl("The flow loss from Node 1 to Node 2."));
        guiLabel revLossLbl = PyroGuiUtil.label(Intl.intl("Reverse Loss:"), Intl.intl("The flow loss from Node 2 to Node 1."));
        this.d_flowPnl = new guiPanel();
        GridBagHelper gbFlow = new GridBagHelper(this.d_flowPnl, true);
        gbFlow.addRow(fwdLossLbl, this.d_forwardLossFld, 0);
        gbFlow.addRow(revLossLbl, this.d_reverseLossFld, 0);
        gbFlow.addRow(Intl.intl("Roughness:"), this.d_roughnessTypeCB, this.d_roughFld, 0);
        gbFlow.addRow(Intl.intl("Flow Device:"), this.d_flowDevcEditorCB, 0);
        gbFlow.addIdentRow(flowDevcPnl, new int[]{0, 0}, new double[]{1.0, 1.0});
        gbFlow.finalizeRows();
    }

    @Override
    public boolean validateData(Component parent, Collection<? extends HvacDuct> objs, boolean showWarn, boolean allowModify) {
        return true;
    }

    private void updateAutoLbl() {
        HvacNode fromNode = this.d_fromNodeCB.getSelectedItem();
        HvacNode toNode = this.d_toNodeCB.getSelectedItem();
        if (fromNode != null && toNode != null) {
            UnitDouble dist = HvacDuct.getDistance(fromNode, toNode);
            String txt = String.format(Intl.intl("Automatic (%s)"), PyroGuiUtil.format(dist, 0));
            this.d_autoLenRB.setText(txt);
        } else {
            this.d_autoLenRB.setText(Intl.intl("Automatic"));
        }
    }

    @Override
    public void add(ModelObjectDialog dlg, guiPanel basePanel) {
        basePanel.add(new guiLabel(Intl.intl("Network ID:")));
        basePanel.add((Component)this.d_networkId, "wrap");
        basePanel.add(new guiLabel(Intl.intl("FYI:")));
        basePanel.add((Component)this.d_fyi, "wrap");
        basePanel.add(new guiLabel(Intl.intl("Node 1:")));
        basePanel.add((Component)this.getPanelForComponents(this.d_fromNodeCB, this.d_flare1), "split 2, grow 0, wrap");
        basePanel.add(new guiLabel(Intl.intl("Node 2:")));
        basePanel.add((Component)this.getPanelForComponents(this.d_toNodeCB, this.d_flare2), "split 2, grow 0, wrap");
        basePanel.add((Component)this.d_dlgPanel, "span, grow");
    }

    private guiPanel getPanelForComponents(Component ... comp) {
        guiPanel n1 = new guiPanel(new MigLayout("insets 0, gap 6"));
        for (Component c : comp) {
            n1.add(c);
        }
        return n1;
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("HVAC Duct Properties");
    }

    @Override
    public Class<HvacDuct> getType() {
        return HvacDuct.class;
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        return Arrays.asList(new Pair<String, guiPanel>(Intl.intl("Waypoints"), this.d_waypointPnl), new Pair<String, guiPanel>(Intl.intl("Flow Model"), this.d_flowPnl));
    }

    @Override
    public boolean isControllable(HvacDuct obj) {
        return true;
    }

    private void updateValidationFlares() {
        boolean same;
        boolean bl = same = this.d_fromNodeCB.getSelectedItem() != null && this.d_fromNodeCB.getSelectedItem() == this.d_toNodeCB.getSelectedItem();
        if (this.d_ducts.size() == 1) {
            this.d_flare1.setVisible(this.d_fromNodeCB.getSelectedItem() == null || same);
            this.d_flare2.setVisible(this.d_toNodeCB.getSelectedItem() == null || same);
        } else {
            this.d_flare1.setVisible(same);
            this.d_flare2.setVisible(same);
        }
    }

    private static guiComboBox<Boolean> newDirCB() {
        guiComboBox<Boolean> dirCB = new guiComboBox<Boolean>((T[])new Boolean[]{false, true});
        DefaultListCellRenderer dirRenderer = new DefaultListCellRenderer(){
            private static final long serialVersionUID = -8808010086343633670L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    Boolean bval = (Boolean)value;
                    String text = bval != false ? Intl.intl("Node 2 to Node 1") : Intl.intl("Node 1 to Node 2");
                    this.setText(text);
                }
                return this;
            }
        };
        dirCB.setRenderer(dirRenderer);
        return dirCB;
    }

    @Override
    public void load(PyroMod domain, Collection<? extends HvacDuct> objs) {
        IFlowDevcEditor editor;
        int m;
        for (int m2 = 0; m2 < this.d_flowDevcEditorCB.getItemCount(); ++m2) {
            IFlowDevcEditor editor2 = this.d_flowDevcEditorCB.getItemAt(m2);
            editor2.updateEnabled(this.d_domain);
        }
        IFlowDevcEditor currEditor = this.d_flowDevcEditorCB.getSelectedItem();
        if (currEditor != null && !currEditor.getPanel().isEnabled()) {
            this.d_flowDevcEditorCB.setSelectedIndex(0);
        }
        Property fyi = Composite.getProp(fyiProp, objs);
        this.d_fyi.setText(fyi.orElse(Intl.intl("<multiple>")));
        Property networkId = Composite.getProp(networkIdProp, objs);
        this.d_networkId.setText(networkId.orElse(null));
        guiComboBox[] nodeCombos = new guiComboBox[]{this.d_fromNodeCB, this.d_toNodeCB};
        for (int m3 = 0; m3 < nodeCombos.length; ++m3) {
            Property<HvacNode> node = Composite.getProp(new NodeProp(m3), objs);
            nodeCombos[m3].setSelectedItem(node.orElse(null));
        }
        Property len = Composite.getProp(lengthProp, objs);
        if (!len.isUniform()) {
            this.d_fixedLenRB.setSelected(false);
            this.d_autoLenRB.setSelected(false);
        } else if (len.get() == null) {
            this.d_autoLenRB.setSelected(true);
            this.d_lengthFld.setValue(new UnitDouble(1.0, SI.METER));
        } else {
            this.d_fixedLenRB.setSelected(true);
            this.d_lengthFld.setValue(len.get());
        }
        Property shape = Composite.getProp(shapeProp, objs);
        if (shape.isUniform()) {
            switch ((HvacDuct.Shape)((Object)shape.get())) {
                case CIRCULAR: {
                    this.d_circularBtn.setSelected(true);
                    break;
                }
                case NON_CIRCULAR: {
                    this.d_nonCircularBtn.setSelected(true);
                }
            }
        } else {
            this.d_circularBtn.setSelected(false);
            this.d_nonCircularBtn.setSelected(false);
        }
        ValueField[] shapeFlds = new ValueField[]{this.d_areaFld, this.d_diaFld, this.d_perimeterFld};
        GenericProp[] shapeProps = new GenericProp[]{areaProp, diamProp, perimProp};
        for (int m4 = 0; m4 < shapeFlds.length; ++m4) {
            Property prop = Composite.getProp(shapeProps[m4], objs);
            shapeFlds[m4].setValue(prop.orElse(null));
        }
        ValueField[] flowFlds = new ValueField[]{this.d_forwardLossFld, this.d_reverseLossFld, this.d_roughFld};
        Composite.IObjectProp[] flowProps = new Composite.IObjectProp[]{new LossProp(0), new LossProp(1), roughnessProp};
        for (int m5 = 0; m5 < flowFlds.length; ++m5) {
            Property prop = Composite.getProp(flowProps[m5], objs);
            flowFlds[m5].setValue(prop.orElse(null));
        }
        Property friction = Composite.getProp(roughTypeProp, objs);
        this.d_roughnessTypeCB.setSelectedItem(friction.orElse(null));
        Property airflow = Composite.getProp(airflowProp, objs);
        int airflowIx = -1;
        if (airflow.isUniform()) {
            for (m = 0; m < this.d_flowDevcEditorCB.getItemCount(); ++m) {
                editor = this.d_flowDevcEditorCB.getItemAt(m);
                HvacDuct.AirflowObj edAirflow = editor.getDevcType();
                if (edAirflow != airflow.get()) continue;
                airflowIx = m;
                break;
            }
        }
        this.d_flowDevcEditorCB.setSelectedIndex(airflowIx);
        for (m = 0; m < this.d_flowDevcEditorCB.getItemCount(); ++m) {
            editor = this.d_flowDevcEditorCB.getItemAt(m);
            editor.load(objs, this.d_nameFld);
        }
        if (objs.size() == 1 && objs.iterator().hasNext()) {
            HvacDuct duct = objs.iterator().next();
            this.d_waypointEditor.load((Collection)duct.getProp("WAYPOINTS"));
            this.d_waypointEditor.setEnabled(true);
        } else {
            this.d_waypointEditor.load(Collections.emptyList());
            this.d_waypointEditor.setEnabled(false);
        }
        this.updateAutoLbl();
        this.d_dlgPanel.setModified(false);
    }

    @Override
    public void save(PyroMod domain, Collection<? extends HvacDuct> objs) {
        if (this.d_fyi.isModified()) {
            Composite.setProperty(fyiProp, this.d_fyi.getText(), objs);
        }
        if (this.d_networkId.isModified()) {
            Composite.setProperty(networkIdProp, this.d_networkId.getText(), objs);
        }
        if (this.d_autoLenRB.isSelected()) {
            Composite.setProperty(lengthProp, null, objs);
        } else if (this.d_fixedLenRB.isSelected()) {
            Composite.setProp(lengthProp, Property.ofNullable((UnitDouble)this.d_lengthFld.getValue()), objs);
        }
        if (this.d_circularBtn.isSelected()) {
            Composite.setProperty(shapeProp, HvacDuct.Shape.CIRCULAR, objs);
            Composite.setProp(diamProp, Property.ofNullable((UnitDouble)this.d_diaFld.getValue()), objs);
        } else if (this.d_nonCircularBtn.isSelected()) {
            Composite.setProperty(shapeProp, HvacDuct.Shape.NON_CIRCULAR, objs);
            Composite.setProp(areaProp, Property.ofNullable((UnitDouble)this.d_areaFld.getValue()), objs);
            Composite.setProp(perimProp, Property.ofNullable((UnitDouble)this.d_perimeterFld.getValue()), objs);
        }
        Composite.setProp(new LossProp(0), Property.ofNullable((UnitDouble)this.d_forwardLossFld.getValue()), objs);
        Composite.setProp(new LossProp(1), Property.ofNullable((UnitDouble)this.d_reverseLossFld.getValue()), objs);
        Composite.setProp(roughnessProp, Property.ofNullable((UnitDouble)this.d_roughFld.getValue()), objs);
        Composite.setProp(roughTypeProp, Property.ofNullable(this.d_roughnessTypeCB.getSelectedItem()), objs);
        IFlowDevcEditor flowDevcEditor = this.d_flowDevcEditorCB.getSelectedItem();
        if (flowDevcEditor != null) {
            HashSet<Composite.IObjectProp> remProps = new HashSet<Composite.IObjectProp>();
            for (int m = 0; m < this.d_flowDevcEditorCB.getItemCount(); ++m) {
                this.d_flowDevcEditorCB.getItemAt(m).getProps(remProps);
            }
            HashSet<Composite.IObjectProp> keepProps = new HashSet<Composite.IObjectProp>();
            flowDevcEditor.getProps(keepProps);
            remProps.removeAll(keepProps);
            for (int m = 0; m < this.d_flowDevcEditorCB.getItemCount(); ++m) {
                if (this.d_flowDevcEditorCB.getItemAt(m) == flowDevcEditor) continue;
                this.d_flowDevcEditorCB.getItemAt(m).resetProps(remProps, objs);
            }
            Composite.setProperty(airflowProp, flowDevcEditor.getDevcType(), objs);
            flowDevcEditor.save(objs);
        }
        HvacNode newNode1 = this.d_fromNodeCB.getSelectedItem();
        HvacNode newNode2 = this.d_toNodeCB.getSelectedItem();
        ArrayList<HvacDuctLoss> removeLosses = new ArrayList<HvacDuctLoss>();
        for (HvacDuct hvacDuct : objs) {
            List oldNodes = (List)hvacDuct.getProp("NODE_ID");
            HvacNode oldNode1 = (HvacNode)oldNodes.get(0);
            HvacNode oldNode2 = (HvacNode)oldNodes.get(1);
            List<HvacNode> newNodes = Arrays.asList(newNode1 != null ? newNode1 : oldNode1, newNode2 != null ? newNode2 : oldNode2);
            assert (newNode1 == null || this.d_domain.getObstructions().containsDeep(newNode1));
            assert (newNode2 == null || this.d_domain.getObstructions().containsDeep(newNode2));
            if (oldNode1 != null && !newNodes.contains(oldNode1)) {
                removeLosses.addAll(HvacUtil.getDuctLosses(this.d_domain.getBridges(), oldNode1, hvacDuct));
            }
            if (oldNode2 != null && !newNodes.contains(oldNode2)) {
                removeLosses.addAll(HvacUtil.getDuctLosses(this.d_domain.getBridges(), oldNode2, hvacDuct));
            }
            hvacDuct.setProp("NODE_ID", newNodes);
        }
        if (objs.size() == 1 && objs.iterator().hasNext()) {
            HvacDuct duct = objs.iterator().next();
            this.d_domain.getTaskManager().exec(duct.taskSetWaypoints(this.d_waypointEditor.save()), Intl.intl("Set HVAC Duct Waypoints"));
        }
        this.d_domain.getBridges().removeAll(removeLosses);
    }

    private static boolean error(boolean showWarn, boolean allowModify, Component badComponent, Supplier<String> error) {
        if (showWarn) {
            guiDialog.showInvalidEntryMessage(SwingUtilities.getWindowAncestor(badComponent), error.get());
        }
        if (allowModify) {
            badComponent.requestFocus();
        }
        return false;
    }

    private static class NoDevcPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = 7170816517958924562L;

        private NoDevcPnl() {
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.NONE;
        }

        @Override
        public String toString() {
            return Intl.intl("<none>");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod mod) {
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> props) {
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> props, Collection<? extends HvacDuct> ducts) {
        }

        @Override
        public void load(Collection<? extends HvacDuct> ducts, JTextField nameSrc) {
        }

        @Override
        public void save(Collection<? extends HvacDuct> ducts) {
        }
    }

    private static class DamperPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = 4536444679561931622L;
        private final ControlSelPnl d_controlPnl;
        private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;

        public DamperPnl(PyroMod mod) {
            this.d_controlPnl = new ControlSelPnl(mod.getControls());
            this.setLayout(new MigLayout("insets 0, gap 6", "[][grow]"));
            this.d_controlPnl.addToMig(this);
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.DAMPER;
        }

        @Override
        public String toString() {
            return Intl.intl("Damper");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod mod) {
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> props) {
            props.add(ctrlProp);
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> props, Collection<? extends HvacDuct> ducts) {
            if (props.contains(ctrlProp)) {
                Composite.setProperty(ctrlProp, null, ducts);
            }
        }

        @Override
        public void load(Collection<? extends HvacDuct> ducts, JTextField nameSrc) {
            this.d_ducts = ducts;
            this.d_controlPnl.setNameSrc(nameSrc, ducts);
            this.d_controlPnl.load(Composite.getProp(ctrlProp, ducts));
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_ducts.stream().anyMatch(duct -> duct.getProp("opt_none_damper_fan") != this.getDevcType()) && !this.d_controlPnl.save().isUniform()) {
                return DuctEditor.error(showWarn, allowModify, this.d_controlPnl.getComboBox(), () -> Intl.intl("Activation must be specified."));
            }
            return true;
        }

        @Override
        public void save(Collection<? extends HvacDuct> ducts) {
            Composite.setProp(ctrlProp, this.d_controlPnl.save(), ducts);
        }
    }

    private static class BasicFanPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = -1347270971426334846L;
        private final ValueField<UnitDouble> d_volFlowFld;
        private final TimeFunctionEditor d_ramp;
        private final guiComboBox<Boolean> d_dirCB;
        private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;

        public BasicFanPnl(PyroMod mod) {
            this.d_volFlowFld = ValueFields.udFld(UnitSystem.getSource(24), UnitDoubleVR.above(SIUS.newud(0.0, 24), true));
            this.d_volFlowFld.setNullAllowed(true);
            this.d_ramp = new TimeFunctionEditor(Intl.intl("Ramp up time"), 29);
            this.d_dirCB = DuctEditor.newDirCB();
            GridBagHelper gb = new GridBagHelper(this);
            gb.addRow(Intl.intl("Volume Flow:"), this.d_volFlowFld, 2);
            gb.addRow(this.d_ramp.getLabel(), this.d_ramp.getCombo(), 1.0, this.d_ramp.getEditor());
            gb.addRow(Intl.intl("Flow Direction:"), this.d_dirCB, 0);
            gb.finalizeRows();
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.VOLFLOW;
        }

        @Override
        public String toString() {
            return Intl.intl("Basic Fan");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod mod) {
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> props) {
            props.add(volflowProp);
            props.add(volflowRampProp);
            props.add(revVolFlowProp);
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> props, Collection<? extends HvacDuct> ducts) {
            if (props.contains(volflowProp)) {
                Composite.setProperty(volflowProp, SIUS.newud(0.0, 24), ducts);
            }
            if (props.contains(volflowRampProp)) {
                Composite.setProperty(volflowRampProp, TimeFunction.newDefault(), ducts);
            }
            if (props.contains(revVolFlowProp)) {
                Composite.setProperty(revVolFlowProp, Boolean.FALSE, ducts);
            }
        }

        @Override
        public void load(Collection<? extends HvacDuct> ducts, JTextField nameSrc) {
            this.d_ducts = ducts;
            Property<UnitDouble> volflow = Composite.getProp(volflowProp, ducts);
            this.d_volFlowFld.setValue(volflow.orElse(null));
            Property<TimeFunction> volflowRamp = Composite.getProp(volflowRampProp, ducts);
            this.d_ramp.loadFunction(volflowRamp.orElse(null));
            Property<Boolean> rev = Composite.getProp(revVolFlowProp, ducts);
            this.d_dirCB.setSelectedItem(rev.orElse(null));
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify) || !this.d_ramp.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_ducts.stream().anyMatch(duct -> duct.getProp("opt_none_damper_fan") != this.getDevcType())) {
                if (this.d_volFlowFld.getValue() == null) {
                    return DuctEditor.error(showWarn, allowModify, this.d_volFlowFld, () -> Intl.intl("Volume Flow must not be empty."));
                }
                if (this.d_dirCB.getSelectedItem() == null) {
                    return DuctEditor.error(showWarn, allowModify, this.d_dirCB, () -> Intl.intl("A Flow Direction must be chosen."));
                }
                if (this.d_ramp.saveFunction() == null) {
                    return DuctEditor.error(showWarn, allowModify, this.d_ramp.getCombo(), () -> Intl.intl("A ramp-up time must be chosen."));
                }
            }
            return true;
        }

        @Override
        public void save(Collection<? extends HvacDuct> ducts) {
            UnitDouble volFlow = (UnitDouble)this.d_volFlowFld.getValue();
            Composite.setProp(volflowProp, Property.ofNullable(volFlow), ducts);
            TimeFunction<?> volFlowRamp = this.d_ramp.saveFunction();
            Composite.setProp(volflowRampProp, Property.ofNullable(volFlowRamp), ducts);
            Boolean rev = this.d_dirCB.getSelectedItem();
            Composite.setProp(revVolFlowProp, Property.ofNullable(rev), ducts);
        }
    }

    private static class AircoilPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = -9020985968423659050L;
        private final guiComboBox<HvacAircoil> d_aircoilCB;
        private final ControlSelPnl d_controlPnl;
        private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;

        public AircoilPnl(PyroMod mod) {
            this.d_aircoilCB = new PyroComboBox<HvacAircoil>(mod.getHvacList(), HvacAircoil.class);
            this.d_controlPnl = new ControlSelPnl(mod.getControls());
            this.setLayout(new MigLayout("insets 0, gap 6", "[][grow]"));
            this.add(new guiLabel(Intl.intl("Aircoil:")));
            this.add(this.d_aircoilCB, "grow 0, wrap");
            this.d_controlPnl.addToMig(this);
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.AIRCOIL;
        }

        @Override
        public String toString() {
            return Intl.intl("Aircoil");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod mod) {
            this.setEnabled(this.d_aircoilCB.getItemCount() > 0);
            if (this.d_aircoilCB.getSelectedIndex() < 0 && this.d_aircoilCB.getItemCount() > 0) {
                this.d_aircoilCB.setSelectedIndex(0);
            }
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> props) {
            props.add(aircoilProp);
            props.add(ctrlProp);
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> props, Collection<? extends HvacDuct> ducts) {
            if (props.contains(aircoilProp)) {
                Composite.setProperty(aircoilProp, null, ducts);
            }
            if (props.contains(ctrlProp)) {
                Composite.setProperty(ctrlProp, null, ducts);
            }
        }

        @Override
        public void load(Collection<? extends HvacDuct> ducts, JTextField nameSrc) {
            this.d_ducts = ducts;
            Property aircoil = Composite.getProp(aircoilProp, ducts);
            this.d_aircoilCB.setSelectedItem(aircoil.orElse(null));
            this.d_controlPnl.setNameSrc(nameSrc, ducts);
            this.d_controlPnl.load(Composite.getProp(ctrlProp, ducts));
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_ducts.stream().anyMatch(duct -> duct.getProp("opt_none_damper_fan") != this.getDevcType())) {
                if (this.d_aircoilCB.getSelectedItem() == null) {
                    return DuctEditor.error(showWarn, allowModify, this.d_aircoilCB, () -> Intl.intl("An aircoil must be chosen."));
                }
                if (!this.d_controlPnl.save().isUniform()) {
                    return DuctEditor.error(showWarn, allowModify, this.d_controlPnl.getComboBox(), () -> Intl.intl("Activation must be specified."));
                }
            }
            return true;
        }

        @Override
        public void save(Collection<? extends HvacDuct> ducts) {
            HvacAircoil aircoil = this.d_aircoilCB.getSelectedItem();
            Composite.setProp(aircoilProp, Property.ofNullable(aircoil), ducts);
            Composite.setProp(ctrlProp, this.d_controlPnl.save(), ducts);
        }
    }

    private static class FanPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = 6320057201436867513L;
        private final guiComboBox<HvacFan> d_fanCB;
        private final guiComboBox<Boolean> d_dirCB;
        private final ControlSelPnl d_controlPnl;
        private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;

        public FanPnl(PyroMod mod) {
            this.d_fanCB = new PyroComboBox<HvacFan>(mod.getHvacList(), HvacFan.class);
            this.d_dirCB = DuctEditor.newDirCB();
            this.d_controlPnl = new ControlSelPnl(mod.getControls());
            this.setLayout(new MigLayout("insets 0, gap 6", "[][grow]"));
            this.add(new guiLabel(Intl.intl("Fan:")));
            this.add(this.d_fanCB, "wrap");
            this.add(new guiLabel(Intl.intl("Flow Direction:")));
            this.add(this.d_dirCB, "wrap");
            this.d_controlPnl.addToMig(this);
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.FAN;
        }

        @Override
        public String toString() {
            return Intl.intl("Fan");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod mod) {
            this.setEnabled(this.d_fanCB.getItemCount() > 0);
            if (this.d_fanCB.getSelectedIndex() < 0 && this.d_fanCB.getItemCount() > 0) {
                this.d_fanCB.setSelectedIndex(0);
            }
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> props) {
            props.add(fanProp);
            props.add(revProp);
            props.add(ctrlProp);
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> props, Collection<? extends HvacDuct> ducts) {
            if (props.contains(fanProp)) {
                Composite.setProperty(fanProp, null, ducts);
            }
            if (props.contains(revProp)) {
                Composite.setProperty(revProp, Boolean.FALSE, ducts);
            }
            if (props.contains(ctrlProp)) {
                Composite.setProperty(ctrlProp, null, ducts);
            }
        }

        @Override
        public void load(Collection<? extends HvacDuct> ducts, JTextField nameSrc) {
            this.d_ducts = ducts;
            Property fan = Composite.getProp(fanProp, ducts);
            this.d_fanCB.setSelectedItem(fan.orElse(null));
            Property rev = Composite.getProp(revProp, ducts);
            this.d_dirCB.setSelectedItem(rev.orElse(null));
            this.d_controlPnl.setNameSrc(nameSrc, ducts);
            Property<ControlBridge> control = Composite.getProp(ctrlProp, ducts);
            this.d_controlPnl.load(control);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            if (this.d_ducts.stream().anyMatch(duct -> duct.getProp("opt_none_damper_fan") != this.getDevcType())) {
                if (this.d_fanCB.getSelectedItem() == null) {
                    return DuctEditor.error(showWarn, allowModify, this.d_fanCB, () -> Intl.intl("A fan must be chosen."));
                }
                if (this.d_dirCB.getSelectedItem() == null) {
                    return DuctEditor.error(showWarn, allowModify, this.d_dirCB, () -> Intl.intl("A Flow Direction must be chosen."));
                }
                if (!this.d_controlPnl.save().isUniform()) {
                    return DuctEditor.error(showWarn, allowModify, this.d_controlPnl.getComboBox(), () -> Intl.intl("Activation must be specified."));
                }
            }
            return true;
        }

        @Override
        public void save(Collection<? extends HvacDuct> ducts) {
            HvacFan fan = this.d_fanCB.getSelectedItem();
            Composite.setProp(fanProp, Property.ofNullable(fan), ducts);
            Boolean rev = this.d_dirCB.getSelectedItem();
            Composite.setProp(revProp, Property.ofNullable(rev), ducts);
            Composite.setProp(ctrlProp, this.d_controlPnl.save(), ducts);
        }
    }

    private static interface IFlowDevcEditor {
        public HvacDuct.AirflowObj getDevcType();

        public void load(Collection<? extends HvacDuct> var1, JTextField var2);

        public void save(Collection<? extends HvacDuct> var1);

        public String toString();

        public guiPanel getPanel();

        public void updateEnabled(PyroMod var1);

        public void getProps(Set<Composite.IObjectProp> var1);

        public void resetProps(Set<Composite.IObjectProp> var1, Collection<? extends HvacDuct> var2);
    }

    private static class StandardProp<T>
    extends Composite.AObjectProp<HvacDuct, T> {
        private final Function<HvacDuct, T> d_getter;
        private final BiConsumer<HvacDuct, T> d_setter;

        public StandardProp(Function<HvacDuct, T> getter, BiConsumer<HvacDuct, T> setter) {
            super(HvacDuct.class);
            this.d_setter = setter;
            this.d_getter = getter;
        }

        @Override
        public Object get(HvacDuct obj) {
            return this.d_getter.apply(obj);
        }

        @Override
        public void set(HvacDuct obj, T prop) {
            this.d_setter.accept(obj, (HvacDuct)prop);
        }
    }

    private static class GenericProp<T>
    extends Composite.AObjectProp<HvacDuct, T> {
        private final String d_propKey;

        public GenericProp(String propKey) {
            super(HvacDuct.class);
            this.d_propKey = propKey;
        }

        @Override
        public Object get(HvacDuct obj) {
            return obj.getProp(this.d_propKey);
        }

        @Override
        public void set(HvacDuct obj, T prop) {
            obj.setProp(this.d_propKey, prop);
        }
    }

    private static class NodeProp
    extends ListProp<HvacNode> {
        public NodeProp(int index) {
            super("NODE_ID", index);
        }
    }

    private static class LossProp
    extends ListProp<UnitDouble> {
        public LossProp(int index) {
            super("LOSS", index);
        }
    }

    private static class ReverseVolFlowProp
    extends Composite.AObjectProp<HvacDuct, Boolean> {
        private static final UnitDouble ZERO = SIUS.newud(0.0, 24);

        public ReverseVolFlowProp() {
            super(HvacDuct.class);
        }

        @Override
        public void set(HvacDuct obj, Boolean prop) {
            if (prop.booleanValue()) {
                TimeBasedValue<UnitDouble> vf = obj.getVolflow();
                vf = new TimeBasedValue<UnitDouble>(((UnitDouble)vf.val).negate(), vf.func);
                obj.setVolflow(vf);
            }
        }

        @Override
        public Object get(HvacDuct obj) {
            return ((UnitDouble)obj.getVolflow().val).lt(ZERO, 0.0);
        }
    }

    private static class ListProp<T>
    extends Composite.AObjectProp<HvacDuct, T> {
        private final String d_key;
        private final int d_index;

        public ListProp(String key, int index) {
            super(HvacDuct.class);
            this.d_key = key;
            this.d_index = index;
        }

        @Override
        public Object get(HvacDuct obj) {
            List vals = (List)obj.getProp(this.d_key);
            return vals.get(this.d_index);
        }

        @Override
        public void set(HvacDuct obj, T prop) {
            ArrayList<T> loss = new ArrayList<T>((List)obj.getProp(this.d_key));
            loss.set(this.d_index, prop);
            obj.setProp(this.d_key, loss);
        }
    }
}

