/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.floorview;

import java.awt.Color;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JOptionPane;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.Floor;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Global;

public class NewFloorDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final List<Floor> d_floors;
    private final guiTextField d_name;
    private final ValueField<UnitDouble> d_elevation;
    private final ValueField<UnitDouble> d_slab;
    private final ValueField<UnitDouble> d_wall;
    private final Color d_newColor;

    public NewFloorDlg(Window parent, List<Floor> floors) {
        super(parent, Intl.intl("New Floor"), 9);
        UnitDouble defElevation;
        UnitDouble defWall;
        UnitDouble defSlab;
        this.d_floors = floors;
        this.d_name = new guiTextField();
        IUnitSrc ltype = UnitSystem.getSource(0);
        this.d_elevation = ValueFields.udFld(ltype);
        this.d_slab = ValueFields.udFld(ltype, UnitDoubleVR.above(0.0, SI.METER, true));
        this.d_wall = ValueFields.udFld(ltype, UnitDoubleVR.above(0.0, SI.METER, true));
        if (!floors.isEmpty()) {
            Floor prevFloor = floors.get(floors.size() - 1);
            defSlab = prevFloor.getSlabThickness();
            defWall = prevFloor.getWallHeight();
            defElevation = this.suggestElevation(floors, defSlab);
            this.d_newColor = floors.get(floors.size() - 1).getClipColor();
        } else {
            Floor defFloor = new Floor("");
            defElevation = defFloor.getElevation();
            defWall = defFloor.getWallHeight();
            defSlab = defFloor.getSlabThickness();
            this.d_newColor = Floor.DEFAULT_COLOR;
        }
        this.d_elevation.setValue(defElevation);
        this.d_slab.setValue(defSlab);
        this.d_wall.setValue(defWall);
        this.d_name.setValue(this.suggestName(defElevation));
        final PropertyChangeListener elevationListener = evt -> {
            if (!this.d_elevation.validateData(false, false)) {
                return;
            }
            this.d_name.setValue(this.suggestName((UnitDouble)this.d_elevation.getValue()));
        };
        final PropertyChangeListener slabListener = evt -> {
            UnitDouble slab = (UnitDouble)this.d_slab.getValue();
            UnitDouble newElevation = this.suggestElevation(floors, slab);
            this.d_elevation.setValue(newElevation);
        };
        this.d_slab.addValueCommitListener(slabListener);
        this.d_elevation.addValueChangeListener(elevationListener);
        this.d_elevation.addValueCommitListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                NewFloorDlg.this.d_slab.removeValueCommitListener(slabListener);
                NewFloorDlg.this.d_elevation.removeValueCommitListener(this);
            }
        });
        this.d_name.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                NewFloorDlg.this.d_elevation.removeValueChangeListener(elevationListener);
                NewFloorDlg.this.d_name.removeKeyListener(this);
            }
        });
        guiLabel keyLbl = new guiLabel(PyroGuiUtil.loadPyroSimIcon("floor_key.png"));
        keyLbl.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        GridBagHelper gb = new GridBagHelper(this.getDialogPane());
        gb.colSpace = 24;
        gb.addRow(Intl.intl("Name:"), this.d_name, 1, 1.0, keyLbl, new double[]{1.0, 1.0}, new int[]{0, 0});
        gb.addRow(Intl.intl("Slab Thickness (A):"), this.d_slab, 1, 1.0);
        gb.addRow(Intl.intl("Elevation (B):"), this.d_elevation, 1, 1.0);
        gb.addRow(Intl.intl("Wall Height (C):"), this.d_wall, 1, 1.0);
        gb.finalizeRows();
    }

    public static void open(Window parent, List<Floor> floors, Consumer<Floor> done) {
        NewFloorDlg dialog = new NewFloorDlg(parent, floors);
        if (dialog.doModal() == 1) {
            done.accept(dialog.save());
        }
    }

    private String suggestName(UnitDouble elevation) {
        elevation = elevation.convert(PyroSim.getApp().getUnitSystem().getLengthUnit());
        return String.format(Intl.intl("Floor %s"), Global.format(elevation));
    }

    private UnitDouble suggestElevation(List<Floor> floors, UnitDouble slabThickness) {
        if (floors.isEmpty()) {
            assert (false);
            Floor defFloor = new Floor("");
            return defFloor.getElevation();
        }
        Floor prevFloor = floors.get(floors.size() - 1);
        return prevFloor.getCeilingLoc().add(slabThickness);
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (!showWarn) {
            return true;
        }
        Floor floor = this.save();
        for (Floor existingFloor : this.d_floors) {
            if (!floor.intersects(existingFloor)) continue;
            String msg = String.format(Intl.intl("Floor overlaps %s. Would you like to continue?"), existingFloor.getName());
            int option = JOptionPane.showConfirmDialog(this, msg, Intl.intl("Overlapping Floors"), 0);
            if (option == 0) break;
            return false;
        }
        return true;
    }

    public Floor save() {
        String name = this.d_name.getText();
        return new Floor(name.equals(this.suggestName((UnitDouble)this.d_elevation.getValue())) ? "" : name, (UnitDouble)this.d_elevation.getValue(), (UnitDouble)this.d_slab.getValue(), (UnitDouble)this.d_wall.getValue(), null, this.d_newColor);
    }
}

