/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.statistics.IStatGeom;
import pyrosim.domain.devices.statistics.StatisticsDevc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityStat;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.geom.Geometry;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.GridComboBox;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.NamePnl;
import pyrosim.gui.devices.TripFlagsPanel;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Predicates;

public class StatisticsDevcEditor
implements IDevcEditor<StatisticsDevc> {
    private final StatisticsDataPanel d_dataPanel;
    private final StatGeomEditor d_geomPanel;
    private final IQuantity d_fixedQuant;

    public StatisticsDevcEditor(PyroMod pyMod, IDevcEditor.Mode mode) {
        this(pyMod, null, mode);
    }

    public StatisticsDevcEditor(PyroMod pyMod, IQuantity type, IDevcEditor.Mode mode) {
        this.d_dataPanel = new StatisticsDataPanel(type);
        this.d_geomPanel = new StatGeomEditor(pyMod, mode, type != null ? type.get() : ((IQuantity)this.d_dataPanel.d_quantCombo.getSelectedItem()).get());
        this.d_fixedQuant = type;
        this.d_dataPanel.addStatComboListener(e -> this.d_geomPanel.updateGeomWarnings(((IQuantity)this.d_dataPanel.d_quantCombo.getSelectedItem()).get(), (QuantityStat)((Object)((Object)this.d_dataPanel.d_temporalStatCombo.getSelectedItem())), (QuantityStat)((Object)((Object)this.d_dataPanel.d_spatialStatCombo.getSelectedItem()))));
        this.d_dataPanel.updateValidStatsForQuantity();
    }

    @Override
    public String getDesc() {
        return Intl.intl("Statistics Device");
    }

    @Override
    public String getDefName() {
        return Intl.intl("STAT");
    }

    @Override
    public StatisticsDevc create() {
        return this.d_dataPanel.create("");
    }

    @Override
    public void save(StatisticsDevc obj) {
        this.d_dataPanel.save(obj);
    }

    @Override
    public void load(StatisticsDevc obj) {
        this.d_dataPanel.load(obj);
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        StatisticSensitiveAlarmPanelModel alarmPanelModel = new StatisticSensitiveAlarmPanelModel(this.d_dataPanel.getSelectedUnits(), () -> this.d_dataPanel.getSelectedSpatialStatistic(), () -> this.d_dataPanel.getSelectedTemporalStatistic());
        AlarmInfoPanel alarmInfoPanel = new AlarmInfoPanel(0, alarmPanelModel);
        this.d_dataPanel.addStatComboListener(e -> alarmInfoPanel.setCurrentUnitType(this.d_dataPanel.getSelectedUnits()));
        if (this.d_fixedQuant != null) {
            alarmInfoPanel.setCurrentMsr(this.d_fixedQuant);
        }
        return alarmInfoPanel;
    }

    @Override
    public TripFlagsPanel createTripPanel() {
        return new TripFlagsPanel();
    }

    @Override
    public ControlSelPnl createCtrlInputPanel(PyroMod domain, NamePnl namePnl) {
        StatisticsDevc tempDevc = this.create();
        if (tempDevc != null && tempDevc.getInputPin() instanceof OneLogicInPin) {
            String lbl = tempDevc instanceof IFreezable ? Intl.intl("Freeze Output:") : null;
            String tt = tempDevc instanceof IFreezable ? Intl.intl("Freezes the output of the device when a control activates.") : null;
            ControlSelPnl eventPanel = new ControlSelPnl(domain.getControls(), lbl, tt);
            if (namePnl != null) {
                tempDevc.setName(namePnl.save());
                eventPanel.setNameSrc(namePnl.getNameField(), Arrays.asList(tempDevc));
            }
            return eventPanel;
        }
        return null;
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return this.d_geomPanel;
    }

    private static boolean promptUserToContinue(Component parent, String message) {
        int choice = JOptionPane.showConfirmDialog(parent, message, Intl.intl("Warning"), 0);
        return choice == 0;
    }

    @Override
    public boolean validateData(Component parent, StatisticsDevc loadedObj, boolean showWarn, boolean allowModify) {
        Quantity selectedQuant = this.d_dataPanel.getSelectedQuantity().get();
        QuantityStat selectedSpatial = this.d_dataPanel.getSelectedSpatialStatistic();
        QuantityStat selectedTemporal = this.d_dataPanel.getSelectedTemporalStatistic();
        IStatGeom.Type selectedGeom = this.d_geomPanel.getSelectedGeomType();
        if (!selectedQuant.isCompatible(selectedSpatial) && showWarn && !StatisticsDevcEditor.promptUserToContinue(parent, String.format(Intl.intl("The quantity '%1$s' and the statistic '%2$s' may not be compatible. Would you like to proceed?"), selectedQuant.name, selectedSpatial.displayName))) {
            return false;
        }
        if (!selectedQuant.isCompatible(selectedTemporal) && showWarn && !StatisticsDevcEditor.promptUserToContinue(parent, String.format(Intl.intl("The quantity '%1$s' and the statistic '%2$s' may not be compatible. Would you like to proceed?"), selectedQuant.name, selectedTemporal.displayName))) {
            return false;
        }
        if (!QuantityStat.isCompatible(selectedSpatial, selectedTemporal) && showWarn && !StatisticsDevcEditor.promptUserToContinue(parent, String.format(Intl.intl("The statistic '%1$s' and the statistic '%2$s' may not be compatible. Would you like to proceed?"), selectedSpatial.displayName, selectedTemporal.displayName))) {
            return false;
        }
        if (!StatisticsDevc.isCompatible(selectedQuant, selectedSpatial, selectedGeom) && showWarn) {
            if (selectedSpatial == null) {
                if (!StatisticsDevcEditor.promptUserToContinue(parent, String.format(Intl.intl("The quantity '%1$s' and the geometry type '%2$s' may not be compatible. Would you like to proceed?"), selectedQuant.name, selectedGeom.name))) {
                    return false;
                }
            } else {
                String statName = selectedSpatial.displayName;
                if (!StatisticsDevcEditor.promptUserToContinue(parent, String.format(Intl.intl("The geometry type '%1$s' and the statistic '%2$s' may not be compatible. Would you like to proceed?"), selectedGeom.name, statName))) {
                    return false;
                }
            }
        }
        if (showWarn && loadedObj != null && loadedObj.getStatGeom().isArray()) {
            IStatGeom editorGeom = this.d_geomPanel.createGeom();
            if (editorGeom.getNumPoints() < loadedObj.getStatGeom().getNumPoints() && !StatisticsDevcEditor.promptUserToContinue(parent, Intl.intl("Reducing the number of devices in the array may cause those inputs to be disconnected from other devices or controls. Do you want to proceed?"))) {
                return false;
            }
            if (loadedObj.getStatGeom().getArrayProfile().equals((Object)IStatGeom.ArrayProfile.TIME_VARYING) && !loadedObj.getStatGeom().getArrayProfile().equals((Object)editorGeom.getArrayProfile()) && !StatisticsDevcEditor.promptUserToContinue(parent, Intl.intl("Changing the Array Profile to 'Steady-State' may cause inputs to other devices or controls to be disconnected. Do you want to proceed?"))) {
                return false;
            }
        }
        return true;
    }

    private static class StatisticsDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 1L;
        private final QuantityComboBox d_quantCombo = new QuantityComboBox(q -> !q.statistics.isEmpty());
        private final StatisticsComboBox d_spatialStatCombo;
        private final StatisticsComboBox d_temporalStatCombo;

        public StatisticsDataPanel(IQuantity defType) {
            this.d_quantCombo.setMinimumSize(this.d_quantCombo.getPreferredSize());
            if (defType != null) {
                this.d_quantCombo.setSelectedItem(defType);
            }
            List<QuantityStat> spatialStatOptions = QuantityStat.getSupportedSpatialList();
            spatialStatOptions.add(0, null);
            this.d_spatialStatCombo = new StatisticsComboBox((Collection<QuantityStat>)spatialStatOptions);
            List<QuantityStat> temporalStatOptions = QuantityStat.getSupportedTemporalList();
            temporalStatOptions.add(0, null);
            this.d_temporalStatCombo = new StatisticsComboBox((Collection<QuantityStat>)temporalStatOptions);
            this.d_quantCombo.addItemListener(e -> this.updateValidStatsForQuantity());
            this.d_temporalStatCombo.addItemListener(e -> this.updateValidStatsForQuantity());
            this.d_spatialStatCombo.addItemListener(e -> this.updateValidStatsForQuantity());
            this.setLayout(new MigLayout("insets 0"));
            this.add(new guiLabel(Intl.intl("Quantity:")));
            this.add((Component)this.d_quantCombo, "grow, wrap");
            this.add(new guiLabel(Intl.intl("Spatial Statistic:")));
            this.add((Component)this.d_spatialStatCombo, "grow, wrap");
            this.add(new guiLabel(Intl.intl("Temporal Statistic:")));
            this.add((Component)this.d_temporalStatCombo, "grow, wrap");
        }

        public void addStatComboListener(ItemListener e) {
            this.d_quantCombo.addItemListener(e);
            this.d_temporalStatCombo.addItemListener(e);
            this.d_spatialStatCombo.addItemListener(e);
        }

        private void updateValidStatsForQuantity() {
            this.d_spatialStatCombo.updateSelectedObjs(((IQuantity)this.d_quantCombo.getSelectedItem()).get(), (QuantityStat)((Object)this.d_spatialStatCombo.getSelectedItem()));
            this.d_temporalStatCombo.updateSelectedObjs(((IQuantity)this.d_quantCombo.getSelectedItem()).get(), (QuantityStat)((Object)this.d_spatialStatCombo.getSelectedItem()));
        }

        public void load(StatisticsDevc devc) {
            this.d_quantCombo.setSelectedItem(devc.getQuantity());
            this.d_spatialStatCombo.setSelectedItem((Object)devc.getSpatialStat());
            this.d_temporalStatCombo.setSelectedItem((Object)devc.getTemporalStat());
        }

        public StatisticsDevc create(String name) {
            return new StatisticsDevc(name, (IQuantity)this.d_quantCombo.getSelectedItem(), (QuantityStat)((Object)this.d_spatialStatCombo.getSelectedItem()), (QuantityStat)((Object)this.d_temporalStatCombo.getSelectedItem()), new IStatGeom.Point(new Point3d()));
        }

        public void save(StatisticsDevc devc) {
            IQuantity quant = (IQuantity)this.d_quantCombo.getSelectedItem();
            devc.setQuantity(quant);
            devc.setSpatialStat((QuantityStat)((Object)this.d_spatialStatCombo.getSelectedItem()));
            devc.setTemporalStat((QuantityStat)((Object)this.d_temporalStatCombo.getSelectedItem()));
        }

        public int getSelectedUnits() {
            IQuantity baseQuant = (IQuantity)this.d_quantCombo.getSelectedItem();
            QuantityStat spatialStat = (QuantityStat)((Object)this.d_spatialStatCombo.getSelectedItem());
            QuantityStat temporalStat = (QuantityStat)((Object)this.d_temporalStatCombo.getSelectedItem());
            return StatisticsDevc.getUnitType(baseQuant.get(), spatialStat, temporalStat);
        }

        public QuantityStat getSelectedSpatialStatistic() {
            return (QuantityStat)((Object)this.d_spatialStatCombo.getSelectedItem());
        }

        public QuantityStat getSelectedTemporalStatistic() {
            return (QuantityStat)((Object)this.d_temporalStatCombo.getSelectedItem());
        }

        public IQuantity getSelectedQuantity() {
            return (IQuantity)this.d_quantCombo.getSelectedItem();
        }
    }

    private static class StatGeomEditor
    extends guiPanel
    implements IGeomEditor<IStatGeom> {
        private static final long serialVersionUID = 1L;
        private final IDevcEditor.Mode d_mode;
        private boolean d_allowArray = true;
        private boolean d_allowSingle = true;
        private final StatGeomCombo d_typeCombo;
        private final CardLayout d_cardManager;
        private final guiPanel d_cardPanel;
        private final Map<String, IStatGeomEditor> d_editors;

        public StatGeomEditor(PyroMod pymod, IDevcEditor.Mode mode, Quantity initQuantity) {
            this.d_mode = mode;
            this.d_typeCombo = new StatGeomCombo((Collection<IStatGeom.Type>)StatGeomCombo.getOptions());
            this.d_typeCombo.addItemListener(e -> this.updateLayout());
            this.d_cardPanel = new guiPanel();
            this.d_cardManager = new CardLayout();
            this.d_cardPanel.setLayout(this.d_cardManager);
            this.d_editors = new HashMap<String, IStatGeomEditor>();
            VolumeStatGeomEditor volumeEditor = new VolumeStatGeomEditor(pymod);
            this.d_editors.put(IStatGeom.Type.POINT.name, new PointStatGeomEditor());
            this.d_editors.put(IStatGeom.Type.RECTANGLE.name, new PlaneStatGeomEditor());
            this.d_editors.put(IStatGeom.Type.BOX.name, volumeEditor);
            this.d_editors.put(IStatGeom.Type.POINT_ARRAY.name, new LinearArrayGeomEditor(IStatGeom.Type.POINT_ARRAY, mode));
            this.d_editors.put(IStatGeom.Type.BOX_ARRAY.name, new LinearArrayGeomEditor(IStatGeom.Type.BOX_ARRAY, mode));
            for (Map.Entry<String, IStatGeomEditor> kvPair : this.d_editors.entrySet()) {
                this.d_cardPanel.add((Component)kvPair.getValue().getEditorPanel(), kvPair.getKey());
            }
            this.d_editors.put(IStatGeom.Type.GRID.name, volumeEditor);
            this.init(initQuantity);
            this.setLayout(new MigLayout());
            this.add(new guiLabel(Intl.intl("Geometry Type:")));
            this.add((Component)this.d_typeCombo, "wrap");
            this.add((Component)this.d_cardPanel, "span 2, wrap");
        }

        @Override
        public String getGeomName() {
            return Intl.intl("Statistics Geometry");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        private void updateLayout() {
            this.d_cardManager.show(this.d_cardPanel, ((IStatGeom.Type)((Object)this.d_typeCombo.getSelectedItem())).name);
        }

        private void init(Quantity initQuantity) {
            this.d_typeCombo.setSelectedItem((Object)IStatGeom.Type.POINT);
            this.d_cardManager.show(this.d_cardPanel, IStatGeom.Type.POINT.name);
            for (IStatGeomEditor geomEditor : this.d_editors.values()) {
                geomEditor.init();
            }
            this.d_typeCombo.updateSelectedStats(initQuantity, null, null);
        }

        @Override
        public void load(Collection<? extends IPyroGeomSrc> geoms) {
            assert (geoms.size() == 1);
            IPyroGeomSrc geomSrc = geoms.iterator().next();
            IGeom probablyStatGeom = geomSrc.getGeom().getLocalGeom();
            if (probablyStatGeom instanceof IStatGeom) {
                IStatGeom statGeom = (IStatGeom)probablyStatGeom;
                if (this.d_mode == IDevcEditor.Mode.EDIT) {
                    if (statGeom.isArray()) {
                        this.d_allowArray = true;
                        this.d_allowSingle = false;
                    } else {
                        this.d_allowArray = false;
                        this.d_allowSingle = true;
                    }
                } else {
                    this.d_allowArray = true;
                    this.d_allowSingle = true;
                }
                this.reduceAllowedItemsForMode();
                IStatGeom.Type type = statGeom.getType();
                if (type.equals((Object)IStatGeom.Type.GRID)) {
                    type = IStatGeom.Type.BOX;
                }
                this.d_typeCombo.setSelectedItem((Object)type);
                IStatGeomEditor activeEditor = this.d_editors.get(statGeom.getType().name);
                activeEditor.load(statGeom);
            }
        }

        @Override
        public void save(Collection<? extends IPyroGeomSrc> geoms) {
            assert (geoms.size() == 1);
            IStatGeom geom = this.createGeom();
            IPyroGeomSrc src = geoms.iterator().next();
            if (this.d_mode.equals((Object)IDevcEditor.Mode.CREATE)) {
                if (src instanceof StatisticsDevc) {
                    StatisticsDevc statDevc = (StatisticsDevc)src;
                    statDevc.forceArrayTypeConversion(geom);
                    statDevc.setGeom(GeomNodeUtil.newNode(geom));
                } else assert (false);
            } else {
                src.setGeom(GeomNodeUtil.newNode(geom));
            }
        }

        public IStatGeom createGeom() {
            return this.getActiveEditor().save();
        }

        public IStatGeom.Type getSelectedGeomType() {
            return (IStatGeom.Type)((Object)this.d_typeCombo.getSelectedItem());
        }

        public IStatGeomEditor getActiveEditor() {
            return this.d_editors.get(this.getSelectedGeomType().name);
        }

        @Override
        public boolean validateData(Collection<? extends IPyroGeomSrc> geoms, boolean showWarn, boolean allowModify) {
            return this.validateData(showWarn, allowModify);
        }

        @Override
        public int getNumFaces() {
            return 0;
        }

        @Override
        public String[] getFaceNames() {
            return new String[0];
        }

        @Override
        public int[] getFaceOrder(IGeomNode geom) {
            return new int[0];
        }

        public void updateGeomWarnings(Quantity selectedQuantity, QuantityStat selectedTemporal, QuantityStat selectedSpatial) {
            this.d_typeCombo.updateSelectedStats(selectedQuantity, selectedSpatial, selectedTemporal);
        }

        private void reduceAllowedItemsForMode() {
            IStatGeom.Type initialType = (IStatGeom.Type)((Object)this.d_typeCombo.getSelectedItem());
            Vector initialTypes = this.d_typeCombo.getAllItems();
            this.d_typeCombo.setItems(initialTypes.stream().filter(this.getModeFilter()).collect(Collectors.toList()));
            if (!this.d_typeCombo.contains(initialType)) {
                this.d_typeCombo.setSelectedIndex(0);
            }
            this.d_cardManager.show(this.d_cardPanel, ((IStatGeom.Type)((Object)this.d_typeCombo.getSelectedItem())).name);
        }

        private Predicate<IStatGeom.Type> getModeFilter() {
            if (!this.d_allowSingle) {
                return type -> type.array;
            }
            if (!this.d_allowArray) {
                return type -> !type.array;
            }
            return Predicates.alwaysTrue();
        }

        private static class StatGeomCombo
        extends guiComboBox<IStatGeom.Type> {
            private static final long serialVersionUID = 1L;
            private Quantity selectedQuantity;
            private QuantityStat selectedSpatial = null;

            private static List<IStatGeom.Type> getOptions() {
                return Arrays.asList(IStatGeom.Type.POINT, IStatGeom.Type.RECTANGLE, IStatGeom.Type.BOX, IStatGeom.Type.POINT_ARRAY, IStatGeom.Type.BOX_ARRAY);
            }

            public StatGeomCombo(Collection<IStatGeom.Type> options) {
                super(options);
                this.setRenderer(new StatisticsGeomTypeRenderer());
            }

            public void updateSelectedStats(Quantity quantity, QuantityStat spatialStat, QuantityStat temporalStat) {
                this.selectedQuantity = quantity;
                this.selectedSpatial = spatialStat;
                this.repaint();
            }

            private class StatisticsGeomTypeRenderer
            extends DefaultListCellRenderer {
                private static final long serialVersionUID = 1L;
                private static final ImageIcon s_warningIcon = PyroGuiUtil.loadPyroSimIcon("bad.png");

                private StatisticsGeomTypeRenderer() {
                }

                @Override
                public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                    this.decorateCells(value);
                    return this;
                }

                private void decorateCells(Object value) {
                    if (value instanceof IStatGeom.Type) {
                        IStatGeom.Type type = (IStatGeom.Type)((Object)value);
                        this.setText(type.name);
                        this.setToolTipText(type.tooltip);
                        if (StatisticsDevc.isCompatible(StatGeomCombo.this.selectedQuantity, StatGeomCombo.this.selectedSpatial, type)) {
                            this.setIcon(null);
                        } else {
                            this.setIcon(s_warningIcon);
                        }
                    }
                }
            }
        }

        private static class VolumeStatGeomEditor
        extends guiPanel
        implements IStatGeomEditor {
            private static final long serialVersionUID = 1L;
            private final AABoxGeomEditor d_editor;
            private final GridComboBox d_gridCombo;
            private final guiRadioButton d_gridRb;
            private final guiRadioButton d_boxRb;
            private final boolean d_gridGeomAllowed;

            public VolumeStatGeomEditor(PyroMod pymod) {
                this.setLayout(new MigLayout());
                this.d_editor = new AABoxGeomEditor(false, false);
                this.d_gridGeomAllowed = pymod.getGridManager().flatten().size() > 0;
                this.d_gridCombo = new GridComboBox(pymod.getGridManager());
                this.d_gridRb = new guiRadioButton(Intl.intl("Record in an entire mesh:"));
                this.d_boxRb = new guiRadioButton(Intl.intl("Record in a volume:"));
                new guiButtonGroup(this.d_boxRb, this.d_gridRb);
                LinkStatus.link((AbstractButton)this.d_gridRb, this.d_gridCombo);
                LinkStatus.link((AbstractButton)this.d_boxRb, this.d_editor);
                this.add((Component)this.d_boxRb, "wrap");
                this.add((Component)this.d_editor, "span, wrap");
                this.add(this.d_gridRb);
                this.add((Component)this.d_gridCombo, "span, wrap");
            }

            @Override
            public void init() {
                this.load(new IStatGeom.Box(new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0)));
                if (!this.d_gridGeomAllowed) {
                    this.d_gridRb.setEnabled(false);
                    this.d_gridCombo.setEnabled(false);
                }
            }

            @Override
            public void load(IStatGeom geom) {
                if (geom.getType().equals((Object)IStatGeom.Type.BOX)) {
                    this.d_boxRb.setSelected(true);
                    this.d_editor.load((IStatGeom.Box)geom);
                } else if (geom.getType().equals((Object)IStatGeom.Type.GRID)) {
                    this.d_gridRb.setSelected(true);
                    this.d_gridCombo.setSelectedItem(((IStatGeom.GridGeom)geom).grid);
                }
            }

            @Override
            public IStatGeom save() {
                if (this.d_boxRb.isSelected()) {
                    AABoxGeom tempGeom = this.d_editor.save();
                    return new IStatGeom.Box(tempGeom.min, tempGeom.max);
                }
                if (this.d_gridRb.isSelected()) {
                    return new IStatGeom.GridGeom((Grid)this.d_gridCombo.getSelectedItem());
                }
                assert (false);
                return new IStatGeom.Box(new Point3d(), new Point3d());
            }

            @Override
            public guiPanel getEditorPanel() {
                return this;
            }
        }

        private static class PointStatGeomEditor
        extends guiPanel
        implements IStatGeomEditor {
            private static final long serialVersionUID = 1L;
            private Point3DPanel d_location;

            public PointStatGeomEditor() {
                this.setLayout(new MigLayout());
                this.d_location = new Point3DPanel(Intl.intl("Location"));
                this.add((Component)this.d_location, "span, wrap");
            }

            @Override
            public void init() {
                this.load(new IStatGeom.Point(new Point3d()));
            }

            @Override
            public void load(IStatGeom geom) {
                Point3d loc = ((IStatGeom.Point)geom).loc;
                this.d_location.load(new UnitPoint3D(loc, Geometry.LU));
            }

            @Override
            public IStatGeom.Point save() {
                UnitPoint3D nonStatLoc = this.d_location.save();
                return new IStatGeom.Point(nonStatLoc.getPoint3dValue(Geometry.LU));
            }

            @Override
            public guiPanel getEditorPanel() {
                return this;
            }
        }

        private static class PlaneStatGeomEditor
        extends guiPanel
        implements IStatGeomEditor {
            private static final long serialVersionUID = 1L;
            private AARectangleEditor d_planeEditor;

            public PlaneStatGeomEditor() {
                this.setLayout(new MigLayout());
                this.d_planeEditor = new AARectangleEditor(false);
                this.add((Component)this.d_planeEditor, "span, wrap");
            }

            @Override
            public void init() {
                this.load(new IStatGeom.Rectangle(new AARectangle()));
            }

            @Override
            public void load(IStatGeom geom) {
                IStatGeom.Rectangle rect = (IStatGeom.Rectangle)geom;
                this.d_planeEditor.load(new AARectangle(rect.d_plane, rect.d_planeVal, rect.d_minx, rect.d_miny, rect.d_maxx, rect.d_maxy, rect.flipped));
            }

            @Override
            public IStatGeom save() {
                return new IStatGeom.Rectangle(this.d_planeEditor.saveData());
            }

            @Override
            public guiPanel getEditorPanel() {
                return this;
            }
        }

        private static class LinearArrayGeomEditor
        extends guiPanel
        implements IStatGeomEditor {
            private static final long serialVersionUID = 1L;
            private final IDevcEditor.Mode d_mode;
            private final IStatGeom.Type d_type;
            private final ValueField<Integer> d_numPoints;
            private final Point3DPanel d_p1;
            private final Point3DPanel d_p2;
            private final Point3DPanel d_delta;
            private final guiComboBox<IStatGeom.ArrayProfile> d_arrayOptionCombo;

            public LinearArrayGeomEditor(IStatGeom.Type type, IDevcEditor.Mode mode) {
                this.setLayout(new MigLayout());
                this.d_mode = mode;
                this.d_type = type;
                this.d_numPoints = ValueFields.intFld(IntVR.between(2, 100, true, true));
                this.d_p1 = new Point3DPanel(Intl.intl("Point 1:"), false, 0, true, false);
                this.d_p2 = new Point3DPanel(Intl.intl("Point 2:"), false, 0, true, false);
                this.d_arrayOptionCombo = new ArrayTypeComboBox();
                this.add((Component)new guiLabel(Intl.intl("Profile:")), "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
                this.add(this.d_arrayOptionCombo, "grow, gaptop 0, gapleft 0, gapbottom 3, gapright 6, span 2, wrap");
                this.add((Component)new guiLabel(Intl.intl("Num Points:")), "gaptop 0, gapleft 0, gapbottom 3, gapright 6");
                this.add(this.d_numPoints, "grow, gaptop 0, gapleft 0, gapbottom 3, gapright 6, span 2, wrap");
                this.d_p1.addToPanel(this, 0, 0);
                this.d_p2.addToPanel(this, 0, 0);
                if (this.isBoxArrayType()) {
                    this.d_delta = new Point3DPanel(Intl.intl("Delta:"), false, 0, true, false);
                    this.d_delta.addToPanel(this, 0, 0);
                } else {
                    this.d_delta = null;
                }
            }

            private boolean isBoxArrayType() {
                return this.d_type.equals((Object)IStatGeom.Type.BOX_ARRAY);
            }

            @Override
            public IStatGeom save() {
                int numPoints = (Integer)this.d_numPoints.getValue();
                UnitPoint3D up1 = this.d_p1.save();
                UnitPoint3D up2 = this.d_p2.save();
                Point3d delta = this.isBoxArrayType() ? this.d_delta.save().getPoint3dValue(Geometry.LU) : new Point3d();
                return new IStatGeom.LinearArray(this.d_arrayOptionCombo.getSelectedItem(), up1.getPoint3dValue(Geometry.LU), up2.getPoint3dValue(Geometry.LU), delta, numPoints);
            }

            @Override
            public void init() {
                this.load(new IStatGeom.LinearArray(IStatGeom.ArrayProfile.STEADY_STATE, new Point3d(0.0, 0.0, 0.0), new Point3d(1.0, 1.0, 1.0), new Point3d(0.0, 0.0, 0.0), 2));
            }

            @Override
            public void load(IStatGeom geom) {
                IStatGeom.LinearArray arrayGeom = (IStatGeom.LinearArray)geom;
                this.d_numPoints.setValue(arrayGeom.numPoints);
                this.d_p1.load(new UnitPoint3D(arrayGeom.p1, Geometry.LU));
                this.d_p2.load(new UnitPoint3D(arrayGeom.p2, Geometry.LU));
                if (geom.getType().equals((Object)IStatGeom.Type.BOX_ARRAY)) {
                    this.d_delta.load(new UnitPoint3D(arrayGeom.delta.x, arrayGeom.delta.y, arrayGeom.delta.z, Geometry.LU));
                }
                this.d_arrayOptionCombo.setSelectedItem((Object)arrayGeom.profile);
            }

            @Override
            public guiPanel getEditorPanel() {
                return this;
            }

            @Override
            public boolean validateData(boolean showWarn, boolean allowModify) {
                int userChoice;
                if (!super.validateData(showWarn, allowModify)) {
                    return false;
                }
                return !this.d_mode.equals((Object)IDevcEditor.Mode.CREATE) || !this.d_arrayOptionCombo.getSelectedItem().equals((Object)IStatGeom.ArrayProfile.STEADY_STATE) || !showWarn || (userChoice = JOptionPane.showConfirmDialog(this.getParent(), Intl.intl("Devices with `Profile` set to `Steady-State` cannot be used as inputs to controls or other devices. Do you want to proceed?"), Intl.intl("Warning"), 0)) != 1;
            }
        }

        private static interface IStatGeomEditor {
            public void init();

            public void load(IStatGeom var1);

            public IStatGeom save();

            public guiPanel getEditorPanel();
        }
    }

    private static class StatisticSensitiveAlarmPanelModel
    extends AlarmInfoPanel.AlarmInfoPanelModel {
        private Supplier<QuantityStat> temporalStatSupplier;
        private Supplier<QuantityStat> spatialStatSupplier;

        public StatisticSensitiveAlarmPanelModel(int unitType, Supplier<QuantityStat> spatialStat, Supplier<QuantityStat> temporalStat) {
            super(unitType);
            this.temporalStatSupplier = temporalStat;
            this.spatialStatSupplier = spatialStat;
        }

        @Override
        public void load(IQuantity msr, AlarmInfo ai) {
            int unitType = StatisticsDevc.getUnitType(msr.get(), this.spatialStatSupplier.get(), this.temporalStatSupplier.get());
            super.load(unitType, ai);
        }
    }

    public static class StatisticsComboBox
    extends guiComboBox<QuantityStat> {
        private static final long serialVersionUID = 1L;
        private Quantity selectedQuant;
        private QuantityStat selectedSpatial;

        public StatisticsComboBox(Collection<QuantityStat> options) {
            super(options);
            this.setRenderer(new StatisticsCellRenderer());
        }

        public void updateSelectedObjs(Quantity q, QuantityStat spatial) {
            this.selectedQuant = q;
            this.selectedSpatial = spatial;
            this.repaint();
        }

        private class StatisticsCellRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;
            private static final ImageIcon s_warningIcon = PyroGuiUtil.loadPyroSimIcon("bad.png");

            private StatisticsCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                this.decorateCells(value);
                return this;
            }

            private void decorateCells(Object value) {
                if (value == null) {
                    this.setText(Intl.intl("[None]"));
                } else if (value instanceof QuantityStat) {
                    boolean isStatsCompatible;
                    QuantityStat quantityStat = (QuantityStat)((Object)value);
                    this.setText(quantityStat.displayName);
                    boolean isQuantCompatible = StatisticsComboBox.this.selectedQuant == null || StatisticsComboBox.this.selectedQuant.isCompatible(quantityStat);
                    boolean bl = isStatsCompatible = quantityStat.isSpatial() ? true : QuantityStat.isCompatible(StatisticsComboBox.this.selectedSpatial, quantityStat);
                    if (isQuantCompatible && isStatsCompatible) {
                        this.setIcon(null);
                    } else {
                        this.setIcon(s_warningIcon);
                    }
                } else {
                    assert (false);
                    this.setText(value.toString());
                }
            }
        }
    }

    public static class ArrayTypeComboBox
    extends guiComboBox<IStatGeom.ArrayProfile> {
        private static final long serialVersionUID = 1L;

        public ArrayTypeComboBox() {
            super(IStatGeom.ArrayProfile.values());
            this.setRenderer(new ArrayTypeListCellRenderer());
        }

        private static class ArrayTypeListCellRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = 1L;

            private ArrayTypeListCellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                IStatGeom.ArrayProfile profile = (IStatGeom.ArrayProfile)((Object)value);
                this.setText(profile.name);
                this.setToolTipText(profile.description);
                return this;
            }
        }
    }
}

