/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.AControl;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.CustomCtrl;
import pyrosim.domain.controls.IControl;
import pyrosim.domain.controls.ManualCtrl;
import pyrosim.domain.controls.Util;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ILogicInPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.Util;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.gui.controls.ControlPnlUtil;
import pyrosim.gui.controls.LogicControlPnl;
import pyrosim.gui.controls.RampActivationPanel;
import pyrosim.io.fds.DefaultFieldRenderer;
import pyrosim.io.fds.FDSGrammar;
import pyrosim.io.fds.FDSParseException;
import pyrosim.io.fds.FDSParseRecord;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParseWarning;
import pyrosim.io.fds.FDSRecord;
import pyrosim.io.fds.FDSRecordCollector;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;
import pyrosim.io.fds.FDSWarningReport;
import pyrosim.io.fds.v6.FDS6Const;
import pyrosim.io.fds.v6.parsers.FDS6Parser;
import pyrosim.io.fds.v6.renderers.FDS6Renderer;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.Utils;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.WarningDlg;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.StringPrintWriter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.SortCache;
import thunderheadeng.util.WarningReport;
import thunderheadeng.util.theUtil;

public class ControlStatementPnl
extends guiPanel {
    static final long serialVersionUID = 1L;
    private final LogicControlPnl d_ctrlPnl;
    private boolean d_modified = false;
    private final JEditorPane d_editor;
    private final JTextArea d_customEditor;
    private final DocumentListener d_customListener;
    private final JScrollPane d_customSP;
    private final RampActivationPanel d_rampPnl;
    private final guiPanel d_customPnl;
    private final guiCheckBox d_linkWithModelCB;
    private final ControlDesc d_desc;
    private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;
    private Predicate<ISignalSink> d_selfReferenceSinkFilter;
    private Predicate<ILogicOutPin> d_selfReferenceSourcePinFilter;
    private Runnable d_onSourceUpdateAction = () -> {};
    private Set<ISignalSink> d_sinks = null;
    private List<String> d_customCtrlNames = null;

    public ControlStatementPnl(LogicControlPnl ctrlPnl, boolean displaySinks) {
        super(new GridBagLayout());
        this.d_ctrlPnl = ctrlPnl;
        this.d_desc = new ControlDesc(true, displaySinks);
        this.d_editor = new JEditorPane("text/html", "");
        this.d_editor.addHyperlinkListener(e -> this.hyperlinkSelected(e));
        this.d_editor.setEditable(false);
        this.d_editor.setCaret(new DefaultCaret(){
            private static final long serialVersionUID = 1L;

            @Override
            public void paint(Graphics g) {
            }
        });
        JScrollPane sp = new JScrollPane(this.d_editor);
        this.d_linkWithModelCB = new guiCheckBox("<html>" + Intl.intl("Synchronize entered controls with model<br>(PyroSim may slightly alter the controls).") + "</html>");
        this.d_customPnl = new guiPanel(new GridBagLayout());
        guiLabel customLbl = new guiLabel(Intl.intl("Enter FDS CTRL Records:"));
        this.d_customEditor = new JTextArea();
        this.d_customEditor.setEditable(true);
        this.d_customEditor.setFont(this.d_editor.getFont());
        this.d_customSP = new JScrollPane(this.d_customEditor);
        GridBagUtil.add(this.d_customPnl, this.d_linkWithModelCB, 0, 0, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_customPnl, customLbl, 0, 1, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_customPnl, this.d_customSP, 0, 2, 1, 1, 6, 0, 6, 0, 1, 1.0, 1.0, 10);
        this.d_rampPnl = new RampActivationPanel();
        GridBagUtil.add(this, this.d_customPnl, 0, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.75, 10);
        GridBagUtil.add(this, sp, 0, 1, 1, 1, 0, 0, 0, 0, 1, 1.0, 0.25, 10);
        GridBagUtil.add(this, this.d_rampPnl, 0, 2, 1, 1, 6, 0, 0, 0, 1, 1.0, 0.75, 10);
        sp.setPreferredSize(new Dimension(350, 150));
        this.d_customSP.setPreferredSize(new Dimension(350, 150));
        this.d_rampPnl.setPreferredSize(new Dimension(350, 250));
        this.d_customListener = new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changed();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changed();
            }

            private void changed() {
                int search;
                ControlStatementPnl.this.d_customCtrlNames = null;
                List<String> names = ControlStatementPnl.this.getCustomCtrlNames();
                if (ControlStatementPnl.this.d_desc.d_customCtrlName != null && (search = theUtil.binarySearch(names, ControlStatementPnl.this.d_desc.d_customCtrlName, ControlStatementPnl.newNameComparator())) < 0) {
                    ControlStatementPnl.this.d_desc.setCustomCtrlName(null);
                    ControlStatementPnl.this.changed();
                }
                if (ControlStatementPnl.this.d_desc.d_customCtrlName == null && names.size() > 0) {
                    ControlStatementPnl.this.d_desc.setCustomCtrlName(names.iterator().next());
                    ControlStatementPnl.this.changed();
                }
                ControlStatementPnl.this.changed();
            }
        };
        this.d_customEditor.getDocument().addDocumentListener(this.d_customListener);
    }

    public ControlDesc getDescription() {
        return this.d_desc;
    }

    private static Comparator<String> newNameComparator() {
        return (o1, o2) -> o1.compareToIgnoreCase((String)o2);
    }

    private static boolean isValidCustomRec(FDSRecord rec) {
        return rec.getType().equals("CTRL") || rec.getType().equals("RAMP") || rec.getType().equals("TABL") || rec.getType().equals("DEVC") && Quantity.TIME.fdsName.equals(rec.getString("QUANTITY"));
    }

    private void showSimplifiedWarnings(FDSWarningReport fullReport) {
        WarningReport<FDSParseWarning> simpleWarnings = new WarningReport<FDSParseWarning>(FDSParseWarning.class, new int[]{2, 0}, new String[]{Intl.intl("Line"), Intl.intl("Warning")}, 2);
        for (FDSParseWarning warning : fullReport.getWarnings()) {
            simpleWarnings.addWarning(warning);
        }
        WarningDlg dlg = WarningDlg.create(this, Intl.intl("FDS Warnings"), Intl.intl("The following table lists some problems reading the FDS controls."), simpleWarnings);
        dlg.doModal();
    }

    private IOutPin parseManualControl(boolean showWarn) {
        if (this.d_desc.d_input != 3) {
            return null;
        }
        if (this.d_desc.d_customCtrlName == null) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, Intl.intl("At least one CTRL record with a valid ID must be specified."), Intl.intl("No CTRL Found"), 0);
            }
            return null;
        }
        if (!this.d_linkWithModelCB.isSelected()) {
            ManualCtrl ctrl = new ManualCtrl(this.d_customEditor.getText(), this.d_desc.d_customCtrlName);
            return ctrl.getOutputPins().get(0);
        }
        FDSWarningReport warnings = new FDSWarningReport();
        try {
            List<FDSParseRecord> recs = this.getCustomRecords(warnings);
            if (showWarn && !warnings.isEmpty()) {
                this.showSimplifiedWarnings(warnings);
            }
            for (FDSParseRecord rec : recs) {
                if (ControlStatementPnl.isValidCustomRec(rec)) continue;
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, Intl.intl("Only enter records of type CTRL and RAMP.  You may additionally specify\nDEVC records if the QUANTITY is \"TIME\"."), Intl.intl("Invalid Custom Records"), 0);
                }
                return null;
            }
            FDS6Parser parser = new FDS6Parser();
            PyroMod tempMod = new PyroMod();
            FDSParseResult result = parser.parseRecords(recs, tempMod, PyroSim.getApp().getMediator());
            if (showWarn && !result.warningReport.isEmpty()) {
                this.showSimplifiedWarnings(result.warningReport);
            }
            ControlBridge ctrlFound = null;
            for (ControlBridge ctrl : theUtil.filter(result.extractedObjs, ControlBridge.class)) {
                if (!ctrl.getName().equals(this.d_desc.d_customCtrlName)) continue;
                ctrlFound = ctrl;
                break;
            }
            if (ctrlFound == null || ctrlFound.getInputPin().getConnections().isEmpty()) {
                if (showWarn) {
                    JOptionPane.showMessageDialog(this, String.format(Intl.intl("The specified CTRL, \"%s\", is invalid."), this.d_desc.d_customCtrlName), Intl.intl("Specified CTRL Invalid"), 0);
                }
                return null;
            }
            return ctrlFound.getInputPin().getConnections().iterator().next();
        }
        catch (Exception e) {
            if (showWarn) {
                JOptionPane.showMessageDialog(this, e.getMessage(), Intl.intl("FDS Format Error"), 0);
            }
            return null;
        }
    }

    @Override
    public boolean validateData(boolean showWarn, boolean allowModify) {
        if (!super.validateData(showWarn, allowModify)) {
            return false;
        }
        if (!this.d_desc.validateData(this, this.d_sinkType, showWarn, allowModify)) {
            return false;
        }
        if (this.d_desc.d_input == 3) {
            IOutPin pin = this.parseManualControl(showWarn);
            return pin != null;
        }
        return true;
    }

    public void setSinkType(ControlDesc.SinkType sinkType) {
        this.d_sinkType = sinkType;
        this.d_rampPnl.setSinkType(sinkType);
    }

    private void loadSelfReferenceFilter(ISignalSink currBridge) {
        this.d_selfReferenceSinkFilter = compObj -> !compObj.isEquiv(currBridge);
        this.d_selfReferenceSourcePinFilter = !(currBridge instanceof ISignalSource) ? Predicates.alwaysTrue() : compPin -> compPin != ((ISignalSource)((Object)currBridge)).getOutputPins().iterator().next();
    }

    public void load(IInPin inPin) {
        AControl ctrl;
        ISignalSource src;
        this.loadSelfReferenceFilter(inPin.getAttachedSink());
        this.d_desc.load(inPin);
        if (this.d_desc.d_input == 4) {
            assert (inPin.getConnections().size() == 1);
            src = inPin.getConnectedSources().iterator().next();
            assert (src instanceof CustomCtrl);
            ctrl = (CustomCtrl)src;
            assert (((CustomCtrl)ctrl).getInputPin().getConnections().size() == 1);
            this.d_rampPnl.load((CustomCtrl)ctrl, false);
        }
        if (inPin.getConnections().size() == 1) {
            src = inPin.getConnectedSources().iterator().next();
            if (src instanceof ManualCtrl) {
                this.d_linkWithModelCB.setSelected(false);
                ctrl = (ManualCtrl)src;
                this.d_desc.setCustomCtrlName(ctrl.getName());
                this.d_customEditor.getDocument().removeDocumentListener(this.d_customListener);
                this.d_customEditor.setText(((ManualCtrl)ctrl).getFDSText());
                this.d_customEditor.getDocument().addDocumentListener(this.d_customListener);
            } else {
                this.d_linkWithModelCB.setSelected(true);
                FDS6Renderer rend = new FDS6Renderer(PyroSim.getApp().getMediator(), PyroSim.getFdsRenderPropsNullSafe(), FDSRenderer.RENDER_ORIGIN.DEFAULT);
                FDSRecordCollector collector = new FDSRecordCollector(rend.getProps());
                rend.renderObjects(collector, Collections.singletonList(inPin.getAttachedSink()), Collections.emptyMap());
                StringPrintWriter writer = new StringPrintWriter();
                Set<IPyroObject> invalidRenders = Util.getManualControlIgnoreRecs(inPin.getAttachedSink());
                for (Map.Entry<IPyroObject, List<FDSRenderRecord>> recordMap : collector.getRecordMap().entrySet()) {
                    if (invalidRenders.contains(recordMap.getKey())) continue;
                    for (FDSRenderRecord rec : recordMap.getValue()) {
                        if (!ControlStatementPnl.isValidCustomRec(rec)) continue;
                        rec.renderRecord(writer, rend.getProps(), DefaultFieldRenderer.INSTANCE);
                    }
                }
                String rendered = writer.toString();
                this.d_customEditor.setText(rendered);
                String name = src instanceof INamed ? ((INamed)((Object)src)).getName() : null;
                this.d_desc.setCustomCtrlName(name);
            }
        } else {
            this.d_linkWithModelCB.setSelected(false);
            this.d_customEditor.setText("");
            this.d_desc.setCustomCtrlName(null);
        }
    }

    public IOutPin save() {
        IOutPin opin = this.d_desc.save();
        if (opin != null) {
            return opin;
        }
        if (this.d_desc.d_input == 4) {
            return this.d_rampPnl.save();
        }
        if (this.d_desc.d_input == 3) {
            return this.parseManualControl(false);
        }
        return null;
    }

    private void changed() {
        this.updateMessage();
        this.d_onSourceUpdateAction.run();
        this.setModified(true);
    }

    public void setData(int action, int input, boolean latch) {
        this.d_desc.setData(action, input, latch);
        this.d_customPnl.setVisible(input == 3);
        this.d_rampPnl.setVisible(input == 4);
        this.changed();
        this.updateMessage();
    }

    @Override
    public boolean isModified() {
        return super.isModified() || this.d_modified;
    }

    @Override
    public void setModified(boolean modified) {
        this.d_modified = modified;
        super.setModified(modified);
    }

    private void updateMessage() {
        String msg = this.d_desc.formatMessage(this.d_sinkType);
        this.d_editor.setText(msg);
        this.d_editor.setEnabled(this.d_desc.d_input != 3 || !this.getCustomCtrlNames().isEmpty());
    }

    private void hyperlinkSelected(HyperlinkEvent evt) {
        if (!this.isEnabled()) {
            return;
        }
        String id = evt.getDescription();
        Rectangle caretLoc = null;
        if (evt.getSourceElement() == null) {
            return;
        }
        try {
            caretLoc = this.d_editor.modelToView(evt.getSourceElement().getStartOffset());
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            Point loc = new Point(this.d_editor.getLocationOnScreen());
            loc.x += caretLoc.x;
            loc.y += caretLoc.y + caretLoc.height;
            if (id.equals("LOGIC")) {
                this.selectLogic(loc);
            } else if (id.equals("ACTIVATE")) {
                this.selectActivate(loc);
            } else if (id.equals("N")) {
                this.selectN(loc);
            } else if (id.equals("T")) {
                this.selectT(loc);
            } else if (id.equals("DBLOWERV")) {
                this.selectDBBound(loc, true);
            } else if (id.equals("DBUPPERV")) {
                this.selectDBBound(loc, false);
            } else if (id.equals("DBLOWERL")) {
                this.selectDBLogic(loc, true);
            } else if (id.equals("DBUPPERL")) {
                this.selectDBLogic(loc, false);
            } else if (id.equals("DETSOURCES")) {
                this.selectDetectorSources(loc);
            } else if (id.equals("MSRSOURCES")) {
                this.selectMeasurerSource(loc);
            } else if (id.equals("SINKS")) {
                this.selectSinks(loc);
            } else if (id.equals("DELAY")) {
                this.selectDelay(loc);
            } else if (id.equals("CUSTOMINPUT")) {
                this.selectCustomInput(loc);
            }
        }
    }

    private Set<ISignalSink> getFilteredSinks() {
        return this.getSinks().stream().filter(this.d_selfReferenceSinkFilter).sorted((p1, p2) -> ControlDesc.getName(p1).compareToIgnoreCase(ControlDesc.getName(p2))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<ISignalSink> getSinks() {
        if (this.d_sinks != null) {
            return this.d_sinks;
        }
        this.beginWaitCursor();
        PyroMod domain = PyroSim.getApp().getMediator();
        Map<AControl, Util.ControlBridgeAsSinkHelper> cbSinks = this.d_ctrlPnl.getCBSinks();
        this.d_sinks = new TreeSet<ISignalSink>((o1, o2) -> {
            int compare = ControlDesc.getName(o1).compareToIgnoreCase(ControlDesc.getName(o2));
            if (compare != 0) {
                return compare;
            }
            return Integer.compare(System.identityHashCode(o1), System.identityHashCode(o2));
        });
        block0: for (ISignalSink sink : Hierarchy.flatten(domain.getMembers(), ISignalSink.class)) {
            if (sink instanceof IControl) {
                if (!(sink instanceof ControlBridge)) continue;
                for (Util.ControlBridgeAsSinkHelper cbHelper : cbSinks.values()) {
                    if (cbHelper.end != sink) continue;
                    this.d_sinks.add(cbHelper);
                    continue block0;
                }
                continue;
            }
            if (sink instanceof IHvacObject || !(sink.getInputPin() instanceof ILogicInPin)) continue;
            this.d_sinks.add(sink);
        }
        this.endWaitCursor();
        return this.d_sinks;
    }

    private void selectSinks(Point loc) {
        if (this.d_desc.d_dstObjNames != null) {
            return;
        }
        Set<ISignalSink> sinks = this.getFilteredSinks();
        if (sinks.isEmpty()) {
            return;
        }
        ControlPnlUtil.MultiSelectHelperWindow wnd = this.createHelperWindow(ControlPnlUtil.MultiSelectHelperWindow.class);
        wnd.initAllObjs(sinks);
        wnd.init(loc, this.d_desc.d_dstObjs, val -> {
            ControlDesc.SinkType sinkType = ControlDesc.getSinkType(val);
            this.d_desc.setSinks(val);
            this.d_ctrlPnl.setSinkType(sinkType);
            this.changed();
        });
    }

    private Set<ILogicOutPin> getFilteredLogicSourcePins() {
        return this.getLogicSourcePins().stream().filter(this.d_selfReferenceSourcePinFilter).sorted((p1, p2) -> ControlDesc.getName(p1).compareToIgnoreCase(ControlDesc.getName(p2))).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<ILogicOutPin> getLogicSourcePins() {
        return this.d_ctrlPnl.getParentEditor().getLogicPins();
    }

    private void selectDetectorSources(Point loc) {
        Set<ILogicOutPin> logicPins = this.getFilteredLogicSourcePins();
        if (logicPins.isEmpty()) {
            return;
        }
        ControlPnlUtil.MultiSelectHelperWindow wnd = this.createHelperWindow(ControlPnlUtil.MultiSelectHelperWindow.class);
        wnd.initAllObjs(logicPins);
        wnd.init(loc, this.d_desc.d_srcDetectors, val -> {
            this.d_desc.setSources(val);
            this.changed();
        });
    }

    private SortCache<IDoubleOutPin> getDblSrcPins() {
        return new SortCache<IDoubleOutPin>(this.d_ctrlPnl.getParentEditor().getDblSrcPins(), (o1, o2) -> ControlDesc.getName(o1).compareToIgnoreCase(ControlDesc.getName(o2)));
    }

    private void selectMeasurerSource(Point loc) {
        SortCache<IDoubleOutPin> msrPins = this.getDblSrcPins();
        if (msrPins.size() == 0) {
            return;
        }
        ControlPnlUtil.ListHelperWindow wnd = this.newListHelperWindow();
        int[] vals = new int[msrPins.size()];
        for (int m = 0; m < vals.length; ++m) {
            vals[m] = m;
        }
        String[] names = new String[msrPins.size()];
        for (int m = 0; m < names.length; ++m) {
            names[m] = ControlDesc.getName(msrPins.get(m));
        }
        int iniSel = this.d_desc.d_srcMeasurer == null ? -1 : msrPins.indexOf(this.d_desc.d_srcMeasurer);
        wnd.init(loc, true, iniSel, vals, names, ix -> {
            IDoubleOutPin newPin = ix >= 0 ? (IDoubleOutPin)msrPins.get(ix) : null;
            this.d_desc.setSourceMeasurer(newPin);
            this.changed();
        });
    }

    private List<FDSParseRecord> getCustomRecords(FDSWarningReport warnings) throws FDSParseException {
        return FDSGrammar.parse(this.d_customEditor.getText(), null, warnings, FDS6Const.getRecordSpecs(), "TAIL");
    }

    private List<String> getCustomCtrlNames() {
        if (this.d_customCtrlNames != null) {
            return this.d_customCtrlNames;
        }
        TreeSet<String> names = new TreeSet<String>((o1, o2) -> o1.compareToIgnoreCase((String)o2));
        try {
            FDSWarningReport warnings = new FDSWarningReport();
            ArrayList<String> allNames = new ArrayList<String>();
            HashSet refedNames = new HashSet();
            List<FDSParseRecord> records = this.getCustomRecords(warnings);
            for (FDSParseRecord rec : records) {
                String id;
                if (rec.getType().equals("CTRL")) {
                    List inputids;
                    id = rec.getString("ID");
                    if (id != null) {
                        allNames.add(id);
                    }
                    if ((inputids = rec.getList("INPUT_ID", true)) == null) continue;
                    refedNames.addAll(inputids);
                    continue;
                }
                if (!rec.getType().equals("DEVC") || !Quantity.TIME.fdsName.equals(rec.getString("QUANTITY")) || (id = rec.getString("ID")) == null) continue;
                allNames.add(id);
            }
            for (String name : allNames) {
                if (refedNames.contains(name)) continue;
                names.add(name);
            }
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
        this.d_customCtrlNames = new ArrayList<String>(names);
        return this.d_customCtrlNames;
    }

    private void selectCustomInput(Point loc) {
        List<String> ctrlNames = this.getCustomCtrlNames();
        String[] names = ctrlNames.toArray(new String[ctrlNames.size()]);
        int[] vals = new int[ctrlNames.size()];
        int iniSel = -1;
        for (int m = 0; m < names.length; ++m) {
            vals[m] = m;
            if (!names[m].equals(this.d_desc.d_customCtrlName)) continue;
            iniSel = m;
        }
        ControlPnlUtil.ListHelperWindow wnd = this.newListHelperWindow();
        wnd.init(loc, true, iniSel, vals, names, val -> {
            if (val == -1) {
                this.d_desc.setCustomCtrlName(null);
            } else {
                this.d_desc.setCustomCtrlName(names[val]);
            }
            this.changed();
        });
    }

    private void selectDelay(Point loc) {
        ControlPnlUtil.ValueFieldHelperWindow<UnitDouble> wnd = this.newVFHelperWindow();
        ValueField<UnitDouble> fld = ValueFields.udFld(this.d_desc.d_delay, UnitDoubleVR.above(0.0, SI.SECOND, true), UnitSystem.getSource(2));
        wnd.init(loc, fld, val -> {
            this.d_desc.setDelay((UnitDouble)val);
            this.changed();
        });
    }

    private void selectDBLogic(Point loc, boolean lower) {
        ControlPnlUtil.ListHelperWindow wnd = this.newListHelperWindow();
        String[] names = new String[]{this.d_sinkType.strings.on, this.d_sinkType.strings.off};
        int[] vals = new int[]{1, 0};
        boolean iniVal = lower ? !this.d_desc.d_dbUpper : this.d_desc.d_dbUpper;
        int iniSel = iniVal ? 1 : 0;
        wnd.init(loc, false, iniSel, vals, names, val -> {
            boolean newval = val == 1;
            this.d_desc.setDBLogic(newval, lower);
            this.changed();
        });
    }

    private void selectDBBound(Point loc, boolean lower) {
        ControlPnlUtil.ValueFieldHelperWindow<UnitDouble> wnd = this.newVFHelperWindow();
        UnitDouble val = lower ? this.d_desc.d_dbRange[0] : this.d_desc.d_dbRange[1];
        ValueField<UnitDouble> fld = ValueFields.udFld(val, UnitSystem.getSource(this.d_desc.d_dbRangeType));
        wnd.init(loc, fld, setVal -> {
            this.d_desc.setDBBound((UnitDouble)setVal, lower);
            this.changed();
        });
    }

    private void selectLogic(Point loc) {
        ControlPnlUtil.ListHelperWindow wnd = this.newListHelperWindow();
        String[] names = new String[]{Intl.intl("any"), Intl.intl("all"), Intl.intl("at least n"), Intl.intl("no more than n"), Intl.intl("exactly n")};
        int[] vals = new int[]{0, 1, 2, 3, 4};
        wnd.init(loc, false, this.d_desc.d_logicType, vals, names, val -> {
            this.d_desc.setLogicType(val);
            this.changed();
        });
    }

    private void selectActivate(Point loc) {
        ControlPnlUtil.ListHelperWindow wnd = this.newListHelperWindow();
        String[] names = new String[]{Intl.intl("activate"), Intl.intl("deactivate")};
        int[] vals = new int[]{1, 0};
        wnd.init(loc, false, this.d_desc.d_sourceActivates ? 1 : 0, vals, names, val -> {
            this.d_desc.setSourceActivates(val == 1);
            this.changed();
        });
    }

    private void selectN(Point loc) {
        ControlPnlUtil.ValueFieldHelperWindow<Integer> wnd = this.newVFHelperWindow();
        ValueField<Integer> fld = ValueFields.intFld(this.d_desc.d_n, IntVR.above(1, true));
        wnd.init(loc, fld, val -> {
            this.d_desc.setN((int)val);
            this.changed();
        });
    }

    private void selectT(Point loc) {
        ControlPnlUtil.ValueFieldHelperWindow<UnitDouble> wnd = this.newVFHelperWindow();
        ValueField<UnitDouble> fld = ValueFields.udFld(new UnitDouble(0.0, SI.SECOND), UnitSystem.getSource(2));
        fld.setNullAllowed(true);
        ValueFields.getFormat(fld).alias(null, ControlDesc.TBEGIN);
        fld.setValue(this.d_desc.d_t);
        wnd.init(loc, fld, val -> {
            this.d_desc.setT((UnitDouble)val);
            this.changed();
        });
    }

    private <T> ControlPnlUtil.ValueFieldHelperWindow<T> newVFHelperWindow() {
        return this.createHelperWindow(ControlPnlUtil.ValueFieldHelperWindow.class);
    }

    private ControlPnlUtil.ListHelperWindow newListHelperWindow() {
        return this.createHelperWindow(ControlPnlUtil.ListHelperWindow.class);
    }

    private ControlPnlUtil.PopupWindow newHelperWindow() {
        return this.createHelperWindow(ControlPnlUtil.PopupWindow.class);
    }

    private <T extends ControlPnlUtil.PopupWindow> T createHelperWindow(Class<T> clazz) {
        Component parent = Utils.findParentWindow(this);
        try {
            if (parent instanceof Frame) {
                return (T)((ControlPnlUtil.PopupWindow)clazz.getConstructor(Frame.class).newInstance((Frame)parent));
            }
            if (parent instanceof Window) {
                return (T)((ControlPnlUtil.PopupWindow)clazz.getConstructor(Window.class).newInstance((Window)parent));
            }
            return (T)((ControlPnlUtil.PopupWindow)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void addOnSourceSelectUpdater(Runnable r) {
        this.d_onSourceUpdateAction = r;
    }
}

