/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.controls;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.swing.JSeparator;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Property;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.controls.ControlMgr;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.signals.Util;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.IGridBagAdder;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.controls.ControlDesc;
import pyrosim.gui.controls.ControlPnl;
import pyrosim.gui.controls.NewControlDlg;
import pyrosim.gui.controls.TextFldNameSource;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.Pair;

public class ControlSelPnl
implements IGridBagAdder {
    public static final String NEW_ENTRY = Intl.intl("<New...>");
    public final ControlBridge NULL_ENTRY = new ControlBridge("");
    private Function<Stream<? extends INamed>, Stream<String>> d_nameSource;
    private Collection<? extends INamed> d_nameSrcs = Collections.emptyList();
    private ControlDesc.SinkType d_sinkType = ControlDesc.SinkType.ACTIVATE;
    private final guiLabel d_lbl;
    private final ControlComboBox d_cb;
    private final guiLabel d_descLbl;
    public static final Composite.IObjectProp<OneLogicInPin, ControlBridge> CTRL_PROP = new Composite.AObjectProp<OneLogicInPin, ControlBridge>(OneLogicInPin.class){

        @Override
        public Object get(OneLogicInPin obj) {
            Set<? extends IOutPin> outPins = obj.getConnections();
            return outPins.isEmpty() ? null : outPins.iterator().next();
        }

        @Override
        public void set(OneLogicInPin obj, ControlBridge prop) {
            obj.disconnectAll();
            if (prop != null) {
                obj.connect(prop.getOutputPins().get(0));
            }
        }
    };

    public ControlSelPnl(ControlMgr mgr) {
        this(mgr, null, null);
    }

    public ControlSelPnl(ControlMgr mgr, String label, String labelTT) {
        this.d_cb = new ControlComboBox(mgr);
        this.d_lbl = new guiLabel(label == null ? Intl.intl("Activation:") : label);
        if (labelTT != null) {
            this.d_lbl.setToolTipText(labelTT);
        }
        this.d_nameSource = objs -> objs.map(INamed::getName);
        this.d_descLbl = new guiLabel();
        this.d_descLbl.setPreferredSize(new Dimension(20, this.d_cb.getPreferredSize().height));
        this.d_descLbl.setCursor(Cursor.getPredefinedCursor(12));
        this.d_descLbl.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!ControlSelPnl.this.d_descLbl.isEnabled()) {
                    return;
                }
                ControlBridge ctrl = (ControlBridge)ControlSelPnl.this.d_cb.getSelectedItem();
                if (ctrl != ControlSelPnl.this.NULL_ENTRY) {
                    ControlSelPnl.this.editControl(ctrl);
                    ControlSelPnl.this.updateFromSelection();
                }
            }
        });
        this.d_cb.addItemListener(e -> this.updateFromSelection());
        this.updateNullDesc();
        this.updateFromSelection();
    }

    private Pair<List<String>, ControlDesc.SinkType> getSinkNames(ControlBridge cb) {
        ControlDesc.SinkType sinkType;
        PyroMod domain = PyroSim.getApp().getMediator();
        DepSnapshot deps = domain.getDependencies(cb);
        Set<ISignalSink> sinks = deps.findAllDependents(ISignalSink.class, (Object)cb);
        for (INamed iNamed : this.d_nameSrcs) {
            if (!(iNamed instanceof ISignalSink)) continue;
            sinks.remove((ISignalSink)((Object)iNamed));
        }
        ControlDesc.SinkType type = !sinks.isEmpty() && !this.d_nameSrcs.isEmpty() ? ((sinkType = ControlDesc.getSinkType(sinks)) == this.d_sinkType ? sinkType : ControlDesc.SinkType.ACTIVATE) : (!sinks.isEmpty() ? ControlDesc.getSinkType(sinks) : (!this.d_nameSrcs.isEmpty() ? this.d_sinkType : ControlDesc.SinkType.ACTIVATE));
        ArrayList<String> arrayList = new ArrayList<String>(sinks.size() + this.d_nameSrcs.size());
        for (ISignalSink sink : sinks) {
            if (!(sink instanceof INamed)) continue;
            arrayList.add(((INamed)((Object)sink)).getName());
        }
        ((Stream)this.d_nameSource.apply(this.d_nameSrcs.stream()).sequential()).forEach(arrayList::add);
        return new Pair<List<String>, ControlDesc.SinkType>(arrayList, type);
    }

    private void editControl(final ControlBridge cb) {
        guiDialog ctrlDlg = new guiDialog((Window)PyroSim.getApp().getActiveFrame(), String.format(Intl.intl("Edit %s"), cb.getName()), 9);
        ctrlDlg.setResizable(true);
        PyroMod pyMod = PyroSim.getApp().getMediator();
        final ControlPnl pnl = new ControlPnl(pyMod);
        ctrlDlg.getDialogPane().add((Component)pnl, "Center");
        Pair<List<String>, ControlDesc.SinkType> sinkNames = this.getSinkNames(cb);
        pnl.initLogic(cb, (Collection)sinkNames.v1, (ControlDesc.SinkType)((Object)sinkNames.v2));
        if (ctrlDlg.doModal() == 1) {
            AOneTimeTask t = new AOneTimeTask(this){

                @Override
                public void run() {
                    pnl.commit(cb);
                }
            };
            pyMod.getTaskManager().exec(t, Intl.intl("Edit Control"));
        }
    }

    public void setSourceObjs(Collection<? extends INamed> objs) {
        this.d_nameSrcs = objs;
        this.d_sinkType = ControlDesc.getSinkType(this.d_nameSrcs);
        this.updateNullDesc();
    }

    private void updateNullDesc() {
        this.NULL_ENTRY.setName(this.d_sinkType.strings.defaultDesc);
        this.d_cb.regen();
    }

    public void setNameSrc(JTextComponent nameFld, Collection<? extends INamed> objs) {
        this.setNameSrc(new TextFldNameSource(nameFld), objs);
    }

    public void setNameSrc(Function<Stream<? extends INamed>, Stream<String>> nameSource, Collection<? extends INamed> objs) {
        this.d_nameSource = nameSource;
        this.setSourceObjs(objs);
    }

    @Override
    public void add(GridBagHelper gbh) {
        gbh.addRow(this.d_lbl, this.d_cb, this.d_descLbl, 1.0, 0);
    }

    public void addToMig(guiPanel basePanel) {
        assert (basePanel.getLayout() instanceof MigLayout);
        basePanel.add((Component)this.d_lbl, "grow 0");
        basePanel.add((Component)this.d_cb, "grow 0, split");
        this.d_descLbl.setPreferredSize(null);
        basePanel.add((Component)this.d_descLbl, String.format(Locale.US, "span, grow, height min:pref:%d, wrap", this.d_cb.getPreferredSize().height));
    }

    public int addToGridBag(Container parent, int col, int row, int top, int left, int bottom, int right) {
        assert (parent.getLayout() instanceof GridBagLayout);
        GridBagUtil.add(parent, this.d_lbl, col, row, 1, 1, top, left, bottom, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(parent, this.d_cb, ++col, row, 1, 1, top, 0, bottom, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(parent, this.d_descLbl, ++col, row, 5, 1, top, 0, bottom, right, 2, 1.0, 0.0, 17);
        return ++row;
    }

    public ControlComboBox getComboBox() {
        return this.d_cb;
    }

    public void setSelectedComboItem(Object obj) {
        this.d_cb.setSelectedItem(obj);
    }

    public void resetCombo() {
        this.d_cb.setSelectedItem(this.NULL_ENTRY);
    }

    private void updateFromSelection() {
        String dispMsg;
        String msg = "";
        ControlBridge ctrl = (ControlBridge)this.d_cb.getSelectedItem();
        if (ctrl != null && ctrl != this.NULL_ENTRY) {
            ControlDesc desc = new ControlDesc(false, false);
            desc.load(ctrl.getInputPin());
            msg = desc.formatMessage(this.d_sinkType);
        }
        if ((dispMsg = msg).length() > 30) {
            dispMsg = dispMsg.substring(0, 29);
            dispMsg = dispMsg.concat("...");
        }
        this.d_descLbl.setText("<html><a href=\"BLAH\">" + dispMsg + "</a></html>");
        String tt = msg.trim().length() > 0 ? "<html>" + msg + "</html>" : null;
        this.d_descLbl.setToolTipText(tt);
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.d_descLbl.setEnabled(this.d_cb.isEnabled() && this.d_cb.getSelectedItem() != this.NULL_ENTRY && this.d_cb.getSelectedItem() != null);
    }

    public void setEnabled(boolean enabled) {
        this.d_lbl.setEnabled(enabled);
        this.d_cb.setEnabled(enabled);
        if (!enabled && this.d_cb.getSelectedItem() != null) {
            this.d_cb.setSelectedItem(this.NULL_ENTRY);
        }
        this.updateEnabled();
    }

    public boolean isEnabled() {
        return this.d_lbl.isEnabled() || this.d_cb.isEnabled() || this.d_descLbl.isEnabled();
    }

    public void selectAlwaysOn() {
        this.d_cb.setSelectedItem(this.NULL_ENTRY);
    }

    public boolean validateData(Component parent, ISignalSink sink, boolean showWarn, boolean allowModify) {
        ControlBridge ctrl = (ControlBridge)this.d_cb.getSelectedItem();
        if (ctrl == null) {
            return true;
        }
        if (Util.containsCycle(sink, ctrl)) {
            if (showWarn) {
                guiDialog.showInvalidEntryMessage(parent, String.format(Intl.intl("The device cannot be controlled by the control %s because it creates a cyclic definition."), ctrl.getName()));
            }
            return false;
        }
        return true;
    }

    public boolean save(Collection<OneLogicInPin> pins) {
        ControlBridge ctrl = (ControlBridge)this.d_cb.getSelectedItem();
        if (ctrl == null) {
            return false;
        }
        for (OneLogicInPin inPin : pins) {
            inPin.disconnectAll();
            if (ctrl == this.NULL_ENTRY) continue;
            inPin.connect(ctrl.getOutputPins().get(0));
        }
        return true;
    }

    public void load(Collection<OneLogicInPin> pins) {
        if (pins.isEmpty()) {
            return;
        }
        Iterator<OneLogicInPin> pinit = pins.iterator();
        IInPin pin = pinit.next();
        while (pinit.hasNext()) {
            if (pinit.next().equals(pin)) continue;
            this.d_cb.setSelectedItem(null);
            return;
        }
        Set<ISignalSource> srcs = pin.getConnectedSources();
        if (!srcs.isEmpty()) {
            ISignalSource src = srcs.iterator().next();
            assert (src instanceof ControlBridge);
            this.d_cb.setSelectedItem(src);
        } else {
            this.d_cb.setSelectedItem(this.NULL_ENTRY);
        }
    }

    public void load(Property<ControlBridge> prop) {
        if (!prop.isUniform()) {
            this.d_cb.setSelectedItem(null);
        } else if (prop.get() == null) {
            this.d_cb.setSelectedItem(this.NULL_ENTRY);
        } else {
            this.d_cb.setSelectedItem(prop.get());
        }
    }

    public Property<ControlBridge> save() {
        ControlBridge ctrl = (ControlBridge)this.d_cb.getSelectedItem();
        if (ctrl == null) {
            return Property.nonUniform();
        }
        if (ctrl == this.NULL_ENTRY) {
            return Property.of(null);
        }
        return Property.of(ctrl);
    }

    public static <T extends ISignalSink> Composite.IObjectProp<T, ControlBridge> getControlProp(Class<T> type) {
        return new Composite.AObjectProp<T, ControlBridge>(type){

            @Override
            public Object get(T obj) {
                Set<ISignalSource> sources = obj.getInputPin().getConnectedSources();
                return sources.stream().filter(src -> src instanceof ControlBridge).findFirst().orElse(null);
            }

            @Override
            public void set(T obj, ControlBridge prop) {
                boolean modified = true;
                if (prop == null) {
                    modified = !obj.getInputPin().getConnections().isEmpty();
                }
                obj.getInputPin().disconnectAll();
                if (prop != null) {
                    obj.getInputPin().connect(prop.getOutputPins().get(0));
                }
                if (modified && obj instanceof IPyroObject) {
                    obj.changedEvt(new Object[0]);
                }
            }
        };
    }

    private class ControlComboBox
    extends PyroComboBox<ControlBridge> {
        private static final long serialVersionUID = 5043899586548986712L;

        public ControlComboBox(ControlMgr mgr) {
            super(mgr, ControlBridge.class);
            super.setSelectedItem(ControlSelPnl.this.NULL_ENTRY);
            this.setFilter(cb -> !cb.isMathControl());
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (anObject == NEW_ENTRY) {
                this.newControl();
            } else if (anObject == null || ControlBridge.class.isInstance(anObject)) {
                super.setSelectedItem(anObject);
            }
        }

        private void newControl() {
            NewControlDlg dlg = new NewControlDlg((ControlMgr)this.getManager(), NewControlDlg.TYPE_ACTIVATION, NewControlDlg.TYPE_CUSTOM);
            if (dlg.doModal() == 1) {
                ControlBridge tmpBridge = dlg.getControlType().equals(NewControlDlg.TYPE_CUSTOM) ? ControlBridge.initNewCustomCtrl(dlg.getName()) : new ControlBridge(dlg.getName());
                guiDialog ctrlDlg = new guiDialog((Window)PyroSim.getApp().getActiveFrame(), Intl.intl("New Control"), 9);
                ctrlDlg.setResizable(true);
                PyroMod pyMod = PyroSim.getApp().getMediator();
                ControlPnl pnl = new ControlPnl(pyMod);
                ctrlDlg.getDialogPane().add((Component)pnl, "Center");
                Pair<List<String>, ControlDesc.SinkType> sinkNames = ControlSelPnl.this.getSinkNames(tmpBridge);
                pnl.initLogic(tmpBridge, (Collection)sinkNames.v1, (ControlDesc.SinkType)((Object)sinkNames.v2));
                if (ctrlDlg.doModal() == 1) {
                    tmpBridge = pnl.commit(tmpBridge);
                    AddTask tsk = new AddTask(this.getManager(), (IPyroObject[])new ControlBridge[]{tmpBridge});
                    pyMod.getTaskManager().exec(tsk, Intl.intl("New Control"));
                    this.setSelectedItem(tmpBridge);
                }
            }
        }

        @Override
        protected Collection<?> getObjList() {
            Collection<?> defList = this.getDefaultList();
            ArrayList<Object> list = new ArrayList<Object>(defList.size() + 3);
            list.add(NEW_ENTRY);
            list.add(new JSeparator());
            list.add(ControlSelPnl.this.NULL_ENTRY);
            list.addAll(defList);
            return list;
        }

        public void regen() {
            this.updateList();
        }
    }

    public static interface INameSource
    extends Function<Stream<? extends INamed>, Stream<String>> {
    }
}

