/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.actions.Actions;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.io.PyroSimObjectOutputStream;
import pyrosim.util.Util;
import thunderheadeng.gui.ALibraryDlg;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ModelCheckLibraryDlg
extends ALibraryDlg<ModelCheck> {
    private List<ModelCheck> d_libModel;
    private List<ModelCheck> d_curModel;
    private PyroMod d_domain = PyroSim.getApp().getMediator();
    private String d_currentLib = "";

    public ModelCheckLibraryDlg(JFrame owner) {
        super(owner, Intl.intl("Model Check Libraries"));
        this.d_curModel = new ArrayList<ModelCheck>();
        this.d_curModel.addAll(PyroSim.getApp().getMediator().getModelCheckMgr().flatten());
        this.d_libModel = new ArrayList<ModelCheck>();
        this.loadList(this.d_curModel, this.d_modelObjs);
        this.init();
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    private boolean init() {
        String prefLib = PyroPrefs.getString(PyroPrefs.PREF_LASTLIBRARY);
        ArrayList<String> libsToTry = new ArrayList<String>();
        libsToTry.add(prefLib);
        if (!prefLib.equals(PyroPrefs.PREF_LASTLIBRARY.defVal)) {
            libsToTry.add((String)PyroPrefs.PREF_LASTLIBRARY.defVal);
        }
        for (String lib : libsToTry) {
            File f = new File(lib);
            if (!this.loadLibraryModelFromFile(f, false)) continue;
            this.setCurrentLibrary(lib);
            return true;
        }
        this.createLibrary();
        this.d_libUnsaved = false;
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            if (!this.checkSaveNewLib()) {
                return;
            }
            PyroPrefs.set(PyroPrefs.PREF_LASTLIBRARY, this.d_currentLib, true);
        }
        super.setVisible(visible);
    }

    private void loadList(List<ModelCheck> from, JList<ModelCheck> to) {
        to.setListData((ModelCheck[])theUtil.toArray(from, ModelCheck.class));
    }

    public boolean loadLibraryModelFromFile(File f, boolean showWarnings) {
        List newLibModel = new ArrayList();
        try {
            FileInputStream fis = new FileInputStream(f);
            BufferedInputStream bis = new BufferedInputStream(fis);
            PyroSimObjectInputStream ois = new PyroSimObjectInputStream(bis, false);
            newLibModel = (List)ois.readObject();
        }
        catch (ClassNotFoundException cnfe) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this, cnfe.getLocalizedMessage(), Intl.intl("Error"), 2);
            }
            cnfe.printStackTrace();
            return false;
        }
        catch (IOException e) {
            if (showWarnings) {
                JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), Intl.intl("Error"), 2);
            }
            e.printStackTrace();
            return false;
        }
        if (newLibModel != null) {
            this.d_libModel = newLibModel;
        }
        return newLibModel != null;
    }

    private void setCurrentLibrary(String lib) {
        this.d_currentLib = lib;
        File f = new File(this.d_currentLib);
        PyroSim.getApp().setLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString(), f);
        String libLabel = String.format(Intl.intl("Library: ...%s"), f.getName());
        String fullLabel = String.format(Intl.intl("Library: %s"), f.getAbsolutePath());
        this.d_libLbl.setText(libLabel);
        this.d_libLbl.setToolTipText(fullLabel);
    }

    @Override
    protected boolean loadLibraryModel() {
        if (!this.checkSaveNewLib()) {
            return false;
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(this.d_currentLib != null ? this.d_currentLib : null, PyroPrefs.get(PyroPrefs.LastFDSDatabaseDirProp), null, (Boolean)false, (Boolean)false, (Boolean)true, FileFilters.EXT_FILTER_PSLIB);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return false;
        }
        PyroPrefs.set(PyroPrefs.LastFDSDatabaseDirProp, f.getParent());
        if (!this.loadLibraryModelFromFile(f, true)) {
            JOptionPane.showMessageDialog(this, String.format(Intl.intl("The file \"%s\" could not be read."), f.getAbsolutePath()));
            return false;
        }
        this.setCurrentLibrary(f.getAbsolutePath());
        return true;
    }

    @Override
    protected void loadLibraryUI() {
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    @Override
    protected void saveToLibrary() {
        Application.getApp().beginWaitCursor();
        if (!this.copyListSelection(this.d_modelObjs, this.d_libObjs, this.d_libModel).isEmpty()) {
            this.d_libUnsaved = true;
        }
        Application.getApp().endWaitCursor();
    }

    @Override
    protected void loadFromLibrary() {
        Application.getApp().beginWaitCursor();
        List<ModelCheck> added = this.copyListSelection(this.d_libObjs, this.d_modelObjs, this.d_curModel);
        AddTask<ModelCheck> t = new AddTask<ModelCheck>((IPyroObject)this.d_domain.getModelCheckMgr(), (Collection<ModelCheck>)added);
        SelectTask wrapper = new SelectTask(this.d_domain, added);
        wrapper.addTask(t);
        this.d_domain.getTaskManager().exec(wrapper, Intl.intl("Add Checks"));
        Application.getApp().endWaitCursor();
    }

    private File serialize(List<ModelCheck> checks) {
        guiJFXFileChooser chooser = new guiJFXFileChooser("checks.pslib", PyroPrefs.get(PyroPrefs.LastFDSDatabaseDirProp), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_PSLIB);
        File f = chooser.showSaveDialog();
        if (f == null) {
            return null;
        }
        PyroPrefs.set(PyroPrefs.LastFDSDatabaseDirProp, f.getParent());
        try (PyroSimObjectOutputStream oos = new PyroSimObjectOutputStream(new FileOutputStream(f));){
            oos.writeObject(checks);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getLocalizedMessage(), Intl.intl("Error"), 2);
            e.printStackTrace();
        }
        return f;
    }

    @Override
    protected boolean saveLibrary() {
        File newLibFile = this.serialize(this.d_libModel);
        if (newLibFile == null) {
            return false;
        }
        this.setCurrentLibrary(newLibFile.getAbsolutePath());
        this.d_libUnsaved = false;
        return true;
    }

    @Override
    protected void createLibrary() {
        if (!this.checkSaveNewLib()) {
            return;
        }
        this.d_libModel = new ArrayList<ModelCheck>();
        this.d_libUnsaved = true;
        this.setCurrentLibrary("untitled.pslib");
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    @Override
    protected void decorateCells(ALibraryDlg.ManagerRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        IPyroObject obj = (IPyroObject)value;
        r.setText(Util.getName(obj));
    }

    @Override
    protected void deleteModObjs() {
        List<ModelCheck> deleted = this.deleteObjs(this.d_modelObjs, this.d_curModel);
        if (deleted.size() > 0) {
            Task t = Actions.getDeleteTask(this.d_domain, deleted);
            if (t == null) {
                return;
            }
            this.d_domain.getTaskManager().exec(t, Intl.intl("Delete Objects"));
        }
    }

    @Override
    protected void deleteLibObjs() {
        if (this.deleteObjs(this.d_libObjs, this.d_libModel).size() > 0) {
            this.d_libUnsaved = true;
        }
    }

    private List<ModelCheck> deleteObjs(JList<ModelCheck> jlist, List<ModelCheck> model) {
        List<ModelCheck> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return new ArrayList<ModelCheck>();
        }
        for (ModelCheck obj : objs) {
            model.remove(obj);
        }
        this.loadList(model, jlist);
        return objs;
    }

    private int indexOf(JList<ModelCheck> jlist, IPyroObject obj) {
        for (int m = 0; m < jlist.getModel().getSize(); ++m) {
            if (jlist.getModel().getElementAt(m) != obj) continue;
            return m;
        }
        return -1;
    }

    private String getNewName(INamed namedObj, Collection<? extends INamed> containerCopiedTo) {
        String baseName = namedObj.getName();
        Object newName = baseName;
        int i = 1;
        boolean alreadyExists = false;
        do {
            alreadyExists = false;
            for (INamed iNamed : containerCopiedTo) {
                if (!iNamed.getName().equals(newName)) continue;
                alreadyExists = true;
                break;
            }
            if (!alreadyExists) continue;
            newName = baseName + " (" + i++ + ")";
        } while (alreadyExists);
        return newName;
    }

    public List<ModelCheck> copyListSelection(JList<ModelCheck> jlistBeingCopied, JList<ModelCheck> jlistCopiedTo, List<ModelCheck> containerCopiedTo) {
        List<ModelCheck> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashMap<ModelCheck, ModelCheck> replacements = new LinkedHashMap<ModelCheck, ModelCheck>();
        for (ModelCheck check : objsToCopy) {
            String newName = this.getNewName(check, containerCopiedTo);
            ModelCheck newCheck = (ModelCheck)check.clone();
            if (!newName.equals(check.getName())) {
                newCheck.setName(newName);
            }
            replacements.put(check, newCheck);
        }
        for (ModelCheck check : replacements.keySet()) {
            int replIndex = objsToCopy.indexOf(check);
            objsToCopy.remove(replIndex);
            objsToCopy.add(replIndex, (ModelCheck)replacements.get(check));
        }
        containerCopiedTo.addAll(objsToCopy);
        this.loadList(containerCopiedTo, jlistCopiedTo);
        return objsToCopy;
    }
}

