/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.auditing;

import java.awt.Component;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.miginfocom.swing.MigLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.auditing.ICheckDesc;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.RecordCheckDesc;
import pyrosim.domain.auditing.SurfaceCheckDesc;
import pyrosim.gui.TagEditor;
import pyrosim.gui.auditing.RecordCheckRenderer;
import pyrosim.gui.auditing.SurfaceCheckRenderer;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.CompositeTask;

public class ModelCheckEditor
extends guiPanel
implements IEditor<ModelCheck> {
    private static final long serialVersionUID = 1274617741602977042L;
    private final guiTextField d_checkID;
    private final guiTextField d_desc;
    private final TagEditor d_tags;
    private final guiComboBox<String> d_checkType;
    private final Consumer<String> d_updateCheckType;
    private final RecordCheckRenderer d_recordCheckPanel;
    private final SurfaceCheckRenderer d_surfaceCheckPanel;
    public static final String SURFACE_CHECK = Intl.intl("Surface");
    public static final String RECORD_CHECK = Intl.intl("Record");

    public ModelCheckEditor() {
        this.setLayout(new MigLayout("hidemode 3, fillx, insets 0, gap 6", "[min!][]"));
        guiLabel checkIDLabel = new guiLabel(Intl.intl("Check ID:"));
        checkIDLabel.setToolTipText(Intl.intl("ID"));
        this.d_checkID = new guiTextField();
        this.d_checkID.setEditable(false);
        guiLabel descriptionLabel = new guiLabel(Intl.intl("Description:"));
        descriptionLabel.setToolTipText(Intl.intl("Description"));
        this.d_desc = new guiTextField();
        guiLabel tagsLbl = new guiLabel(Intl.intl("Tags:"));
        this.d_tags = new TagEditor();
        guiLabel checkTypeLabel = new guiLabel(Intl.intl("Check Type:"));
        checkTypeLabel.setToolTipText(Intl.intl("Type of Model Check"));
        this.d_checkType = new guiComboBox<String>((T[])new String[]{SURFACE_CHECK, RECORD_CHECK});
        this.add(checkIDLabel);
        this.add((Component)this.d_checkID, "growx, wrap");
        this.add(descriptionLabel);
        this.add((Component)this.d_desc, "growx, wrap");
        this.add(tagsLbl);
        this.add((Component)this.d_tags.getEditor(), "growx, wrap");
        this.add(checkTypeLabel);
        this.add(this.d_checkType, "wrap, width 100");
        this.d_surfaceCheckPanel = new SurfaceCheckRenderer();
        this.d_surfaceCheckPanel.render(this);
        this.d_recordCheckPanel = new RecordCheckRenderer();
        this.d_recordCheckPanel.render(this);
        this.d_updateCheckType = check -> {
            this.d_surfaceCheckPanel.setVisible(false);
            this.d_recordCheckPanel.setVisible(true);
            if (check.equals(SURFACE_CHECK)) {
                this.d_surfaceCheckPanel.setVisible(true);
                this.d_recordCheckPanel.setVisible(false);
            }
        };
        this.d_checkType.addItemListener(e -> {
            this.d_updateCheckType.accept((String)e.getItem());
            this.d_recordCheckPanel.clearRows();
        });
        this.d_updateCheckType.accept(this.d_checkType.getSelectedItem());
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public void init(ModelCheck mc) {
        this.setEnabled(mc != null);
        if (mc != null) {
            this.d_surfaceCheckPanel.init(mc);
            this.d_recordCheckPanel.init(mc);
            ICheckDesc iCheckDesc = mc.getCheckDesc();
            if (iCheckDesc instanceof SurfaceCheckDesc) {
                SurfaceCheckDesc surfaceCheckDesc = (SurfaceCheckDesc)iCheckDesc;
                this.d_checkType.setSelectedItem(SURFACE_CHECK);
            } else {
                this.d_checkType.setSelectedItem(RECORD_CHECK);
            }
            this.d_checkID.setText(mc.getName());
            this.d_desc.setText(mc.getDescription());
            this.d_desc.setEnabled(true);
            this.d_tags.initTags(mc);
            this.setModified(false);
        }
    }

    @Override
    public ModelCheck preview(ModelCheck check) {
        if (!this.validateData(false, false)) {
            return null;
        }
        this.saveCheck(check);
        return check;
    }

    @Override
    public ModelCheck commit(final ModelCheck dataObj) {
        assert (dataObj != null);
        assert (this.isModified());
        PyroMod domain = PyroSim.getApp().getMediator();
        CompositeTask<PyroMod> editTask = new CompositeTask<PyroMod>(domain);
        editTask.addTask(new AOneTimeTask(){

            @Override
            public void run() {
                ModelCheckEditor.this.saveCheck(dataObj);
            }
        });
        editTask.addTask(this.d_tags.getUpdateTagsTask(domain, dataObj));
        PyroSim.getApp().getMediator().getTaskManager().exec(editTask, Intl.intl("Edit Check"));
        this.setModified(false);
        return dataObj;
    }

    protected void saveCheck(ModelCheck modelCheck) {
        modelCheck.setDescription(this.d_desc.getText());
        String checkType = this.d_checkType.getSelectedItem();
        if (checkType != null) {
            if (checkType.equals(SURFACE_CHECK)) {
                if (modelCheck.getCheckDesc() instanceof RecordCheckDesc) {
                    modelCheck.setCheckDesc(new SurfaceCheckDesc());
                }
                this.d_surfaceCheckPanel.updateCheck(modelCheck);
            }
            if (checkType.equals(RECORD_CHECK)) {
                if (modelCheck.getCheckDesc() instanceof SurfaceCheckDesc) {
                    modelCheck.setCheckDesc(new RecordCheckDesc(new ArrayList()));
                }
                this.d_recordCheckPanel.updateCheck(modelCheck);
            }
        }
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }
}

