/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.appearance;

import java.io.File;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.appearance.MaterialDB;
import thunderheadeng.gui.ImageBtn;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.image.IImage;
import thunderheadeng.scene3d.gui.materialdlg.IImageBtnListener;

public class ImageBtnListener
implements IImageBtnListener {
    public static final ImageBtnListener INSTANCE = new ImageBtnListener();
    private File d_defaultFile;

    @Override
    public void setDefaultFile(File file) {
        this.d_defaultFile = file;
    }

    @Override
    public boolean chooseNewImage(ImageBtn btn, String name) {
        IImage currImg = btn.getImage();
        File defFile = currImg != null && new File(currImg.getFilename()).exists() ? new File(currImg.getFilename()) : this.d_defaultFile;
        guiJFXFileChooser chooser = new guiJFXFileChooser(defFile != null ? defFile.getName() : null, defFile != null ? defFile.getAbsolutePath() : PyroPrefs.get(PyroPrefs.OPEN_DIR_PREF), String.format(Intl.intl("Choose %s Image"), name), (Boolean)true, (Boolean)true, (Boolean)false, PyroSim.getApp().getMediator().getAppearances().getFileFilters());
        File f = chooser.showOpenDialog();
        if (f == null) {
            return false;
        }
        PyroPrefs.set(PyroPrefs.OPEN_DIR_PREF, f.getParent());
        this.d_defaultFile = f;
        IImage img = MaterialDB.loadImage(f.getAbsolutePath());
        if (img == null) {
            return false;
        }
        if (img != btn.getImage()) {
            btn.setImage(img);
            btn.setModified(true);
        }
        return true;
    }
}

