/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.actions.ComponentSensitiveAction;
import pyrosim.mv.ModelView;
import pyrosim.mv.tools.ManipulationTool;
import pyrosim.mv.tools.ToolNames;
import thunderheadeng.geometry.GeomConstants;
import thunderheadeng.gui.dialogs.CustomKeyAcceleratorDlg;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.gui.tool.Tool;
import thunderheadeng.gui.tool.ToolManager;
import thunderheadeng.io.KeyboardAcceleratorIO;
import thunderheadeng.util.Pair;

public class PyroActionMap {
    private static final Set<String> s_fileActionList = new LinkedHashSet<String>();
    private static final Set<String> s_editActionList;
    private static final Set<String> s_viewActionList;
    private static final Set<String> s_selectionActionList;
    private static final Set<String> s_contextActionList;
    private static final Set<String> s_toolActionList;
    private static PyroActionMap INSTANCE;
    private final Map<String, Collection<Action>> idToActionMap = new HashMap<String, Collection<Action>>();
    private final Map<String, String> idToOverrideNameMap = new HashMap<String, String>();
    private final Map<String, String> idToAcceleratorDefaultMap = new LinkedHashMap<String, String>();
    private final Map<String, KeyStroke> idToKeybindMap = new HashMap<String, KeyStroke>();
    private final Map<String, ToolManager.ToolProps> idToToolbarProps = new HashMap<String, ToolManager.ToolProps>();
    private JToolBar d_toolbar3d;
    private JToolBar d_toolbar2d;

    public static Set<String> getFileActionList() {
        return Collections.unmodifiableSet(s_fileActionList);
    }

    public static Set<String> getEditActionList() {
        return Collections.unmodifiableSet(s_editActionList);
    }

    public static Set<String> getViewActionList() {
        return Collections.unmodifiableSet(s_viewActionList);
    }

    public static Set<String> getSelectionActionList() {
        return Collections.unmodifiableSet(s_selectionActionList);
    }

    public static Set<String> getContextActionList() {
        return Collections.unmodifiableSet(s_contextActionList);
    }

    public static Set<String> getToolActionList() {
        return Collections.unmodifiableSet(s_toolActionList);
    }

    private PyroActionMap() {
        this.initIdToActionMap();
        this.initIdToDefaultMap();
    }

    public static PyroActionMap getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PyroActionMap();
        }
        return INSTANCE;
    }

    private void initIdToActionMap() {
        this.idToActionMap.put("undo", Collections.singletonList(Actions.getUndoAction()));
        this.idToActionMap.put("redo", Collections.singletonList(Actions.getRedoAction()));
        this.idToOverrideNameMap.put("undo", Actions.getUndoAction().getValue("Name").toString());
        this.idToOverrideNameMap.put("redo", Actions.getRedoAction().getValue("Name").toString());
        this.idToActionMap.put("undoEdit", Collections.singletonList(Actions.getUndoMajorAction()));
        this.idToActionMap.put("redoEdit", Collections.singletonList(Actions.getRedoMajorAction()));
        this.idToOverrideNameMap.put("undoEdit", Actions.getUndoMajorAction().getValue("Name").toString());
        this.idToOverrideNameMap.put("redoEdit", Actions.getRedoMajorAction().getValue("Name").toString());
        this.idToActionMap.put("delete", Collections.singletonList(Actions.getDeleteAction()));
        this.idToActionMap.put("find", Collections.singletonList(Actions.getFindAction()));
        this.idToActionMap.put("cut", Collections.singletonList(Actions.getCutAction()));
        this.idToActionMap.put("copy", Collections.singletonList(Actions.getCopyAction()));
        this.idToActionMap.put("copyFDS", Collections.singletonList(Actions.getCopyFDSAction()));
        this.idToActionMap.put("paste", Collections.singletonList(Actions.getPasteAction()));
        this.idToActionMap.put("hideObj", Collections.singletonList(Actions.getHideNodeAction()));
        this.idToActionMap.put("showObj", Collections.singletonList(Actions.getShowNodeAction()));
        this.idToActionMap.put("showAll", Collections.singletonList(Actions.getShowAllNodesAction()));
        this.idToActionMap.put("filterObjs", Collections.singletonList(Actions.getHideUnselectedNodeAction()));
        this.idToActionMap.put("editTags", Collections.singletonList(Actions.getEditTagsAction()));
        this.idToActionMap.put("addTags", Collections.singletonList(Actions.getAddTagsAction()));
        this.idToActionMap.put("removeTags", Collections.singletonList(Actions.getRemoveTagsAction()));
        this.idToActionMap.put("showTaggedObjects", Collections.singletonList(Actions.getShowTagsAction()));
        this.idToActionMap.put("selectReferencingObjects", Collections.singletonList(Actions.getSelectReferencingObjsAction()));
        this.idToActionMap.put("showReferencingObjects", Collections.singletonList(Actions.getShowReferencingObjsAction()));
        this.idToActionMap.put("newView", Collections.singletonList(Actions.getNewViewAction()));
        this.idToActionMap.put("newSectionBox", Collections.singletonList(Actions.getNewSectionBoxAction()));
        this.idToActionMap.put("resetSectionBox", Collections.singletonList(Actions.getResetSectionBoxAction()));
        this.idToActionMap.put("saveViewpoint", Collections.singletonList(Actions.getSaveViewpointAction()));
        this.idToActionMap.put("resetToViewpoint", Collections.singletonList(Actions.getResetViewpointAction()));
        PyroSim app = PyroSim.getApp();
        this.idToActionMap.put("newFile", Collections.singletonList(app.getNewAction()));
        this.idToActionMap.put("openFile", Collections.singletonList(app.getOpenAction()));
        this.idToActionMap.put("saveFile", Collections.singletonList(app.getSaveAction()));
        this.idToActionMap.put("saveFileAs", Collections.singletonList(app.getSaveAsAction()));
        this.idToActionMap.put("screenshot", Collections.singletonList(app.getScreenShotAction()));
        ModelView mv = app.getModelView();
        this.d_toolbar2d = mv.getViewMode2d().getCameraToolbar(mv);
        this.d_toolbar3d = mv.getViewMode3d().getCameraToolbar(mv);
        this.idToActionMap.put("resetView", Collections.singletonList(mv.getResetToAllAction()));
        this.idToActionMap.put("resetToSelection", Collections.singletonList(mv.getResetToSelectedAction()));
        this.idToActionMap.put("fillSelection", Collections.singletonList(mv.getFillViewAction()));
        this.idToActionMap.put("enableSectionBoxes", Collections.singletonList(mv.getEnableSectionBoxesAction()));
        this.idToActionMap.put("showSectionBoxes", Collections.singletonList(mv.getShowSectionBoxesAction()));
        this.idToActionMap.put("resetToTop", new HashSet());
        this.idToActionMap.put("resetToBottom", new HashSet());
        this.idToActionMap.put("resetToFront", new HashSet());
        this.idToActionMap.put("resetToBack", new HashSet());
        this.idToActionMap.put("resetToLeft", new HashSet());
        this.idToActionMap.put("resetToRight", new HashSet());
        Consumer<Map.Entry> viewActionConsumer = kvPair -> {
            if (((ModelView.PredefCam)((Object)((Object)kvPair.getKey()))).getResetOrientation().equals(GeomConstants.VEC3D_ZNEG)) {
                this.idToActionMap.get("resetToTop").add((Action)kvPair.getValue());
            } else if (((ModelView.PredefCam)((Object)((Object)kvPair.getKey()))).getResetOrientation().equals(GeomConstants.VEC3D_ZPOS)) {
                this.idToActionMap.get("resetToBottom").add((Action)kvPair.getValue());
            } else if (((ModelView.PredefCam)((Object)((Object)kvPair.getKey()))).getResetOrientation().equals(GeomConstants.VEC3D_YPOS)) {
                this.idToActionMap.get("resetToFront").add((Action)kvPair.getValue());
            } else if (((ModelView.PredefCam)((Object)((Object)kvPair.getKey()))).getResetOrientation().equals(GeomConstants.VEC3D_YNEG)) {
                this.idToActionMap.get("resetToBack").add((Action)kvPair.getValue());
            } else if (((ModelView.PredefCam)((Object)((Object)kvPair.getKey()))).getResetOrientation().equals(GeomConstants.VEC3D_XPOS)) {
                this.idToActionMap.get("resetToLeft").add((Action)kvPair.getValue());
            } else if (((ModelView.PredefCam)((Object)((Object)kvPair.getKey()))).getResetOrientation().equals(GeomConstants.VEC3D_XNEG)) {
                this.idToActionMap.get("resetToRight").add((Action)kvPair.getValue());
            }
        };
        for (Map.Entry<ModelView.PredefCam, ModelView.AChangeViewListener> kvPair2 : mv.getViewMode2d().getViewActionMap().entrySet()) {
            viewActionConsumer.accept(kvPair2);
        }
        for (Map.Entry<ModelView.PredefCam, ModelView.AChangeViewListener> kvPair2 : mv.getViewMode3d().getViewActionMap().entrySet()) {
            viewActionConsumer.accept(kvPair2);
        }
        ToolManager tm = mv.getToolManager();
        for (Tool t : tm.getTools()) {
            ToolManager.ToolProps tp = tm.getProps(t);
            String toolName = tp.action.getName();
            String nameKey = null;
            if (toolName.equals(ToolNames.NEW_MESH)) {
                nameKey = "drawMesh";
            }
            if (toolName.equals(ToolNames.NEW_WALL)) {
                nameKey = "drawWall";
            }
            if (toolName.equals(ToolNames.NEW_WALL_HOLE)) {
                nameKey = "drawWallHole";
            }
            if (toolName.equals(ToolNames.NEW_BLOCK)) {
                nameKey = "drawBlock";
            }
            if (toolName.equals(ToolNames.NEW_BLOCK_HOLE)) {
                nameKey = "drawBlockHole";
            }
            if (toolName.equals(ToolNames.NEW_SLAB)) {
                nameKey = "drawSlab";
            }
            if (toolName.equals(ToolNames.NEW_SLAB_HOLE)) {
                nameKey = "drawSlabHole";
            }
            if (toolName.equals(ToolNames.NEW_ROOM)) {
                nameKey = "drawRoom";
            }
            if (toolName.equals(ToolNames.NEW_ZONE)) {
                nameKey = "drawZone";
            }
            if (toolName.equals(ToolNames.NEW_VENT)) {
                nameKey = "drawVent";
            }
            if (toolName.equals(ToolNames.NEW_PARTICLE_CLOUD)) {
                nameKey = "drawParticleCloud";
            }
            if (toolName.equals(ToolNames.NEW_PARTICLE_LOCATION)) {
                nameKey = "drawParticle";
            }
            if (toolName.equals(ToolNames.NEW_PLANAR_SLICE)) {
                nameKey = "drawSlice2d";
            }
            if (toolName.equals(ToolNames.NEW_3D_SLICE)) {
                nameKey = "drawSlice3d";
            }
            if (toolName.equals(ToolNames.NEW_INIT)) {
                nameKey = "drawInitRegion";
            }
            if (toolName.equals(ToolNames.NEW_DEVICE)) {
                nameKey = "drawDevice";
            }
            if (toolName.equals(ToolNames.NEW_HVAC_DUCT)) {
                nameKey = "drawDuct";
            }
            if (toolName.equals(ToolNames.NEW_HVAC_NODE)) {
                nameKey = "drawNode";
            }
            if (toolName.equals(ToolNames.MEASURE)) {
                nameKey = "measureTool";
            }
            if (toolName.equals(ToolNames.SURFACE_PAINTER)) {
                // empty if block
            }
            if (toolName.equals(ToolNames.SURFACE_PICKER)) {
                // empty if block
            }
            if (toolName.equals(ToolNames.MOVE)) {
                nameKey = "moveTool";
            }
            if (toolName.equals(ToolNames.ROTATE)) {
                nameKey = "rotateTool";
            }
            if (toolName.equals(ToolNames.MIRROR)) {
                nameKey = "mirrorTool";
            }
            if (toolName.equals(ToolNames.SELECT) && t instanceof ManipulationTool) {
                ManipulationTool manipTool = (ManipulationTool)t;
                String string = nameKey = manipTool.threeDim ? "selectionTool3d" : "selectionTool2d";
            }
            if (toolName.equals(ToolNames.ROAM)) {
                nameKey = "roamTool";
            }
            if (toolName.equals(ToolNames.PAN)) {
                nameKey = "panTool";
            }
            if (toolName.equals(ToolNames.ZOOM)) {
                nameKey = "zoomTool";
            }
            if (toolName.equals(ToolNames.ZOOM_BOX)) {
                nameKey = "zoomBoxTool";
            }
            if (toolName.equals(ToolNames.ORBIT)) {
                nameKey = "orbitTool";
            }
            if (nameKey == null) continue;
            this.idToActionMap.put(nameKey, Collections.singleton(tp.action));
            this.idToToolbarProps.put(nameKey, tp);
        }
    }

    private void initIdToDefaultMap() {
        this.idToAcceleratorDefaultMap.put("undo", "ctrl Z");
        this.idToAcceleratorDefaultMap.put("redo", "ctrl Y");
        this.idToAcceleratorDefaultMap.put("undoEdit", "ctrl shift Z");
        this.idToAcceleratorDefaultMap.put("redoEdit", "ctrl shift Y");
        this.idToAcceleratorDefaultMap.put("delete", "DELETE");
        this.idToAcceleratorDefaultMap.put("find", "ctrl F");
        this.idToAcceleratorDefaultMap.put("cut", "ctrl X");
        this.idToAcceleratorDefaultMap.put("copy", "ctrl C");
        this.idToAcceleratorDefaultMap.put("copyFDS", "");
        this.idToAcceleratorDefaultMap.put("paste", "ctrl V");
        this.idToAcceleratorDefaultMap.put("hideObj", "alt shift H");
        this.idToAcceleratorDefaultMap.put("showObj", "alt shift S");
        this.idToAcceleratorDefaultMap.put("showAll", "alt shift A");
        this.idToAcceleratorDefaultMap.put("filterObjs", "alt shift F");
        this.idToAcceleratorDefaultMap.put("editTags", "");
        this.idToAcceleratorDefaultMap.put("addTags", "");
        this.idToAcceleratorDefaultMap.put("removeTags", "");
        this.idToAcceleratorDefaultMap.put("showTaggedObjects", "");
        this.idToAcceleratorDefaultMap.put("selectReferencingObjects", "");
        this.idToAcceleratorDefaultMap.put("showReferencingObjects", "");
        this.idToAcceleratorDefaultMap.put("newView", "ctrl shift V");
        this.idToAcceleratorDefaultMap.put("newSectionBox", "ctrl shift S");
        this.idToAcceleratorDefaultMap.put("resetSectionBox", "ctrl shift R");
        this.idToAcceleratorDefaultMap.put("saveViewpoint", "ctrl shift P");
        this.idToAcceleratorDefaultMap.put("resetToViewpoint", "ctrl shift I");
        this.idToAcceleratorDefaultMap.put("newFile", "ctrl N");
        this.idToAcceleratorDefaultMap.put("openFile", "ctrl O");
        this.idToAcceleratorDefaultMap.put("saveFile", "ctrl S");
        this.idToAcceleratorDefaultMap.put("saveFileAs", "");
        this.idToAcceleratorDefaultMap.put("screenshot", "");
        this.idToAcceleratorDefaultMap.put("resetView", "ctrl R");
        this.idToAcceleratorDefaultMap.put("resetToSelection", "ctrl E");
        this.idToAcceleratorDefaultMap.put("enableSectionBoxes", "ctrl shift E");
        this.idToAcceleratorDefaultMap.put("showSectionBoxes", "ctrl shift D");
        this.idToAcceleratorDefaultMap.put("resetToTop", "ctrl 5");
        this.idToAcceleratorDefaultMap.put("resetToBottom", "ctrl 6");
        this.idToAcceleratorDefaultMap.put("resetToFront", "ctrl 1");
        this.idToAcceleratorDefaultMap.put("resetToBack", "ctrl 2");
        this.idToAcceleratorDefaultMap.put("resetToLeft", "ctrl 3");
        this.idToAcceleratorDefaultMap.put("resetToRight", "ctrl 4");
        this.idToAcceleratorDefaultMap.put("drawMesh", "");
        this.idToAcceleratorDefaultMap.put("drawSlab", "");
        this.idToAcceleratorDefaultMap.put("drawSlabHole", "");
        this.idToAcceleratorDefaultMap.put("drawWall", "");
        this.idToAcceleratorDefaultMap.put("drawWallHole", "");
        this.idToAcceleratorDefaultMap.put("drawBlock", "");
        this.idToAcceleratorDefaultMap.put("drawBlockHole", "");
        this.idToAcceleratorDefaultMap.put("drawRoom", "");
        this.idToAcceleratorDefaultMap.put("drawZone", "");
        this.idToAcceleratorDefaultMap.put("drawVent", "");
        this.idToAcceleratorDefaultMap.put("drawInitRegion", "");
        this.idToAcceleratorDefaultMap.put("drawParticleCloud", "");
        this.idToAcceleratorDefaultMap.put("drawParticle", "");
        this.idToAcceleratorDefaultMap.put("drawSlice2d", "");
        this.idToAcceleratorDefaultMap.put("drawSlice3d", "");
        this.idToAcceleratorDefaultMap.put("drawDevice", "");
        this.idToAcceleratorDefaultMap.put("drawNode", "");
        this.idToAcceleratorDefaultMap.put("drawDuct", "");
        this.idToAcceleratorDefaultMap.put("measureTool", "");
        this.idToAcceleratorDefaultMap.put("moveTool", "");
        this.idToAcceleratorDefaultMap.put("rotateTool", "");
        this.idToAcceleratorDefaultMap.put("mirrorTool", "");
        this.idToAcceleratorDefaultMap.put("selectionTool", "");
        this.idToAcceleratorDefaultMap.put("selectionTool2d", "");
        this.idToAcceleratorDefaultMap.put("selectionTool3d", "");
        this.idToAcceleratorDefaultMap.put("orbitTool", "");
        this.idToAcceleratorDefaultMap.put("roamTool", "");
        this.idToAcceleratorDefaultMap.put("panTool", "");
        this.idToAcceleratorDefaultMap.put("zoomTool", "");
        this.idToAcceleratorDefaultMap.put("zoomBoxTool", "");
    }

    private void updateActionMap(Map<String, KeyStroke> newKeyStrokeValues) {
        Set<String> defaultFuncNames = this.idToAcceleratorDefaultMap.keySet();
        LinkedHashMap<String, String> defaultsToAdd = new LinkedHashMap<String, String>();
        for (String string : defaultFuncNames) {
            if (newKeyStrokeValues.containsKey(string)) continue;
            defaultsToAdd.put(string, this.idToAcceleratorDefaultMap.get(string));
        }
        this.idToKeybindMap.clear();
        for (Map.Entry entry : defaultsToAdd.entrySet()) {
            KeyStroke ks = KeyStroke.getKeyStroke((String)entry.getValue());
            this.idToKeybindMap.put((String)entry.getKey(), ks);
        }
        for (Map.Entry entry : newKeyStrokeValues.entrySet()) {
            this.idToKeybindMap.put((String)entry.getKey(), (KeyStroke)entry.getValue());
        }
        this.updateActions();
    }

    private void updateActions() {
        for (Map.Entry<String, Collection<Action>> idToActionKV : this.idToActionMap.entrySet()) {
            ToolManager.ToolProps tp;
            KeyStroke ks;
            String actionStr = idToActionKV.getKey();
            if (PyroActionMap.isViewAction(actionStr)) {
                ks = this.idToKeybindMap.get(actionStr);
                String actionName = this.getActionNameForID(actionStr);
                guiUtil.keyboardShortcutUpdate(this.d_toolbar2d, ks, actionName);
                guiUtil.keyboardShortcutUpdate(this.d_toolbar3d, ks, actionName);
                continue;
            }
            if (PyroActionMap.isManipAction(actionStr)) {
                ks = this.idToKeybindMap.get("selectionTool");
                tp = this.idToToolbarProps.get(actionStr);
                guiUtil.keyboardShortcutUpdate(tp.toolbarBtn, ks, tp.action.getTool());
                continue;
            }
            if (PyroActionMap.isToolbarAction(actionStr)) {
                ks = this.idToKeybindMap.get(actionStr);
                tp = this.idToToolbarProps.get(actionStr);
                guiUtil.keyboardShortcutUpdate(tp.toolbarBtn, ks, tp.action.getTool());
                continue;
            }
            if (PyroActionMap.isContextAction(actionStr)) {
                ks = this.idToKeybindMap.get(actionStr);
                for (Action action : idToActionKV.getValue()) {
                    assert (action instanceof ComponentSensitiveAction);
                    if (!(action instanceof ComponentSensitiveAction)) continue;
                    ComponentSensitiveAction compSensitive = (ComponentSensitiveAction)action;
                    compSensitive.setKeyStroke(ks);
                }
                continue;
            }
            ks = this.idToKeybindMap.get(actionStr);
            for (Action action : idToActionKV.getValue()) {
                action.putValue("AcceleratorKey", ks);
            }
        }
    }

    private static boolean isToolbarAction(String action) {
        return NamedActions.TOOLBAR_ACTIONS.contains(action);
    }

    private static boolean isViewAction(String action) {
        return NamedActions.VIEW_ACTIONS.contains(action);
    }

    private static boolean isManipAction(String action) {
        return NamedActions.MANIP_ACTIONS.contains(action);
    }

    private static boolean isContextAction(String action) {
        return NamedActions.CONTEXT_ACTIONS.contains(action);
    }

    private String getActionNameForID(String namedActionId) {
        if (namedActionId.equals("selectionTool")) {
            return ToolNames.SELECT;
        }
        String overrideName = this.idToOverrideNameMap.get(namedActionId);
        if (overrideName != null) {
            return overrideName;
        }
        Collection<Action> actions = this.idToActionMap.get(namedActionId);
        Set actionNames = actions.stream().map(a -> (String)a.getValue("Name")).collect(Collectors.toSet());
        assert (actionNames.size() == 1);
        return (String)actionNames.iterator().next();
    }

    private String getTooltipForActionKey(String id) {
        Action action = null;
        if (this.idToActionMap.get(id) != null) {
            action = this.idToActionMap.get(id).iterator().next();
        } else if (this.idToToolbarProps.get(id) != null) {
            action = this.idToToolbarProps.get((Object)id).action;
        }
        if (action != null) {
            String longDesc = (String)action.getValue("LongDescription");
            if (longDesc != null && !longDesc.isEmpty()) {
                return longDesc;
            }
            return (String)action.getValue("ShortDescription");
        }
        return null;
    }

    private KeyStroke getKeyStrokeForID(String namedActionId) {
        return this.idToKeybindMap.get(namedActionId);
    }

    private KeyStroke getDefaultKeyStrokeForID(String namedActionId) {
        String defKSString = this.idToAcceleratorDefaultMap.get(namedActionId);
        return KeyStroke.getKeyStroke(defKSString);
    }

    static {
        s_fileActionList.add("newFile");
        s_fileActionList.add("openFile");
        s_fileActionList.add("saveFile");
        s_fileActionList.add("saveFileAs");
        s_fileActionList.add("screenshot");
        s_editActionList = new LinkedHashSet<String>();
        s_editActionList.add("undo");
        s_editActionList.add("redo");
        s_editActionList.add("undoEdit");
        s_editActionList.add("redoEdit");
        s_editActionList.add("cut");
        s_editActionList.add("copy");
        s_editActionList.add("copyFDS");
        s_editActionList.add("paste");
        s_editActionList.add("delete");
        s_editActionList.add("find");
        s_editActionList.add("hideObj");
        s_editActionList.add("showObj");
        s_editActionList.add("showAll");
        s_editActionList.add("filterObjs");
        s_viewActionList = new LinkedHashSet<String>();
        s_viewActionList.add("resetView");
        s_viewActionList.add("fillSelection");
        s_viewActionList.add("resetToSelection");
        s_viewActionList.add("resetToTop");
        s_viewActionList.add("resetToBottom");
        s_viewActionList.add("resetToFront");
        s_viewActionList.add("resetToBack");
        s_viewActionList.add("resetToLeft");
        s_viewActionList.add("resetToRight");
        s_viewActionList.add("enableSectionBoxes");
        s_viewActionList.add("showSectionBoxes");
        s_viewActionList.add("newSectionBox");
        s_viewActionList.add("resetSectionBox");
        s_viewActionList.add("newView");
        s_viewActionList.add("saveViewpoint");
        s_viewActionList.add("resetToViewpoint");
        s_selectionActionList = new LinkedHashSet<String>();
        s_selectionActionList.add("selectReferencingObjects");
        s_selectionActionList.add("showReferencingObjects");
        s_selectionActionList.add("showTaggedObjects");
        s_contextActionList = new LinkedHashSet<String>();
        s_contextActionList.add("editTags");
        s_contextActionList.add("addTags");
        s_contextActionList.add("removeTags");
        s_toolActionList = new LinkedHashSet<String>();
        s_toolActionList.add("orbitTool");
        s_toolActionList.add("drawMesh");
        s_toolActionList.add("drawSlab");
        s_toolActionList.add("drawSlabHole");
        s_toolActionList.add("drawWall");
        s_toolActionList.add("drawWallHole");
        s_toolActionList.add("drawBlock");
        s_toolActionList.add("drawBlockHole");
        s_toolActionList.add("drawRoom");
        s_toolActionList.add("drawZone");
        s_toolActionList.add("drawVent");
        s_toolActionList.add("drawInitRegion");
        s_toolActionList.add("drawParticle");
        s_toolActionList.add("drawParticleCloud");
        s_toolActionList.add("drawSlice2d");
        s_toolActionList.add("drawSlice3d");
        s_toolActionList.add("drawDevice");
        s_toolActionList.add("drawNode");
        s_toolActionList.add("drawDuct");
        s_toolActionList.add("moveTool");
        s_toolActionList.add("measureTool");
        s_toolActionList.add("mirrorTool");
        s_toolActionList.add("panTool");
        s_toolActionList.add("roamTool");
        s_toolActionList.add("rotateTool");
        s_toolActionList.add("selectionTool");
        s_toolActionList.add("zoomTool");
        s_toolActionList.add("zoomBoxTool");
    }

    public static class NamedActions {
        public static final String UNDO = "undo";
        public static final String REDO = "redo";
        public static final String UNDO_EDIT = "undoEdit";
        public static final String REDO_EDIT = "redoEdit";
        public static final String DELETE = "delete";
        public static final String FIND = "find";
        public static final String CUT = "cut";
        public static final String COPY = "copy";
        public static final String COPY_FDS = "copyFDS";
        public static final String PASTE = "paste";
        public static final String HIDE_OBJ = "hideObj";
        public static final String SHOW_OBJ = "showObj";
        public static final String SHOW_ALL = "showAll";
        public static final String FILTER = "filterObjs";
        public static final String NEW_VIEW = "newView";
        public static final String NEW_SECTION_BOX = "newSectionBox";
        public static final String RESET_SECTION_BOX = "resetSectionBox";
        public static final String SAVE_VIEWPOINT = "saveViewpoint";
        public static final String RESET_TO_VIEWPOINT = "resetToViewpoint";
        public static final String NEW = "newFile";
        public static final String OPEN = "openFile";
        public static final String SAVE = "saveFile";
        public static final String SAVE_AS = "saveFileAs";
        public static final String SCREENSHOT = "screenshot";
        public static final String RESET_VIEW = "resetView";
        public static final String RESET_TO_SELECTION = "resetToSelection";
        public static final String FILL_SELECTION = "fillSelection";
        public static final String ENABLE_SECTION_BOXES = "enableSectionBoxes";
        public static final String SHOW_SECTION_BOXES = "showSectionBoxes";
        public static final String RESET_TO_TOP = "resetToTop";
        public static final String RESET_TO_BOTTOM = "resetToBottom";
        public static final String RESET_TO_FRONT = "resetToFront";
        public static final String RESET_TO_BACK = "resetToBack";
        public static final String RESET_TO_LEFT = "resetToLeft";
        public static final String RESET_TO_RIGHT = "resetToRight";
        public static final String DRAW_MESH_TOOL = "drawMesh";
        public static final String DRAW_SLAB_TOOL = "drawSlab";
        public static final String DRAW_SLAB_HOLE_TOOL = "drawSlabHole";
        public static final String DRAW_WALL_TOOL = "drawWall";
        public static final String DRAW_WALL_HOLE_TOOL = "drawWallHole";
        public static final String DRAW_BLOCK_TOOL = "drawBlock";
        public static final String DRAW_BLOCK_HOLE_TOOL = "drawBlockHole";
        public static final String DRAW_ROOM_TOOL = "drawRoom";
        public static final String DRAW_ZONE_TOOL = "drawZone";
        public static final String DRAW_VENT_TOOL = "drawVent";
        public static final String DRAW_INIT_TOOL = "drawInitRegion";
        public static final String DRAW_PARTICLE_CLOUD_TOOL = "drawParticleCloud";
        public static final String DRAW_PARTICLE_TOOL = "drawParticle";
        public static final String DRAW_SLICE_2D_TOOL = "drawSlice2d";
        public static final String DRAW_SLICE_3D_TOOL = "drawSlice3d";
        public static final String DRAW_DEVICE_TOOL = "drawDevice";
        public static final String DRAW_NODE_TOOL = "drawNode";
        public static final String DRAW_DUCT_TOOL = "drawDuct";
        public static final String MEASURE_TOOL = "measureTool";
        public static final String TOOL_OPTIONS = "toolOptionsMenu";
        public static final String MOVE_MANIP_TOOL = "moveTool";
        public static final String ROTATE_MANIP_TOOL = "rotateTool";
        public static final String MIRROR_MANIP_TOOL = "mirrorTool";
        public static final String SELECT_TOOL = "selectionTool";
        public static final String SELECT_TOOL_3D = "selectionTool3d";
        public static final String SELECT_TOOL_2D = "selectionTool2d";
        public static final String ORBIT_TOOL = "orbitTool";
        public static final String ROAM_TOOL = "roamTool";
        public static final String PAN_TOOL = "panTool";
        public static final String ZOOM_TOOL = "zoomTool";
        public static final String ZOOM_BOX_TOOL = "zoomBoxTool";
        public static final String EDIT_TAGS = "editTags";
        public static final String ADD_TAGS = "addTags";
        public static final String REMOVE_TAGS = "removeTags";
        public static final String SHOW_TAGS = "showTaggedObjects";
        public static final String SELECT_REFERENCING = "selectReferencingObjects";
        public static final String SHOW_REFERENCING = "showReferencingObjects";
        private static final Collection<String> VIEW_ACTIONS = new LinkedHashSet<String>();
        private static final Collection<String> TOOLBAR_ACTIONS;
        private static final Collection<String> MANIP_ACTIONS;
        private static final Collection<String> CONTEXT_ACTIONS;

        static {
            VIEW_ACTIONS.add(RESET_TO_TOP);
            VIEW_ACTIONS.add(RESET_TO_BOTTOM);
            VIEW_ACTIONS.add(RESET_TO_FRONT);
            VIEW_ACTIONS.add(RESET_TO_BACK);
            VIEW_ACTIONS.add(RESET_TO_LEFT);
            VIEW_ACTIONS.add(RESET_TO_RIGHT);
            TOOLBAR_ACTIONS = new LinkedHashSet<String>();
            TOOLBAR_ACTIONS.add(DRAW_MESH_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_SLAB_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_SLAB_HOLE_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_WALL_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_WALL_HOLE_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_BLOCK_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_BLOCK_HOLE_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_ROOM_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_ZONE_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_VENT_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_INIT_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_PARTICLE_CLOUD_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_PARTICLE_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_SLICE_2D_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_SLICE_3D_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_DEVICE_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_NODE_TOOL);
            TOOLBAR_ACTIONS.add(DRAW_DUCT_TOOL);
            TOOLBAR_ACTIONS.add(MEASURE_TOOL);
            TOOLBAR_ACTIONS.add(MOVE_MANIP_TOOL);
            TOOLBAR_ACTIONS.add(ROTATE_MANIP_TOOL);
            TOOLBAR_ACTIONS.add(MIRROR_MANIP_TOOL);
            TOOLBAR_ACTIONS.add(SELECT_TOOL);
            TOOLBAR_ACTIONS.add(SELECT_TOOL_2D);
            TOOLBAR_ACTIONS.add(SELECT_TOOL_3D);
            TOOLBAR_ACTIONS.add(ORBIT_TOOL);
            TOOLBAR_ACTIONS.add(ROAM_TOOL);
            TOOLBAR_ACTIONS.add(PAN_TOOL);
            TOOLBAR_ACTIONS.add(ZOOM_TOOL);
            TOOLBAR_ACTIONS.add(ZOOM_BOX_TOOL);
            MANIP_ACTIONS = new LinkedHashSet<String>();
            MANIP_ACTIONS.add(SELECT_TOOL_2D);
            MANIP_ACTIONS.add(SELECT_TOOL_3D);
            CONTEXT_ACTIONS = new LinkedHashSet<String>();
            CONTEXT_ACTIONS.add(EDIT_TAGS);
            CONTEXT_ACTIONS.add(ADD_TAGS);
            CONTEXT_ACTIONS.add(REMOVE_TAGS);
            CONTEXT_ACTIONS.add(SHOW_TAGS);
            CONTEXT_ACTIONS.add(SELECT_REFERENCING);
            CONTEXT_ACTIONS.add(SHOW_REFERENCING);
        }
    }

    public static class DefaultAcceleratorStrings {
        public static final String NEW = "ctrl N";
        public static final String OPEN = "ctrl O";
        public static final String SAVE = "ctrl S";
        public static final String SAVE_AS = "";
        public static final String SCREENSHOT = "";
        public static final String COPY = "ctrl C";
        public static final String COPY_FDS = "";
        public static final String PASTE = "ctrl V";
        public static final String CUT = "ctrl X";
        public static final String DELETE = "DELETE";
        public static final String HIDE = "alt shift H";
        public static final String FILTER = "alt shift F";
        public static final String SHOW_ALL = "alt shift A";
        public static final String SHOW = "alt shift S";
        public static final String UNDO = "ctrl Z";
        public static final String REDO = "ctrl Y";
        public static final String UNDO_EDIT = "ctrl shift Z";
        public static final String REDO_EDIT = "ctrl shift Y";
        public static final String FILL_VIEW = "F";
        public static final String RESET_VIEW = "ctrl R";
        public static final String RESET_SELECTED = "ctrl E";
        public static final String GARBAGE_COLLECTOR = "ctrl shift G";
        public static final String CRASH = "ctrl alt F6";
        public static final String NEW_VIEW = "ctrl shift V";
        public static final String NEW_SECTION_BOX = "ctrl shift S";
        public static final String RESET_SECTION_BOX = "ctrl shift R";
        public static final String SAVE_VIEWPOINT = "ctrl shift P";
        public static final String SHOW_VIEWPOINT = "ctrl shift I";
        public static final String SHOW_SECTION_BOXES = "ctrl shift D";
        public static final String ENABLE_SECTION_BOXES = "ctrl shift E";
        public static final String FIND = "ctrl F";
        public static final String RESET_TOP = "ctrl 5";
        public static final String RESET_BOTTOM = "ctrl 6";
        public static final String RESET_FRONT = "ctrl 1";
        public static final String RESET_BACK = "ctrl 2";
        public static final String RESET_LEFT = "ctrl 3";
        public static final String RESET_RIGHT = "ctrl 4";
        public static final String DRAW_MESH_TOOL = "";
        public static final String DRAW_SLAB_TOOL = "";
        public static final String DRAW_SLAB_HOLE_TOOL = "";
        public static final String DRAW_WALL_TOOL = "";
        public static final String DRAW_WALL_HOLE_TOOL = "";
        public static final String DRAW_BLOCK_TOOL = "";
        public static final String DRAW_BLOCK_HOLE_TOOL = "";
        public static final String DRAW_ROOM_TOOL = "";
        public static final String DRAW_ZONE_TOOL = "";
        public static final String DRAW_VENT_TOOL = "";
        public static final String DRAW_INIT_TOOL = "";
        public static final String DRAW_PARTICLE_CLOUD_TOOL = "";
        public static final String DRAW_PARTICLE_TOOL = "";
        public static final String DRAW_SLICE_2D_TOOL = "";
        public static final String DRAW_SLICE_3D_TOOL = "";
        public static final String DRAW_DEVICE_TOOL = "";
        public static final String DRAW_NODE_TOOL = "";
        public static final String DRAW_DUCT_TOOL = "";
        public static final String MEASURE_TOOL = "";
        public static final String MOVE_MANIP_TOOL = "";
        public static final String ROTATE_MANIP_TOOL = "";
        public static final String MIRROR_MANIP_TOOL = "";
        public static final String SELECT_TOOL = "";
        public static final String ORBIT_TOOL = "";
        public static final String ROAM_TOOL = "";
        public static final String PAN_TOOL = "";
        public static final String ZOOM_TOOL = "";
        public static final String ZOOM_BOX_TOOL = "";
        public static final String UNDEFINED = "";
    }

    public static class PyroShortcutIOHelper
    implements KeyboardAcceleratorIO.IKeyboardAcceleratorHelper {
        private final PyroSim d_pyroApp;

        public PyroShortcutIOHelper(PyroSim pyro) {
            this.d_pyroApp = pyro;
        }

        @Override
        public String getDefaultFileLocation() {
            return this.d_pyroApp.getAppDataDir() + "keybindings.json";
        }

        @Override
        public void updateActionMap(Map<String, KeyStroke> newKeyStrokeValues) {
            PyroActionMap.getInstance().updateActionMap(newKeyStrokeValues);
        }

        @Override
        public Collection<String> getSortedActionList() {
            LinkedHashSet<String> sorted = new LinkedHashSet<String>();
            sorted.addAll(PyroActionMap.getFileActionList());
            sorted.addAll(PyroActionMap.getEditActionList());
            sorted.addAll(PyroActionMap.getViewActionList());
            sorted.addAll(PyroActionMap.getSelectionActionList());
            sorted.addAll(PyroActionMap.getContextActionList());
            sorted.addAll(PyroActionMap.getToolActionList());
            return sorted;
        }

        @Override
        public KeyStroke getKeyStrokeForActionKey(String key) {
            return PyroActionMap.getInstance().getKeyStrokeForID(key);
        }
    }

    public static class PyroShortcutUIHelper
    implements CustomKeyAcceleratorDlg.ICustomKeyUIHelper {
        @Override
        public KeyStroke getKeyStrokeForID(String id) {
            return PyroActionMap.getInstance().getKeyStrokeForID(id);
        }

        @Override
        public KeyStroke getDefaultKeyStrokeForID(String id) {
            return PyroActionMap.getInstance().getDefaultKeyStrokeForID(id);
        }

        @Override
        public String getActionNameForID(String id) {
            return PyroActionMap.getInstance().getActionNameForID(id);
        }

        @Override
        public String getTooltipForID(String id) {
            return PyroActionMap.getInstance().getTooltipForActionKey(id);
        }

        @Override
        public void saveToActionMap(Map<String, KeyStroke> keystrokes) {
            PyroActionMap.getInstance().updateActionMap(keystrokes);
        }

        @Override
        public Collection<Pair<String, Collection<String>>> getTabStrings() {
            ArrayList<Pair<String, Collection<String>>> tabs = new ArrayList<Pair<String, Collection<String>>>();
            tabs.add(new Pair<String, Set<String>>(Intl.intl("File"), PyroActionMap.getFileActionList()));
            tabs.add(new Pair<String, Set<String>>(Intl.intl("Edit"), PyroActionMap.getEditActionList()));
            tabs.add(new Pair<String, Set<String>>(Intl.intl("View"), PyroActionMap.getViewActionList()));
            tabs.add(new Pair<String, Set<String>>(Intl.intl("Selection"), PyroActionMap.getSelectionActionList()));
            tabs.add(new Pair<String, Set<String>>(Intl.intl("Context"), PyroActionMap.getContextActionList()));
            tabs.add(new Pair<String, Set<String>>(Intl.intl("Tool"), PyroActionMap.getToolActionList()));
            return tabs;
        }
    }
}

