/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Optional;
import javax.vecmath.Matrix4d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import pyrosim.Intl;
import pyrosim.domain.Floor;
import pyrosim.domain.FloorManager;
import pyrosim.domain.ModelImage;
import pyrosim.gui.actions.ExportMetaAction;
import pyrosim.io.IOUtil;

public class ExportPyroFloorsAction
extends ExportMetaAction {
    private static final long serialVersionUID = 1L;
    public static final String EXT = "pyrofloors";

    public ExportPyroFloorsAction() {
        super(Intl.intl("PyroSim Floors..."), Intl.intl("Exports Floor Data for 3D Results"), Intl.intl("Results Floor Files"), EXT, (app, file) -> {
            try {
                ExportPyroFloorsAction.writeFloorsFile(file, app.getMediator().getFloorManager());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static void writeFloorsFile(File floorsFile, FloorManager floors) throws IOException {
        try (PrintWriter fWrite = IOUtil.newPrintWriterUTF8(floorsFile);){
            JSONObject obj = new JSONObject();
            obj.put("version", Version.curr().ordinal());
            obj.put("floors", ExportPyroFloorsAction.toJSONArray(floors));
            fWrite.println(obj.toJSONString());
        }
    }

    private static JSONArray toJSONArray(FloorManager floors) {
        JSONArray objects = new JSONArray();
        for (Floor floor : floors.flatten()) {
            ExportPyroFloorsAction.toJSON(floor).ifPresent(jsonView -> objects.add(jsonView));
        }
        return objects;
    }

    private static Optional<JSONObject> toJSON(Floor floor) {
        BaseUnit lu = SI.METER;
        JSONObject obj = new JSONObject();
        obj.put("name", floor.getName());
        obj.put("elevation", floor.getElevation().get(lu));
        obj.put("slabThickness", floor.getSlabThickness().get(lu));
        obj.put("wallHeight", floor.getWallHeight().get(lu));
        obj.put("color", ExportPyroFloorsAction.toArray(floor.getClipColor()));
        ModelImage image = floor.getBgImage();
        if (image != null) {
            obj.put("image", ExportPyroFloorsAction.toJSON(image));
        }
        return Optional.of(obj);
    }

    private static JSONObject toJSON(ModelImage image) {
        JSONObject jimage = new JSONObject();
        Matrix4d xform = image.getLWTransform().toMatrix(false);
        jimage.put("xform", ExportPyroFloorsAction.toArray(xform));
        jimage.put("fn", image.getImage().getFilename());
        jimage.put("opacity", Float.valueOf(image.getOpacity()));
        return jimage;
    }

    public static enum Version {
        V00;


        public static Version curr() {
            return Version.values()[Version.values().length - 1];
        }
    }
}

