/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.HeatTransfer3D;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.ARunFDSValidation;
import thunderheadeng.util.theUtil;

public class Domain3DHeatTransferModelValidation
extends ARunFDSValidation {
    protected Domain3DHeatTransferModelValidation(PyroSim app, PyroMod mod) {
        super(app, mod);
    }

    @Override
    public Collection<IPyroObject> validateModel() {
        Collection surfObjs = this.d_pyroMod.getAllGeom().stream().filter(g -> g.isEnabled() && g instanceof ISurfObj).map(g -> (ISurfObj)g).collect(Collectors.toList());
        ArrayList<IPyroObject> invalid = new ArrayList<IPyroObject>();
        for (ISurfObj surfObj : surfObjs) {
            for (Surface surface : surfObj.getSurfaces()) {
                if (!(surface.getSurfDesc() instanceof LayeredSurfDesc)) continue;
                LayeredSurfDesc desc = (LayeredSurfDesc)surface.getSurfDesc();
                HeatTransfer3D ht3d = desc.d_ht3d;
                if (ht3d == null || !theUtil.le0(ht3d.d_cellSize.getValue(Geometry.LU), 1.0E-6)) continue;
                invalid.add(surface);
            }
        }
        return invalid;
    }

    @Override
    public ARunFDSValidation.Prompt getPrompt(Window owner, int issueSize) {
        String instructions = Intl.intl("The 3D Heat Transfer Model requires a Cell Size greater than 0. \nIt should be set to the smallest cell size of any Mesh where the \nsurface is applied. \n\nClick OK to abort simulation and return to PyroSim.");
        ARunFDSValidation.Prompt p = new ARunFDSValidation.Prompt(owner, instructions);
        p.overrideButtonDesc(8, Intl.intl("Ignore"));
        return p;
    }

    @Override
    public String getValidationDescription() {
        return Intl.intl("Domain 3D Heat Transfer Model Validation");
    }
}

