/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.OptionalLong;
import java.util.function.Predicate;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.SetNameTask;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.RenameDialog;
import thunderheadeng.gui.guiAction;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Predicates;

public class ContextRenameAction
extends guiAction {
    public static final guiAction s_uiHook = new ContextRenameAction();
    private static final long serialVersionUID = 1L;

    public ContextRenameAction() {
        super(Intl.intl("Rename..."));
        this.putValue("ShortDescription", Intl.intl("Rename Objects"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PyroSim app = (PyroSim)Application.getApp();
        PyroMod mediator = app.getMediator();
        ArrayList<INamed> namedObjs = new ArrayList<INamed>(mediator.getSelectionModel().getSelected(INamed.class, named -> TVEntryPoints.ep(named).canRename(mediator, (INamed)named)));
        RenameDialog.ICallback<INamed> renameCallback = ContextRenameAction.getRenameCallback(mediator);
        List keywords = RenameDialog.getDefaultKeywords(renameCallback, namedObjs);
        RenameDialog<INamed> renameDlg = new RenameDialog<INamed>((Window)app.getActiveFrame(), renameCallback, keywords, namedObjs);
        if (renameDlg.doModal() != 1) {
            return;
        }
        List<String> newNames = renameDlg.generateNames(namedObjs);
        if (newNames.isEmpty()) {
            return;
        }
        assert (namedObjs.size() == newNames.size());
        CompositeTask<PyroMod> compTask = new CompositeTask<PyroMod>(mediator);
        for (int i = 0; i < namedObjs.size(); ++i) {
            if (newNames.get(i) == null) continue;
            compTask.addTask(new SetNameTask((INamed)namedObjs.get(i), newNames.get(i)));
        }
        mediator.getTaskManager().exec(compTask, Intl.intl("Rename"));
    }

    private static RenameDialog.ICallback<INamed> getRenameCallback(final PyroMod mod) {
        return new RenameDialog.ICallback<INamed>(){

            @Override
            public Object getRoot(INamed obj) {
                TVEntryPoint<INamed> entryPoint = TVEntryPoints.ep(obj);
                return entryPoint.getCategoryRoot(mod, obj);
            }

            @Override
            public Object getParent(Object obj) {
                TVEntryPoint<Object> entryPoint = TVEntryPoints.ep(obj);
                return entryPoint.getTreeviewParent(mod, obj);
            }

            @Override
            public List<Object> getChildren(Object obj) {
                TVEntryPoint<Object> entryPoint = TVEntryPoints.ep(obj);
                return new ArrayList<Object>(entryPoint.getTreeviewChildren(mod, obj));
            }

            @Override
            public List<Object> flattenHierarchy(Object obj) {
                TVEntryPoint<Object> entryPoint = TVEntryPoints.ep(obj);
                if (obj instanceof Composite) {
                    Composite asComp = (Composite)obj;
                    return new ArrayList<Object>(asComp.flatten());
                }
                return new ArrayList<Object>(entryPoint.getTreeviewChildren(mod, obj));
            }

            @Override
            public String getName(Object obj) {
                TVEntryPoint<Object> entryPoint = TVEntryPoints.ep(obj);
                return entryPoint.getName(obj);
            }

            @Override
            public String getTypeString(INamed obj) {
                TVEntryPoint<INamed> entryPoint = TVEntryPoints.ep(obj);
                return entryPoint.getCategoryName(obj);
            }

            @Override
            public OptionalLong getResultsId(INamed obj) {
                INamed asPyro;
                long id;
                if (obj instanceof IPyroObject && (id = (asPyro = obj).getResultsId()) != -1L) {
                    return OptionalLong.of(id);
                }
                return OptionalLong.empty();
            }

            @Override
            public Predicate<String> getNameValidator(INamed obj) {
                return Predicates.alwaysTrue();
            }

            @Override
            public Object getUniqueNameGroup(INamed obj) {
                TVEntryPoint<INamed> entryPoint = TVEntryPoints.ep(obj);
                return entryPoint.getRenameGroup(mod, obj);
            }

            @Override
            public Collection<?> getGroupObjs(Object group) {
                if (group instanceof TVEntryPoint.IRenameGroup) {
                    TVEntryPoint.IRenameGroup sharedNameSource = (TVEntryPoint.IRenameGroup)group;
                    return sharedNameSource.getGroupedObjects(mod);
                }
                return Collections.emptyList();
            }
        };
    }

    @Override
    public void updateEnabled() {
        PyroMod pyMod = PyroSim.getApp().getMediator();
        this.setEnabled(ContextRenameAction.containsExplicitRenames(pyMod));
    }

    private static boolean containsExplicitRenames(PyroMod pyMod) {
        return !pyMod.getSelectionModel().getSelected(INamed.class, n -> TVEntryPoints.ep(n).canRename(pyMod, (INamed)n)).isEmpty();
    }
}

