/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.actions;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.gui.CloudFDSDlg;

public class CloudFDSUtil {
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).connectTimeout(Duration.ofSeconds(20L)).build();
    private static final Logger LOGGER = Logger.getLogger(CloudFDSUtil.class.getName());
    public static final String API_VERSION = "v1";

    public static FDS_FEA_STATUS getStatusFromCode(long code) {
        for (FDS_FEA_STATUS status : FDS_FEA_STATUS.values()) {
            if ((long)status.code != code) continue;
            return status;
        }
        assert (false);
        return null;
    }

    public static String getFolderName(File outfile) {
        return outfile.getName() + "_" + System.currentTimeMillis();
    }

    public static String getUploadLocation(File outfile, String CFDFEAFolder, CloudFDSDlg.CFD_FEA_Params params) throws HttpException, ExecutionException, InterruptedException, ParseException {
        JSONObject data = new JSONObject();
        data.put("dirname", CFDFEAFolder);
        data.put("basename", outfile.getName());
        data.put("contentType", "application/octet-stream");
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        String jsonString = payload.toString();
        HttpRequest request = CloudFDSUtil.getRequestBuilder(params.apiKey, "storage/upload/url").POST(HttpRequest.BodyPublishers.ofString(jsonString)).build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
        return CloudFDSUtil.parseObject(response).get("url").toString();
    }

    public static void uploadFile(String gfcFolder, File outFile) throws IOException, ExecutionException, InterruptedException {
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(gfcFolder)).PUT(HttpRequest.BodyPublishers.ofFile(outFile.toPath())).timeout(Duration.ofMinutes(2L)).header("Content-Type", "application/octet-stream").build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
    }

    public static JSONObject getDownloadMetadata(long id) throws IOException, ParseException, ExecutionException, InterruptedException {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, String.format("storage/%d/download/url", id)).GET().build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
        return CloudFDSUtil.parseObject(response);
    }

    public static JSONObject getSimulationResults(String folderName) throws IOException, ParseException, ExecutionException, InterruptedException {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        JSONObject data = new JSONObject();
        JSONObject payload = new JSONObject();
        data.put("path", folderName + "\\FDS.tar.gz");
        payload.put("data", data);
        String jsonString = payload.toJSONString();
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, "storage/view").POST(HttpRequest.BodyPublishers.ofString(jsonString)).build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
        return CloudFDSUtil.parseObject(response);
    }

    private static CompletableFuture<HttpResponse<String>> getCPUOptions() {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, "simulation/cpu").GET().build();
        return HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    private static CompletableFuture<HttpResponse<String>> getMemOptions() {
        String apiKey = PyroPrefs.getString(PyroPrefs.FDSFEA_ApiKey);
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, "simulation/ram").GET().build();
        return HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    public static SimOptions getSimOptions() {
        JSONArray jArray;
        CompletableFuture<HttpResponse<String>> cpu = CloudFDSUtil.getCPUOptions();
        CompletableFuture<HttpResponse<String>> mem = CloudFDSUtil.getMemOptions();
        CompletableFuture.allOf(cpu, mem).join();
        ArrayList<Integer> cpuArray = new ArrayList<Integer>();
        ArrayList<String> memArray = new ArrayList<String>();
        try {
            HttpResponse<String> cpuResponse = cpu.get();
            CloudFDSUtil.validateStatus(cpuResponse, 200);
            jArray = CloudFDSUtil.parseArray(cpuResponse);
            jArray.forEach(obj -> cpuArray.add(((Number)obj).intValue()));
        }
        catch (InterruptedException | ExecutionException | ParseException | HttpException cpuResponse) {
            // empty catch block
        }
        try {
            HttpResponse<String> memResponse = mem.get();
            CloudFDSUtil.validateStatus(memResponse, 200);
            jArray = CloudFDSUtil.parseArray(memResponse);
            jArray.forEach(obj -> memArray.add((String)obj));
        }
        catch (InterruptedException | ExecutionException | ParseException | HttpException exception) {
            // empty catch block
        }
        return new SimOptions(cpuArray, memArray);
    }

    private static CompletableFuture<HttpResponse<String>> getSimulationData(CloudFDSDlg.CFD_FEA_Params params, int id) {
        HttpRequest request = CloudFDSUtil.getRequestBuilder(params.apiKey, String.format("simulation/%d", id)).GET().build();
        return HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    public static int startSim(String CFDFEAFolder, CloudFDSDlg.CFD_FEA_Params params) throws ExecutionException, InterruptedException, HttpException {
        JSONObject data = new JSONObject();
        data.put("cpu", String.valueOf(params.numCores));
        data.put("ram", params.ramOpt);
        data.put("folder", CFDFEAFolder);
        data.put("script", params.version.value);
        data.put("source", "pyrosim_" + "2024.2.1120".replace(".", "-"));
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        String jsonString = data.toJSONString();
        HttpRequest request = CloudFDSUtil.getRequestBuilder(params.apiKey, "simulation").POST(HttpRequest.BodyPublishers.ofString(jsonString)).build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200, new StartSimException(Integer.toString(response.statusCode()), response.body(), response.body()));
        return Integer.parseInt(response.body());
    }

    public static void stopSim(CloudFDSDlg.CFD_FEA_Params params, int id, boolean force) throws ExecutionException, InterruptedException, HttpException {
        JSONObject data = new JSONObject();
        data.put("signal", force ? "SIGINT" : "SIGTSTP");
        JSONObject payload = new JSONObject();
        payload.put("data", data);
        String jsonString = data.toJSONString();
        HttpRequest request = CloudFDSUtil.getRequestBuilder(params.apiKey, String.format("simulation/%d/stop", id)).PUT(HttpRequest.BodyPublishers.ofString(jsonString)).build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
    }

    public static JSONArray getSimsList(String apiKey) throws ExecutionException, InterruptedException, HttpException, ParseException {
        assert (!apiKey.isEmpty());
        HttpRequest request = CloudFDSUtil.getRequestBuilder(apiKey, "simulation").GET().build();
        HttpResponse<String> response = HTTP_CLIENT.sendAsync(request, HttpResponse.BodyHandlers.ofString()).get();
        CloudFDSUtil.validateStatus(response, 200);
        return CloudFDSUtil.parseArray(response);
    }

    private static HttpRequest.Builder getRequestBuilder(String apiKey, String route) {
        return HttpRequest.newBuilder().uri(URI.create(String.format("%s/api/%s/%s", CLOUD_PROVIDERS.CFD_FEA.URI, API_VERSION, route))).timeout(Duration.ofMinutes(2L)).header("Content-Type", "application/json").headers("Accept", "application/json").header("api-key", apiKey);
    }

    private static void validateStatus(HttpResponse<String> response, int expectedStatus) throws HttpException {
        if (response.statusCode() != expectedStatus) {
            JSONParser parser = new JSONParser();
            try {
                JSONObject object = (JSONObject)parser.parse(response.body());
                JSONObject err = (JSONObject)object.get("error");
                if (err != null) {
                    CloudFDSUtil.validateStatus(response, expectedStatus, new HttpException(String.format("%s: %s", err.get("message"), err.get("code"))));
                }
            }
            catch (ParseException e) {
                CloudFDSUtil.validateStatus(response, expectedStatus, new HttpException(String.format(Intl.intl("Request failed: %d"), expectedStatus)));
            }
        }
    }

    private static void validateStatus(HttpResponse<String> response, int expectedStatus, HttpException exception) throws HttpException {
        if (response.statusCode() != expectedStatus) {
            throw exception;
        }
    }

    private static JSONArray parseArray(HttpResponse<String> response) throws ParseException {
        JSONParser parser = new JSONParser();
        return (JSONArray)parser.parse(response.body());
    }

    private static JSONObject parseObject(HttpResponse<String> response) throws ParseException {
        JSONParser parser = new JSONParser();
        return (JSONObject)parser.parse(response.body());
    }

    public static enum FDS_FEA_STATUS {
        COMPLETED(10),
        ERROR(60),
        PENDING(20),
        RUNNING(30),
        STOPPING(40),
        STOPPED(50);

        public final int code;

        private FDS_FEA_STATUS(int code) {
            this.code = code;
        }
    }

    public static class HttpException
    extends IOException {
        public HttpException() {
        }

        public HttpException(String message) {
            super(message);
        }
    }

    public static class SimOptions {
        public Collection<Integer> cpuOptions;
        public Collection<String> memoryOptions;

        public SimOptions(Collection<Integer> cpuOptions, Collection<String> memoryOptions) {
            this.cpuOptions = cpuOptions;
            this.memoryOptions = memoryOptions;
        }
    }

    public static class StartSimException
    extends HttpException {
        private static final long serialVersionUID = 1L;
        public final String responseEntityStr;
        public final String requestEntityStr;

        public StartSimException(String statusLineStr, String responseEntityStr, String requestEntityStr) {
            super(statusLineStr);
            this.responseEntityStr = responseEntityStr;
            this.requestEntityStr = requestEntityStr;
        }
    }

    public static enum CLOUD_PROVIDERS {
        CFD_FEA("CFD FEA", "https://cloud.cfdfeaservice.it");

        public final String name;
        public final String URI;

        private CLOUD_PROVIDERS(String serviceName, String URI2) {
            this.name = serviceName;
            this.URI = URI2;
        }

        public String toString() {
            return this.name;
        }
    }
}

