/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.io.POVRayWriter;
import pyrosim.mv.ModelView;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.io.FilenameManager;
import thunderheadeng.util.IntVR;

public class SnapshotDialog
extends guiDialog {
    private static final long serialVersionUID = -246230779389540893L;
    private static final String nl = System.getProperty("line.separator");
    private final File d_outFile;
    private final ModelView d_mv;
    private final PyroSim d_pyro;
    private final JRadioButton d_snapshotButton;
    private final JRadioButton d_povrayButton;
    private final JCheckBox d_antiAlias;
    private final JCheckBox d_shadows;
    private final JCheckBox d_povFile;
    private final TitleSeparator d_exportTypeTitle;
    private final guiPanel d_dlgPanel;
    private ValueField<Integer> d_widthField;
    private ValueField<Integer> d_heightField;
    private final JButton d_useWindowSizeButton;

    public SnapshotDialog(JFrame owner, PyroSim sim, ModelView mv, File outFile) {
        super((Window)owner, Intl.intl("Snapshot Properties"), 9);
        this.d_outFile = outFile;
        this.d_mv = mv;
        this.d_pyro = sim;
        this.d_dlgPanel = super.getDialogPane();
        this.d_dlgPanel.setLayout(new GridBagLayout());
        this.d_snapshotButton = new JRadioButton(Intl.intl("PyroSim"));
        this.d_povrayButton = new JRadioButton(Intl.intl("POV-Ray"));
        this.d_antiAlias = new JCheckBox(Intl.intl("Anti-alias"));
        this.d_shadows = new JCheckBox(Intl.intl("Shadows"));
        this.d_povFile = new JCheckBox(Intl.intl("Export POV File"));
        this.d_exportTypeTitle = new TitleSeparator(Intl.intl("Render Program"));
        this.d_widthField = ValueFields.intFld();
        this.d_heightField = ValueFields.intFld();
        this.d_useWindowSizeButton = new JButton(Intl.intl("Use window size"));
        new guiButtonGroup(this.d_snapshotButton, this.d_povrayButton);
        LinkStatus.link((AbstractButton)this.d_povrayButton, this.d_antiAlias, this.d_shadows, this.d_povFile);
        this.setInitialProperties();
        this.buildPanel();
    }

    @Override
    public int doModal() {
        int result = super.doModal();
        if (result == 1) {
            this.d_pyro.beginWaitCursor();
            if (this.d_snapshotButton.isSelected()) {
                this.takeShot();
            } else {
                this.runPOV();
            }
            this.d_pyro.endWaitCursor();
        }
        return result;
    }

    private void buildPanel() {
        guiLabel sizeL = new guiLabel(Intl.intl("Size") + ":");
        guiLabel pyroSimL = new guiLabel(Intl.intl("(fast, medium quality)"));
        guiLabel povrayL = new guiLabel(Intl.intl("(slow, high quality)"));
        guiLabel x = new guiLabel("x");
        guiPanel sizePanel = new guiPanel(new GridBagLayout());
        int row = 0;
        GridBagUtil.add(sizePanel, sizeL, 0, ++row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_widthField, 1, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, x, 2, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_heightField, 3, row, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(sizePanel, this.d_useWindowSizeButton, 4, row, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        guiPanel progPanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(progPanel, this.d_exportTypeTitle, 0, row, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(progPanel, this.d_snapshotButton, 0, ++row, 1, 1, 0, 12, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, pyroSimL, 1, row, 1, 1, 0, 6, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, this.d_povrayButton, 0, ++row, 1, 1, 0, 12, 2, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(progPanel, povrayL, 1, row, 1, 1, 0, 6, 2, 0, 0, 0.0, 0.0, 17);
        guiPanel povPanel = new guiPanel(new GridBagLayout());
        row = 0;
        GridBagUtil.add(povPanel, this.d_antiAlias, 0, row, 1, 1, 0, 24, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(povPanel, this.d_shadows, 1, row, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(povPanel, this.d_povFile, 2, row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        row = 0;
        GridBagUtil.add(this.d_dlgPanel, sizePanel, 0, ++row, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
    }

    private void setInitialProperties() {
        if (PyroPrefs.getBoolean(PyroPrefs.LastScreenShotPyroButton)) {
            Dimension maxSize = this.d_mv.getScreenshotGenerator().getMaximumSize();
            this.d_widthField.setFilter(IntVR.between(1, maxSize.width, true, true));
            this.d_heightField.setFilter(IntVR.between(1, maxSize.height, true, true));
        } else {
            this.d_widthField.setFilter(IntVR.between(1, 5000000, true, true));
            this.d_heightField.setFilter(IntVR.between(1, 5000000, true, true));
        }
        this.d_widthField.setColumns(5);
        this.d_heightField.setColumns(5);
        this.fillSizeFromView();
        try {
            int ssWidth = PyroPrefs.getInt(PyroPrefs.LastScreenShotWidth);
            int ssHeight = PyroPrefs.getInt(PyroPrefs.LastScreenShotHeight);
            this.d_widthField.setValue(ssWidth);
            this.d_heightField.setValue(ssHeight);
        }
        catch (NumberFormatException ssWidth) {
            // empty catch block
        }
        this.d_useWindowSizeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotDialog.this.fillSizeFromView();
            }
        });
        boolean pyroButton = PyroPrefs.getBoolean(PyroPrefs.LastScreenShotPyroButton);
        this.d_snapshotButton.setSelected(pyroButton);
        this.d_povrayButton.setSelected(!pyroButton);
        this.d_antiAlias.setSelected(PyroPrefs.getBoolean(PyroPrefs.POVScreenShotAntiAlias));
        this.d_antiAlias.setEnabled(!pyroButton);
        this.d_shadows.setSelected(PyroPrefs.getBoolean(PyroPrefs.POVScreenShotShadows));
        this.d_shadows.setEnabled(!pyroButton);
        this.d_povFile.setSelected(PyroPrefs.getBoolean(PyroPrefs.POVScreenShotPOVFile));
        this.d_povFile.setEnabled(!pyroButton);
        this.d_snapshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Dimension maxSize = SnapshotDialog.this.d_mv.getScreenshotGenerator().getMaximumSize();
                SnapshotDialog.this.d_widthField.setFilter(IntVR.between(1, maxSize.width, true, true));
                SnapshotDialog.this.d_heightField.setFilter(IntVR.between(1, maxSize.height, true, true));
            }
        });
        this.d_povrayButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String megaPovLocation = PyroPrefs.getString(PyroPrefs.PREF_MPOVLOCATION);
                if (megaPovLocation == null || !new File(megaPovLocation).exists()) {
                    JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("The location specified for MegaPOV is invalid.  Please specify a valid file by\ngoing to \"File->Preferences.\""), Intl.intl("Invalid MegaPOV File Specified"), 0);
                    SnapshotDialog.this.d_snapshotButton.setSelected(true);
                    return;
                }
                String ext = FilenameManager.getExtension(SnapshotDialog.this.d_outFile.getName());
                if (!(ext.equalsIgnoreCase("png") || ext.equalsIgnoreCase("tga") || ext.equalsIgnoreCase("targa") || ext.equalsIgnoreCase("ppm"))) {
                    JOptionPane.showMessageDialog(Application.getApp().getActiveFrame(), Intl.intl("Only PNG, TGA, and PPM files may be output by MegaPOV."), Intl.intl("Invalid File Type"), 0);
                    SnapshotDialog.this.d_snapshotButton.setSelected(true);
                    return;
                }
                SnapshotDialog.this.d_widthField.setFilter(IntVR.above(1, true));
                SnapshotDialog.this.d_heightField.setFilter(IntVR.above(1, true));
            }
        });
    }

    private void fillSizeFromView() {
        this.d_widthField.setValue(this.d_mv.getRenderComponent().getWidth());
        this.d_heightField.setValue(this.d_mv.getRenderComponent().getHeight());
    }

    private void runPOV() {
        int width = (Integer)this.d_widthField.getValue();
        int height = (Integer)this.d_heightField.getValue();
        boolean antiAlias = this.d_antiAlias.isSelected();
        boolean shadows = this.d_shadows.isSelected();
        boolean povFile = this.d_povFile.isSelected();
        POVRayWriter.writePOVRayFile(this.d_pyro, this.d_outFile.getAbsolutePath(), width, height, antiAlias, shadows, povFile);
        PyroPrefs.set(PyroPrefs.LastScreenShotWidth, (Integer)this.d_widthField.getValue(), false);
        PyroPrefs.set(PyroPrefs.LastScreenShotHeight, (Integer)this.d_heightField.getValue(), false);
        PyroPrefs.set(PyroPrefs.POVScreenShotAntiAlias, antiAlias, false);
        PyroPrefs.set(PyroPrefs.POVScreenShotShadows, shadows, false);
        PyroPrefs.set(PyroPrefs.POVScreenShotPOVFile, povFile, false);
        PyroPrefs.set(PyroPrefs.LastScreenShotPyroButton, false, true);
    }

    private boolean takeShot() {
        this.d_mv.getScreenshotGenerator().setSize((Integer)this.d_widthField.getValue(), (Integer)this.d_heightField.getValue());
        this.d_mv.getScreenshotGenerator().writeFile(this.d_outFile.getAbsolutePath());
        PyroPrefs.set(PyroPrefs.LastScreenShotWidth, (Integer)this.d_widthField.getValue(), false);
        PyroPrefs.set(PyroPrefs.LastScreenShotHeight, (Integer)this.d_heightField.getValue(), false);
        PyroPrefs.set(PyroPrefs.LastScreenShotPyroButton, true, true);
        this.d_mv.getRenderComponent().repaint();
        return true;
    }
}

