/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.Actions;
import pyrosim.util.Util;
import thunderheadeng.gui.dialogs.ShowObjectsDialog;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Task;

public class ShowObjectsDlg
extends ShowObjectsDialog<IPyroObject> {
    private static final long serialVersionUID = 1L;

    public ShowObjectsDlg(Window owner, PyroMod pyMod, String title, String undoDesc, Collection<? extends IPyroObject> objs) {
        super(owner, title, true, ShowObjectsDlg.getCallback(pyMod, undoDesc), objs);
    }

    private static ShowObjectsDialog.ICallback<IPyroObject> getCallback(final PyroMod d_pyro, final String undoDesc) {
        return new ShowObjectsDialog.ICallback<IPyroObject>(){

            @Override
            public Events getEvents() {
                return d_pyro.getEvents();
            }

            @Override
            public boolean isSelectionEvent(IEventRecord<?> events) {
                return events.containsChange(PyroMod.EVT_SEL) || events.containsChange(PyroMod.EVT_MODEL_CHANGED);
            }

            @Override
            public boolean isDecorationEvent(IEventRecord<?> events) {
                return events.containsChange(PyroMod.EVT_APPEARANCE);
            }

            @Override
            public boolean isSelected(IPyroObject obj) {
                return d_pyro.getSelectionModel().isSelected(obj);
            }

            @Override
            public void setSelection(ShowObjectsDialog<IPyroObject> dlg, Collection<? extends IPyroObject> objs) {
                SelectTask selLocalSelectionTask = new SelectTask(d_pyro, objs);
                d_pyro.getTaskManager().exec((Task)selLocalSelectionTask, undoDesc, 0);
            }

            @Override
            public void decorateCells(DefaultListCellRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                PyroGuiUtil.decorateCellRenderer(d_pyro, icons -> {
                    r.setIcon(icons[0]);
                    r.setIcon(icons[1]);
                    list.repaint();
                }, value, r, isSelected, cellHasFocus);
                IPyroObject obj = (IPyroObject)value;
                r.setText(Util.getName(obj));
            }

            @Override
            public JPopupMenu getContextMenu(MouseEvent e) {
                return Actions.getContextMenu(d_pyro.getSelectionModel().getSelection());
            }
        };
    }
}

