/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public class ProcessUtil {
    public static ProcessResult run(Process p) throws InterruptedException {
        StringBuffer stderr = new StringBuffer();
        StringBuffer stdout = new StringBuffer();
        Thread terr = new Thread(ProcessUtil.createOutputConsumer(stderr, p.getErrorStream()));
        Thread tout = new Thread(ProcessUtil.createOutputConsumer(stdout, p.getInputStream()));
        terr.start();
        tout.start();
        int exitCode = p.waitFor();
        terr.join();
        tout.join();
        return new ProcessResult(exitCode, stdout.toString(), stderr.toString(), true);
    }

    public static ProcessResult run(Process p, int seconds) throws InterruptedException {
        StringBuffer stderr = new StringBuffer();
        StringBuffer stdout = new StringBuffer();
        Thread terr = new Thread(ProcessUtil.createOutputConsumer(stderr, p.getErrorStream()));
        Thread tout = new Thread(ProcessUtil.createOutputConsumer(stdout, p.getInputStream()));
        terr.start();
        tout.start();
        boolean exitedSuccess = p.waitFor(seconds, TimeUnit.SECONDS);
        int exitcode = 0;
        try {
            exitcode = p.exitValue();
        }
        catch (IllegalThreadStateException e) {
            e.printStackTrace();
            p.destroy();
            if (p.isAlive()) {
                p.destroyForcibly();
            }
            exitcode = -1;
        }
        terr.join((seconds + 1) * 1000);
        tout.join((seconds + 1) * 1000);
        return new ProcessResult(exitcode, stdout.toString(), stderr.toString(), exitedSuccess);
    }

    private static Runnable createOutputConsumer(StringBuffer sb, InputStream is) {
        return () -> {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line + System.lineSeparator());
                    line = reader.readLine();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
    }

    public static class ProcessResult {
        public final int exitCode;
        public final String stdout;
        public final String stderr;
        public final boolean success;

        public ProcessResult(int exitCode, String stdout, String stderr, boolean success) {
            this.exitCode = exitCode;
            this.stdout = stdout;
            this.stderr = stderr;
            this.success = success;
        }

        public String toString() {
            return String.format("ProcessResult[exitCode=%s, stdout=\"%s\", stderr=\"%s\"]", this.exitCode, this.stdout.trim(), this.stderr.trim());
        }
    }
}

