/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.NonSI;
import pyrosim.FDSVersion;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.Version;
import pyrosim.domain.GridProcessUtil;
import pyrosim.domain.tasks.ReplaceRefTask;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.actions.PyroActionMap;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.CrashCatcher;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.dialogs.CustomKeyAcceleratorDlg;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.scene3d.gui.GPUInfoPnl;
import thunderheadeng.scene3d.gui.RenderPrefs;
import thunderheadeng.scene3d.gui.ToolPrefsPnl;
import thunderheadeng.scene3d.nativebuffered.IRenderSurface;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.TeciProps;
import thunderheadeng.util.TypedProp;

public class PreferencesDialog
extends guiDialog {
    private static final long serialVersionUID = -6104217703945371899L;
    private final Map<Tabs, PrefsPanel> d_tabPanels;
    private final PyroMod d_pyroMod;

    public PreferencesDialog(Supplier<IPropertySet> getRenderDefault, Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp) {
        this(getRenderDefault, getRenderPref, getRenderComp, Tabs.PYROSIM);
    }

    public PreferencesDialog(Supplier<IPropertySet> getRenderDefault, Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp, Tabs defTab) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("Preferences"), 9);
        PyroSim pySim = (PyroSim)Application.getApp();
        this.d_pyroMod = pySim.getMediator();
        JTabbedPane tabs = new JTabbedPane();
        HashMap tabMap = new HashMap();
        this.d_tabPanels = new LinkedHashMap<Tabs, PrefsPanel>();
        BiConsumer<Tabs, PrefsPanel> addTab = (tab, panel) -> {
            this.d_tabPanels.put((Tabs)((Object)tab), (PrefsPanel)panel);
            panel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            int tabIx = tabs.getTabCount();
            tabs.add(tab.desc, (Component)panel);
            tabMap.put(tab, tabIx);
        };
        addTab.accept(Tabs.PYROSIM, new PyroSimPanel());
        addTab.accept(Tabs.RECORDVIEW, new RecordViewPanel());
        addTab.accept(Tabs.FDS, new FDSPanel(this.d_pyroMod));
        addTab.accept(Tabs.RESULTS, new ResultsPanel());
        PyroSim app = PyroSim.getApp();
        Supplier<IRenderSurface.OpenGLInfo> getRenderInfo = () -> app.get3DView().getRenderComp().getOpenGLInfo();
        addTab.accept(Tabs.RENDERING, new DisplayPanel(getRenderDefault, getRenderPref, getRenderComp, getRenderInfo));
        guiPanel dlgPanel = this.getDialogPane();
        dlgPanel.add((Component)tabs, "Center");
        this.loadValues();
        tabs.setSelectedIndex((Integer)tabMap.get((Object)defTab));
    }

    public void loadValues() {
        for (PrefsPanel p : this.d_tabPanels.values()) {
            p.loadData();
        }
    }

    public void saveData() {
        this.d_pyroMod.pauseUpdates();
        ArrayList<Pair> tasks = new ArrayList<Pair>();
        for (PrefsPanel p2 : this.d_tabPanels.values()) {
            p2.saveData(tasks::add);
        }
        PyroSim.getApp().superSavePreferences();
        if (!tasks.isEmpty()) {
            if (tasks.size() == 1) {
                this.d_pyroMod.getTaskManager().exec((Task)((Pair)tasks.get((int)0)).v2, (String)((Pair)tasks.get((int)0)).v1);
            } else {
                CompositeTask<PyroMod> ctask = new CompositeTask<PyroMod>(this.d_pyroMod);
                tasks.forEach(p -> ctask.addTask((Task)p.v2));
                this.d_pyroMod.getTaskManager().exec(ctask, (String)((Pair)tasks.get((int)0)).v1);
            }
        }
        this.d_pyroMod.resumeUpdates();
    }

    public static <T> boolean setPref(TypedProp<T> prop, T value) {
        return PyroSim.setPref(prop, value, false);
    }

    public static boolean setPref(PyroPrefs.UDProp prop, UnitDouble value) {
        return PyroSim.setPref(prop, value.getValue(prop.d_storeUnit), false);
    }

    public static enum Tabs {
        PYROSIM(Intl.intl("PyroSim")),
        RECORDVIEW(Intl.intl("Record View")),
        FDS(Intl.intl("FDS")),
        RESULTS(Intl.intl("Results")),
        RENDERING(Intl.intl("Rendering"));

        public final String desc;

        private Tabs(String desc) {
            this.desc = desc;
        }
    }

    private static class PyroSimPanel
    extends PrefsPanel {
        private static final long serialVersionUID = 2460256735511807191L;
        private final guiCheckBox d_easyReadFormatBox;
        private final ValueField<Integer> d_easyReadPrecision;
        private final ValueField<Integer> d_numMRUFiles;
        private final ValueField<Integer> d_maxUndoHistory;
        private final guiCheckBox d_autosave;
        private final ValueField<UnitDouble> d_autosaveInterval;
        private final guiCheckBox d_createBackupOnOpen;
        private final guiCheckBox d_recordPreview;
        private final guiCheckBox d_showSplash;
        private final ToolPrefsPnl d_toolPrefs;
        private final guiCheckBox d_crashCatcherNag;

        public PyroSimPanel() {
            super(new GridBagLayout());
            TitleSeparator fileFormatLabel = new TitleSeparator(Intl.intl("FDS File Format"));
            this.d_easyReadFormatBox = new guiCheckBox(Intl.intl("Format FDS file for easy reading"));
            this.d_easyReadPrecision = ValueFields.intFld(IntVR.above(2, true));
            guiLabel precisionLbl = new guiLabel(Intl.intl("Max precision:"));
            LinkStatus.link((AbstractButton)this.d_easyReadFormatBox, this.d_easyReadPrecision, precisionLbl);
            TitleSeparator autosaveLabel = new TitleSeparator(Intl.intl("Options"));
            this.d_numMRUFiles = ValueFields.intFld(IntVR.between(1, 30, true, true));
            this.d_maxUndoHistory = ValueFields.intFld(IntVR.between(0, 200, false, true));
            this.d_autosave = new guiCheckBox(Intl.intl("Autosave:"));
            UnitDouble tenMin = new UnitDouble(10.0, NonSI.MINUTE);
            UnitDoubleVR aboveOneMin = UnitDoubleVR.above(new UnitDouble(0.0, NonSI.MINUTE), false);
            this.d_autosaveInterval = ValueFields.udFld(tenMin, aboveOneMin, UnitSystem.getSource(2));
            LinkStatus.link((AbstractButton)this.d_autosave, this.d_autosaveInterval);
            this.d_createBackupOnOpen = new guiCheckBox(Intl.intl("Create Backup on Open"));
            this.d_recordPreview = new guiCheckBox(Intl.intl("Record Preview"));
            this.d_showSplash = new guiCheckBox(Intl.intl("Show Splash Screen on Startup"));
            this.d_crashCatcherNag = new guiCheckBox(Intl.intl("Always Prompt for Additional Info on Crash"));
            guiLabel editHotkeyLbl = new guiLabel(Intl.intl("Keyboard Shortcuts:"));
            JButton editHotkeys = new JButton(Intl.intl("Edit..."));
            editHotkeys.addActionListener(e -> {
                CustomKeyAcceleratorDlg dlg = new CustomKeyAcceleratorDlg(Application.getApp().getActiveFrame(), new PyroActionMap.PyroShortcutUIHelper());
                if (dlg.doModal() == 1) {
                    dlg.saveData();
                }
            });
            this.d_toolPrefs = new ToolPrefsPnl();
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(fileFormatLabel);
            gb.addIdentRow(this.d_easyReadFormatBox, 0);
            gb.indent();
            gb.addIdentRow(precisionLbl, this.d_easyReadPrecision);
            gb.unindent();
            gb.addFilledRow(autosaveLabel);
            gb.addIdentRow(new guiLabel(Intl.intl("Number of Recent Files:")), this.d_numMRUFiles);
            gb.addIdentRow(guiUtil.lbl(Intl.intl("Undo/Redo History:"), "<html>" + Intl.intl("Sets the maximum number of actions to remember for <b>Undo</b> and <b>Redo</b>.")), this.d_maxUndoHistory);
            gb.addIdentRow(this.d_autosave, this.d_autosaveInterval);
            gb.addIdentRow(this.d_createBackupOnOpen, 0);
            gb.addIdentRow(this.d_recordPreview, 0);
            gb.addIdentRow(this.d_showSplash, 0);
            gb.addIdentRow(this.d_crashCatcherNag, 0);
            gb.addIdentRow(editHotkeyLbl, editHotkeys);
            gb.addFilledRow(this.d_toolPrefs);
            gb.finalizeRows();
        }

        @Override
        public void loadData() {
            PyroSim pySim = PyroSim.getApp();
            FDSRenderProps props = pySim.getFDSRenderProps();
            FDSRenderProps.IDecimalFormatter formatter = props.getDecimalFormatter();
            this.d_easyReadFormatBox.setSelected(formatter instanceof FDSRenderProps.GeneralFormatter);
            if (formatter instanceof FDSRenderProps.GeneralFormatter) {
                this.d_easyReadPrecision.setValue(((FDSRenderProps.GeneralFormatter)formatter).precision);
            } else {
                this.d_easyReadPrecision.setValue(PyroPrefs.getInt(PyroPrefs.FDSFormatGenPrecision));
            }
            this.d_numMRUFiles.setValue(pySim.getMRUMenu().getNumMenuItems());
            this.d_maxUndoHistory.setValue(PyroPrefs.get(PyroPrefs.UNDO_STACK_SIZE));
            this.d_autosave.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_USEAUTOSAVE));
            this.d_autosaveInterval.setValue(PyroPrefs.getUnitDouble(PyroPrefs.PREF_AUTOSAVE_INTERVAL));
            this.d_createBackupOnOpen.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_CREATE_BACKUP_ON_OPEN));
            this.d_recordPreview.setSelected(PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW));
            this.d_showSplash.setSelected(pySim.getPrefs().getBoolean(Application.PROP_SHOWSPLASH));
            this.d_crashCatcherNag.setSelected(Application.getApp().getPrefs().getBoolean(CrashCatcher.PROP_INFO_NAG));
            this.d_toolPrefs.load(PyroPrefs.instance());
        }

        @Override
        public void saveData(Consumer<Pair<String, Task>> tasks) {
            PyroSim pySim = PyroSim.getApp();
            TeciProps tempPrefs = new TeciProps();
            FDSRenderProps props = pySim.getFDSRenderProps();
            FDSRenderProps.IDecimalFormatter formatter = this.d_easyReadFormatBox.isSelected() ? new FDSRenderProps.GeneralFormatter((Integer)this.d_easyReadPrecision.getValue()) : new FDSRenderProps.ScientificFormatter();
            props.setDecimalFormatter(formatter);
            pySim.getMRUMenu().setNumMenuItems((Integer)this.d_numMRUFiles.getValue());
            PreferencesDialog.setPref(PyroPrefs.UNDO_STACK_SIZE, (Integer)this.d_maxUndoHistory.getValue());
            PreferencesDialog.setPref(PyroPrefs.PREF_USEAUTOSAVE, this.d_autosave.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_AUTOSAVE_INTERVAL, (UnitDouble)this.d_autosaveInterval.getValue());
            PreferencesDialog.setPref(PyroPrefs.PREF_CREATE_BACKUP_ON_OPEN, this.d_createBackupOnOpen.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_RECORD_PREVIEW, this.d_recordPreview.isSelected());
            PreferencesDialog.setPref(Application.PROP_SHOWSPLASH, this.d_showSplash.isSelected());
            PreferencesDialog.setPref(CrashCatcher.PROP_INFO_NAG, this.d_crashCatcherNag.isSelected());
            this.d_toolPrefs.save(tempPrefs);
            PyroSim.setPrefs(tempPrefs, false);
        }
    }

    private static class RecordViewPanel
    extends PrefsPanel {
        private static final long serialVersionUID = -6926992930099772676L;
        private guiComboBox d_fontSizeCombo;
        private guiCheckBox d_enableSyntaxHi;
        private ValueField<Integer> d_obstSyntaxLimit;

        public RecordViewPanel() {
            super(new GridBagLayout());
            GridBagHelper gbh = new GridBagHelper(this);
            guiLabel fontSizeLabel = new guiLabel(Intl.intl("Font Size:"));
            guiLabel obstSyntaxLimitLabel = new guiLabel(Intl.intl("Set Limit for Highlighting HOLE and OBST records:"));
            String[] sizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "20", "22", "24", "26", "28", "36"};
            this.d_fontSizeCombo = new guiComboBox(Arrays.asList(sizes)){
                private static final long serialVersionUID = -3857544167298911010L;

                @Override
                public boolean validateData(boolean showWarn, boolean allowModify) {
                    super.validateData(showWarn, allowModify);
                    try {
                        float f = Float.parseFloat(String.valueOf(this.getSelectedItem()));
                        if ((double)f < 1.0) {
                            throw new Exception("Invalid font size.");
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (showWarn) {
                            String msg = String.format(Intl.intl("Invalid font size."), new Object[0]);
                            this.showMessageBox(msg);
                            this.requestFocusHack();
                        }
                        return false;
                    }
                    return true;
                }
            };
            this.d_fontSizeCombo.setEditable(true);
            gbh.addRow(fontSizeLabel, 2, this.d_fontSizeCombo);
            this.d_enableSyntaxHi = new guiCheckBox(Intl.intl("Enable Syntax Highlighting"));
            gbh.addRow(this.d_enableSyntaxHi, 3);
            this.d_obstSyntaxLimit = ValueFields.intFld(4000);
            gbh.addRow(obstSyntaxLimitLabel, 2, this.d_obstSyntaxLimit);
            gbh.finalizeRows();
        }

        @Override
        public void loadData() {
            float fontSize = PyroPrefs.getFloat(PyroPrefs.RECORD_VIEW_FONTSIZE);
            this.d_fontSizeCombo.setSelectedItem(Float.valueOf(fontSize));
            boolean enableSyntaxHiFlag = PyroPrefs.getBoolean(PyroPrefs.SYNTAX_HIGHLIGHT_ENABLE);
            this.d_enableSyntaxHi.setSelected(enableSyntaxHiFlag);
            int obstLimit = PyroPrefs.getInt(PyroPrefs.SYNTAX_HIGHLIGHT_OBSTHOLELIMIT);
            this.d_obstSyntaxLimit.setValue(obstLimit);
        }

        @Override
        public void saveData(Consumer<Pair<String, Task>> tasks) {
            PreferencesDialog.setPref(PyroPrefs.RECORD_VIEW_FONTSIZE, Float.valueOf(Float.parseFloat(String.valueOf(this.d_fontSizeCombo.getSelectedItem()))));
            PreferencesDialog.setPref(PyroPrefs.SYNTAX_HIGHLIGHT_ENABLE, this.d_enableSyntaxHi.isSelected());
            PreferencesDialog.setPref(PyroPrefs.SYNTAX_HIGHLIGHT_OBSTHOLELIMIT, (Integer)this.d_obstSyntaxLimit.getValue());
        }
    }

    private static class FDSPanel
    extends PrefsPanel {
        private static final String GRID_OPTIMIZE_PREF_NONE = Intl.intl("None");
        private static final String GRID_OPTIMIZE_PREF_BASIC = Intl.intl("Basic");
        private static final long serialVersionUID = 2220889344058346621L;
        private final guiComboBox<FDSVersion> d_fdsCompCB;
        private final ExeFileChooserPanel d_svExe;
        private final ExeFileChooserPanel d_fdsExe;
        private final guiCheckBox d_autosaveFileOnRun;
        private final guiCheckBox d_runSV;
        private final guiComboBox<String> d_optimizeProcessorsCB;
        private final guiRadioButton d_procPerMeshRB;
        private final guiRadioButton d_procPerLogicalRB;
        private final guiCheckBox d_validateGEOM;
        private final guiCheckBox d_enableFDSGEOM;
        private final PyroMod d_pyroMod;

        public FDSPanel(PyroMod pyroMod) {
            super(new GridBagLayout());
            this.d_pyroMod = pyroMod;
            guiLabel fdsCompLbl = new guiLabel("FDS Compability:");
            this.d_fdsCompCB = new guiComboBox<FDSVersion>(FDSVersion.getSupported());
            boolean x64 = PyroSim.is64Bit();
            TitleSeparator fdsExecutablesLbl = new TitleSeparator(Intl.intl("Executable Locations") + (x64 ? " (x64)" : ""));
            TitleSeparator fdsExecutionLbl = new TitleSeparator(Intl.intl("Execution"));
            TitleSeparator fdsGeomLbl = new TitleSeparator(Intl.intl("FDS GEOM"));
            guiLabel parallelSettingsLbl = new guiLabel(Intl.intl("Parallel Execution Settings"));
            this.d_autosaveFileOnRun = new guiCheckBox(Intl.intl("Auto-Save PyroSim Model Before Running FDS"), false);
            this.d_runSV = new guiCheckBox(Intl.intl("Run Results When FDS Simulation Completes"), true);
            guiLabel optimizeLabel = new guiLabel(Intl.intl("Optimize Processor Utilization:"));
            this.d_optimizeProcessorsCB = new guiComboBox<String>((T[])new String[]{GRID_OPTIMIZE_PREF_NONE, GRID_OPTIMIZE_PREF_BASIC});
            guiLabel compatibilityLbl = new guiLabel(String.format(Intl.intl("NOTE: PyroSim is designed to work with FDS %s and later."), Version.FDS_DESIGN));
            compatibilityLbl.setFont(compatibilityLbl.getFont().deriveFont(1));
            GridBagHelper gb = new GridBagHelper(this);
            gb.addFilledRow(fdsExecutablesLbl);
            this.d_svExe = new ExeFileChooserPanel(this, "sv.location", Intl.intl("Smokeview:"));
            this.d_fdsExe = new ExeFileChooserPanel(this, "location", Intl.intl("FDS:"), true);
            this.d_fdsExe.addToPanel(gb);
            this.d_svExe.addToPanel(gb);
            this.d_procPerLogicalRB = new guiRadioButton(Intl.intl("Limit Processes Based on Logical Processor Count"));
            this.d_procPerMeshRB = new guiRadioButton(Intl.intl("Create Process for Each Mesh"));
            this.d_enableFDSGEOM = new guiCheckBox(Intl.intl("Enable FDS GEOM"));
            this.d_enableFDSGEOM.setToolTipText(Intl.intl("Enables the ability to write obstructions using GEOM records."));
            this.d_validateGEOM = new guiCheckBox(Intl.intl("Validate GEOM obstructions"));
            this.d_validateGEOM.setToolTipText(Intl.intl("Controls whether obstructions marked with the \"Write as GEOM\" flag should be validated to ensure they are solids."));
            guiUtil.link((AbstractButton)this.d_enableFDSGEOM, this.d_validateGEOM);
            guiUtil.group(new AbstractButton[]{this.d_procPerLogicalRB, this.d_procPerMeshRB});
            gb.addIdentRow(compatibilityLbl, GridBagHelper.REMAINING);
            gb.addFilledRow(fdsExecutionLbl);
            gb.addIdentRow(optimizeLabel, this.d_optimizeProcessorsCB);
            gb.addIdentRow(this.d_autosaveFileOnRun, 0);
            if (this.d_fdsCompCB.getModel().getSize() > 1) {
                gb.addIdentRow(fdsCompLbl, this.d_fdsCompCB);
            }
            gb.addIdentRow(this.d_runSV, 0);
            gb.addIdentRow(parallelSettingsLbl);
            gb.indent();
            gb.addIdentRow(this.d_procPerMeshRB, 2);
            gb.addIdentRow(this.d_procPerLogicalRB, 2);
            gb.unindent();
            gb.addFilledRow(fdsGeomLbl);
            gb.addIdentRow(this.d_enableFDSGEOM, 0);
            gb.addIdentRow(this.d_validateGEOM, 0);
            gb.finalizeRows();
        }

        @Override
        public void loadData() {
            PyroSim pySim = PyroSim.getApp();
            this.d_fdsCompCB.setSelectedItem(pySim.getFDSCompability());
            this.d_fdsExe.load(pySim);
            this.d_svExe.load(pySim);
            this.d_autosaveFileOnRun.setSelected(PyroPrefs.getBoolean(PyroPrefs.AUTOSAVE_ON_RUN_FDS));
            boolean runSV = PyroPrefs.getBoolean(PyroPrefs.PREF_RUNSV);
            this.d_runSV.setSelected(runSV);
            GridProcessUtil.PREF mpiOptimize = GridProcessUtil.getPrefForString(PyroPrefs.getString(PyroPrefs.PREF_OPTIMIZE_FDS_PROCS));
            if (mpiOptimize.equals((Object)GridProcessUtil.PREF.NONE)) {
                this.d_optimizeProcessorsCB.setSelectedItem(GRID_OPTIMIZE_PREF_NONE);
            } else if (mpiOptimize.equals((Object)GridProcessUtil.PREF.BASIC)) {
                this.d_optimizeProcessorsCB.setSelectedItem(GRID_OPTIMIZE_PREF_BASIC);
            }
            GridProcessUtil.PROC_COUNT processes = GridProcessUtil.getProcCountForString(PyroPrefs.getString(PyroPrefs.PREF_MPI_PROC_COUNT));
            if (processes.equals((Object)GridProcessUtil.PROC_COUNT.PER_CORE)) {
                this.d_procPerLogicalRB.setSelected(true);
            } else if (processes.equals((Object)GridProcessUtil.PROC_COUNT.PER_MESH)) {
                this.d_procPerMeshRB.setSelected(true);
            }
            this.d_enableFDSGEOM.setSelected(PyroSim.isFDSGeomEnabled());
            this.d_validateGEOM.setSelected(PyroPrefs.getBoolean(PyroPrefs.VALIDATE_GEOM));
        }

        @Override
        public void saveData(Consumer<Pair<String, Task>> tasks) {
            PyroSim pySim = PyroSim.getApp();
            pySim.setFDSCompability(this.d_fdsCompCB.getSelectedItem());
            this.d_fdsExe.save(pySim);
            this.d_svExe.save(pySim);
            PreferencesDialog.setPref(PyroPrefs.PREF_OPTIMIZE_FDS_PROCS, this.d_optimizeProcessorsCB.getSelectedItem());
            pySim.getFDSRenderProps().setGridProcessSetting(GridProcessUtil.getPrefForString(this.d_optimizeProcessorsCB.getSelectedItem()));
            PreferencesDialog.setPref(PyroPrefs.AUTOSAVE_ON_RUN_FDS, this.d_autosaveFileOnRun.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_RUNSV, this.d_runSV.isSelected());
            if (this.d_procPerMeshRB.isSelected()) {
                PreferencesDialog.setPref(PyroPrefs.PREF_MPI_PROC_COUNT, GridProcessUtil.PROC_COUNT.PER_MESH.getPropName());
                pySim.getFDSRenderProps().setMPIProcessRule(GridProcessUtil.PROC_COUNT.PER_MESH);
            } else if (this.d_procPerLogicalRB.isSelected()) {
                PreferencesDialog.setPref(PyroPrefs.PREF_MPI_PROC_COUNT, GridProcessUtil.PROC_COUNT.PER_CORE.getPropName());
                pySim.getFDSRenderProps().setMPIProcessRule(GridProcessUtil.PROC_COUNT.PER_CORE);
            }
            if (PreferencesDialog.setPref(PyroPrefs.PROP_ENABLE_FDS_GEOM, this.d_enableFDSGEOM.isSelected()) && this.d_enableFDSGEOM.isSelected() && !this.d_pyroMod.getRastOptions().isFdsGeomEnabled()) {
                tasks.accept(new Pair<String, ReplaceRefTask<Boolean>>(Intl.intl("Change Simulation Parameters"), new ReplaceRefTask<Boolean>(this.d_pyroMod.getRastOptions().isFdsGeomEnabled(), this.d_enableFDSGEOM.isSelected(), v -> this.d_pyroMod.setRastProps(this.d_pyroMod.getRastOptions().setFdsGeomEnabled((boolean)v)))));
            }
            if (PyroSim.isFDSGeomEnabled()) {
                PreferencesDialog.setPref(PyroPrefs.VALIDATE_GEOM, this.d_validateGEOM.isSelected());
            }
        }
    }

    private static class ResultsPanel
    extends PrefsPanel {
        private static final long serialVersionUID = 3807312583474227091L;
        private final guiCheckBox d_showInCad;
        private final guiCheckBox d_showMesh;
        private final guiCheckBox d_writePyroGeom;
        private final guiCheckBox d_writeGE1;
        private final guiCheckBox d_writeIni;
        private final guiCheckBox d_writeViews;

        public ResultsPanel() {
            super(new GridBagLayout());
            TitleSeparator initTitle = new TitleSeparator(Intl.intl("Initialization"));
            this.d_showInCad = new guiCheckBox(Intl.intl("Show GE1 file by default"));
            this.d_showInCad.setToolTipText(Intl.intl("Shows the GE1 file immediately when Smokeview is launched"));
            this.d_showMesh = new guiCheckBox(Intl.intl("Include mesh boundaries in CAD files"));
            this.d_showMesh.setToolTipText(Intl.intl("Whether to include the mesh boundaries in exported CAD files (GE1, PyroGeom)"));
            this.d_writePyroGeom = new guiCheckBox(Intl.intl("Output PyroGeom file"));
            this.d_writePyroGeom.setToolTipText("<html>" + Intl.intl("Outputs a CAD data file for the PyroSim 3D Results"));
            this.d_writeGE1 = new guiCheckBox(Intl.intl("Output GE1 file"));
            this.d_writeGE1.setToolTipText("<html>" + Intl.intl("Outputs a CAD data file for Smokeview (also viewable in the PyroSim 3D Results)."));
            this.d_writeIni = new guiCheckBox(Intl.intl("Output INI file"));
            this.d_writeIni.setToolTipText("<html>" + Intl.intl("Writes the Smokeview INI file (NOTE: view information is only<br>included if the Views file is turned off)."));
            this.d_writeViews = new guiCheckBox(Intl.intl("Output Views file"));
            this.d_writeViews.setToolTipText(Intl.intl("Writes the Views file for PyroSim 3D Results, containing view information."));
            guiUtil.link((AbstractButton)this.d_writeGE1, this.d_showInCad);
            GridBagHelper gbh = new GridBagHelper(this);
            gbh.addFilledRow(initTitle);
            gbh.addIdentRow(this.d_showMesh);
            gbh.addFilledRow(new TitleSeparator(Intl.intl("PyroSim 3D Results Files")));
            gbh.indent();
            gbh.addRow(this.d_writeViews);
            gbh.addRow(this.d_writePyroGeom);
            gbh.unindent();
            gbh.addFilledRow(new TitleSeparator(Intl.intl("Smokeview Files")));
            gbh.indent();
            gbh.addRow(this.d_writeIni);
            gbh.addRow(this.d_writeGE1);
            gbh.addIdentRow(this.d_showInCad);
            gbh.unindent();
            gbh.finalizeRows();
        }

        @Override
        public void loadData() {
            this.d_showInCad.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_DISPLAYGE1));
            this.d_showMesh.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_MESHBOUNDS));
            this.d_writePyroGeom.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEPYROGEOM));
            this.d_writeGE1.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEGE1));
            this.d_writeIni.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITESMVINI));
            this.d_writeViews.setSelected(PyroPrefs.getBoolean(PyroPrefs.RESULTS_WRITEVIEWS));
        }

        @Override
        public void saveData(Consumer<Pair<String, Task>> tasks) {
            PreferencesDialog.setPref(PyroPrefs.RESULTS_DISPLAYGE1, this.d_showInCad.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_MESHBOUNDS, this.d_showMesh.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEPYROGEOM, this.d_writePyroGeom.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEGE1, this.d_writeGE1.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITESMVINI, this.d_writeIni.isSelected());
            PreferencesDialog.setPref(PyroPrefs.RESULTS_WRITEVIEWS, this.d_writeViews.isSelected());
        }
    }

    private static class DisplayPanel
    extends PrefsPanel {
        private static final long serialVersionUID = -1830210112889756964L;
        private final guiCheckBox d_useFastColorRedraws = new guiCheckBox(Intl.intl("Hardware accelerated cursor"), false);
        private final guiCheckBox d_useFastDepthRedraws;
        private final RenderPrefs.PrefsUI d_rprefs;

        public DisplayPanel(Supplier<IPropertySet> getRenderDef, Supplier<IPropertySet> getRenderPref, Supplier<IPropertySet> getRenderComp, Supplier<IRenderSurface.OpenGLInfo> getRenderInfo) {
            super(new GridBagLayout());
            this.d_useFastColorRedraws.setToolTipText(Intl.intl("Accelerates drawing and editing objects in complex models."));
            this.d_useFastDepthRedraws = new guiCheckBox(Intl.intl("Hardware accelerated 3D editing (only available on some hardware)"), false);
            this.d_rprefs = new RenderPrefs.PrefsUI("PyroSim");
            LinkStatus.link((AbstractButton)this.d_useFastColorRedraws, this.d_useFastDepthRedraws);
            this.d_useFastColorRedraws.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    if (!d_useFastColorRedraws.isSelected()) {
                        d_useFastDepthRedraws.setSelected(false);
                    }
                }
            });
            Consumer<IPropertySet> loadPrefs = prefs -> this.loadData((IPropertySet)prefs, true, false);
            GridBagHelper gb = new GridBagHelper(this);
            gb.addTitle(Intl.intl("GPU Information"));
            gb.addIdentRow(new GPUInfoPnl(getRenderInfo, true), 1.0, 0);
            gb.addSeparator();
            gb.addRow(new Object[]{RenderPrefs.getRenderPrefsBtns(getRenderDef, getRenderPref, getRenderComp, loadPrefs), 1.0, 0, GridBagHelper.Anchor.CENTER});
            gb.indent();
            gb.addRow(this.d_useFastColorRedraws, 0);
            this.d_rprefs.addTo(gb);
            gb.finalizeRows();
        }

        @Override
        public void loadData() {
            this.loadData(PyroPrefs.instance(), false, true);
        }

        private void loadData(IPropertySet props, boolean onlyIfDefined, boolean clearRestart) {
            guiUtil.loadPref(props, onlyIfDefined, this.d_useFastColorRedraws, PyroPrefs.PREF_DRAWCOLORBUFFER);
            guiUtil.loadPref(props, onlyIfDefined, this.d_useFastDepthRedraws, PyroPrefs.PREF_DRAWDEPTHBUFFER);
            this.d_rprefs.loadData(props, onlyIfDefined, clearRestart);
        }

        @Override
        public void saveData(Consumer<Pair<String, Task>> tasks) {
            PreferencesDialog.setPref(PyroPrefs.PREF_DRAWCOLORBUFFER, this.d_useFastColorRedraws.isSelected());
            PreferencesDialog.setPref(PyroPrefs.PREF_DRAWDEPTHBUFFER, this.d_useFastDepthRedraws.isSelected());
            TeciProps tprops = new TeciProps();
            this.d_rprefs.saveData(tprops);
            PyroSim.setPrefs(tprops, false);
        }

        @Override
        public boolean validateData(boolean showWarn, boolean allowModify) {
            if (!super.validateData(showWarn, allowModify)) {
                return false;
            }
            return this.d_rprefs.validateData(showWarn, allowModify);
        }
    }

    private static abstract class PrefsPanel
    extends guiPanel {
        private static final long serialVersionUID = 1906931603730818333L;

        public PrefsPanel(LayoutManager lmgr) {
            super(lmgr);
        }

        public abstract void loadData();

        public abstract void saveData(Consumer<Pair<String, Task>> var1);
    }

    private static class ExeFileChooserPanel {
        private static final Icon OPEN_ICON = PyroGuiUtil.loadTeciIcon("Open16.gif");
        private final String d_preferenceKey;
        private final guiLabel d_label;
        private final guiTextField d_locationTF;
        private final JButton d_locationBtn;
        private final guiLabel d_versionLbl;
        private final boolean d_detectVersionComp;

        public ExeFileChooserPanel(guiPanel parent, String locKey, String desc) {
            this(parent, locKey, desc, false);
        }

        public ExeFileChooserPanel(final guiPanel parent, String locKey, String desc, boolean detectFDSComp) {
            this.d_preferenceKey = locKey;
            this.d_detectVersionComp = detectFDSComp;
            this.d_label = new guiLabel(desc);
            this.d_locationTF = new guiTextField();
            this.d_locationTF.setEditable(false);
            this.d_locationTF.setColumns(35);
            this.d_locationBtn = new JButton(OPEN_ICON);
            this.d_locationBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    this.getFile(parent);
                    if (d_detectVersionComp) {
                        this.detectFDSVersion(d_locationTF.getText());
                    }
                }
            });
            if (this.d_detectVersionComp) {
                this.d_versionLbl = new guiLabel(Version.FDS_DESIGN.toString());
                Dimension prototype = this.d_versionLbl.getPreferredSize();
                this.d_versionLbl.setPreferredSize(new Dimension(prototype.width * 11 / 10, prototype.height));
                this.d_versionLbl.setToolTipText(this.d_versionLbl.getText());
                this.d_versionLbl.setText("");
            } else {
                this.d_versionLbl = null;
            }
        }

        private void detectFDSVersion(String fdsExeLoc) {
            new Thread(() -> {
                try {
                    FDSVersion version = FDSVersion.detectCompability(new File(fdsExeLoc));
                    ExeFileChooserPanel.updateLabel(this.d_versionLbl, version.toString(), this.d_versionLbl.getText());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    ExeFileChooserPanel.updateLabel(this.d_versionLbl, Intl.intl("Version: ?"), t.getClass().getSimpleName() + ": " + t.getLocalizedMessage());
                }
            }).start();
        }

        private static void updateLabel(guiLabel label, String text, String tooltip) {
            EventQueue.invokeLater(() -> {
                label.setText(text);
                label.setToolTipText(tooltip);
            });
        }

        public void addToPanel(GridBagHelper gb) {
            gb.addIdentRow(this.d_label, this.d_locationTF, 1.0, this.d_locationBtn, this.d_versionLbl);
        }

        public void load(PyroSim app) {
            String loc = PyroPrefs.getFDSLoc(this.d_preferenceKey, true);
            if (loc == null) {
                loc = "";
            }
            this.d_locationTF.setText(loc);
            if (this.d_detectVersionComp) {
                this.detectFDSVersion(loc);
            }
        }

        public void save(PyroSim app) {
            String loc = this.d_locationTF.getText();
            PyroPrefs.setFDSLoc(this.d_preferenceKey, loc);
            PyroSim.getApp().getMediator().changedEvt(PyroMod.EVT_PREFS_CHANGED);
        }

        public void getFile(guiPanel parent) {
            guiJFXFileChooser chooser = new guiJFXFileChooser(this.d_locationTF.getText(), this.d_locationTF.getText(), null, (Boolean)false, (Boolean)false, (Boolean)false, FileFilters.EXT_FILTER_EXE);
            File f = chooser.showOpenDialog();
            if (f == null) {
                return;
            }
            this.d_locationTF.setText(f.getAbsolutePath());
        }
    }
}

