/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Window;
import java.util.function.Predicate;
import javax.swing.JFrame;
import org.jscience.physics.units.NonSI;
import pyrosim.Intl;
import pyrosim.domain.geom.ImportType;
import pyrosim.gui.actions.GenerateModelFromBIMAction;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;

public class GenerateModelFromBIMDlg
extends guiDialog {
    private static final long serialVersionUID = 1L;
    private final guiCheckBox d_keepOriginal = new guiCheckBox(Intl.intl("Keep Original Objects"));
    private final guiCheckBox d_includeSlabs;
    private final guiCheckBox d_includeWalls;
    private final guiCheckBox d_includeDoors;
    private final guiCheckBox d_includeWindows;
    private final guiCheckBox d_includeRemoves;
    private ValueField<UnitDouble> d_thickenDoors;
    private ValueField<UnitDouble> d_thickenWindows;

    public GenerateModelFromBIMDlg(JFrame owner, GenerateModelFromBIMAction.GenFromBIMOpts opts) {
        super((Window)owner, Intl.intl("Generate Settings"), 9);
        this.d_keepOriginal.setSelected(opts.getKeepOriginal());
        this.d_thickenDoors = ValueFields.udFld(opts.getThickenDoors(), (Predicate<UnitDouble>)UnitDoubleVR.ge(0.0, NonSI.PERCENT));
        this.d_thickenWindows = ValueFields.udFld(opts.getThickenWindows(), (Predicate<UnitDouble>)UnitDoubleVR.ge(0.0, NonSI.PERCENT));
        this.d_includeSlabs = new guiCheckBox(Intl.intl("Generate Slabs"));
        this.d_includeSlabs.setSelected(opts.isComponentEnabled(ImportType.SLAB));
        this.d_includeWalls = new guiCheckBox(Intl.intl("Generate Walls"));
        this.d_includeWalls.setSelected(opts.isComponentEnabled(ImportType.WALL));
        this.d_includeDoors = new guiCheckBox(Intl.intl("Generate Doors"));
        this.d_includeDoors.setSelected(opts.isComponentEnabled(ImportType.DOOR));
        this.d_includeWindows = new guiCheckBox(Intl.intl("Generate Windows"));
        this.d_includeWindows.setSelected(opts.isComponentEnabled(ImportType.WINDOW));
        this.d_includeRemoves = new guiCheckBox(Intl.intl("Remove Space Annotations"));
        this.d_includeRemoves.setSelected(opts.isComponentEnabled(ImportType.REMOVE));
        MultiLineLabel warningLabel = new MultiLineLabel(Intl.intl("Warning: Geometry conversion from BIM is approximate! Make sure to review the resulting geometry."));
        guiPanel p = this.getDialogPane();
        GridBagHelper gb = new GridBagHelper(p);
        gb.addTitle(Intl.intl("Options"));
        gb.indent();
        gb.addRow(this.d_keepOriginal);
        guiLabel thickenDoorsLabel = guiUtil.lbl(Intl.intl("Thicken door hole:"), Intl.intl("Expand the hole generated from doors by this percentage in each direction.\nThis can help ensure it fully pierces the walls."));
        gb.addRow(thickenDoorsLabel, this.d_thickenDoors);
        guiLabel thickenWindowsLabel = guiUtil.lbl(Intl.intl("Thicken window hole:"), Intl.intl("Expand the hole generated from windows by this percentage in each direction.\nThis can help ensure it fully pierces the walls."));
        gb.addRow(thickenWindowsLabel, this.d_thickenWindows);
        gb.unindent();
        gb.addTitle(Intl.intl("Components"));
        gb.indent();
        gb.addRow(this.d_includeSlabs);
        gb.addRow(this.d_includeWalls);
        gb.addRow(this.d_includeDoors);
        gb.addRow(this.d_includeWindows);
        gb.addRow(this.d_includeRemoves);
        gb.unindent();
        gb.addFilledRow(warningLabel);
        gb.finalizeRows();
    }

    public void applyOpts(GenerateModelFromBIMAction.GenFromBIMOpts opts) {
        opts.setKeepOriginal(this.d_keepOriginal.isSelected());
        opts.setThickenDoors((UnitDouble)this.d_thickenDoors.getValue());
        opts.setThickenWindows((UnitDouble)this.d_thickenWindows.getValue());
        opts.setComponentEnabled(ImportType.SLAB, this.d_includeSlabs.isSelected());
        opts.setComponentEnabled(ImportType.WALL, this.d_includeWalls.isSelected());
        opts.setComponentEnabled(ImportType.DOOR, this.d_includeDoors.isSelected());
        opts.setComponentEnabled(ImportType.WINDOW, this.d_includeWindows.isSelected());
        opts.setComponentEnabled(ImportType.REMOVE, this.d_includeRemoves.isSelected());
    }
}

