/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.ListModel;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.reaction.Reaction;
import pyrosim.gui.actions.Actions;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSParseResult;
import pyrosim.io.fds.FDSParser;
import pyrosim.util.ANameSorter;
import pyrosim.util.Util;
import thunderheadeng.gui.ALibraryDlg;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiJFXFileChooser;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.FileFilters;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class FDSLibraryDlg
extends ALibraryDlg<IPyroObject> {
    private static final long serialVersionUID = 6394989489998116704L;
    private static final Map<Class<? extends IPyroObject>, IMgrRetriever<? extends IPyroObject>> s_retrievers = new HashMap<Class<? extends IPyroObject>, IMgrRetriever<? extends IPyroObject>>();
    private final PyroMod d_mediator = PyroSim.getApp().getMediator();
    private final guiComboBox<IMgrRetriever<? extends IPyroObject>> d_libCB;
    private String d_currentLib = "";
    private PyroMod d_libModel = null;

    private static <T extends IPyroObject> void registerRetriever(IMgrRetriever<T> retriever) {
        s_retrievers.put(retriever.getType(), retriever);
    }

    public FDSLibraryDlg(JFrame owner, Class<? extends IPyroObject> defLibType) {
        super(owner, Intl.intl("PyroSim Libraries"));
        WindowListener[] listeners = this.getWindowListeners();
        for (int m = 0; m < listeners.length; ++m) {
            this.removeWindowListener(listeners[m]);
        }
        this.addWindowListener(new CloseListener());
        this.d_libCB = new guiComboBox();
        this.d_libCB.setRenderer(new RetrieverRenderer());
        this.d_libCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FDSLibraryDlg.this.updateLibSelection();
            }
        });
        guiPanel mainPanel = this.getDialogPane();
        GridBagUtil.add(mainPanel, new guiLabel(Intl.intl("Category:")), 0, 0, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, this.d_libCB, 1, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(mainPanel, new JSeparator(0), 0, 1, 10, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        this.init();
        Collection<IMgrRetriever<? extends IPyroObject>> retrievers = theUtil.sort(new ANameSorter<IMgrRetriever<? extends IPyroObject>>(this){

            @Override
            protected String getName(IMgrRetriever<? extends IPyroObject> o) {
                return o.getDescription();
            }
        }, s_retrievers.values());
        this.d_libCB.setItems(retrievers);
        if (defLibType != null) {
            this.d_libCB.setSelectedItem(s_retrievers.get(defLibType));
        } else {
            this.d_libCB.setSelectedIndex(0);
        }
        this.updateLibSelection();
    }

    private void updateLibSelection() {
        this.loadList(this.d_mediator, this.d_modelObjs);
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    private Composite getManager(PyroMod model) {
        return this.d_libCB.getSelectedItem().getManager(model);
    }

    private Predicate<? extends IPyroObject> getFilter() {
        return this.d_libCB.getSelectedItem().getFilter();
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            if (!this.checkSaveNewLib()) {
                return;
            }
            PyroPrefs.set(PyroPrefs.PREF_LASTLIBRARY, this.d_currentLib, true);
        }
        super.setVisible(visible);
    }

    private boolean init() {
        String prefLib = PyroPrefs.getString(PyroPrefs.PREF_LASTLIBRARY);
        ArrayList<String> libsToTry = new ArrayList<String>();
        libsToTry.add(prefLib);
        if (!prefLib.equals(PyroPrefs.PREF_LASTLIBRARY.defVal)) {
            libsToTry.add((String)PyroPrefs.PREF_LASTLIBRARY.defVal);
        }
        for (String lib : libsToTry) {
            if (!this.loadLibraryModelFromFile(lib, false)) continue;
            this.setCurrentLibrary(lib);
            return true;
        }
        this.createLibrary();
        this.d_libUnsaved = false;
        return true;
    }

    private void setCurrentLibrary(String lib) {
        this.d_currentLib = lib;
        File f = new File(this.d_currentLib);
        PyroSim.getApp().setLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString(), f);
        String libLabel = String.format(Intl.intl("Library: ...%s"), f.getName());
        String fullLabel = String.format(Intl.intl("Library: %s"), f.getAbsolutePath());
        this.d_libLbl.setText(libLabel);
        this.d_libLbl.setToolTipText(fullLabel);
    }

    @Override
    public void createLibrary() {
        if (!this.checkSaveNewLib()) {
            return;
        }
        this.d_libModel = new PyroMod();
        this.d_libUnsaved = true;
        this.setCurrentLibrary("untitled.fds");
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    @Override
    protected void loadLibraryUI() {
        this.loadList(this.d_libModel, this.d_libObjs);
    }

    @Override
    protected boolean loadLibraryModel() {
        if (!this.checkSaveNewLib()) {
            return false;
        }
        guiJFXFileChooser chooser = new guiJFXFileChooser(this.d_currentLib != null ? this.d_currentLib : null, this.d_currentLib != null ? this.d_currentLib : PyroPrefs.get(PyroPrefs.LastFDSDatabaseDirProp), null, (Boolean)false, (Boolean)false, (Boolean)true, FileFilters.EXT_FILTER_FDS6_DATABASE);
        File f = chooser.showOpenDialog();
        if (f == null) {
            return false;
        }
        PyroPrefs.set(PyroPrefs.LastFDSDatabaseDirProp, f.getParent());
        if (!this.loadLibraryModelFromFile(f.getAbsolutePath(), true)) {
            JOptionPane.showMessageDialog(this, String.format(Intl.intl("The file \"%s\" could not be read."), f.getAbsolutePath()));
            return false;
        }
        this.setCurrentLibrary(f.getAbsolutePath());
        return true;
    }

    public boolean loadLibraryModelFromFile(String filename, boolean showWarnings) {
        PyroSim.getApp().setLastDir(PyroPrefs.LastFDSDatabaseDirProp.key.toString(), new File(filename));
        try {
            this.d_libModel = new PyroMod();
            FDSParser parser = FDS.newParser(6);
            FDSParseResult result = parser.parseFile(filename, this.d_libModel);
            if (showWarnings) {
                result.warningReport.showWarnings(this, false);
            }
            this.d_libUnsaved = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public boolean saveLibrary() {
        ArrayList<? extends IPyroObject> toExport = new ArrayList<IPyroObject>();
        for (IMgrRetriever<? extends IPyroObject> retriever : s_retrievers.values()) {
            toExport.addAll(FDSLibraryDlg.getObjects(this.d_libModel, retriever));
        }
        File newLibFile = Actions.exportToFile(this, new File(this.d_currentLib), this.d_libModel, toExport, PyroPrefs.LastFDSDatabaseDirProp.key.toString());
        if (newLibFile == null) {
            return false;
        }
        this.setCurrentLibrary(newLibFile.getAbsolutePath());
        this.d_libUnsaved = false;
        return true;
    }

    @Override
    protected void loadFromLibrary() {
        Application.getApp().beginWaitCursor();
        this.copyListSelection(this.d_libObjs, this.d_modelObjs, this.d_libModel, this.d_mediator);
        Application.getApp().endWaitCursor();
    }

    @Override
    protected void saveToLibrary() {
        Application.getApp().beginWaitCursor();
        boolean changed = this.copyListSelection(this.d_modelObjs, this.d_libObjs, this.d_mediator, this.d_libModel);
        if (changed) {
            this.d_libUnsaved = true;
        }
        Application.getApp().endWaitCursor();
    }

    @Override
    protected void deleteModObjs() {
        this.deleteObjs(this.d_modelObjs, this.d_mediator);
    }

    @Override
    protected void deleteLibObjs() {
        if (this.deleteObjs(this.d_libObjs, this.d_libModel)) {
            this.d_libUnsaved = true;
        }
    }

    private boolean deleteObjs(JList<IPyroObject> jlist, PyroMod domain) {
        List<IPyroObject> objs = jlist.getSelectedValuesList();
        if (objs.isEmpty()) {
            return false;
        }
        Task t = Actions.getDeleteTask(domain, objs);
        if (t == null) {
            return false;
        }
        domain.getTaskManager().exec(t, Intl.intl("Delete Objects"));
        this.loadList(domain, jlist);
        this.preserveSelection(objs, jlist, this.getManager(domain));
        return true;
    }

    private void preserveSelection(Collection<? extends IPyroObject> lastSelectedObjs, JList<IPyroObject> jlist, Composite<? extends IPyroObject> mgr) {
        ArrayList<Integer> selIxes = new ArrayList<Integer>();
        jlist.clearSelection();
        for (IPyroObject iPyroObject : lastSelectedObjs) {
            if (!mgr.containsDeep(iPyroObject)) continue;
            selIxes.add(this.indexOf(jlist, iPyroObject));
        }
        jlist.setSelectedIndices(theUtil.toIntArray(selIxes));
    }

    private int indexOf(JList<IPyroObject> jlist, IPyroObject obj) {
        for (int m = 0; m < jlist.getModel().getSize(); ++m) {
            if (jlist.getModel().getElementAt(m) != obj) continue;
            return m;
        }
        return -1;
    }

    private static <T extends IPyroObject> Collection<T> getObjects(PyroMod domain, IMgrRetriever<T> retriever) {
        Composite<T> mgr = retriever.getManager(domain);
        Predicate<T> filter = retriever.getFilter();
        Collection<T> objs = filter != null ? mgr.flatten(retriever.getType(), filter) : ((APyroObject)mgr).flatten(retriever.getType());
        return Util.sort(objs);
    }

    private void loadList(PyroMod domain, JList<IPyroObject> list) {
        list.setListData((IPyroObject[])theUtil.toArray(FDSLibraryDlg.getObjects(domain, this.d_libCB.getSelectedItem()), IPyroObject.class));
    }

    private Set<? extends IPyroObject> getListContents(JList<IPyroObject> list) {
        LinkedIdentityHashSet objs = new LinkedIdentityHashSet();
        ListModel<IPyroObject> model = list.getModel();
        for (int m = 0; m < model.getSize(); ++m) {
            objs.add(model.getElementAt(m));
        }
        return objs;
    }

    public boolean copyListSelection(JList<IPyroObject> jlistBeingCopied, JList<IPyroObject> jlistCopiedTo, PyroMod containerBeingCopied, PyroMod containerCopiedTo) {
        Set<? extends IPyroObject> oldListVals = this.getListContents(jlistCopiedTo);
        List<IPyroObject> objsToCopy = jlistBeingCopied.getSelectedValuesList();
        if (objsToCopy.isEmpty()) {
            return true;
        }
        try {
            Actions.doTransfer(containerBeingCopied, containerCopiedTo, objsToCopy);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.loadList(containerCopiedTo, jlistCopiedTo);
        Set<? extends IPyroObject> newListVals = this.getListContents(jlistCopiedTo);
        newListVals.removeAll(oldListVals);
        this.preserveSelection(newListVals, jlistCopiedTo, this.getManager(containerCopiedTo));
        return true;
    }

    @Override
    protected void decorateCells(ALibraryDlg.ManagerRenderer r, JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        IPyroObject obj = (IPyroObject)value;
        r.setText(Util.getName(obj));
    }

    static {
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Materials"), Material.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getMaterialMgr();
            }
        });
        Predicate<Surface> surfFilter = new Predicate<Surface>(){

            @Override
            public boolean test(Surface o) {
                return !o.isPredefined();
            }
        };
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Surfaces"), Surface.class, (Predicate)surfFilter){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSurfaceMgr();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Gas-phase Reactions"), Reaction.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getReactions();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Smoke Detector Models"), SmokeLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSmokeLinkModels();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Heat Detector Models"), HeatLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getHeatLinkModels();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Sprinkler Link Models"), SprinklerLinkModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSprinklerLinkModels();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Spray Models"), SprayModel.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getSprayModels();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Particles"), Particle.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getPartList();
            }
        });
        FDSLibraryDlg.registerRetriever(new AMgrRetriever(Intl.intl("Species"), ExSpec.class){

            @Override
            public Composite getManager(PyroMod model) {
                return model.getExSpecList();
            }
        });
    }

    public static interface IMgrRetriever<T extends IPyroObject> {
        public String getDescription();

        public Composite<T> getManager(PyroMod var1);

        public Class<T> getType();

        public Predicate<T> getFilter();
    }

    private class CloseListener
    extends WindowAdapter {
        private CloseListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            FDSLibraryDlg.this.d_status = 8;
        }
    }

    private class RetrieverRenderer
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = -4364493595770278351L;

        private RetrieverRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            IMgrRetriever obj = (IMgrRetriever)value;
            this.setText(obj.getDescription());
            return this;
        }
    }

    public static abstract class AMgrRetriever<T extends IPyroObject>
    implements IMgrRetriever<T> {
        private final Class<T> d_type;
        private final String d_desc;
        private final Predicate<T> d_filter;

        public AMgrRetriever(String desc, Class<T> type) {
            this(desc, type, null);
        }

        public AMgrRetriever(String desc, Class<T> type, Predicate<T> filter) {
            this.d_desc = desc;
            this.d_filter = filter;
            this.d_type = type;
        }

        @Override
        public String getDescription() {
            return this.d_desc;
        }

        @Override
        public Class<T> getType() {
            return this.d_type;
        }

        @Override
        public Predicate<T> getFilter() {
            return this.d_filter;
        }
    }
}

