/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.DeletePreserveTask;
import pyrosim.domain.tasks.InsertTask;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.util.LinkedIdentityHashSet;

public class ReorderObjectsTask
extends DeletePreserveTask {
    private final IPyroObject d_target;
    private final int d_insertPt;

    public ReorderObjectsTask(IPyroObject target, int insertPt, IPyroObject ... objs) {
        this(target, insertPt, Arrays.asList(objs));
    }

    public ReorderObjectsTask(IPyroObject target, int insertPt, Collection<? extends IPyroObject> objs) {
        super(objs);
        this.d_target = target;
        this.d_insertPt = insertPt;
    }

    @Override
    public void undo() {
        this.run(false);
    }

    @Override
    public void run() {
        this.run(true);
    }

    public void run(boolean ascend) {
        ((PyroMod)this.d_target.getDomain()).pauseUpdates(false);
        if (ascend) {
            this.doAction();
        } else {
            this.undoAction();
        }
        ((PyroMod)this.d_target.getDomain()).resumeUpdates();
        ((PyroMod)this.d_target.getDomain()).pauseUpdates();
        this.d_target.changedEvt(PyroMod.EVT_CHILDREN_CHANGED);
        for (DeletePreserveTask.MoveRecord mr : this.getRecords()) {
            mr.oldParent.changedEvt(PyroMod.EVT_CHILDREN_CHANGED);
            mr.moveObj.changedEvt(PyroMod.EVT_PARENT_CHANGED);
        }
        ((PyroMod)this.d_target.getDomain()).resumeUpdates();
    }

    public void doAction() {
        LinkedIdentityHashSet toInsert = new LinkedIdentityHashSet();
        for (DeletePreserveTask.MoveRecord pair : this.getRecords()) {
            toInsert.add(pair.moveObj);
        }
        IPyroObject insertAfter = null;
        Iterator<? extends IPyroObject> objit = this.d_target.getMembers().iterator();
        for (int ix = 0; objit.hasNext() && ix < this.d_insertPt; ++ix) {
            IPyroObject obj = objit.next();
            if (toInsert.contains(obj)) continue;
            insertAfter = obj;
        }
        super.run();
        int insertIx = 0;
        if (insertAfter != null) {
            insertIx = 1;
            for (IPyroObject iPyroObject : this.d_target.getMembers()) {
                if (iPyroObject == insertAfter) break;
                ++insertIx;
            }
        }
        new InsertTask(this.d_target, insertIx, toInsert).run();
    }

    public void undoAction() {
        List<DeletePreserveTask.MoveRecord> recs = this.getRecords();
        for (int m = recs.size() - 1; m >= 0; --m) {
            DeletePreserveTask.MoveRecord rec = recs.get(m);
            TVEntryPoints.ep(this.d_target).remove(this.d_target, rec.moveObj);
        }
        super.undo();
    }
}

