/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tasks;

import java.util.Collection;
import java.util.List;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.InsertTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.Pair;

public class AddGridBoundaryVentsTask
extends CompositeTask<PyroMod> {
    private static final String GRID_BOUNDARY_VENT_PARENT = Intl.intl("Mesh Boundary Vents");

    public AddGridBoundaryVentsTask(PyroMod mediator, List<Pair<Grid, List<Vent>>> gridVentMap) {
        super(mediator);
        ModelComposite gridCompsParent = this.findComposite(mediator.getObstructions(), GRID_BOUNDARY_VENT_PARENT, 0);
        for (Pair<Grid, List<Vent>> entry : gridVentMap) {
            String gridCompName = String.format(Intl.intl("Vents for %s"), ((Grid)entry.v1).getName());
            ModelComposite gridComp = this.findComposite(gridCompsParent, gridCompName, null);
            this.addTask(new AddTask((IPyroObject)gridComp, (Collection)entry.v2));
        }
    }

    @Override
    public boolean isMajor() {
        return true;
    }

    private ModelComposite findComposite(ModelComposite parent, String name, Integer insertIndex) {
        ModelComposite composite = parent.find(name, ModelComposite.class, false);
        if (composite == null) {
            composite = new ModelComposite(name);
            if (insertIndex != null) {
                this.addTask(new InsertTask((IPyroObject)parent, insertIndex.intValue(), new IPyroObject[]{composite}));
            } else {
                this.addTask(new AddTask((IPyroObject)parent, new IPyroObject[]{composite}));
            }
        }
        return composite;
    }
}

