/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.tags;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.domain.tags.TagRoot;
import pyrosim.domain.tasks.AddTask;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;

public class TagsUtil {
    public static Set<Tag> getTagsForStrings(CompositeTask<PyroMod> tagInsertConsumer, TagRoot dataRoot, Set<String> tagStrings) {
        List<Pair<Tag, Boolean>> tagsPresentList = TagsUtil.queueNewTagIds(dataRoot, tagStrings);
        tagInsertConsumer.addTask(TagsUtil.queueInserts(dataRoot, tagsPresentList));
        return tagsPresentList.stream().map(p -> (Tag)p.v1).collect(Collectors.toCollection(LinkedIdentityHashSet::new));
    }

    public static AddTask<Tag> queueInserts(TagRoot dataRoot, List<Pair<Tag, Boolean>> potentialNewTagsList) {
        Set inserts = potentialNewTagsList.stream().filter(kvPair -> (Boolean)kvPair.v2 == false).map(pair -> (Tag)pair.v1).collect(Collectors.toCollection(LinkedHashSet::new));
        return new AddTask<Tag>((IPyroObject)dataRoot, inserts);
    }

    public static List<Pair<Tag, Boolean>> queueNewTagIds(TagRoot dataRoot, Set<String> ids) {
        ArrayList<Pair<Tag, Boolean>> tagIsPresentList = new ArrayList<Pair<Tag, Boolean>>();
        Map<String, Tag> currTags = dataRoot.getNameToTagMap();
        for (String id : ids) {
            if (currTags.containsKey(id)) {
                tagIsPresentList.add(new Pair<Tag, Boolean>(currTags.get(id), true));
                continue;
            }
            tagIsPresentList.add(new Pair<Tag, Boolean>(new Tag(id), false));
        }
        return tagIsPresentList;
    }

    public static void queueEditTagsDirect(CompositeTask<PyroMod> tagInsertConsumer, Collection<ITaggable> editObjs, final Set<Tag> assignTags) {
        if (editObjs.isEmpty()) {
            return;
        }
        final ArrayList<ITaggable> taggables = new ArrayList<ITaggable>(editObjs);
        tagInsertConsumer.addTask(new AUndoableTask(){
            List<Pair<ITaggable, Set<Tag>>> oldTags = null;

            @Override
            public void undo() {
                for (Pair pair : this.oldTags.reversed()) {
                    ((ITaggable)pair.v1).setTags((Set)pair.v2);
                }
                this.oldTags = null;
            }

            @Override
            public void run() {
                this.oldTags = new ArrayList<Pair<ITaggable, Set<Tag>>>(taggables.size());
                for (ITaggable obj : taggables) {
                    if (assignTags.equals(obj.getTags())) continue;
                    this.oldTags.add(new Pair<ITaggable, Set<Tag>>(obj, obj.getTags()));
                    obj.setTags(assignTags);
                }
            }
        });
    }

    public static void queueAddRemoveTags(CompositeTask<PyroMod> tagChangeConsumer, Collection<ITaggable> editObjs, final Set<Tag> addTags, final Set<Tag> removeTags) {
        if (editObjs.isEmpty()) {
            return;
        }
        if (addTags.isEmpty() && removeTags.isEmpty()) {
            return;
        }
        final ArrayList<ITaggable> taggables = new ArrayList<ITaggable>(editObjs);
        tagChangeConsumer.addTask(new AUndoableTask(){
            private List<Pair<ITaggable, Set<Tag>>> oldTags = null;

            @Override
            public void undo() {
                for (Pair entry : this.oldTags.reversed()) {
                    ((ITaggable)entry.v1).setTags((Set)entry.v2);
                }
                this.oldTags = null;
            }

            @Override
            public void run() {
                HashMap<LinkedIdentityHashSet<Tag>, LinkedIdentityHashSet<Tag>> tagCache = new HashMap<LinkedIdentityHashSet<Tag>, LinkedIdentityHashSet<Tag>>();
                this.oldTags = new ArrayList<Pair<ITaggable, Set<Tag>>>(taggables.size());
                for (ITaggable obj : taggables) {
                    Set<Tag> tags;
                    if (!addTags.stream().anyMatch(t -> !obj.getTags().contains(t))) {
                        if (!removeTags.stream().anyMatch(obj.getTags()::contains)) continue;
                    }
                    this.oldTags.add(new Pair<ITaggable, Set<Tag>>(obj, obj.getTags()));
                    Set<Tag> tagsForObj = new LinkedIdentityHashSet<Tag>((Collection<Tag>)obj.getTags());
                    tagsForObj.addAll(addTags);
                    tagsForObj.removeAll(removeTags);
                    if (tagsForObj.isEmpty()) {
                        tagsForObj = Collections.emptySet();
                    }
                    if ((tags = (Set<Tag>)tagCache.putIfAbsent((LinkedIdentityHashSet<Tag>)tagsForObj, (LinkedIdentityHashSet<Tag>)tagsForObj)) == null) {
                        tags = tagsForObj;
                    }
                    obj.setTags(tags);
                }
            }
        });
    }

    public static String renderTagsAsString(Set<String> tags) {
        return String.join((CharSequence)" ", tags);
    }

    public static Set<String> tagsToStrings(Collection<Tag> tags) {
        return tags.stream().map(tag -> tag.getName()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Set<String> splitStrings(String input) {
        return Stream.of(input.split("[ ,;]+")).map(s -> s.trim().toLowerCase(Locale.ROOT)).filter(s -> !s.isEmpty()).collect(Collectors.toCollection(LinkedHashSet::new));
    }
}

