/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.rasterization;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import pyrosim.PyroSim;

public class RasterizationOptions
implements Serializable,
Cloneable {
    static final long serialVersionUID = 1L;
    private Boolean d_enableFdsGeom;
    public final boolean largeBlocks;
    public final boolean mergeIdentical;
    public final boolean separateDisconnected;
    public final boolean ignoreMergeNames;
    public final boolean forceThicken;
    public final boolean geomGroups;
    public final boolean rasterizeAligned;

    public RasterizationOptions() {
        this(true, true, true, true, false, false, true, false);
    }

    public RasterizationOptions(boolean fdsGeomEnabled, boolean largeBlocks, boolean mergeIdentical, boolean separateDisconnected, boolean ignoreMergeNames, boolean forceThicken, boolean geomGroups, boolean rasterizeAligned) {
        this.d_enableFdsGeom = fdsGeomEnabled;
        this.largeBlocks = largeBlocks;
        this.mergeIdentical = mergeIdentical;
        this.separateDisconnected = separateDisconnected;
        this.ignoreMergeNames = ignoreMergeNames;
        this.forceThicken = forceThicken;
        this.geomGroups = geomGroups;
        this.rasterizeAligned = rasterizeAligned;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RasterizationOptions)) {
            return false;
        }
        RasterizationOptions props = (RasterizationOptions)obj;
        return this.d_enableFdsGeom == props.d_enableFdsGeom && this.largeBlocks == props.largeBlocks && this.mergeIdentical == props.mergeIdentical && this.separateDisconnected == props.separateDisconnected && this.ignoreMergeNames == props.ignoreMergeNames && this.forceThicken == props.forceThicken && this.geomGroups == props.geomGroups && this.rasterizeAligned == props.rasterizeAligned;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_enableFdsGeom == null) {
            this.d_enableFdsGeom = true;
        }
    }

    public boolean isFdsGeomEnabled() {
        return this.d_enableFdsGeom != false && PyroSim.isFDSGeomEnabled();
    }

    protected RasterizationOptions clone() {
        try {
            return (RasterizationOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public RasterizationOptions setFdsGeomEnabled(boolean enabled) {
        if (enabled == this.d_enableFdsGeom) {
            return this;
        }
        RasterizationOptions options = this.clone();
        options.d_enableFdsGeom = enabled;
        return options;
    }
}

