/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.rasterization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.rasterization.FaceProps;
import pyrosim.domain.rasterization.IFragGenerator;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.util.Pair;

public class FDSObjectRasterization {
    public final IFragGenerator fragGen;
    public final List<FDSObject> sources;
    public final Pair<IGeom, FaceProps[]>[] geoms;

    public FDSObjectRasterization(IFragGenerator fragGen, List<FDSObject> sources, Pair<IGeom, FaceProps[]>[] geoms) {
        this.fragGen = fragGen;
        this.sources = sources;
        this.geoms = new Pair[geoms.length];
        for (int m = 0; m < geoms.length; ++m) {
            Pair<IGeom, FaceProps[]> pair;
            IGeom oldGeom = (IGeom)geoms[m].v1;
            IGeom newGeom = fragGen.transformGeom(oldGeom);
            if (newGeom == oldGeom) {
                pair = geoms[m];
            } else {
                Pair<IGeom, FaceProps[]> pair2;
                pair = pair2;
                super(newGeom, (FaceProps[])geoms[m].v2);
            }
            this.geoms[m] = pair;
        }
    }

    public IPyroObject getFrags(boolean asGeomGroup) {
        if (!asGeomGroup) {
            Collection<FDSObject> coll = this.getFragsAsCollection();
            if (coll.isEmpty()) {
                return null;
            }
            if (coll.size() == 1) {
                return coll.iterator().next();
            }
            ModelComposite group = new ModelComposite(this.sources.get(0).getName());
            group.addAll(coll);
            return group;
        }
        return this.getFragsAsComposite();
    }

    public Collection<FDSObject> getFragsAsCollection() {
        ArrayList<FDSObject> frags = new ArrayList<FDSObject>(this.geoms.length);
        for (Pair<IGeom, FaceProps[]> pair : this.geoms) {
            Object frag = this.fragGen.generateFrag((IGeom)pair.v1, (FaceProps[])pair.v2);
            frags.add((FDSObject)frag);
        }
        if (frags.size() > 1) {
            for (FDSObject obj : frags) {
                obj.setName(String.format(Intl.intl("%s [Segment]"), obj.getName()));
            }
        }
        return frags;
    }

    public FDSObject getFragsAsComposite() {
        int totalNumFaces = 0;
        for (Pair<IGeom, FaceProps[]> pair : this.geoms) {
            totalNumFaces += ((IGeom)pair.v1).getNumPrims(1);
        }
        if (totalNumFaces == 0) {
            return null;
        }
        ArrayList<IGeom> allGeom = new ArrayList<IGeom>(this.geoms.length);
        FaceProps[] allProps = new FaceProps[totalNumFaces];
        int faceix = 0;
        for (Pair<IGeom, FaceProps[]> pair : this.geoms) {
            int m;
            allGeom.add((IGeom)pair.v1);
            int numFaces = ((IGeom)pair.v1).getNumPrims(1);
            if (((FaceProps[])pair.v2).length == 1) {
                for (m = 0; m < numFaces; ++m) {
                    allProps[faceix++] = ((FaceProps[])pair.v2)[0];
                }
                continue;
            }
            for (m = 0; m < numFaces; ++m) {
                allProps[faceix++] = ((FaceProps[])pair.v2)[m];
            }
        }
        IGeom iGeom = allGeom.size() == 1 ? (IGeom)allGeom.get(0) : new GeomGroup(allGeom);
        return this.fragGen.generateFrag(iGeom, allProps);
    }
}

