/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.jscience.physics.units.NonSI;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IImplicitGeomSrc;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.hvac.AHvacGeomComponent;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.HvacUtil;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.geometry.BoundingSphere;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.EmptyGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.ILinearCurve;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Triangle;
import thunderheadeng.geometry.objs.node.GeomNodeLeaf;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.CollResult;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.FlattenedProps;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.IPropsSrc;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class HvacDuct
extends AHvacGeomComponent
implements ISignalSink,
IImplicitGeomSrc {
    private static final long serialVersionUID = -4887397052092333390L;
    private static final UnitDouble ZERO_VF = SIUS.newud(0.0, 24);
    public static final String OPT_SHAPE = "opt_shape";
    public static final String OPT_AIRFLOW = "opt_none_damper_fan";
    public static final String OPT_FRICTION_TYPE = "opt_friction_type";
    public transient String d_n1;
    public transient String d_n2;
    private TimeBasedValue<UnitDouble> d_volflow;
    private IInPin d_inPin;
    private static final Color DUCT_COLOR;
    private static final IPropsSrc DISPLAY_GEOM_STYLE;
    private static final Predicate<HvacNode> s_nodeFilter;

    public HvacDuct(String id) {
        super(id);
        HvacDuct.setDefaults(this);
        this.d_inPin = new OneLogicInPin(this);
        this.d_volflow = new TimeBasedValue<UnitDouble>(SIUS.newud(0.0, 24), TimeFunction.newDefault());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.isPropDefined(OPT_FRICTION_TYPE)) {
            UnitDouble roughness = (UnitDouble)this.getProp("ROUGHNESS");
            if (roughness == null) {
                this.setProp(OPT_FRICTION_TYPE, (Object)FrictionType.NO_FRICTION);
            } else if (roughness.getValueNoUnit() == 0.0) {
                this.setProp(OPT_FRICTION_TYPE, (Object)FrictionType.COMPUTED_FRICTION);
            } else {
                this.setProp(OPT_FRICTION_TYPE, (Object)FrictionType.EXPLICIT);
            }
        }
        if (!this.isPropDefined("WAYPOINTS")) {
            this.setProp("WAYPOINTS", Collections.emptyList());
        }
        if (!this.isPropDefined("NETWORK_ID")) {
            this.setProp("NETWORK_ID", null);
        }
    }

    public TimeBasedValue<UnitDouble> getVolflow() {
        return this.d_volflow;
    }

    public void setVolflow(TimeBasedValue<UnitDouble> func) {
        if (theUtil.equal(this.d_volflow, func)) {
            return;
        }
        this.d_volflow = func;
        this.changedEvt(new Object[0]);
    }

    private static void setDefaults(HvacDuct obj) {
        obj.setProp("TYPE_ID", "DUCT");
        obj.setProp(OPT_SHAPE, (Object)Shape.CIRCULAR);
        obj.setProp("DIAMETER", new UnitDouble(1.0, NonSI.FOOT));
        obj.setProp("AREA", new UnitDouble(0.0, SI.METER.pow(2)));
        obj.setProp("PERIMETER", new UnitDouble(0.0, SI.METER));
        obj.setProp(OPT_AIRFLOW, (Object)AirflowObj.NONE);
        obj.setProp("FAN_ID", null);
        obj.setProp("AIRCOIL_ID", null);
        obj.setProp("LENGTH", null);
        obj.setProp("LOSS", Arrays.asList(new UnitDouble(0.0, Unit.ONE), new UnitDouble(0.0, Unit.ONE)));
        obj.setProp("NODE_ID", Arrays.asList(null, null));
        obj.setProp("REVERSE", false);
        obj.setProp("ROUGHNESS", new UnitDouble(0.001, SI.METER));
        obj.setProp(OPT_FRICTION_TYPE, (Object)FrictionType.EXPLICIT);
        obj.setProp("WAYPOINTS", Collections.emptyList());
        obj.setProp("NETWORK_ID", null);
    }

    public UnitDouble getFinalLength() {
        UnitDouble len = (UnitDouble)this.getProp("LENGTH");
        if (len != null) {
            return len;
        }
        List nodeIds = (List)this.getProp("NODE_ID");
        if (nodeIds.size() >= 2) {
            HvacNode node1 = (HvacNode)nodeIds.get(0);
            HvacNode node2 = (HvacNode)nodeIds.get(1);
            if (node1 != null && node2 != null) {
                return HvacDuct.getDistance(node1, node2);
            }
        }
        return new UnitDouble(1.0, SI.METER);
    }

    public Task taskSetWaypoints(List<Point3d> waypoints) {
        List oldWaypoints = (List)this.getProp("WAYPOINTS");
        List<Point3d> newWaypoints = waypoints;
        return new AReplaceRefTask<List<Point3d>>((Object)oldWaypoints, newWaypoints){

            @Override
            protected void set(List<Point3d> obj) {
                HvacDuct.this.setProp("WAYPOINTS", obj);
            }
        };
    }

    public static UnitDouble getDistance(HvacNode node1, HvacNode node2) {
        double dist = node1.getLocation().distance(node2.getLocation());
        return new UnitDouble(dist, Geometry.LU);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        this.addDep(deps, "AIRCOIL_ID");
        this.addDep(deps, "FAN_ID");
        this.addDep(deps, "NODE_ID");
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
        if (old instanceof HvacNode) {
            Util.keepIfNullOr(objs, HvacNode.class);
            List nodeIds = (List)this.getProp("NODE_ID");
            for (HvacNode n : nodeIds) {
                if (n == null || n == old) continue;
                objs.remove(n);
            }
        } else if (old instanceof HvacAircoil) {
            Util.keepIfNullOr(objs, HvacAircoil.class);
        } else if (old instanceof HvacFan) {
            Util.keepIfNullOr(objs, HvacFan.class);
        }
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        if (dep instanceof HvacNode || dep instanceof HvacAircoil || dep instanceof HvacFan) {
            return GeomUtil.taskChanged(this);
        }
        return super.taskUpdateDep(dep, changes);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old instanceof HvacNode) {
            List<HvacNode> nodes = this.getNodes();
            ArrayList<Integer> ixList = new ArrayList<Integer>();
            for (int m = 0; m < nodes.size(); ++m) {
                if (nodes.get(m) != old) continue;
                ixList.add(m);
            }
            final int[] ixes = theUtil.toIntArray(ixList);
            return new AReplaceRefTask<HvacNode>((Object)old, (Object)replacement){

                @Override
                protected void set(HvacNode obj) {
                    ArrayList<HvacNode> nodes = new ArrayList<HvacNode>(HvacDuct.this.getNodes());
                    for (int ix : ixes) {
                        nodes.set(ix, obj);
                    }
                    HvacDuct.this.setNodes((HvacNode)nodes.get(0), (HvacNode)nodes.get(1));
                }
            };
        }
        if (old instanceof HvacAircoil) {
            return new AReplaceRefTask<HvacAircoil>((Object)old, (Object)replacement){

                @Override
                protected void set(HvacAircoil obj) {
                    HvacDuct.this.setAircoil(obj);
                }
            };
        }
        if (old instanceof HvacFan) {
            return new AReplaceRefTask<HvacFan>((Object)old, (Object)replacement){

                @Override
                protected void set(HvacFan obj) {
                    HvacDuct.this.setFan(obj);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    private void setAircoil(HvacAircoil obj) {
        this.pauseUpdates();
        this.setProp("AIRCOIL_ID", obj);
        AirflowObj airflowOpt = obj == null ? AirflowObj.NONE : AirflowObj.AIRCOIL;
        this.setProp(OPT_AIRFLOW, (Object)airflowOpt);
        this.resumeUpdates();
    }

    private void setFan(HvacFan obj) {
        this.pauseUpdates();
        this.setProp("FAN_ID", obj);
        AirflowObj airflowOpt = obj == null ? AirflowObj.NONE : AirflowObj.FAN;
        this.setProp(OPT_AIRFLOW, (Object)airflowOpt);
        this.resumeUpdates();
    }

    @Override
    public Collection<IPyroGeomSrc> getDefiningObjs(Collection<IPyroGeomSrc> objs) {
        objs.addAll(this.getNodes());
        return objs;
    }

    public List<HvacNode> getNodes() {
        return (List)this.getProp("NODE_ID");
    }

    public void setNodes(HvacNode node1, HvacNode node2) {
        this.setNodes(Arrays.asList(node1, node2));
    }

    public void setNodes(List<HvacNode> nodes) {
        assert (nodes.size() == 2);
        this.setProp("NODE_ID", nodes);
    }

    @Override
    public void setProp(String key, Object value) {
        assert (!key.equals("VOLUME_FLOW")) : "Use HvacDuct.setVolflow() instead.";
        super.setProp(key, value);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        HvacDuct clone = (HvacDuct)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        clone.d_volflow = this.d_volflow.clone();
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof HvacDuct && super.equals(obj) && this.d_inPin.equals(((HvacDuct)obj).d_inPin);
    }

    public boolean isNodeAttached(HvacNode node) {
        List nodes = (List)this.getProp("NODE_ID");
        if (!nodes.isEmpty()) {
            return node.equals(nodes.get(0)) || node.equals(nodes.get(1));
        }
        return false;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps props) {
        IGeom iGeom;
        boolean isFan;
        IGeomNode geom = this.getGeom();
        if (geom == GeomNodeUtil.EMPTY_NODE) {
            return DisplayGeom.EMPTY;
        }
        Object airflow = this.getProp(OPT_AIRFLOW);
        boolean bl = isFan = AirflowObj.FAN.equals(airflow) || AirflowObj.VOLFLOW.equals(airflow);
        if (isFan && this.getVolflow() != null && this.getVolflow().val != null && (iGeom = this.getDuctGeom()) instanceof DuctGeom) {
            DuctGeom ductGeom = (DuctGeom)iGeom;
            Point3d a = ductGeom.p1;
            Point3d b = ductGeom.p2;
            if (((UnitDouble)this.getVolflow().val).lt(ZERO_VF, 0.0)) {
                a = ductGeom.p2;
                b = ductGeom.p1;
            }
            double ductLen = a.distance(b);
            double szt = Math.min(0.3, 0.3 / ductLen);
            Point3d headPt = Util3D.linesegPoint(a, b, 0.5 + 0.5 * szt);
            Point3d baseOnDuct = Util3D.linesegPoint(a, b, 0.5 - 0.5 * szt);
            Point3d b1 = Util3D.add(headPt, (Tuple3d)Util3D.rotate(Util3D.vector(headPt, baseOnDuct), Util3D.VEC3D_ZPOS, Math.toRadians(15.0)));
            Point3d b2 = Util3D.add(headPt, (Tuple3d)Util3D.rotate(Util3D.vector(headPt, baseOnDuct), Util3D.VEC3D_ZPOS, Math.toRadians(-15.0)));
            GeomNodeLeaf extra = GeomNodeUtil.newNode(new Triangle(b1, b2, headPt));
            geom = GeomNodeUtil.newNode(Arrays.asList(geom, extra));
        }
        return new DisplayGeom(geom, DISPLAY_GEOM_STYLE);
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getDuctGeom());
    }

    public IGeom getDuctGeom() {
        List<HvacNode> nodes = this.getNodes();
        if (nodes.size() < 2 || nodes.get(0) == null || nodes.get(1) == null) {
            return EmptyGeom.INSTANCE;
        }
        return new DuctGeom(nodes.get(0), nodes.get(1));
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof DuctGeom) {
            DuctGeom dg = (DuctGeom)geom;
            ArrayList<HvacNode> nodes = new ArrayList<HvacNode>(2);
            nodes.add(dg.node1);
            nodes.add(dg.node2);
            this.setProp("NODE_ID", nodes);
        }
    }

    public static Predicate<HvacNode> getNodeFilter() {
        return s_nodeFilter;
    }

    static {
        TVEntryPoint.registerReferencedUpdateTypes(HvacNode.class, HvacAircoil.class, HvacFan.class);
        DUCT_COLOR = new Color(16753920);
        DISPLAY_GEOM_STYLE = new FlattenedProps(new IPrimProps.Edge(DUCT_COLOR, 3.0, IPrimProps.DEF_STIPPLE, 0), new IPrimProps.Edge(DUCT_COLOR.darker(), 1.0, IPrimProps.DEF_STIPPLE, 0));
        s_nodeFilter = new Predicate<HvacNode>(){

            @Override
            public boolean test(HvacNode o) {
                PyroMod domain = (PyroMod)o.getDomain();
                if (domain == null) {
                    return false;
                }
                int numDucts = HvacUtil.getConnectedDucts(domain.getObstructions(), o).size();
                int remaining = o.getOpenDuctCount(numDucts);
                return 0 < remaining;
            }
        };
    }

    public static enum FrictionType {
        NO_FRICTION(Intl.intl("No Friction")),
        COMPUTED_FRICTION(Intl.intl("Minimum Friction")),
        EXPLICIT(Intl.intl("Explicit"));

        public final String displayName;

        private FrictionType(String displayName) {
            this.displayName = displayName;
        }
    }

    public static enum Shape {
        CIRCULAR,
        NON_CIRCULAR;

    }

    public static enum AirflowObj {
        NONE,
        DAMPER,
        FAN,
        AIRCOIL,
        VOLFLOW;

    }

    public static class DuctGeom
    extends LineSeg {
        private static final long serialVersionUID = -6451536396755602607L;
        public final HvacNode node1;
        public final HvacNode node2;

        public DuctGeom(HvacNode node1, HvacNode node2) {
            super(node1.getLocation(), node2.getLocation());
            this.node1 = node1;
            this.node2 = node2;
        }

        @Override
        public DuctGeom newCurve(Point3d ... points) {
            return this;
        }

        @Override
        public LineSeg optimize(IPointOptimizer pool) {
            return this;
        }

        @Override
        public LineSeg transform(TransformInfo ti, int options) {
            return this;
        }

        @Override
        public boolean equals(Object obj) {
            return obj == this || obj instanceof DuctGeom && ((DuctGeom)obj).node1 == this.node1 && ((DuctGeom)obj).node2 == this.node2;
        }

        @Override
        public LineSeg negate() {
            return new DuctGeom(this.node2, this.node1);
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            handles.accept(new Handle(this, 0));
            handles.accept(new Handle(this, 1));
        }

        protected static class Handle
        extends ILinearCurve.Handle {
            public Handle(DuctGeom geom, int ix) {
                super(geom, ix);
            }

            @Override
            public boolean equals(Object obj) {
                return obj == this || obj instanceof Handle && super.equals(obj);
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(this, new Class[]{HvacNode.class}){

                    @Override
                    public boolean acceptPickObject(Object obj) {
                        return obj instanceof HvacNode && HvacDuct.getNodeFilter().test((HvacNode)obj);
                    }
                });
            }

            protected LineSeg newGeom(LineSeg originalGeom, int modIx, Point3d p1, Point3d p2) throws Exception {
                DuctGeom dgeom = (DuctGeom)originalGeom;
                HvacNode[] nodes = new HvacNode[]{dgeom.node1, dgeom.node2};
                Point3d searchPoint = modIx == 0 ? p1 : p2;
                BoundingSphere tester = new BoundingSphere(searchPoint, 1.0E-6);
                CollResult result = new CollResult(HvacNode.class);
                PyroSim.getApp().getMediator().getGeomLocator().find(tester, result, false, true);
                HvacNode closest = null;
                double closestDist = Double.POSITIVE_INFINITY;
                for (HvacNode node : result.coll) {
                    Point3d loc = node.getLocation();
                    double dist = searchPoint.distance(loc);
                    if (!(dist < closestDist)) continue;
                    closestDist = dist;
                    closest = node;
                }
                if (closest == null) {
                    throw new Exception();
                }
                nodes[modIx] = closest;
                return new DuctGeom(nodes[0], nodes[1]);
            }
        }
    }
}

