/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.hvac;

import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.IHvacObject;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public class HvacAircoil
extends HvacComponent
implements IHvacObject,
ISignalSink {
    private static final long serialVersionUID = 1L;
    public static final String OPT_AIRCOIL_MODEL = "opt_aircoil_model";
    private TimeBasedValue<UnitDouble> d_fixedQ;
    @Deprecated
    private IInPin d_inPin;

    public HvacAircoil(String id) {
        super(id);
        HvacAircoil.setDefaults(this);
        this.d_fixedQ = new TimeBasedValue<UnitDouble>(new UnitDouble(0.0, SI.KILO(SI.JOULE).divide(SI.SECOND)), TimeFunction.newDefault());
        this.d_inPin = new OneLogicInPin(this);
    }

    public static void setDefaults(HvacAircoil obj) {
        obj.setProp("TYPE_ID", "AIRCOIL");
        obj.setProp("COOLANT_SPECIFIC_HEAT", new UnitDouble(0.0, SI.KILO(SI.JOULE).divide(SI.KILOGRAM.multiply(SI.KELVIN))));
        obj.setProp("COOLANT_MASS_FLOW", new UnitDouble(0.0, SI.KILOGRAM.divide(SI.SECOND)));
        obj.setProp("COOLANT_TEMPERATURE", new UnitDouble(0.0, SI.CELSIUS));
        obj.setProp("EFFICIENCY", new UnitDouble(0.0, Unit.ONE));
        obj.setProp(OPT_AIRCOIL_MODEL, (Object)Model.FIXEDQ);
    }

    public TimeBasedValue<UnitDouble> getFixedQ() {
        return this.d_fixedQ;
    }

    public void setFixedQ(TimeBasedValue<UnitDouble> val) {
        if (theUtil.equal(this.d_fixedQ, val)) {
            return;
        }
        this.d_fixedQ = val;
        this.changedEvt(new Object[0]);
    }

    @Override
    public IInPin getInputPin() {
        return this.d_inPin;
    }

    @Override
    public Object clone() {
        HvacAircoil clone = (HvacAircoil)super.clone();
        clone.d_inPin = (IInPin)this.d_inPin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this || obj instanceof HvacAircoil && this.d_fixedQ.equals(((HvacAircoil)obj).d_fixedQ) && super.equals(obj) && this.d_inPin.equals(((HvacAircoil)obj).d_inPin);
    }

    public static enum Model {
        COOLANT,
        FIXEDQ;

    }
}

