/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.evac;

import java.util.ArrayList;
import java.util.Map;
import pyrosim.domain.IPyroObject;
import thunderheadeng.util.AUndoableTask;

public class MultiKeyReplTask
extends AUndoableTask {
    private final IPyroObject d_obj;
    private final Map<String, Object> d_props;
    private final IPyroObject d_old;
    private final IPyroObject d_replacement;
    private String[] d_replKeys = null;

    public MultiKeyReplTask(IPyroObject obj, Map<String, Object> props, IPyroObject old, IPyroObject repl) {
        this.d_obj = obj;
        this.d_props = props;
        this.d_old = old;
        this.d_replacement = repl;
    }

    @Override
    public void run() {
        if (this.d_replKeys == null) {
            ArrayList<String> replKeys = new ArrayList<String>();
            for (Map.Entry<String, Object> entry : this.d_props.entrySet()) {
                if (entry.getValue() != this.d_old) continue;
                replKeys.add(entry.getKey());
            }
            this.d_replKeys = replKeys.toArray(new String[replKeys.size()]);
        }
        this.setKeys(this.d_replacement);
    }

    @Override
    public void undo() {
        this.setKeys(this.d_old);
        this.d_replKeys = null;
    }

    protected void setKeys(IPyroObject newObj) {
        assert (this.d_replKeys != null);
        for (String key : this.d_replKeys) {
            this.d_props.put(key, newObj);
        }
        this.d_obj.changedEvt(new Object[0]);
    }
}

