/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.statistics;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.LongPredicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import pyrosim.domain.devices.ASourceDevice;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.devices.measurers.IMeasureOutInfo;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.statistics.IStatGeom;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.quantity.QuantityReplacer;
import pyrosim.domain.quantity.QuantityStat;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.domain.signals.IDoubleInPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.LogicOutPin;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Task;

public class StatisticsDevc
extends ASourceDevice
implements IDirectDependent,
IMeasurer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(StatisticsDevc.class.getSimpleName());
    public static final ImageIcon ICON = PyroGuiUtil.loadPyroSimIcon("stat16.png");
    private IStatGeom d_geom;
    private IQuantity d_measurement;
    private OneLogicInPin d_freezePin;
    private List<OutPin> d_outPins;
    private List<StatLogicOutPin> d_alarmPins;
    private AlarmInfo d_alarmInfo;
    private QuantityStat d_spatialStat = null;
    private QuantityStat d_temporalStat = null;
    private static final Color s_spatialColor = new Color(0.2f, 0.2f, 1.0f, 0.3f);
    private static final Color s_nonSpatialColor = new Color(0.2f, 0.2f, 1.0f, 1.0f);

    public StatisticsDevc(String name, IQuantity measurment, QuantityStat spatialStat, QuantityStat temporalStat, IStatGeom statGeom) {
        super(name);
        assert (spatialStat == null || spatialStat.type == QuantityStat.Type.SPATIAL);
        assert (temporalStat == null || temporalStat.type == QuantityStat.Type.TEMPORAL);
        this.d_measurement = measurment;
        this.d_spatialStat = spatialStat;
        this.d_temporalStat = temporalStat;
        this.d_geom = statGeom;
        this.d_freezePin = new OneLogicInPin(this);
        this.initOutputPins();
    }

    private void initOutputPins() {
        this.d_outPins = IntStream.range(0, this.d_geom.getNumDevcOutputs()).mapToObj(i -> new OutPin(this, this.d_geom.isArray() ? i : -1)).toList();
        this.d_alarmPins = IntStream.range(0, this.d_geom.getNumDevcOutputs()).mapToObj(i -> new StatLogicOutPin(this, this.d_geom.isArray() ? i : -1)).toList();
    }

    @Override
    public Icon[] getIcons() {
        return new Icon[]{ICON, null};
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        StatisticsDevc devc = (StatisticsDevc)obj;
        return this.propsEquals(devc) && this.d_geom.surrogateEquals(devc.d_geom);
    }

    public boolean propsEquals(StatisticsDevc devc) {
        return super.equals(devc) && this.d_spatialStat == devc.d_spatialStat && this.d_temporalStat == devc.d_temporalStat && this.d_measurement.equals(devc.d_measurement) && this.d_freezePin.equals(devc.d_freezePin) && Objects.equals(devc.d_alarmInfo, this.d_alarmInfo);
    }

    @Override
    public StatisticsDevc clone() {
        StatisticsDevc clone = (StatisticsDevc)super.clone();
        clone.d_outPins = this.d_outPins.stream().map(pin -> pin.clone(clone)).toList();
        clone.d_alarmPins = this.d_alarmPins.stream().map(pin -> pin.clone(clone)).toList();
        clone.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(clone);
        return clone;
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        super.getCustomFDSTypes(recTypes);
        recTypes.add("PROP");
    }

    public QuantityStat getSpatialStat() {
        return this.d_spatialStat;
    }

    public void setSpatialStat(QuantityStat spatialStat) {
        assert (spatialStat == null || spatialStat.type == QuantityStat.Type.SPATIAL);
        if (this.d_spatialStat == spatialStat) {
            return;
        }
        this.pauseUpdates();
        this.d_spatialStat = spatialStat;
        this.updateInputUnits();
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public QuantityStat getTemporalStat() {
        return this.d_temporalStat;
    }

    public void setTemporalStat(QuantityStat temporalStat) {
        assert (temporalStat == null || temporalStat.type == QuantityStat.Type.TEMPORAL);
        if (this.d_temporalStat == temporalStat) {
            return;
        }
        this.pauseUpdates();
        this.d_temporalStat = temporalStat;
        this.updateInputUnits();
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    @Override
    public int getNumMeasurements() {
        return this.d_geom.getNumDevcOutputs();
    }

    @Override
    public IMeasureOutInfo getMsrInfo(int index) {
        return new MeasureInfo(index);
    }

    public void setAlarmInfo(AlarmInfo ai) {
        if (AlarmInfo.checkAlarmChange((ISignalSource)this, this.d_alarmInfo, ai, this.d_alarmPins)) {
            this.d_alarmInfo = ai;
            this.changedEvt(new Object[0]);
        }
    }

    public AlarmInfo getAlarmInfo() {
        return this.d_alarmInfo;
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return this.d_alarmInfo != null && TripFlags.latch(this.d_alarmInfo.tripFlags);
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    public IQuantity getQuantity() {
        return this.d_measurement;
    }

    @Override
    public IQuantity getQuantity(int index) {
        return this.getQuantity();
    }

    public void setQuantity(IQuantity m) {
        assert (m != null);
        if (!this.d_measurement.equals(m)) {
            this.d_measurement = m;
            this.pauseUpdates();
            this.updateInputUnits();
            this.changedEvt(new Object[0]);
            this.resumeUpdates();
        }
    }

    public static int getUnitType(Quantity q, QuantityStat spatialStat, QuantityStat temporalStat) {
        int unit = q.unitType;
        if (spatialStat != null) {
            unit = spatialStat.toStatUnit(unit);
        }
        if (temporalStat != null) {
            unit = temporalStat.toStatUnit(unit);
        }
        return unit;
    }

    public int getUnitType() {
        return StatisticsDevc.getUnitType(this.d_measurement.get(), this.d_spatialStat, this.d_temporalStat);
    }

    protected void updateInputUnits() {
        if (this.getDomain() == null) {
            return;
        }
        int newUnitType = this.getUnitType();
        Unit newUnit = PyroSim.getAppOpt().map(app -> app.getUnitSystem().getUnit(newUnitType)).orElse(SIUS.unit(newUnitType));
        DepSnapshot ds = ((PyroMod)this.getDomain()).getDependencies(this);
        Set<Dependency> deps = ds.getDependents(this);
        for (Dependency dep : deps) {
            if (!(dep.source instanceof IDoubleInPin)) continue;
            IDoubleInPin pin = (IDoubleInPin)dep.source;
            pin.updateInputUnit(newUnit);
        }
    }

    public boolean isArray() {
        return this.d_geom.isArray();
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public boolean isCompatible(IStatGeom statGeom) {
        return this.isCompatible(statGeom.getArrayProfile());
    }

    public boolean isCompatible(IStatGeom.ArrayProfile arrayProfile) {
        return IStatGeom.getNumDevcOutputs(arrayProfile) == this.getNumMeasurements();
    }

    public static boolean isCompatible(Quantity quantity, QuantityStat spatialStat, IStatGeom.Type geomType) {
        if (spatialStat != null) {
            return spatialStat.geomTypes.contains((Object)geomType);
        }
        LongPredicate testOutput = outputs -> (quantity.outputTypes & outputs) != 0L;
        if (testOutput.test(1L)) {
            return !geomType.isSpatial();
        }
        if (testOutput.test(2L)) {
            return geomType.isSpatial();
        }
        if (testOutput.test(12L)) {
            IStatGeom.SpatialType spatialType = geomType.spatial;
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"VOLUME", "AREA"}, (IStatGeom.SpatialType)spatialType, n)) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> false;
                case -1 -> false;
            };
        }
        return true;
    }

    public boolean setGeom(IGeom geom) {
        IStatGeom statGeom;
        IGeom iGeom = geom;
        Objects.requireNonNull(iGeom);
        IGeom iGeom2 = iGeom;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IStatGeom.class}, (Object)iGeom2, n)) {
            case 0: {
                IStatGeom sgeom2;
                IStatGeom iStatGeom = sgeom2 = (IStatGeom)iGeom2;
                break;
            }
            default: {
                IStatGeom iStatGeom = statGeom = (IStatGeom)Stream.of(IStatGeom.Type.values()).map(t -> t.toStatGeom.apply(geom)).filter(sgeom -> sgeom != null).findFirst().orElse(null);
            }
        }
        if (statGeom != null && this.isCompatible(statGeom)) {
            if (!this.d_geom.equals(statGeom)) {
                if (this.getDomain() != null) {
                    ((PyroMod)this.getDomain()).pauseUpdates();
                }
                int numEnabledPre = this.d_geom.getNumEnabledDevcOutputs();
                this.d_geom = statGeom;
                int numEnabledPost = this.d_geom.getNumEnabledDevcOutputs();
                if (numEnabledPre > numEnabledPost && this.getDomain() != null) {
                    IMeasureOutInfo.disconnectDisabledPins((PyroMod)this.getDomain(), this, Stream.concat(this.d_outPins.subList(numEnabledPost, numEnabledPre).stream(), this.d_alarmPins.subList(numEnabledPost, numEnabledPre).stream()).collect(Collectors.toCollection(() -> new LinkedIdentityHashSet())));
                }
                this.changedEvt(new Object[0]);
                if (this.getDomain() != null) {
                    ((PyroMod)this.getDomain()).resumeUpdates();
                }
            }
            return true;
        }
        return false;
    }

    public void forceArrayTypeConversion(IStatGeom geom) {
        assert (this.getParent() == null);
        if (!this.d_geom.equals(geom)) {
            if (!this.isCompatible(geom)) {
                this.d_geom = geom;
                this.initOutputPins();
            }
            this.changedEvt(new Object[0]);
        }
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.d_geom);
    }

    public IStatGeom getStatGeom() {
        return this.d_geom;
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        return this.d_geom.getDisplayGeom(drawProps, this.d_geom.getType().isSpatial() ? s_spatialColor : s_nonSpatialColor);
    }

    public List<? extends IStatOutPin> getOutputPins() {
        ArrayList pins = new ArrayList();
        IMeasurer.super.getOutputPins(pin -> pins.add((IStatOutPin)pin));
        return pins;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        this.d_geom.streamDependencies().forEach(callback -> callback.takeSnapshot().accept(this, deps));
        QuantityUtil.takeDepSnapshot(deps, DLink.STRONG, this.d_measurement);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
        this.d_geom.streamDependencies().filter(callback -> callback.type().isInstance(old)).forEach(callback -> this.removeInvalidReplacements((IStatGeom.DependencyInfo)callback, old, objs));
        QuantReplacer replacer = new QuantReplacer();
        replacer.removeInvalidReplacements(old, objs, this.d_measurement);
    }

    private <T extends IPyroObject> void removeInvalidReplacements(IStatGeom.DependencyInfo<T> callback, T old, Set<T> objs) {
        callback.removeInvalidRepl().accept(this, old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        Task tagReplace = super.taskReplaceDep(old, replacement);
        if (tagReplace != EmptyTask.INSTANCE) {
            return tagReplace;
        }
        Optional<Task> optGeomDep = this.d_geom.streamDependencies().filter(callback -> callback.type().isInstance(old)).map(callback -> this.taskReplaceDep((IStatGeom.DependencyInfo)callback, (IPyroObject)old, (IPyroObject)replacement)).filter(task -> task != null).findFirst();
        if (optGeomDep.isPresent()) {
            return optGeomDep.get();
        }
        QuantReplacer replacer = new QuantReplacer();
        return replacer.taskReplaceDep(old, replacement, this.d_measurement);
    }

    private <T extends IPyroObject> Task taskReplaceDep(IStatGeom.DependencyInfo<T> callback, T old, T repl) {
        IStatGeom replacedGeom = callback.replaceDep().apply(this, old, repl);
        if (replacedGeom == null) {
            return null;
        }
        return new AReplaceRefTask<IStatGeom>((Object)this.getStatGeom(), (Object)replacedGeom){

            @Override
            protected void set(IStatGeom geom) {
                StatisticsDevc.this.setGeom(geom);
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return super.taskUpdateDep(dep, changes);
    }

    public class MeasureInfo
    implements IMeasureOutInfo {
        public final int index;

        public MeasureInfo(int index) {
            this.index = index;
        }

        @Override
        public boolean isEnabled() {
            return this.index < StatisticsDevc.this.d_geom.getNumEnabledDevcOutputs();
        }

        @Override
        public IDoubleOutPin getPin() {
            return StatisticsDevc.this.d_outPins.get(this.index);
        }

        @Override
        public LogicOutPin getAlarmPin() {
            return StatisticsDevc.this.d_alarmPins.get(this.index);
        }

        @Override
        public void setAlarmInfo(AlarmInfo ai) {
            StatisticsDevc.this.setAlarmInfo(ai);
        }

        @Override
        public AlarmInfo getAlarmInfo() {
            return StatisticsDevc.this.getAlarmInfo();
        }
    }

    private class QuantReplacer
    extends QuantityReplacer {
        public QuantReplacer() {
            super((PyroMod)StatisticsDevc.this.getDomain());
        }

        @Override
        protected Task taskReplaceQuant(IQuantity oldMsr, IQuantity newMsr) {
            assert (newMsr != null);
            return new AReplaceRefTask<IQuantity>((Object)oldMsr, (Object)newMsr){

                @Override
                protected void set(IQuantity obj) {
                    StatisticsDevc.this.d_measurement = obj;
                    StatisticsDevc.this.changedEvt(new Object[0]);
                }
            };
        }
    }

    public static interface IStatOutPin
    extends IOutPin {
        public int getIndex();
    }

    private static class StatLogicOutPin
    extends LogicOutPin
    implements IStatOutPin {
        static final long serialVersionUID = 1L;
        public final int index;

        public StatLogicOutPin(StatisticsDevc source, int index) {
            super(source, source.d_geom.isArray() ? String.format(Intl.intl("ALARM-%d"), index + 1) : Intl.intl("ALARM"));
            this.index = index;
        }

        @Override
        public StatLogicOutPin clone() {
            return (StatLogicOutPin)super.clone();
        }

        @Override
        public StatLogicOutPin clone(ISignalSource newSource) {
            return (StatLogicOutPin)super.clone(newSource);
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            StatLogicOutPin pin = (StatLogicOutPin)obj;
            return super.equals(pin) && this.index == pin.index;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.index;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this.equals(obj);
        }
    }

    private static class OutPin
    extends APyroObject
    implements IDoubleOutPin,
    IStatOutPin {
        static final long serialVersionUID = 1L;
        @SkipDep
        private StatisticsDevc d_source;
        public final int index;

        public OutPin(StatisticsDevc source, int index) {
            this.d_source = source;
            this.index = index;
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
        }

        @Override
        public StatisticsDevc getAttachedSource() {
            return this.d_source;
        }

        @Override
        public void setSource(ISignalSource source) {
            assert (source instanceof StatisticsDevc);
            this.d_source = (StatisticsDevc)source;
        }

        @Override
        public int getIndex() {
            return this.index;
        }

        @Override
        public String getName() {
            return this.index == -1 ? Intl.intl("OUT") : String.format(Intl.intl("OUT-%d"), this.index + 1);
        }

        @Override
        public void setName(String id) {
        }

        @Override
        public int getUnitType() {
            return this.d_source.d_measurement.get().unitType;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !obj.getClass().equals(this.getClass())) {
                return false;
            }
            OutPin pin = (OutPin)obj;
            return this.getAttachedSource().equals(pin.getAttachedSource()) && this.index == pin.index;
        }

        @Override
        public OutPin clone(ISignalSource newSource) {
            OutPin pin = (OutPin)super.clone();
            assert (newSource instanceof StatisticsDevc);
            pin.d_source = (StatisticsDevc)newSource;
            return pin;
        }

        public int hashCode() {
            return 160596815 + this.getAttachedSource().hashCode() + this.index;
        }

        @Override
        public boolean isEquiv(Object obj) {
            return this.equals(obj);
        }
    }
}

