/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.measurers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.AlarmInfo;
import pyrosim.domain.devices.TripFlags;
import pyrosim.domain.ramp.Ramp;
import pyrosim.domain.ramp.SignalInput;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.IOutPin;
import pyrosim.domain.signals.LogicOutPin;

public interface IMeasureOutInfo {
    public IDoubleOutPin getPin();

    public LogicOutPin getAlarmPin();

    public void setAlarmInfo(AlarmInfo var1);

    public AlarmInfo getAlarmInfo();

    default public boolean latches() {
        return this.getAlarmInfo() != null ? TripFlags.latch(this.getAlarmInfo().tripFlags) : false;
    }

    public boolean isEnabled();

    default public List<IOutPin> getPins() {
        ArrayList<IOutPin> pins = new ArrayList<IOutPin>(2);
        this.getPins(pins);
        return pins;
    }

    default public void getPins(List<IOutPin> pins) {
        this.getPins(pins::add);
    }

    default public void getPins(Consumer<? super IOutPin> pins) {
        if (this.isEnabled()) {
            pins.accept(this.getPin());
            if (this.getAlarmInfo() != null) {
                pins.accept(this.getAlarmPin());
            }
        }
    }

    public static void disconnectDisabledPins(PyroMod domain, IPyroObject source, Set<? extends IOutPin> disabledPins) {
        if (disabledPins.isEmpty()) {
            return;
        }
        domain.pauseUpdates();
        DepSnapshot dss = domain.getDependencies(source);
        Set<Dependency> deps = dss.getDependents(source);
        for (Dependency dep : deps) {
            Object object = dep.source;
            if (object instanceof IInPin) {
                IInPin inPin = (IInPin)object;
                disabledPins.forEach(pin -> inPin.disconnect((IOutPin)pin));
                continue;
            }
            object = dep.source;
            if (!(object instanceof Ramp)) continue;
            Ramp r = (Ramp)object;
            if (!disabledPins.contains(((SignalInput)r.getInput()).input)) continue;
            r.taskSetInput(r.getDefaultInput()).run();
            for (IPyroObject pobj : dss.getAncestors(IPyroObject.class, source)) {
                pobj.changedEvt(new Object[0]);
            }
        }
        domain.resumeUpdates();
    }
}

