/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices.aspiration;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.APointSrcDevc;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.signals.DoubleOutPin;
import pyrosim.domain.signals.IDoubleOutPin;
import pyrosim.domain.signals.ILogicOutPin;
import pyrosim.domain.signals.ISignalSource;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.unitsystem.SIUS;
import pyrosim.util.Util;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;

public class Aspirator
extends APointSrcDevc
implements IMeasurer,
IDirectDependent {
    static final long serialVersionUID = 1L;
    private UnitDouble d_bypassFlowrate;
    private Map<AspiratorSampler, SamplerLine> d_samplerLines;
    private Object d_outPin;
    private OneLogicInPin d_freezePin;
    private static final IPrimProps s_primProps = new IPrimProps.Vertex(Color.DARK_GRAY, 10.0);

    public Aspirator(String name, FreePointLoc loc) {
        this(name, SIUS.newud(0.0, 38), loc);
    }

    public Aspirator(String name, UnitDouble bypassFlowrate, FreePointLoc loc) {
        super(name, loc);
        this.d_bypassFlowrate = bypassFlowrate;
        this.d_outPin = this.createOutInfo(new DoubleOutPin((ISignalSource)this, Quantity.ASPIRATION.unitType));
        this.d_samplerLines = new LinkedIdentityHashMap<AspiratorSampler, SamplerLine>();
        this.d_freezePin = new OneLogicInPin(this);
    }

    private MeasureOutInfo createOutInfo(IDoubleOutPin outPin) {
        return new MeasureOutInfo(this, true, outPin, Intl.intl("ALARM"));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (PyroSimObjectInputStream.getVersion(stream) < 29) {
            assert (this.d_outPin instanceof IDoubleOutPin);
            this.d_outPin = this.createOutInfo((IDoubleOutPin)this.d_outPin);
        }
        if (!(this.d_samplerLines instanceof LinkedIdentityHashMap)) {
            this.d_samplerLines = new LinkedIdentityHashMap<AspiratorSampler, SamplerLine>(this.d_samplerLines);
        }
        if (this.d_freezePin == null) {
            this.d_freezePin = new OneLogicInPin(this);
        }
    }

    @Override
    public Object clone() {
        Aspirator clone = (Aspirator)super.clone();
        clone.d_samplerLines = new LinkedIdentityHashMap<AspiratorSampler, SamplerLine>();
        clone.d_samplerLines.putAll(this.d_samplerLines);
        clone.d_outPin = ((MeasureOutInfo)this.d_outPin).clone(clone);
        clone.d_freezePin = (OneLogicInPin)this.d_freezePin.clone(clone);
        return clone;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Aspirator)) {
            return false;
        }
        Aspirator asp = (Aspirator)obj;
        return super.equals(obj) && this.d_bypassFlowrate.equals(asp.d_bypassFlowrate) && this.d_outPin.equals(asp.d_outPin) && Util.identityMapsEqual(this.d_samplerLines, asp.d_samplerLines) && this.d_freezePin.equals(asp.d_freezePin);
    }

    @Override
    public boolean latches(ILogicOutPin pin) {
        return this.getMsrInfo().latches();
    }

    @Override
    public OneLogicInPin getFreezePin() {
        return this.d_freezePin;
    }

    @Override
    public int getNumMeasurements() {
        return 1;
    }

    public IQuantity getQuantity() {
        return Quantity.ASPIRATION.create();
    }

    @Override
    public IQuantity getQuantity(int ix) {
        return this.getQuantity();
    }

    public MeasureOutInfo getMsrInfo() {
        return (MeasureOutInfo)this.d_outPin;
    }

    @Override
    public MeasureOutInfo getMsrInfo(int ix) {
        return this.getMsrInfo();
    }

    public UnitDouble getBypassFlowrate() {
        return this.d_bypassFlowrate;
    }

    public void setBypassFlowrate(UnitDouble rate) {
        this.d_bypassFlowrate = rate;
        this.changedEvt(new Object[0]);
    }

    public void setSamplerLines(Collection<SamplerLine> lines) {
        this.pauseUpdates();
        this.d_samplerLines.clear();
        for (SamplerLine line : lines) {
            this.setSamplerLine(line);
        }
        this.changedEvt(new Object[0]);
        this.resumeUpdates();
    }

    public Collection<SamplerLine> getSamplerLines() {
        return Collections.unmodifiableCollection(this.d_samplerLines.values());
    }

    public void setSamplerLine(SamplerLine line) {
        this.d_samplerLines.put(line.d_sampler, line);
        this.changedEvt(new Object[0]);
    }

    public boolean removeSamplerLine(AspiratorSampler sampler) {
        if (this.d_samplerLines.remove(sampler) != null) {
            this.changedEvt(new Object[0]);
            return true;
        }
        return false;
    }

    public SamplerLine getSamplerLine(AspiratorSampler sampler) {
        return this.d_samplerLines.get(sampler);
    }

    public boolean isConnectedTo(AspiratorSampler sampler) {
        return this.d_samplerLines.containsKey(sampler);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        deps.add(DLink.WEAK, this.d_samplerLines.keySet());
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
        if (old instanceof AspiratorSampler) {
            Util.keepIfNullOr(objs, AspiratorSampler.class);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (!(old instanceof AspiratorSampler)) {
            return super.taskReplaceDep(old, replacement);
        }
        return new AUndoableTask(){
            private SamplerLine d_oldLine;

            @Override
            public void undo() {
                Aspirator.this.d_samplerLines.put(this.d_oldLine.d_sampler, this.d_oldLine);
                Aspirator.this.changedEvt(new Object[0]);
            }

            @Override
            public void run() {
                this.d_oldLine = Aspirator.this.d_samplerLines.remove(old);
                if (replacement != null && !Aspirator.this.d_samplerLines.containsKey(replacement)) {
                    AspiratorSampler replSamp = (AspiratorSampler)replacement;
                    SamplerLine replLine = new SamplerLine(replSamp, this.d_oldLine.d_flowrate, this.d_oldLine.d_delay);
                    Aspirator.this.d_samplerLines.put(replSamp, replLine);
                }
                Aspirator.this.changedEvt(new Object[0]);
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return super.taskUpdateDep(dep, changes);
    }

    @Override
    protected IPrimProps getPrimProps() {
        return s_primProps;
    }

    public static class SamplerLine
    implements Serializable {
        static final long serialVersionUID = 1L;
        public final AspiratorSampler d_sampler;
        public final UnitDouble d_flowrate;
        public final UnitDouble d_delay;

        public SamplerLine(AspiratorSampler sampler) {
            this(sampler, SIUS.newud(0.0, 38), new UnitDouble(0.0, SI.SECOND));
        }

        public SamplerLine(AspiratorSampler sampler, UnitDouble flowrate, UnitDouble delay) {
            this.d_sampler = sampler;
            this.d_flowrate = flowrate;
            this.d_delay = delay;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof SamplerLine)) {
                return false;
            }
            SamplerLine line = (SamplerLine)obj;
            return this.d_sampler.equals(line.d_sampler) && this.d_flowrate.equals(line.d_flowrate) && this.d_delay.equals(line.d_delay);
        }

        public int hashCode() {
            return this.d_sampler.hashCode() + this.d_flowrate.hashCode() + this.d_delay.hashCode();
        }
    }
}

