/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.devices;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.signals.IInPin;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.util.Util;
import thunderheadeng.util.Task;

public class ControlValueDevice
extends GasPointMeasurer
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private ControlBridge d_bridge;
    private IInPin d_bridgePin;

    public ControlValueDevice(String name, ControlBridge bridge) {
        super(name, Quantity.CONTROL_VALUE.create(), new FreePointLoc());
        this.d_bridge = bridge;
        this.d_bridgePin = new OneLogicInPin(this);
        if (this.d_bridge != null) {
            this.d_bridgePin.connect(this.d_bridge.getLogicOutPin());
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof ControlValueDevice && super.equals(obj) && this.d_bridge.equals(((ControlValueDevice)obj).d_bridge);
    }

    public IInPin getBridgeAdapterPin() {
        return this.d_bridgePin;
    }

    public ControlBridge getLinkedControl() {
        return this.d_bridge;
    }

    public void setLinkedControl(ControlBridge bridge) {
        assert (this.d_bridge != null);
        this.d_bridge = bridge;
        this.d_bridgePin.disconnectAll();
        this.d_bridgePin.connect(bridge.getLogicOutPin());
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        super.takeDepSnapshot(deps);
        assert (this.d_bridge != null) : "A CustomCtrlDevice must have a control source";
        deps.add(DLink.STRONG, (IPyroObject)this.d_bridge);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        super.removeInvalidReplacements(old, objs);
        Util.keepIfNullOr(objs, ControlBridge.class);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        if (old == this.d_bridge) {
            assert (replacement != null);
            return new AReplaceRefTask<ControlBridge>((Object)old, (Object)replacement){

                @Override
                public void set(ControlBridge obj) {
                    ControlValueDevice.this.setLinkedControl(obj);
                }
            };
        }
        return super.taskReplaceDep(old, replacement);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return super.taskUpdateDep(dep, changes);
    }
}

