/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.dependencies;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Serialized;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.dependencies.SkipDep;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theTimer;
import thunderheadeng.util.theUtil;

public class DepSnapshot {
    private final Map<Object, Set<IParentEntry>> d_map;
    private final Set<?> d_interestingDepOns;
    private Map<Class, List<Field>> d_fieldCache = new HashMap<Class, List<Field>>();
    private static final Predicate<Field> s_fieldFilter = field -> !Modifier.isStatic(field.getModifiers()) && !DepSnapshot.isSkippable(field.getType()) && !field.isAnnotationPresent(SkipDep.class);
    private static final Function<Class, List<Field>> s_fieldFunc = clazz -> new ArrayList<Field>(theUtil.filter(Arrays.asList(clazz.getDeclaredFields()), s_fieldFilter));
    private static final Set<? extends Class> s_skipClazzes = Sets.fromArrayHS(String.class, Boolean.class, Boolean.TYPE, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, PyroSim.class);

    public DepSnapshot() {
        this(Collections.EMPTY_LIST);
    }

    public DepSnapshot(Collection<?> interestingDepOns) {
        this.d_map = new LinkedIdentityHashMap<Object, Set<IParentEntry>>();
        this.d_interestingDepOns = interestingDepOns instanceof Set ? (Set<Object>)interestingDepOns : (interestingDepOns.isEmpty() ? Collections.EMPTY_SET : new IdentityHashSet(interestingDepOns));
    }

    public void start(PyroMod root, Serialized ser) {
        theTimer timer = new theTimer();
        this.add(root, ser, DLink.WEAK);
        System.out.println("DepSnapshot: " + timer.curr());
    }

    private boolean add(Object parent, Object child, DLink link) {
        if (child == null) {
            return false;
        }
        assert (parent != null);
        boolean childImportant = this.takeSnapshot(child);
        if (childImportant) {
            Set<IParentEntry> revDeps = this.d_map.get(child);
            assert (revDeps != null);
            if (parent instanceof IDirectDependent) {
                DirectEntry entry = new DirectEntry(link, (IDirectDependent)parent);
                if (link != DLink.WEAK) {
                    revDeps.remove(entry);
                }
                revDeps.add(entry);
            } else {
                revDeps.add(new IndirectEntry(parent));
            }
        }
        return childImportant;
    }

    /*
     * WARNING - void declaration
     */
    public boolean takeSnapshot(Object obj) {
        boolean recordDependency;
        if (obj instanceof PyroMod) {
            return false;
        }
        if (this.d_map.containsKey(obj)) {
            Set<IParentEntry> parents = this.d_map.get(obj);
            return parents != null;
        }
        this.d_map.put(obj, new LinkedHashSet());
        boolean bl = recordDependency = this.d_interestingDepOns.isEmpty() && obj instanceof IPyroObject || this.d_interestingDepOns.contains(obj);
        if (obj instanceof IDirectDependent) {
            Iterator deps = new DepList((IDirectDependent)obj);
            ((IDirectDependent)obj).takeDepSnapshot((DepList)((Object)deps));
            for (Pair<DLink, IPyroObject> pair : ((DepList)((Object)deps)).getLinks()) {
                recordDependency |= this.add(obj, pair.v2, (DLink)((Object)pair.v1));
            }
        }
        if (obj instanceof Composite) {
            for (Object e : ((Composite)obj).getMembers()) {
                recordDependency |= this.takeSnapshot(e);
            }
        } else if (!(obj instanceof IDirectDependent) && obj instanceof Collection) {
            for (Object e : (Collection)obj) {
                recordDependency |= this.checkTypeAndAdd(obj, e);
            }
        } else if (!(obj instanceof IDirectDependent) && obj instanceof Map) {
            Set entries = ((Map)obj).entrySet();
            for (Map.Entry entry : entries) {
                recordDependency |= this.checkTypeAndAdd(obj, entry.getKey());
                recordDependency |= this.checkTypeAndAdd(obj, entry.getValue());
            }
        } else if (obj.getClass().isArray()) {
            Class<?> compType = obj.getClass().getComponentType();
            if (!DepSnapshot.isSkippable(compType)) {
                void var5_19;
                int n = Array.getLength(obj);
                boolean bl2 = false;
                while (var5_19 < n) {
                    recordDependency |= this.checkTypeAndAdd(obj, Array.get(obj, (int)var5_19));
                    ++var5_19;
                }
            }
        } else {
            try {
                for (Class<?> clazz = obj.getClass(); clazz != null && !clazz.getName().startsWith("java"); clazz = clazz.getSuperclass()) {
                    for (Field field : this.d_fieldCache.computeIfAbsent(clazz, s_fieldFunc)) {
                        boolean accessible = field.isAccessible();
                        if (!accessible) {
                            field.setAccessible(true);
                        }
                        Object member = field.get(obj);
                        if (!accessible) {
                            field.setAccessible(false);
                        }
                        if (member == null) continue;
                        recordDependency |= this.checkTypeAndAdd(obj, member);
                    }
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                assert (false);
            }
        }
        if (!recordDependency) {
            this.d_map.put(obj, null);
        }
        return recordDependency;
    }

    private boolean checkTypeAndAdd(Object parent, Object child) {
        if (DepSnapshot.isSkippable(child)) {
            return false;
        }
        return this.add(parent, child, DLink.WEAK);
    }

    private static boolean isSkippable(Object o) {
        return o == null || DepSnapshot.isSkippable(o.getClass());
    }

    private static boolean isSkippable(Class clazz) {
        return s_skipClazzes.contains(clazz) || IGeom.class.isAssignableFrom(clazz) || IGeomNode.class.isAssignableFrom(clazz) || IElemSource.class.isAssignableFrom(clazz);
    }

    public <T> Set<T> findAllDependents(Class<T> dependentType, Object child) {
        LinkedIdentityHashSet deps = new LinkedIdentityHashSet();
        TypeFilter<Object> filter = new TypeFilter<Object>(dependentType);
        this.findAllDependents(filter, child, deps);
        return deps;
    }

    public Set<Object> findAllDependents(Predicate<Object> filter, Object child) {
        LinkedIdentityHashSet<Object> deps = new LinkedIdentityHashSet<Object>();
        this.findAllDependents(filter, child, deps);
        return deps;
    }

    public void findAllDependents(Predicate<Object> filter, Object obj, Set deps) {
        LinkedIdentityHashSet closed = new LinkedIdentityHashSet();
        ArrayDeque<Object> open = new ArrayDeque<Object>();
        open.addLast(obj);
        closed.add(obj);
        while (!open.isEmpty()) {
            Object child = open.removeLast();
            Set<IParentEntry> parents = this.d_map.get(child);
            if (parents == null) continue;
            for (IParentEntry parentEntry : parents) {
                Object source = parentEntry.getSource();
                if (filter.test(source)) {
                    deps.add(source);
                    continue;
                }
                if (!closed.add(source)) continue;
                open.addLast(source);
            }
        }
    }

    public Set<IPyroObject> getAllDependedOn() {
        Predicate<IPyroObject> filter = new Predicate<IPyroObject>(){

            @Override
            public boolean test(IPyroObject o) {
                Set<IParentEntry> parents = DepSnapshot.this.d_map.get(o);
                return parents != null && !parents.isEmpty();
            }
        };
        return theUtil.filter(this.d_map.keySet(), IPyroObject.class, filter);
    }

    public Set<Dependency> getDependents(IPyroObject o) {
        Set<IParentEntry> deps = this.d_map.get(o);
        if (deps == null || deps.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        Function<DirectEntry, Dependency> transformer = new Function<DirectEntry, Dependency>(this){

            @Override
            public Dependency apply(DirectEntry obj) {
                return new Dependency(obj.link, obj.source);
            }
        };
        Function<Dependency, DirectEntry> invTransformer = new Function<Dependency, DirectEntry>(this){

            @Override
            public DirectEntry apply(Dependency obj) {
                return new DirectEntry(obj.link, obj.source);
            }
        };
        IFilteredCollection<DirectEntry> directParents = theUtil.filter(deps, DirectEntry.class);
        return theUtil.map(directParents, transformer, invTransformer, Dependency.class);
    }

    public <T> Set<T> getAncestors(Class<T> clazz, Object dependedOn) {
        LinkedIdentityHashSet ancestors = new LinkedIdentityHashSet();
        ArrayDeque<Object> depOnQueue = new ArrayDeque<Object>();
        depOnQueue.push(dependedOn);
        while (!depOnQueue.isEmpty()) {
            Object currDepOn = depOnQueue.pop();
            Set<IParentEntry> parents = this.d_map.get(currDepOn);
            if (parents == null) continue;
            for (IParentEntry parentEntry : parents) {
                Object source = parentEntry.getSource();
                if (clazz.isInstance(source)) {
                    ancestors.add(clazz.cast(source));
                    continue;
                }
                depOnQueue.push(source);
            }
        }
        return ancestors;
    }

    public void removeMappings(Collection<?> objs) {
        this.d_map.keySet().removeAll(objs);
    }

    private static class DirectEntry
    implements IParentEntry {
        public final DLink link;
        public final IDirectDependent source;

        public DirectEntry(DLink link, IDirectDependent source) {
            this.source = source;
            this.link = link;
        }

        public int hashCode() {
            return -1826424077 + System.identityHashCode(this.source);
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof DirectEntry && this.source == ((DirectEntry)obj).source;
        }

        @Override
        public Object getSource() {
            return this.source;
        }
    }

    private static class IndirectEntry
    implements IParentEntry {
        public final Object obj;

        public IndirectEntry(Object obj) {
            this.obj = obj;
        }

        public int hashCode() {
            return System.identityHashCode(this.obj);
        }

        public boolean equals(Object o) {
            return o == this || o == this.obj || o instanceof IndirectEntry && ((IndirectEntry)o).obj == this.obj;
        }

        @Override
        public Object getSource() {
            return this.obj;
        }
    }

    private static interface IParentEntry {
        public Object getSource();
    }
}

