/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.surf;

import java.io.ObjectStreamException;
import java.io.Serializable;
import pyrosim.unitsystem.SIUS;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.theUtil;

public interface ISlip
extends Serializable {
    public static final ISlip DEFAULT = new RoughSlip(SIUS.newud(0.0, 0));
    public static final FreeSlip FREE_SLIP = new FreeSlip();
    public static final NoSlip NO_SLIP = new NoSlip();

    public static class RoughSlip
    implements ISlip {
        static final long serialVersionUID = 1L;
        public final UnitDouble roughness;

        public RoughSlip(UnitDouble roughness) {
            this.roughness = roughness;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.roughness);
            return hash;
        }

        public boolean equals(Object obj) {
            return obj instanceof RoughSlip && ((RoughSlip)obj).roughness.equals(this.roughness);
        }
    }

    public static class FreeSlip
    implements ISlip {
        static final long serialVersionUID = 1L;

        private FreeSlip() {
        }

        private Object readResolve() throws ObjectStreamException {
            return FREE_SLIP;
        }
    }

    public static class NoSlip
    implements ISlip {
        static final long serialVersionUID = 1L;

        private NoSlip() {
        }

        private Object readResolve() throws ObjectStreamException {
            return NO_SLIP;
        }
    }
}

