/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.boundcond.mat;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.Reaction;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.util.Util;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AUndoableTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class ReacByproducts
implements IDirectDependent,
Serializable {
    static final long serialVersionUID = 1L;
    private final Map<NamedPyroObject, Residue> d_residues = new LinkedIdentityHashMap<NamedPyroObject, Residue>();
    public UnitDouble d_heat;

    public ReacByproducts() {
        this(null, null, null, null, null);
    }

    public ReacByproducts(ReacByproducts bp) {
        for (Residue r : bp.getResidues()) {
            this.d_residues.put(r.d_type, r);
        }
        this.d_heat = bp.d_heat;
    }

    public ReacByproducts(List<Double> nuMatl, List<Material> matlId, List<Double> nuSpec, List<ExSpec> specId, UnitDouble heat) {
        if (nuMatl != null && matlId != null && nuMatl.size() == matlId.size()) {
            for (int i = 0; i < nuMatl.size(); ++i) {
                this.d_residues.put(matlId.get(i), new Residue(nuMatl.get(i), matlId.get(i)));
            }
        }
        if (nuSpec != null && specId != null && nuSpec.size() == specId.size()) {
            for (int j = 0; j < nuSpec.size(); ++j) {
                this.d_residues.put(specId.get(j), new Residue(nuSpec.get(j), specId.get(j)));
            }
        }
        this.d_heat = heat;
    }

    public int hashCode() {
        int hash = 11;
        hash = 31 * hash + theUtil.hashCode(this.d_heat);
        hash = 31 * hash + theUtil.hashCode(this.d_residues);
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ReacByproducts)) {
            return false;
        }
        ReacByproducts byp = (ReacByproducts)obj;
        return Objects.equals(this.d_heat, byp.d_heat) && ReacByproducts.equal(this.d_residues, byp.d_residues);
    }

    private static boolean equal(Map<NamedPyroObject, Residue> residues1, Map<NamedPyroObject, Residue> residues2) {
        if (residues1.size() != residues2.size()) {
            return false;
        }
        BitSet found2 = new BitSet(residues2.size());
        for (Residue r1 : residues1.values()) {
            boolean found = false;
            int ix2 = 0;
            for (Residue r2 : residues2.values()) {
                if (found2.get(ix2)) {
                    ++ix2;
                    continue;
                }
                if (r1.equals(r2)) {
                    found = true;
                    found2.set(ix2);
                    ++ix2;
                    break;
                }
                ++ix2;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public Collection<Residue> getResidues() {
        return this.d_residues.values();
    }

    public List<Material> getMaterials() {
        ArrayList<Material> mats = new ArrayList<Material>();
        for (Residue r : this.d_residues.values()) {
            if (!(r.d_type instanceof Material)) continue;
            mats.add((Material)r.d_type);
        }
        return mats;
    }

    public List<ExSpec> getSpecies() {
        ArrayList<ExSpec> specs = new ArrayList<ExSpec>();
        for (Residue r : this.d_residues.values()) {
            if (!(r.d_type instanceof ExSpec)) continue;
            specs.add((ExSpec)r.d_type);
        }
        return specs;
    }

    public List<Double> getNuMaterials() {
        ArrayList<Double> nuMats = new ArrayList<Double>();
        for (Residue r : this.d_residues.values()) {
            if (!(r.d_type instanceof Material)) continue;
            nuMats.add(r.d_fraction);
        }
        return nuMats;
    }

    public List<Double> getNuSpecies() {
        ArrayList<Double> nuSpecs = new ArrayList<Double>();
        for (Residue r : this.d_residues.values()) {
            if (!(r.d_type instanceof ExSpec)) continue;
            nuSpecs.add(r.d_fraction);
        }
        return nuSpecs;
    }

    public void addResidue(NamedPyroObject residue, double nuResidue) {
        this.d_residues.put(residue, new Residue(nuResidue, residue));
    }

    public boolean residueCreatesCycle(Material residue) {
        for (Reaction reaction : residue.getPyrolysis().getReactions()) {
            ReacByproducts byprod = reaction.d_byproducts;
            if (byprod == this) {
                return true;
            }
            for (Material mat : byprod.getMaterials()) {
                if (!this.residueCreatesCycle(mat)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        for (Residue r : this.d_residues.values()) {
            deps.add(DLink.WEAK, (IPyroObject)r.d_type);
        }
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        if (old instanceof Material) {
            Util.keepIfNullOr(objs, Material.class);
            ArrayList<Material> toRemove = new ArrayList<Material>();
            for (Material residue : objs) {
                if (residue == null) continue;
                Set<Material> descendants = residue.getResidueMaterials();
                if (descendants == null) {
                    return;
                }
                if (!descendants.contains(old)) continue;
                toRemove.add(residue);
            }
            objs.removeAll(toRemove);
        }
        if (old instanceof ExSpec) {
            Util.keepIfNullOr(objs, ExSpec.class);
        }
    }

    @Override
    public Task taskReplaceDep(final IPyroObject old, final IPyroObject replacement) {
        if (!this.d_residues.containsKey(old)) {
            return null;
        }
        return new AUndoableTask(){
            private Map<NamedPyroObject, Residue> d_oldRes;

            @Override
            public void undo() {
                ReacByproducts.this.d_residues.clear();
                ReacByproducts.this.d_residues.putAll(this.d_oldRes);
                this.d_oldRes = null;
            }

            @Override
            public void run() {
                this.d_oldRes = new LinkedIdentityHashMap<NamedPyroObject, Residue>(ReacByproducts.this.d_residues);
                Residue oldRes = ReacByproducts.this.d_residues.remove(old);
                Residue existingRes = ReacByproducts.this.d_residues.get(replacement);
                if (existingRes == null && replacement != null) {
                    Residue newRes = new Residue(oldRes.d_fraction, (NamedPyroObject)replacement);
                    ReacByproducts.this.d_residues.put((NamedPyroObject)replacement, newRes);
                } else if (replacement != null) {
                    Residue combinedComp = new Residue(oldRes.d_fraction + existingRes.d_fraction, (NamedPyroObject)replacement);
                    ReacByproducts.this.d_residues.put((NamedPyroObject)replacement, combinedComp);
                }
            }
        };
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    private Object readResolve() throws ObjectStreamException {
        for (Map.Entry<NamedPyroObject, Residue> entr : this.d_residues.entrySet()) {
            if (entr.getKey() != null) continue;
            Residue newRes = new Residue(entr.getValue().d_fraction, ExSpecList.getDefaultFuel(true));
            this.d_residues.remove(entr.getKey());
            this.d_residues.put(newRes.d_type, newRes);
        }
        return this;
    }

    public static final class Residue
    implements Serializable {
        static final long serialVersionUID = -7132955491265279813L;
        public final double d_fraction;
        public final NamedPyroObject d_type;

        public Residue(double fraction, NamedPyroObject type) {
            this.d_fraction = fraction;
            this.d_type = type;
        }

        public int hashCode() {
            int hash = 7;
            hash = 31 * hash + theUtil.hashCode(this.d_fraction);
            hash = 31 * hash + theUtil.hashCode(this.d_type);
            return hash;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Residue)) {
                return false;
            }
            Residue res = (Residue)obj;
            return this.d_fraction == res.d_fraction && Objects.equals(this.d_type, res.d_type);
        }
    }
}

