/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.auditing;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.stream.Collectors;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.auditing.ICheckDesc;
import pyrosim.domain.auditing.ModelCheck;
import pyrosim.domain.auditing.ModelCheckFilter;
import pyrosim.domain.auditing.ModelWarning;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSRecordCollector;
import pyrosim.io.fds.FDSRecordSpec;
import pyrosim.io.fds.FDSRenderProps;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.io.fds.FDSRenderer;

public class RecordCheckDesc
implements ICheckDesc {
    private static final long serialVersionUID = 1L;
    private ArrayList<ModelCheckFilter<?>> d_filters;
    private static String PASS_VALUE = Intl.intl("Check Passed");
    private static String FAIL_VALUE = Intl.intl("Check Failed");

    public RecordCheckDesc(ArrayList<ModelCheckFilter<?>> filters) {
        this.d_filters = filters;
    }

    public ArrayList<ModelCheckFilter<?>> getFilters() {
        return this.d_filters;
    }

    public void setFilters(ArrayList<ModelCheckFilter<?>> mcfs) {
        this.d_filters = mcfs;
    }

    @Override
    public Collection<ModelWarning> getModelWarnings(PyroMod pyroMod, ModelCheck check) {
        if (this.getFilters().isEmpty()) {
            return new ArrayList<ModelWarning>();
        }
        File tempFDSFile = new File("modelcheck.fds");
        tempFDSFile.deleteOnExit();
        FDSRecordCollector collector = new FDSRecordCollector(new FDSRenderProps());
        FDSRenderer renderer = FDS.newRenderer(pyroMod, new FDSRenderProps(), FDSRenderer.RENDER_ORIGIN.DEFAULT);
        renderer.renderAllObjects(collector, Collections.EMPTY_MAP);
        Map<IPyroObject, List<FDSRenderRecord>> recordMap = collector.getRecordMap();
        HashMap<FDSRenderRecord, List> recordObjMap = new HashMap<FDSRenderRecord, List>();
        HashMap<FDSRecordSpec, List> specRecordMap = new HashMap<FDSRecordSpec, List>();
        ArrayList<FDSRenderRecord> records = new ArrayList<FDSRenderRecord>();
        for (IPyroObject obj : recordMap.keySet()) {
            List<FDSRenderRecord> mapRecords = recordMap.get(obj);
            for (FDSRenderRecord record : mapRecords) {
                recordObjMap.computeIfAbsent(record, r -> new ArrayList());
                ((List)recordObjMap.get(record)).add(obj);
                records.add(record);
                specRecordMap.computeIfAbsent(record.getSpec(), K -> new ArrayList());
                ((List)specRecordMap.get(record.getSpec())).add(record);
            }
        }
        LinkedList<ModelCheckFilter> filtersQueue = new LinkedList<ModelCheckFilter>();
        filtersQueue.addAll(this.getFilters());
        ArrayList<ModelWarning> warnings = new ArrayList<ModelWarning>();
        Collection<FDSRenderRecord> filteredRecords = this.filter(records, records, filtersQueue);
        String val = check.checkCondition(filteredRecords) ? PASS_VALUE : FAIL_VALUE;
        for (FDSRenderRecord record : filteredRecords) {
            warnings.add(new ModelWarning(check.getName(), check.getDescription(), val, (Collection)recordObjMap.get(record)));
        }
        if (warnings.isEmpty()) {
            warnings.add(new ModelWarning(check.getName(), check.getDescription(), val, Collections.EMPTY_SET));
        }
        return warnings;
    }

    public Collection<FDSRenderRecord> filter(Collection<FDSRenderRecord> records, Collection<FDSRenderRecord> filteredRecords, Queue<ModelCheckFilter> checkFilters) {
        ModelCheckFilter checkFilter = checkFilters.poll();
        if (checkFilter == null) {
            return filteredRecords;
        }
        if (checkFilter.getOp().equals((Object)ModelCheck.Op.AND)) {
            return this.filter(records, filteredRecords.stream().distinct().filter(checkFilter.filter(filteredRecords)::contains).collect(Collectors.toCollection(ArrayList::new)), checkFilters);
        }
        if (checkFilter.getOp().equals((Object)ModelCheck.Op.OR)) {
            filteredRecords.addAll(this.filter(records, checkFilter.filter(records), checkFilters));
            return filteredRecords;
        }
        return Collections.EMPTY_LIST;
    }
}

