/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain.auditing;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.auditing.ICheckDesc;
import pyrosim.domain.auditing.IResultCondition;
import pyrosim.domain.auditing.ModelWarning;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.io.fds.FDSRenderRecord;
import pyrosim.util.Util;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.Task;

public class ModelCheck
extends NamedPyroObject
implements ITaggable {
    private static final long serialVersionUID = -753615434228082754L;
    private String d_description;
    private Set<Tag> d_tags;
    private IResultCondition d_resultCondition;
    private ICheckDesc d_checkDesc;

    public ModelCheck(String name, String description, IResultCondition resultCondition, ICheckDesc checkDesc) {
        super(name);
        this.d_description = description;
        this.d_resultCondition = resultCondition;
        this.d_checkDesc = checkDesc;
        this.d_tags = Collections.emptySet();
    }

    public Collection<ModelWarning> getModelWarnings(PyroMod pyroMod) {
        return this.d_checkDesc.getModelWarnings(pyroMod, this);
    }

    public String getDescription() {
        return this.d_description;
    }

    public void setDescription(String desc) {
        this.d_description = desc;
        this.changedEvt(new Object[0]);
    }

    public IResultCondition getResultCondition() {
        return this.d_resultCondition;
    }

    public void setResultCondition(IResultCondition condition) {
        this.d_resultCondition = condition;
    }

    public ICheckDesc getCheckDesc() {
        return this.d_checkDesc;
    }

    public void setCheckDesc(ICheckDesc checkDesc) {
        this.d_checkDesc = checkDesc;
    }

    public boolean checkCondition(Collection<FDSRenderRecord> records) {
        return this.getResultCondition().checkCondition(records);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        return ITaggable.taskReplaceTagDep(old, replacement, this);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return EmptyTask.INSTANCE;
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean isEquiv(Object obj) {
        return this.equals(obj);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ModelCheck)) {
            return false;
        }
        ModelCheck modelCheck = (ModelCheck)obj;
        return super.equals(modelCheck) && modelCheck.getDescription().equals(this.getDescription()) && modelCheck.getCheckDesc().equals(this.getCheckDesc()) && modelCheck.getResultCondition().equals(this.getResultCondition()) && modelCheck.isEnabled() == this.isEnabled() && Util.identitySetsEqual(this.getTags(), modelCheck.getTags());
    }

    public static enum Op {
        AND,
        OR;

    }

    public static enum Condition {
        EQ(Intl.intl("=")),
        NEQ(Intl.intl("\u2260")),
        LT(Intl.intl("<")),
        GT(Intl.intl(">")),
        LTE(Intl.intl("<=")),
        GTE(Intl.intl(">="));

        public final String presentationStr;

        private Condition(String presentationStr) {
            this.presentationStr = presentationStr;
        }

        public String toString() {
            return this.presentationStr;
        }
    }
}

