/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Consumer;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.BaseUnit;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.PyroMod;
import pyrosim.domain.CustomFDSProps;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.dependencies.DepList;
import pyrosim.domain.dependencies.IDirectDependent;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.domain.tags.ITaggable;
import pyrosim.domain.tags.Tag;
import pyrosim.geom.Geometry;
import pyrosim.geom.TexCoordGenerator;
import pyrosim.io.PyroSimObjectInputStream;
import pyrosim.util.Util;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.ConvexHull;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.manip.IManipulatable;
import thunderheadeng.geometry.manip.ManipException;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IBoxCollector;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IIsectCollector;
import thunderheadeng.geometry.objs.IPointOptimizer;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.geometry.search.IResult;
import thunderheadeng.geometry.search.ITest;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IDisplayProps;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PlanarCoordMapper;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.CancelObjectPicking;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.ISnapConstraint;
import thunderheadeng.units.GeomUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.EmptyTask;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Task;
import thunderheadeng.util.theUtil;

public class Grid
extends NamedPyroObject
implements IPyroGeomSrc,
ICustomFDSPropsContainer,
ITaggable,
IDirectDependent {
    static final long serialVersionUID = 1L;
    public static final int FACE_MIN_X = 0;
    public static final int FACE_MAX_X = 1;
    public static final int FACE_MIN_Y = 2;
    public static final int FACE_MAX_Y = 3;
    public static final int FACE_MIN_Z = 4;
    public static final int FACE_MAX_Z = 5;
    public static final double DEFAULT_CELL_SIZE = 0.2;
    public static final int DEFAULT_NUM_X_CELLS = 50;
    public static final int DEFAULT_NUM_Y_CELLS = 50;
    public static final int DEFAULT_NUM_Z_CELLS = 15;
    private UnitPoint3D d_minPoint;
    private UnitPoint3D d_maxPoint;
    private UnitDouble[] d_x;
    private UnitDouble[] d_y;
    private UnitDouble[] d_z;
    private String d_fyi;
    private Color d_color;
    private Set<Tag> d_tags;
    private boolean d_visible = true;
    private CustomFDSProps d_customProps;
    @Deprecated
    private boolean d_syncTimeStep = true;
    @Deprecated
    private boolean d_evacuation = false;
    @Deprecated
    private boolean d_evacHumans = false;
    @Deprecated
    private UnitDouble d_evacZOffset = new UnitDouble(1.0, SI.METER);

    public Grid(String name) {
        this(name, Geometry.UP3D_ZERO, new UnitPoint3D(10.0, 10.0, 3.0, SI.METER), 20, 20, 6);
    }

    public Grid(String name, UnitPoint3D minPoint, UnitPoint3D maxPoint, int xCells, int yCells, int zCells) {
        this(name, minPoint, maxPoint, Grid.makeUniformDivisions(xCells, minPoint.xu(), maxPoint.xu()), Grid.makeUniformDivisions(yCells, minPoint.yu(), maxPoint.yu()), Grid.makeUniformDivisions(zCells, minPoint.zu(), maxPoint.zu()));
    }

    public Grid(String name, GridGeom geom) {
        this(name, geom.min, geom.max, geom.dx, geom.dy, geom.dz);
    }

    public Grid(String name, UnitPoint3D minPoint, UnitPoint3D maxPoint, UnitDouble[] xCellWidths, UnitDouble[] yCellWidths, UnitDouble[] zCellWidths) {
        this.d_customProps = CustomFDSProps.EMPTY;
        this.d_tags = Collections.emptySet();
        this.setName(name);
        this.setGeom(minPoint, maxPoint, xCellWidths, yCellWidths, zCellWidths);
    }

    private void setGeom(UnitPoint3D minPoint, UnitPoint3D maxPoint, UnitDouble[] xCellWidths, UnitDouble[] yCellWidths, UnitDouble[] zCellWidths) {
        this.d_minPoint = minPoint;
        this.d_maxPoint = maxPoint;
        this.d_x = xCellWidths;
        this.d_y = yCellWidths;
        this.d_z = zCellWidths;
        this.changedEvt(new Object[0]);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 29) {
            this.d_visible = true;
        }
        if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 30) {
            this.d_evacuation = false;
            this.d_evacHumans = false;
            this.d_evacZOffset = new UnitDouble(1.0, SI.METER);
        }
        if (stream instanceof PyroSimObjectInputStream && ((PyroSimObjectInputStream)stream).getVersion() < 84 && this.d_customProps == null) {
            this.d_customProps = CustomFDSProps.EMPTY;
        }
        if (this.d_tags == null) {
            this.d_tags = Collections.emptySet();
        }
    }

    @Override
    public Set<Tag> getTags() {
        return this.d_tags;
    }

    @Override
    public void setTags(Set<Tag> tags) {
        this.d_tags = tags;
        this.changedEvt(new Object[0]);
    }

    @Override
    public void takeDepSnapshot(DepList deps) {
        ITaggable.addTagsToDepSnapshot(this, deps);
    }

    @Override
    public <T extends IPyroObject> void removeInvalidReplacements(T old, Set<T> objs) {
        ITaggable.removeInvalidTagReplacements(old, objs);
    }

    @Override
    public Task taskReplaceDep(IPyroObject old, IPyroObject replacement) {
        return ITaggable.taskReplaceTagDep(old, replacement, this);
    }

    @Override
    public Task taskUpdateDep(IPyroObject dep, Collection<Object> changes) {
        return ITaggable.getTagUpdateDep();
    }

    @Override
    public IGeomNode getGeom() {
        return GeomNodeUtil.newNode(this.getGridGeom());
    }

    public IGeom getGridGeom() {
        return new GridGeom(this.d_minPoint, this.d_maxPoint, this.d_x, this.d_y, this.d_z);
    }

    @Override
    public void setGeom(IGeomNode geom) {
        this.setGeom(geom.flatten().getLocalGeom());
    }

    public void setGeom(IGeom geom) {
        if (geom instanceof GridGeom) {
            GridGeom gg = (GridGeom)geom;
            this.setGeom(gg.min, gg.max, gg.dx, gg.dy, gg.dz);
        }
    }

    @Override
    public DisplayGeom getDisplayGeom(IDisplayProps drawProps) {
        Surface surf = null;
        if (this.getDomain() != null) {
            surf = ((PyroMod)this.getDomain()).getSimParams().getMisc().getSurfDefault();
        }
        IGeomNode geom = this.getGeom();
        PlanarCoordMapper texGen = TexCoordGenerator.newGenerator(geom, TexOrigin.DEF_WORLD);
        IPropertySet elements = Elements.newElements("teciuv0x193fa", texGen);
        geom = geom.applyLocalElements(elements);
        Color color = Grid.resolveColor(this.getColor(), surf);
        return new DisplayGeom(geom, (IPrimProps)new IPrimProps.Face(color, surf, 2));
    }

    private static Color resolveColor(Color c, Surface s) {
        if (c != null) {
            return c;
        }
        return s.getColor();
    }

    @Override
    public boolean isVisible() {
        return this.d_visible;
    }

    @Override
    public void setVisible(boolean visible) {
        if (this.d_visible != visible) {
            this.d_visible = visible;
            this.changedEvt(PyroMod.EVT_VISIBILITY_CHANGED);
        }
    }

    public TexOrigin getTextureOrigin() {
        return TexOrigin.DEF_WORLD;
    }

    public Task taskImprint(Object baseObject) {
        if (baseObject instanceof Grid) {
            return EmptyTask.INSTANCE;
        }
        final Grid grid = (Grid)baseObject;
        return new AOneTimeTask(){

            @Override
            public void run() {
                Grid.this.imprint(grid);
            }
        };
    }

    public String getFYI() {
        return this.d_fyi == null ? "" : this.d_fyi;
    }

    public void setFYI(String fyi) {
        this.d_fyi = fyi;
        this.changedEvt(new Object[0]);
    }

    public UnitDouble getVolume() {
        return pyrosim.geom.Util.calcVolume(this.d_minPoint, this.d_maxPoint);
    }

    public boolean syncTimeStep() {
        return this.d_syncTimeStep;
    }

    public void setSyncTimeStep(boolean sync) {
        this.d_syncTimeStep = sync;
        this.changedEvt(new Object[0]);
    }

    public void setColor(Color c) {
        this.d_color = c;
        this.changedEvt(new Object[0]);
    }

    public Color getColor() {
        return this.d_color;
    }

    public void setEvacuation(boolean flag) {
        if (this.d_evacuation != flag) {
            this.d_evacuation = flag;
            this.changedEvt(new Object[0]);
        }
    }

    public boolean getEvacuation() {
        return this.d_evacuation;
    }

    public void setEvacHumans(boolean flag) {
        if (this.d_evacHumans != flag) {
            this.d_evacHumans = flag;
            this.changedEvt(new Object[0]);
        }
    }

    public boolean getEvacHumans() {
        return this.d_evacHumans;
    }

    public void setEvacZOffset(UnitDouble ud) {
        if (this.d_evacZOffset != ud) {
            this.d_evacZOffset = ud;
            this.changedEvt(new Object[0]);
        }
    }

    public UnitDouble getEvacZOffset() {
        return this.d_evacZOffset;
    }

    @Override
    public Object clone() {
        Grid clone = (Grid)super.clone();
        clone.imprint(this);
        return clone;
    }

    public Task taskRefine(double factor) {
        return new RefineGridTask(this, factor);
    }

    private void coarsen(double factor) {
        int minDivsOnAxis = 3;
        this.d_x = Grid.makeUniformDivisions(this.getRefinedDivisionsN(this.getXDivisions().length, 3, factor), this.getMinPoint().xu(), this.getMaxPoint().xu());
        this.d_y = Grid.makeUniformDivisions(this.getRefinedDivisionsN(this.getYDivisions().length, 3, factor), this.getMinPoint().yu(), this.getMaxPoint().yu());
        this.d_z = Grid.makeUniformDivisions(this.getRefinedDivisionsN(this.getZDivisions().length, 3, factor), this.getMinPoint().zu(), this.getMaxPoint().zu());
        this.changedEvt(new Object[0]);
    }

    private void refine(int cellsPerDiv) {
        this.d_x = Grid.getRefinedDivisions(this.getXDivisions(), cellsPerDiv);
        this.d_y = Grid.getRefinedDivisions(this.getYDivisions(), cellsPerDiv);
        this.d_z = Grid.getRefinedDivisions(this.getZDivisions(), cellsPerDiv);
        this.changedEvt(new Object[0]);
    }

    private static UnitDouble[] getRefinedDivisions(UnitDouble[] divs, int cellsPerDiv) {
        assert (0 < cellsPerDiv);
        Object[] refined = new UnitDouble[divs.length * cellsPerDiv];
        for (int i = 0; i < divs.length; ++i) {
            UnitDouble div = divs[i];
            UnitDouble refDiv = new UnitDouble(div.getValueNoUnit() / (double)cellsPerDiv, div.getUnit());
            int insertAt = i * cellsPerDiv;
            Arrays.fill(refined, insertAt, insertAt + cellsPerDiv, refDiv);
        }
        return refined;
    }

    private int getRefinedDivisionsN(int origDivs, int minDivs, double factor) {
        minDivs = Math.min(origDivs, minDivs);
        return (int)Math.round(Math.max((double)minDivs, (double)origDivs * factor));
    }

    public Task taskImprint(Grid g) {
        return new ImprintGridTask(this, g);
    }

    public void imprint(Grid g) {
        int m;
        assert (this != g);
        this.pauseUpdates(false);
        this.d_fyi = g.d_fyi;
        this.setName(g.getName());
        this.d_minPoint = g.d_minPoint;
        this.d_maxPoint = g.d_maxPoint;
        this.d_x = new UnitDouble[g.d_x.length];
        for (m = 0; m < g.d_x.length; ++m) {
            this.d_x[m] = g.d_x[m];
        }
        this.d_y = new UnitDouble[g.d_y.length];
        for (m = 0; m < g.d_y.length; ++m) {
            this.d_y[m] = g.d_y[m];
        }
        this.d_z = new UnitDouble[g.d_z.length];
        for (m = 0; m < g.d_z.length; ++m) {
            this.d_z[m] = g.d_z[m];
        }
        this.d_color = g.d_color;
        this.d_syncTimeStep = g.d_syncTimeStep;
        this.d_evacuation = g.d_evacuation;
        this.d_evacHumans = g.d_evacHumans;
        this.d_evacZOffset = g.d_evacZOffset;
        this.d_customProps = g.d_customProps;
        this.d_tags = g.d_tags;
        this.resumeUpdates();
        this.changedEvt(new Object[0]);
    }

    @Override
    public boolean equals(Object o) {
        int m;
        if (!(o instanceof Grid)) {
            return false;
        }
        Grid g = (Grid)o;
        if (this.d_x.length != g.d_x.length || this.d_y.length != g.d_y.length || this.d_z.length != g.d_z.length) {
            return false;
        }
        for (m = 0; m < this.d_x.length; ++m) {
            if (this.d_x[m].equals(g.d_x[m])) continue;
            return false;
        }
        for (m = 0; m < this.d_y.length; ++m) {
            if (this.d_y[m].equals(g.d_y[m])) continue;
            return false;
        }
        for (m = 0; m < this.d_z.length; ++m) {
            if (this.d_z[m].equals(g.d_z[m])) continue;
            return false;
        }
        boolean equal = this.getName().equals(g.getName()) && Util.identitySetsEqual(this.getTags(), g.getTags()) && (this.d_color == null ? g.d_color == null : this.d_color.equals(g.d_color)) && this.d_syncTimeStep == g.d_syncTimeStep && (this.d_minPoint == null ? g.d_minPoint == null : this.d_minPoint.equals(g.d_minPoint)) && (this.d_maxPoint == null ? g.d_maxPoint == null : this.d_maxPoint.equals(g.d_maxPoint));
        return equal;
    }

    public static UnitDouble[] makeUniformDivisions(int numDivs, UnitDouble min, UnitDouble max) {
        Object[] divs = new UnitDouble[numDivs];
        BaseUnit u = SI.METER;
        double width = (max.getValue(u) - min.getValue(u)) / (double)numDivs;
        Arrays.fill(divs, new UnitDouble(width, u));
        return divs;
    }

    public UnitPoint3D getMinPoint() {
        return this.d_minPoint;
    }

    public UnitPoint3D getMaxPoint() {
        return this.d_maxPoint;
    }

    public UnitDouble[] getXDivisions() {
        return this.d_x;
    }

    public UnitDouble getXDivisionLength() {
        if (this.d_x.length > 0) {
            return this.d_x[0];
        }
        return new UnitDouble(0.2, Geometry.LU);
    }

    public UnitDouble[] getYDivisions() {
        return this.d_y;
    }

    public UnitDouble getYDivisionLength() {
        if (this.d_y.length > 0) {
            return this.d_y[0];
        }
        return new UnitDouble(0.2, Geometry.LU);
    }

    public UnitDouble[] getZDivisions() {
        return this.d_z;
    }

    public UnitDouble getZDivisionLength() {
        if (this.d_z.length > 0) {
            return this.d_z[0];
        }
        return new UnitDouble(0.2, Geometry.LU);
    }

    public long getNumCells() {
        return this.getXDivisions().length * this.getYDivisions().length * this.getZDivisions().length;
    }

    private static UnitDouble[] convertDivisionsToPositions(UnitDouble minPos, UnitDouble maxPos, UnitDouble[] divisions) {
        UnitDouble[] positions = new UnitDouble[divisions.length + 1];
        positions[0] = minPos;
        for (int i = 1; i < positions.length; ++i) {
            positions[i] = positions[i - 1];
            positions[i] = positions[i].add(divisions[i - 1]);
        }
        return positions;
    }

    private static double[] convertDivisionsToDoublePositions(UnitDouble minPos, UnitDouble maxPos, UnitDouble[] divisions) {
        double[] positions = new double[divisions.length + 1];
        positions[0] = minPos.getValue(Geometry.LU);
        for (int i = 1; i < positions.length; ++i) {
            positions[i] = positions[i - 1];
            positions[i] = positions[i] + divisions[i - 1].getValue(Geometry.LU);
        }
        return positions;
    }

    public UnitDouble[] getLinePositions(int axis) {
        switch (axis) {
            case 0: {
                return this.getXLinePositions();
            }
            case 1: {
                return this.getYLinePositions();
            }
        }
        return this.getZLinePositions();
    }

    public UnitDouble[] getXLinePositions() {
        return Grid.convertDivisionsToPositions(this.d_minPoint.xu(), this.d_maxPoint.xu(), this.d_x);
    }

    public UnitDouble[] getYLinePositions() {
        return Grid.convertDivisionsToPositions(this.d_minPoint.yu(), this.d_maxPoint.yu(), this.d_y);
    }

    public UnitDouble[] getZLinePositions() {
        return Grid.convertDivisionsToPositions(this.d_minPoint.zu(), this.d_maxPoint.zu(), this.d_z);
    }

    public String getUniqueID() {
        return this.getName();
    }

    public int getCellCount() {
        return this.d_x.length * this.d_y.length * this.d_z.length;
    }

    public UnitPoint3D getCellSize(boolean[] uniform) {
        return new UnitPoint3D(this.getDivisionSize(this.getXDivisions(), uniform, 0), this.getDivisionSize(this.getYDivisions(), uniform, 1), this.getDivisionSize(this.getZDivisions(), uniform, 2));
    }

    private UnitDouble getDivisionSize(UnitDouble[] divs, boolean[] uniform, int dir) {
        double tol = 1.0E-6;
        UnitDouble ud0 = divs[0];
        for (UnitDouble div : divs) {
            if (!(1.0E-6 < ud0.diff(div).getValue(SI.METER))) continue;
            uniform[dir] = false;
            return ud0;
        }
        return ud0;
    }

    @Override
    public void getAll(Consumer<Object> result, IIsectFilter filter) {
    }

    @Override
    public String toString() {
        return String.format("Grid[name=%s]", this.getName());
    }

    @Override
    public void getCustomFDSTypes(Collection<String> recTypes) {
        recTypes.add("MESH");
    }

    @Override
    public void setCustomFDSProps(String recType, CustomFDSProps props) {
        this.d_customProps = props;
        this.changedEvt(new Object[0]);
    }

    @Override
    public CustomFDSProps getCustomFDSProps(String recType) {
        return this.d_customProps;
    }

    public static class GridGeom
    implements IGeom,
    IManipulatable {
        private static final long serialVersionUID = -7586528457893615416L;
        private final UnitPoint3D min;
        private final UnitPoint3D max;
        private final UnitDouble[] dx;
        private final UnitDouble[] dy;
        private final UnitDouble[] dz;

        public GridGeom(UnitPoint3D minPoint, UnitPoint3D maxPoint, UnitDouble[] x, UnitDouble[] y, UnitDouble[] z) {
            this.min = minPoint;
            this.max = maxPoint;
            this.dx = x;
            this.dy = y;
            this.dz = z;
        }

        @Override
        public IGeom optimize(IPointOptimizer pool) {
            return this;
        }

        @Override
        public int getNumPrims(int types) {
            return 0;
        }

        @Override
        public Iterator<Byte> iteratePrimTypes(int offset) {
            return Collections.emptyIterator();
        }

        @Override
        public boolean isAxisAlignedBlock(TransformInfo parentXform) {
            return true;
        }

        @Override
        public boolean isShell() {
            return Boolean.FALSE;
        }

        @Override
        public IDOF getDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IDOF getRetainingDOF() {
            return IDOF.ALIGNED;
        }

        @Override
        public IGeom transform(TransformInfo ti, int options) {
            if (ti.isIdentity()) {
                return this;
            }
            Matrix4d xform = ti.getMatrix();
            UnitPoint3D p1 = Geometry.xform(xform, this.min);
            UnitPoint3D p2 = Geometry.xform(xform, this.max);
            UnitPoint3D[] rect = GeomUtil.rectify(p1, p2);
            p1 = rect[0];
            p2 = rect[1];
            int[] swizzle = this.getSwizzle(xform);
            UnitDouble[][] result = new UnitDouble[3][];
            result[swizzle[0]] = new UnitDouble[this.dx.length];
            result[swizzle[1]] = new UnitDouble[this.dy.length];
            result[swizzle[2]] = new UnitDouble[this.dz.length];
            this.xform(xform, this.dx, 0, swizzle, result);
            this.xform(xform, this.dy, 1, swizzle, result);
            this.xform(xform, this.dz, 2, swizzle, result);
            return new GridGeom(p1, p2, result[0], result[1], result[2]);
        }

        private void xform(Matrix4d xform, UnitDouble[] arr, int pos, int[] swizzle, UnitDouble[][] result) {
            Unit u = Geometry.LU;
            double[] data = new double[]{0.0, 0.0, 0.0};
            double[] data2 = new double[3];
            Vector3d tempvec = new Vector3d();
            UnitDouble[] resultArr = result[swizzle[pos]];
            for (int m = 0; m < arr.length; ++m) {
                data[pos] = arr[m].getValue(u);
                tempvec.set(data);
                xform.transform(tempvec);
                tempvec.get(data2);
                Unit unit = arr[m].getUnit();
                double newval = u.getConverterTo(unit).convert(data2[swizzle[pos]]);
                int rm = m;
                if (newval < 0.0) {
                    rm = resultArr.length - m - 1;
                    newval = -newval;
                }
                resultArr[rm] = new UnitDouble(newval, unit);
            }
        }

        private int[] getSwizzle(Matrix4d xform) {
            Vector3d x = new Vector3d(1.0, 0.0, 0.0);
            Vector3d y = new Vector3d(0.0, 1.0, 0.0);
            Vector3d z = new Vector3d(0.0, 0.0, 1.0);
            xform.transform(x);
            xform.transform(y);
            xform.transform(z);
            x.normalize();
            y.normalize();
            z.normalize();
            int sx = theUtil.eq(Math.abs(x.x), 1.0, 1.0E-6) ? 0 : (theUtil.eq(Math.abs(x.y), 1.0, 1.0E-6) ? 1 : 2);
            int sy = theUtil.eq(Math.abs(y.x), 1.0, 1.0E-6) ? 0 : (theUtil.eq(Math.abs(y.y), 1.0, 1.0E-6) ? 1 : 2);
            int sz = theUtil.eq(Math.abs(z.x), 1.0, 1.0E-6) ? 0 : (theUtil.eq(Math.abs(z.y), 1.0, 1.0E-6) ? 1 : 2);
            assert (sx != sy && sx != sz && sy != sz);
            return new int[]{sx, sy, sz};
        }

        @Override
        public AABox getBoundingBox(AABox aabb) {
            this.min.add(aabb, Geometry.LU);
            this.max.add(aabb, Geometry.LU);
            return aabb;
        }

        @Override
        public boolean canExplode() {
            return false;
        }

        @Override
        public Collection<IGeom> explode(Collection<IGeom> prims) {
            return prims;
        }

        @Override
        public void pickPoints(IIsectCollector isects, IIsectFilter filter, Object source, IElemSource<Boolean> creases, Point3d rayBegin, Vector3d rayDirN, double maxDist, ITest<AABox> tester) {
        }

        @Override
        public void pickBox(Object source, IElemSource<Boolean> visFaceEdges, IIsectFilter filter, ConvexHull region, IBoxCollector isects) throws CancelObjectPicking {
        }

        @Override
        public void find(ITest<AABox> test, IResult<? super IGeom.FoundPrimitive> result) {
        }

        @Override
        public void getAll(IResult<? super IPrimitive> result) {
        }

        @Override
        public void generateManipHandles(Consumer<? super IHandle> handles) {
            AABoxGeom bg = new AABoxGeom(this.min.getPoint3dValue(Geometry.LU), this.max.getPoint3dValue(Geometry.LU));
            bg.generateManipHandles(handle -> handles.accept(new Handle(this, (IHandle)handle)));
        }

        private static class Handle
        implements IHandle {
            private final GridGeom geom;
            private final IHandle handle;
            private double[] d_x;
            private double[] d_y;
            private double[] d_z;

            public Handle(GridGeom originalGeom, IHandle handle) {
                this.geom = originalGeom;
                this.handle = handle;
            }

            public boolean equals(Object obj) {
                return obj == this || obj instanceof Handle && ((Handle)obj).handle.equals(this.handle);
            }

            @Override
            public IGeomNode getGeom() {
                return this.handle.getGeom();
            }

            @Override
            public Pair<SnapMode, IIsectFilter> getPickFilter() {
                return this.handle.getPickFilter();
            }

            @Override
            public ISnapConstraint getConstraint(Point3d handleLoc) {
                return this.handle.getConstraint(handleLoc);
            }

            @Override
            public void begin(Point3d handleLoc, ISnapConstraint constraint) {
                this.handle.begin(handleLoc, constraint);
                this.d_x = Grid.convertDivisionsToDoublePositions(this.geom.min.xu(), this.geom.max.xu(), this.geom.dx);
                this.d_y = Grid.convertDivisionsToDoublePositions(this.geom.min.yu(), this.geom.max.yu(), this.geom.dy);
                this.d_z = Grid.convertDivisionsToDoublePositions(this.geom.min.zu(), this.geom.max.zu(), this.geom.dz);
            }

            @Override
            public Object modify(Point3d newLoc) throws ManipException {
                Object mod = this.handle.modify(newLoc);
                return this.convert(mod);
            }

            @Override
            public Object end() {
                GridGeom result = null;
                try {
                    result = this.convert(this.handle.end());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.d_z = null;
                this.d_y = null;
                this.d_x = null;
                return result;
            }

            private GridGeom convert(Object mod) throws ManipException {
                if (!(mod instanceof AABoxGeom)) {
                    return null;
                }
                AABoxGeom bg = (AABoxGeom)mod;
                Pair<Double, Integer> minx = this.snapCoordinate(this.d_x, bg.min.x);
                Pair<Double, Integer> maxx = this.snapCoordinate(this.d_x, bg.max.x);
                Pair<Double, Integer> miny = this.snapCoordinate(this.d_y, bg.min.y);
                Pair<Double, Integer> maxy = this.snapCoordinate(this.d_y, bg.max.y);
                Pair<Double, Integer> minz = this.snapCoordinate(this.d_z, bg.min.z);
                Pair<Double, Integer> maxz = this.snapCoordinate(this.d_z, bg.max.z);
                return new GridGeom(new UnitPoint3D((Double)minx.v1, (Double)miny.v1, (Double)minz.v1, Geometry.LU), new UnitPoint3D((Double)maxx.v1, (Double)maxy.v1, (Double)maxz.v1, Geometry.LU), Handle.trimDivs(this.geom.dx, (Integer)minx.v2, (Integer)maxx.v2), Handle.trimDivs(this.geom.dy, (Integer)miny.v2, (Integer)maxy.v2), Handle.trimDivs(this.geom.dz, (Integer)minz.v2, (Integer)maxz.v2));
            }

            private Pair<Double, Integer> snapCoordinate(double[] divs, double val) {
                if (divs.length < 2) {
                    return new Pair<Double, Integer>(val, 0);
                }
                int pos = Arrays.binarySearch(divs, val);
                if (pos >= 0) {
                    return new Pair<Double, Integer>(val, pos);
                }
                int insertPos = -pos - 1;
                if (insertPos == 0) {
                    double dv = divs[1] - divs[0];
                    int count = (int)Math.round((val - divs[0]) / dv);
                    return new Pair<Double, Integer>(divs[0] + dv * (double)count, count);
                }
                if (insertPos == divs.length) {
                    double dv = divs[divs.length - 1] - divs[divs.length - 2];
                    int count = (int)Math.round((val - divs[divs.length - 1]) / dv);
                    return new Pair<Double, Integer>(divs[divs.length - 1] + dv * (double)count, count + divs.length - 1);
                }
                double v1 = divs[insertPos - 1];
                double v2 = divs[insertPos];
                return val - v1 < v2 - val ? new Pair<Double, Integer>(v1, insertPos - 1) : new Pair<Double, Integer>(v2, insertPos);
            }

            private static UnitDouble[] trimDivs(UnitDouble[] divs, int min, int max) throws ManipException {
                int m;
                int num;
                if (divs.length == 0) {
                    return divs;
                }
                if (--max < min) {
                    throw new ManipException();
                }
                ArrayList<UnitDouble> newDivs = new ArrayList<UnitDouble>();
                if (min < 0) {
                    num = Math.abs(min);
                    for (m = 0; m < num; ++m) {
                        newDivs.add(divs[0]);
                    }
                    min = 0;
                }
                for (int m2 = min; m2 <= Math.min(divs.length - 1, max); ++m2) {
                    newDivs.add(divs[m2]);
                }
                if (max >= divs.length) {
                    num = Math.abs(max + 1 - divs.length);
                    for (m = 0; m < num; ++m) {
                        newDivs.add(divs[divs.length - 1]);
                    }
                }
                return newDivs.toArray(new UnitDouble[newDivs.size()]);
            }
        }
    }

    private static class RefineGridTask
    implements Task {
        private final Grid d_target;
        private final Grid d_holder;
        private final double d_factor;

        public RefineGridTask(Grid target, double factor) {
            this.d_target = target;
            this.d_factor = factor;
            this.d_holder = new Grid(target.getName());
            this.d_holder.imprint(target);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            this.d_target.imprint(this.d_holder);
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void run() {
            if (1.0 <= this.d_factor) {
                this.d_target.refine((int)Math.round(this.d_factor));
            } else {
                this.d_target.coarsen(this.d_factor);
            }
        }
    }

    private static class ImprintGridTask
    implements Task {
        private final Grid d_target;
        private final Grid d_holder;
        private final Grid d_newData;

        public ImprintGridTask(Grid target, Grid newData) {
            this.d_target = target;
            this.d_newData = newData;
            this.d_holder = new Grid(target.getName());
            this.d_holder.imprint(target);
        }

        @Override
        public boolean canUndo() {
            return true;
        }

        @Override
        public void undo() {
            this.d_target.imprint(this.d_holder);
        }

        @Override
        public int getEst() {
            return 0;
        }

        @Override
        public void run() {
            this.d_target.imprint(this.d_newData);
        }
    }
}

