/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.domain;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.Property;
import pyrosim.util.Util;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.MappedIterator;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class Composite<DataT extends IPyroObject>
extends NamedPyroObject {
    static final long serialVersionUID = 1L;
    public static final Object NON_UNIFORM = new Object();
    public static final Object NOT_SUPPORTED = new Object();
    private Class<DataT> d_type;
    private Set<IPyroObject> d_members;

    public Composite(String name, Class<DataT> type) {
        super(name);
        this.d_type = type;
        this.d_members = new LinkedIdentityHashSet<IPyroObject>();
    }

    public Class<DataT> getType() {
        return this.d_type;
    }

    protected void legacySetType(Class<DataT> type) {
        this.d_type = type;
    }

    protected boolean getSerializeMembersEnabled() {
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.getSerializeMembersEnabled()) {
            out.defaultWriteObject();
        } else {
            Set<IPyroObject> tempMembers = this.d_members;
            this.d_members = new LinkedIdentityHashSet<IPyroObject>();
            out.defaultWriteObject();
            this.d_members = tempMembers;
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    protected boolean addDefault(DataT obj) {
        if (this.get(Util.getName(obj)) == null) {
            this.add((IPyroObject)obj);
            return true;
        }
        return false;
    }

    public Composite<DataT> newGroup(String name) {
        Composite result = (Composite)super.clone();
        result.d_members = new LinkedIdentityHashSet<IPyroObject>();
        result.setName(name);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return obj == this;
    }

    @Override
    public Composite<DataT> clone() {
        return this.clone(true);
    }

    public Composite<DataT> clone(boolean deep) {
        Composite clone = (Composite)super.clone();
        if (deep) {
            clone.d_members = new LinkedIdentityHashSet<IPyroObject>(this.d_members.size());
            for (IPyroObject member : this.d_members) {
                IPyroObject objClone = (IPyroObject)member.clone();
                objClone.setDomain(null, clone);
                clone.d_members.add(objClone);
            }
        } else {
            clone.d_members = new LinkedIdentityHashSet<IPyroObject>();
        }
        return clone;
    }

    public DataT get(String name) {
        return this.find(name, this.d_type, true);
    }

    public List<DataT> getAll(String name) {
        return this.findAll(name, this.d_type, true);
    }

    public <T extends IPyroObject> T find(String name, Class<T> type, boolean deep) {
        Collection<T> objs = deep ? ((APyroObject)this).flatten(type) : this.getMembers(type);
        for (IPyroObject obj : objs) {
            if (!Util.getName(obj).equals(name)) continue;
            return (T)obj;
        }
        return null;
    }

    public <T extends IPyroObject> List<T> findAll(String name, Class<T> type, boolean deep) {
        ArrayList<IPyroObject> result = new ArrayList<IPyroObject>();
        Collection<T> objs = deep ? ((APyroObject)this).flatten(type) : this.getMembers(type);
        for (IPyroObject obj : objs) {
            if (!Util.getName(obj).equals(name)) continue;
            result.add(obj);
        }
        return result;
    }

    public boolean accept(IPyroObject obj) {
        return obj instanceof Composite ? this.d_type.isAssignableFrom(((Composite)obj).getType()) : this.d_type.isInstance(obj);
    }

    public void reorder(Collection<? extends IPyroObject> newOrder) {
        assert (this.d_members.containsAll(newOrder) && this.d_members.size() == newOrder.size());
        this.d_members.clear();
        this.d_members.addAll(newOrder);
        this.changedEvt(PyroMod.EVT_CHILDREN_CHANGED);
    }

    public boolean containsAny(Collection<? extends IPyroObject> objs) {
        for (IPyroObject iPyroObject : objs) {
            if (!this.d_members.contains(iPyroObject)) continue;
            return true;
        }
        return false;
    }

    public void insert(Collection<? extends IPyroObject> objs, int insertPos) {
        if (objs.isEmpty()) {
            return;
        }
        assert (!this.containsAny(objs));
        if (insertPos == this.d_members.size()) {
            this.addAll(objs);
            return;
        }
        ArrayList<IPyroObject> newList = new ArrayList<IPyroObject>(this.d_members);
        newList.addAll(insertPos, objs);
        this.d_members.clear();
        this.d_members.addAll(newList);
        this.addChildren(objs);
    }

    public void insert(IPyroObject[] objs, int[] insertPositions) {
        if (objs.length == 0) {
            return;
        }
        assert (!this.containsAny(Arrays.asList(objs)));
        assert (objs.length <= insertPositions.length);
        ArrayList<IPyroObject> newList = new ArrayList<IPyroObject>(this.d_members);
        for (int m = 0; m < objs.length; ++m) {
            newList.add(insertPositions[m], objs[m]);
        }
        this.d_members.clear();
        this.d_members.addAll(newList);
        this.addChildren(objs);
    }

    public int indexOf(IPyroObject obj) {
        int ix = 0;
        for (IPyroObject child : this.d_members) {
            if (child == obj) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public <ObjT, PropT> Object getProperty(IObjectProp<ObjT, PropT> prop) {
        return Composite.getProperty(prop, this.d_members);
    }

    public static <ObjT extends IPyroObject, PropT> Property<PropT> getProp(IObjectProp<ObjT, PropT> prop, Collection<? extends IPyroObject> objs) {
        return Composite.getProp(prop, objs, Predicates.alwaysTrue());
    }

    public static <ObjT extends IPyroObject, PropT> Property<PropT> getProp(IObjectProp<ObjT, PropT> prop, Collection<? extends IPyroObject> objs, Predicate<ObjT> filter) {
        Object val = Composite.getProperty(prop, theUtil.filter(objs, prop.getType(), filter));
        if (val == NOT_SUPPORTED) {
            return Property.notSupported();
        }
        if (val == NON_UNIFORM) {
            return Property.nonUniform();
        }
        return Property.of(val);
    }

    public static <ObjT, PropT> Object getProperty(IObjectProp<ObjT, PropT> prop, Collection<? extends IPyroObject> objs) {
        if (objs.isEmpty()) {
            return NOT_SUPPORTED;
        }
        return Composite.getProperty(theUtil.filter(objs, o -> prop.getType().isInstance(o) || o instanceof Composite).iterator(), pobj -> {
            if (prop.getType().isInstance(pobj)) {
                IPyroObject sobj = pobj;
                return prop.get(sobj);
            }
            return ((Composite)pobj).getProperty(prop);
        }, prop::equal);
    }

    public static <ObjT, PropT> Object getProperty(Iterator<? extends ObjT> objs, Function<ObjT, Object> getter, BiPredicate<PropT, PropT> equals) {
        return Composite.getProperty(new MappedIterator<ObjT, Object>(objs, getter), equals);
    }

    public static <PropT> Object getProperty(Iterator<? extends PropT> vals, BiPredicate<PropT, PropT> equals) {
        if (!vals.hasNext()) {
            return NOT_SUPPORTED;
        }
        Object val = NOT_SUPPORTED;
        while (vals.hasNext()) {
            PropT val2 = vals.next();
            if (val2 == NON_UNIFORM) {
                return NON_UNIFORM;
            }
            if (val2 == NOT_SUPPORTED) continue;
            if (val == NOT_SUPPORTED) {
                val = val2;
                continue;
            }
            if (equals.test(val, val2)) continue;
            return NON_UNIFORM;
        }
        return val;
    }

    public <ObjT, PropT> void setProperty(IObjectProp<ObjT, PropT> prop, PropT value) {
        this.pauseUpdates();
        Composite.setProperty(prop, value, this.d_members);
        this.resumeUpdates();
    }

    public static <ObjT, PropT> void setProp(IObjectProp<ObjT, PropT> prop, Property<PropT> value, Collection<? extends IPyroObject> objs) {
        assert (value != null);
        if (value.isUniform()) {
            Composite.setProperty(prop, value.get(), objs);
        }
    }

    public static <ObjT, PropT> void setProperty(IObjectProp<ObjT, PropT> prop, PropT value, Collection<? extends IPyroObject> objs) {
        for (IPyroObject iPyroObject : objs) {
            if (prop.getType().isInstance(iPyroObject)) {
                prop.set(iPyroObject, value);
                continue;
            }
            if (!(iPyroObject instanceof Composite)) continue;
            ((Composite)iPyroObject).setProperty(prop, value);
        }
    }

    public boolean contains(IPyroObject obj) {
        return this.d_members.contains(obj);
    }

    public boolean containsDeep(IPyroObject obj) {
        if (this.d_members.contains(obj)) {
            return true;
        }
        for (Composite comp : this.getNodes()) {
            if (!comp.containsDeep(obj)) continue;
            return true;
        }
        return false;
    }

    public Collection<IPyroObject> getMembers() {
        return this.d_members;
    }

    public Collection<Composite> getNodes() {
        return this.getMembers(Composite.class);
    }

    public Collection<DataT> flatten() {
        return ((APyroObject)this).flatten(this.d_type);
    }

    public Collection<DataT> flatten(Predicate<? super DataT> filter) {
        return Hierarchy.flatten(this.d_members, this.d_type, filter);
    }

    public Collection<Composite> flattenNodes() {
        return ((APyroObject)this).flatten(Composite.class);
    }

    public Collection<? extends IPyroObject> getDeepMembers() {
        return ((APyroObject)this).flatten(IPyroObject.class);
    }

    public void clear() {
        this.pauseUpdates();
        ArrayList<IPyroObject> members = new ArrayList<IPyroObject>(this.d_members);
        this.d_members.clear();
        this.removeChildren((Collection)members);
        this.resumeUpdates();
    }

    public boolean isEmpty() {
        return this.d_members.isEmpty();
    }

    public void prune() {
        this.prune(Predicates.alwaysTrue());
    }

    public void prune(Predicate<Composite> filter) {
        this.pauseUpdates();
        ArrayList<Composite> toRemove = Collections.EMPTY_LIST;
        for (Composite member : this.getMembers(Composite.class, filter)) {
            member.prune(filter);
            if (!member.isEmpty()) continue;
            if (toRemove.isEmpty()) {
                toRemove = new ArrayList<Composite>();
            }
            toRemove.add(member);
        }
        this.removeAll((Collection<IPyroObject>)toRemove);
        this.resumeUpdates();
    }

    public Collection<? extends IPyroObject> getChildren() {
        return this.d_members;
    }

    public boolean add(IPyroObject obj) {
        if (!this.accept(obj)) {
            System.err.println("Adding non-accepted object to group: [group=" + this.getName() + "], [object=" + Util.getName(obj) + "]");
        }
        boolean result = this.d_members.add(obj);
        this.addChild(obj);
        return result;
    }

    public boolean addAll(Collection<? extends IPyroObject> objs) {
        boolean result = true;
        this.pauseUpdates();
        for (IPyroObject iPyroObject : objs) {
            result &= this.add(iPyroObject);
        }
        this.resumeUpdates();
        return result;
    }

    public boolean remove(IPyroObject obj) {
        boolean result = this.d_members.remove(obj);
        if (result) {
            this.removeChild(obj);
        }
        return result;
    }

    public boolean removeAll(Collection<? extends IPyroObject> objs) {
        boolean removed = false;
        this.pauseUpdates();
        for (IPyroObject iPyroObject : objs) {
            removed |= this.remove(iPyroObject);
        }
        this.resumeUpdates();
        return removed;
    }

    protected <T extends IPyroObject> void addChild(T child) {
        child.setDomain((PyroMod)this.getDomain(), this);
        this.changedEvt(PyroMod.EVT_CHILDREN_ADDED);
    }

    protected <T extends IPyroObject> void addChildren(T ... children) {
        this.addChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IPyroObject> void addChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IPyroObject child : children) {
            child.setDomain((PyroMod)this.getDomain(), this);
        }
        this.changedEvt(PyroMod.EVT_CHILDREN_ADDED);
        this.resumeUpdates();
    }

    protected <T extends IPyroObject> void removeChild(T child) {
        child.setDomain(null, null);
        this.changedEvt(PyroMod.EVT_CHILDREN_REMOVED);
    }

    protected <T extends IPyroObject> void removeChildren(T ... children) {
        this.removeChildren((Collection<T>)Arrays.asList(children));
    }

    protected <T extends IPyroObject> void removeChildren(Collection<T> children) {
        this.pauseUpdates();
        for (IPyroObject child : children) {
            child.setDomain(null, null);
        }
        this.changedEvt(PyroMod.EVT_CHILDREN_REMOVED);
        this.resumeUpdates();
    }

    public static interface IObjectProp<ObjT, PropT> {
        public Class<ObjT> getType();

        public void set(ObjT var1, PropT var2);

        public Object get(ObjT var1);

        public boolean equal(PropT var1, PropT var2);
    }

    public static abstract class AObjectProp<ObjT, PropT>
    implements IObjectProp<ObjT, PropT> {
        private final Class<ObjT> d_type;

        public AObjectProp(Class<ObjT> type) {
            this.d_type = type;
        }

        @Override
        public Class<ObjT> getType() {
            return this.d_type;
        }

        @Override
        public boolean equal(PropT obj1, PropT obj2) {
            return theUtil.equal(obj1, obj2);
        }
    }
}

