/*
 * Decompiled with CFR 0.152.
 */
package pyrosim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Predicate;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.domain.GridList;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.boundcond.mat.MaterialManager;
import pyrosim.domain.boundcond.surf.SurfaceManager;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.output.Isosurface;
import pyrosim.domain.reaction.Reaction;
import pyrosim.domain.reaction.ReactionList;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class PyroSimSelectionModel {
    private final Set<Object> d_selectionSet = new LinkedIdentityHashSet<Object>();
    private final PyroMod d_pyMod;

    public PyroSimSelectionModel(PyroMod pyMod) {
        this.d_pyMod = pyMod;
    }

    protected void pauseUpdates() {
        this.d_pyMod.pauseUpdates();
    }

    protected void resumeUpdates() {
        this.d_pyMod.resumeUpdates();
    }

    public void setSelection(Object ... objs) {
        this.setSelection(Arrays.asList(objs));
    }

    public void setSelection(Collection<?> objs) {
        this.pauseUpdates();
        this.clearSelection();
        this.selectAll(objs);
        this.resumeUpdates();
    }

    private <T> void fireHierarchySelEvt(T obj) {
        PyroMod md = obj instanceof IPyroObject ? (PyroMod)((IPyroObject)obj).getDomain() : this.d_pyMod;
        if (md != null) {
            md.getEvents().changed(obj, PyroMod.EVT_SEL);
            if (obj instanceof IPyroObject) {
                for (IPyroObject iPyroObject : ((IPyroObject)obj).getMembers()) {
                    this.fireHierarchySelEvt(iPyroObject);
                }
            }
        }
    }

    private <T> void deselectChildren(T obj) {
        if (obj instanceof IPyroObject) {
            for (IPyroObject iPyroObject : ((IPyroObject)obj).getMembers()) {
                this.d_selectionSet.remove(iPyroObject);
                this.deselectChildren(iPyroObject);
            }
        }
    }

    public <T> void select(T obj) {
        this.pauseUpdates();
        if (!this.isSelected(obj) && this.d_selectionSet.add(obj)) {
            this.deselectChildren(obj);
            this.fireHierarchySelEvt(obj);
        }
        this.resumeUpdates();
    }

    public <T> void select(T ... objs) {
        this.select((T)Arrays.asList(objs));
    }

    public <T> void selectAll(Collection<? extends T> objs) {
        this.pauseUpdates();
        for (T o : objs) {
            this.select(o);
        }
        this.resumeUpdates();
    }

    public <T> void deselect(T obj) {
        this.pauseUpdates();
        if (this.d_selectionSet.remove(obj)) {
            this.fireHierarchySelEvt(obj);
        }
        this.resumeUpdates();
    }

    public <T> void deselect(T ... objs) {
        this.deselect((T)Arrays.asList(objs));
    }

    public <T> void deselectAll(Collection<? extends T> objs) {
        this.pauseUpdates();
        for (T o : objs) {
            this.deselect(o);
        }
        this.resumeUpdates();
    }

    public void clearSelection() {
        ArrayList<Object> objs = new ArrayList<Object>(this.d_selectionSet);
        this.deselectAll(objs);
    }

    private boolean isHierarchySelected(Object o) {
        IPyroObject parent = o instanceof IPyroObject ? ((IPyroObject)o).getParent() : null;
        return parent != null ? this.isSelected(parent) : false;
    }

    public boolean isSelected(Object o) {
        if (o == null) {
            return this.isEmpty();
        }
        return this.d_selectionSet.contains(o) || this.isHierarchySelected(o);
    }

    private <T> void collectChildren(Collection<T> coll, T obj, Class<T> type) {
        coll.add(obj);
        if (obj instanceof IPyroObject) {
            for (IPyroObject iPyroObject : ((IPyroObject)obj).getMembers()) {
                if (!type.isInstance(iPyroObject)) continue;
                IPyroObject childObj = iPyroObject;
                this.collectChildren(coll, childObj, type);
            }
        }
    }

    public Set<?> getSelection() {
        return this.d_selectionSet;
    }

    public IFilteredCollection<Object> getSelected(Predicate<Object> filter) {
        return theUtil.filter(this.d_selectionSet, filter);
    }

    public <T> IFilteredCollection<T> getSelected(Class<T> type) {
        return theUtil.filter(this.d_selectionSet, type);
    }

    public <T> IFilteredCollection<T> getSelected(Class<T> commonType, Class<? extends T> ... types) {
        TypeFilter filter = new TypeFilter(types);
        return theUtil.filter(this.d_selectionSet, commonType, filter);
    }

    public <T> IFilteredCollection<T> getSelected(Class<T> type, Predicate<T> filter) {
        return theUtil.filter(this.d_selectionSet, type, filter);
    }

    public <T> Collection<T> flatten(Class<T> type) {
        return Hierarchy.flatten(this.d_selectionSet, type);
    }

    public <T> Collection<T> flatten(Class<T> type, Predicate<T> filter) {
        return Hierarchy.flatten(this.d_selectionSet, type, filter);
    }

    public int getNum(Class type) {
        return this.getSelected(type).size();
    }

    public boolean isEmpty() {
        return this.d_selectionSet.isEmpty();
    }

    public boolean isEmpty(Class<?> clazz) {
        return this.flatten(clazz).isEmpty();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("PyroSimSelectionModel:" + this.hashCode() + " {\n");
        str.append("   Object.class         -->> " + this.getSelection().size() + "\n");
        str.append("   GridList.class       -->> " + this.getSelected(GridList.class).size() + "\n");
        str.append("   Grid.class           -->> " + this.getSelected(Grid.class).size() + "\n");
        str.append("   MaterialManager.class-->> " + this.getSelected(MaterialManager.class).size() + "\n");
        str.append("   Material.class       -->> " + this.getSelected(Material.class).size() + "\n");
        str.append("   SurfaceManager.class -->> " + this.getSelected(SurfaceManager.class).size() + "\n");
        str.append("   ISurface.class       -->> " + this.getSelected(Isosurface.class).size() + "\n");
        str.append("   ReactionList.class   -->> " + this.getSelected(ReactionList.class).size() + "\n");
        str.append("   Reaction.class       -->> " + this.getSelected(Reaction.class).size() + "\n");
        str.append("   GenericGeomSrc.class -->> " + this.getSelected(GenericGeomSrc.class).size() + "\n");
        str.append("   FDSObject.class      -->> " + this.getSelected(FDSObject.class).size() + "\n");
        str.append("}\n");
        return str.toString();
    }
}

