/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.util;

import java.awt.geom.Rectangle2D;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.treeview.TVEntryPoint;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.NamedSorter;
import thunderheadeng.geometry.objs.BGImageXform;
import thunderheadeng.gui.Application;
import thunderheadeng.image.Image;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.TypeFilter;
import thunderheadeng.util.theUtil;

public class Util {
    public static <T> boolean keepIf(Collection<T> objs, Predicate<? super T> filter) {
        if (filter == Predicates.alwaysTrue()) {
            return false;
        }
        if (filter == Predicates.alwaysFalse()) {
            boolean empty = objs.isEmpty();
            objs.clear();
            return !empty;
        }
        boolean removed = false;
        Iterator<T> it = objs.iterator();
        while (it.hasNext()) {
            if (filter.test(it.next())) continue;
            it.remove();
            removed = true;
        }
        return removed;
    }

    public static <T> boolean keepIfNullOr(Collection<T> objs, Class<?> type) {
        return Util.keepIfNullOr(objs, (? super T o) -> type.isInstance(o));
    }

    public static <T> boolean keepIfNullOr(Collection<T> objs, Predicate<? super T> filter) {
        return Util.keepIf(objs, o -> o == null || filter.test(o));
    }

    public static boolean keepOnlyNull(Collection<?> objs) {
        return Util.keepIf(objs, o -> o == null);
    }

    public static BGImageXform createDxfImageTransform(Image img, Rectangle2D bounds, Unit boundsUnit, UnitDouble z) {
        int iwidth = img.getWidth();
        int iheight = img.getHeight();
        if (iwidth == 0) {
            iwidth = (int)bounds.getWidth();
        }
        if (iheight == 0) {
            iheight = (int)bounds.getHeight();
        }
        Point2d originImg = new Point2d(-bounds.getMinX() / bounds.getWidth() * (double)iwidth, -bounds.getMinY() / bounds.getHeight() * (double)iheight);
        return new BGImageXform(originImg, new Point3d(0.0, 0.0, z.getValue(SI.METER)), new Point2d(0.0, 0.0), new Point2d(iwidth, 0.0), UnitDouble.convert(bounds.getWidth(), boundsUnit, SI.METER), 0.0);
    }

    public static void assignFinalField(Object obj, String strField, Object val) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = obj.getClass().getField(strField);
        f.setAccessible(true);
        f.set(obj, val);
        f.setAccessible(false);
    }

    public static <T extends IPyroObject> Collection<? extends T> getAllObjects(PyroMod domain, Class<T> type, Predicate<T> filter, boolean includeImplicitObjs) {
        Composite root = Util.getCategoryRoot(domain, type);
        if (root == null) {
            return Collections.EMPTY_LIST;
        }
        Collection<T> objs = root.flatten(type, filter);
        return objs;
    }

    public static Composite getCategoryRoot(PyroMod domain, Class<? extends IPyroObject> type) {
        for (IPyroObject iPyroObject : domain.getMembers()) {
            if (!(iPyroObject instanceof Composite) || !((Composite)iPyroObject).getType().isAssignableFrom(type)) continue;
            return (Composite)iPyroObject;
        }
        return null;
    }

    public static String getCatName(IPyroObject obj) {
        return TVEntryPoints.ep(obj).getCategoryName();
    }

    public static String getName(IPyroObject obj) {
        TVEntryPoint<IPyroObject> ep = TVEntryPoints.ep(obj);
        return ep.getName(obj);
    }

    public static boolean canDelete(PyroMod md, Object o) {
        IPyroObject parent;
        if (o instanceof IPyroObject && (parent = ((IPyroObject)o).getParent()) != null) {
            return TVEntryPoints.ep(parent).canDelete(md, parent, o);
        }
        return false;
    }

    public static String validateName(PyroMod md, INamed obj, String name) throws Exception {
        if ((name = name.trim()).isEmpty()) {
            throw new Exception(Intl.intl("Empty names are not allowed."));
        }
        if (obj.getName().equals(name)) {
            return name;
        }
        TVEntryPoint<INamed> ep = TVEntryPoints.ep(obj);
        Object catRoot = ep.getCategoryRoot(md, obj);
        if (catRoot instanceof Composite && Util.isKeyedByName(md, catRoot, obj) && md.getNames(obj).isRegistered(name)) {
            String msg = String.format(Intl.intl("The name, \"%s,\" is already in use."), name);
            throw new Exception(msg);
        }
        return name;
    }

    public static boolean isKeyedByName(PyroMod md, Object o) {
        return !md.getNames(o).getAllowsDuplicates();
    }

    public static boolean isKeyedByName(PyroMod md, Object catRoot, Object o) {
        return !md.getNames(o).getAllowsDuplicates();
    }

    public static Set<String> getNames(Collection<?> objs) {
        HashSet<String> names = new HashSet<String>();
        for (INamed nobj : theUtil.filter(objs, INamed.class)) {
            names.add(nobj.getName());
        }
        return names;
    }

    public static <T extends IPyroObject> List<T> sort(Composite<? extends T> group) {
        return Util.sort(group.flatten());
    }

    public static <T extends IPyroObject> List<T> sort(Collection<? extends T> objs) {
        ArrayList<? extends T> members = new ArrayList<T>(objs);
        Collections.sort(members, new NamedSorter());
        return members;
    }

    public static <T> List<T> sort(Collection<? extends T> objs, Comparator<T> sorter) {
        ArrayList<? extends T> members = new ArrayList<T>(objs);
        Collections.sort(members, sorter);
        return members;
    }

    public static <T> int indexOf(Collection<? extends T> objs, T obj) {
        int ix = 0;
        for (T o : objs) {
            if (o == obj) {
                return ix;
            }
            ++ix;
        }
        return -1;
    }

    public static boolean identityMapsEqual(Map<?, ?> map1, Map<?, ?> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Map.Entry<?, ?> entry1 : map1.entrySet()) {
            Object key2 = null;
            Object val2 = null;
            for (Map.Entry<?, ?> entry2 : map2.entrySet()) {
                if (!entry1.getKey().equals(entry2.getKey())) continue;
                key2 = entry2.getKey();
                val2 = entry2.getValue();
                break;
            }
            if (key2 == null) {
                return false;
            }
            if (theUtil.equal(entry1.getValue(), val2)) continue;
            return false;
        }
        return true;
    }

    public static boolean identitySetsEqual(Set<?> map1, Set<?> map2) {
        if (map1.size() != map2.size()) {
            return false;
        }
        for (Object val1 : map1) {
            boolean found = false;
            for (Object val2 : map2) {
                if (!theUtil.equal(val1, val2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public static boolean isExclusive(Collection<?> coll, Class<?> ... types) {
        if (types.length == 1) {
            return theUtil.filter(coll, types[0]).isExclusive();
        }
        return theUtil.filter(coll, new TypeFilter(types)).isExclusive();
    }

    public static boolean containsAny(Collection<?> coll, Object ... objs) {
        for (Object o : objs) {
            if (!coll.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static <K, V> boolean isObjMapEqual(Map<? extends K, ? extends V> map1, Map<? extends K, ? extends V> map2) {
        if (map1 == null && map2 == null) {
            return true;
        }
        if (map1 == null || map2 == null) {
            return false;
        }
        if (map1.size() != map2.size()) {
            return false;
        }
        BitSet foundBits = new BitSet(map2.size());
        for (K k1 : map1.keySet()) {
            boolean found = false;
            int ix = 0;
            for (K k2 : map2.keySet()) {
                if (foundBits.get(ix)) {
                    ++ix;
                    continue;
                }
                if (!k1.equals(k2)) continue;
                if (theUtil.equal(map1.get(k1), map2.get(k2))) {
                    found = true;
                    foundBits.set(ix);
                    ++ix;
                    break;
                }
                return false;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static UnitSystem getUnitSystemSafe() {
        Application app = Application.getApp();
        if (!(app instanceof PyroSim)) {
            return null;
        }
        return ((PyroSim)app).getUnitSystem();
    }
}

