/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.PyroMod;
import pyrosim.domain.Grid;
import pyrosim.geom.Geometry;
import pyrosim.mv.tools.DrawPlaneGeomTool;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.Mesh;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.picking.RayPointProx;
import thunderheadeng.util.theUtil;

public class MeshAutoAxisChooser
implements DrawPlaneGeomTool.IAutoAxisChooser {
    private final PyroMod d_domain;
    private final boolean d_selGridsOnly;

    public MeshAutoAxisChooser(PyroMod mediator, boolean selGridsOnly) {
        this.d_domain = mediator;
        this.d_selGridsOnly = selGridsOnly;
    }

    @Override
    public Geometry.Axis chooseAxis(DrawPlaneGeomTool tool, Point3d p) {
        List<Geometry.Axis> allowableAxes = tool.getAllowableAxes();
        if (allowableAxes.size() == 1) {
            return allowableAxes.get(0);
        }
        CursorTool.Ray pickRay = tool.getPickRay(p);
        Point3d rayBeginSc = tool.getView().worldToScreen(pickRay.begin);
        RayPointProx[] closestProx = new RayPointProx[]{null};
        Geometry.Axis[] bestAxis = new Geometry.Axis[]{null};
        BiConsumer<Point3d, LineSeg> isectColl = (ap, ls) -> {
            double t = Inter3D.nearestTOnLine(pickRay.begin, pickRay.dir, ap);
            if (theUtil.lt0(t, 1.0E-9)) {
                return;
            }
            Point3d pSc = tool.getView().worldToScreen((Point3d)ap);
            double rDist = new Point2d(pSc.x, pSc.y).distance(new Point2d(rayBeginSc.x, rayBeginSc.y));
            RayPointProx prox = new RayPointProx(t, rDist);
            if (closestProx[0] == null || prox.compareTo(closestProx[0]) < 0) {
                Vector3d dir = ls.getTangent(0.0, ICurve.Orient.POSITIVE, true);
                Geometry.Axis result = Geometry.Axis.values()[Util3D.getClosestAxis(dir)];
                if (allowableAxes.contains((Object)result)) {
                    bestAxis[0] = result;
                    closestProx[0] = prox;
                }
            }
        };
        Collection<Object> grids = this.d_selGridsOnly ? this.d_domain.getSelectionModel().flatten(Grid.class) : this.d_domain.getGridManager().flatten();
        ArrayList<ICurve> boundary = new ArrayList<ICurve>();
        Vector3d lsDir = new Vector3d();
        Point3d nearp = new Point3d();
        for (Grid grid : grids) {
            AABoxGeom box = new AABoxGeom(grid.getBounds());
            for (IPolygon poly : GeomUtil.explode(Collections.singleton(box), IPolygon.class)) {
                boundary.clear();
                poly.getBoundary(boundary);
                for (ICurve bedge : boundary) {
                    Mesh segs = bedge.getSegments(0.0);
                    if (segs.indices.length == 0) continue;
                    Point3d last = segs.vertices[segs.indices[segs.indices.length - 1]];
                    for (int m = 0; m < segs.indices.length; ++m) {
                        Point3d curr = segs.vertices[segs.indices[m]];
                        lsDir.sub(curr, last);
                        if (Inter3D.lineLineSegProximity(null, nearp, pickRay.begin, pickRay.dir, last, curr, lsDir)) {
                            isectColl.accept(nearp, new LineSeg(last, curr));
                        }
                        last = curr;
                    }
                }
            }
        }
        return bestAxis[0];
    }
}

