/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.util.List;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.PyroToolHooks;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.PolyLine;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.MenuBuilder;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.scene3d.tools.IToggleListener;
import thunderheadeng.scene3d.tools.MouseHistory;

public class DrawRoomTool
extends ADrawTool {
    private WallGeom d_wall = null;
    private WallGeom.Alignment d_alignment = WallGeom.Alignment.LEFT;

    public DrawRoomTool(IToolController mv, DrawProps toolProps) {
        super(mv, toolProps, DrawProps.GeomSpace.S3D);
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IAdvancedTool tool) {
                DrawRoomTool.this.incrementAlignment();
                DrawRoomTool.this.repaintSurface();
            }
        });
        this.setMenuBuilder(PyroToolHooks.Menu.TOOL_ACTIONS.key, (IAdvancedTool tool, MenuBuilder builder) -> builder.addMutuallyExclusive(new AlignmentAction(Intl.intl("Align wall to left"), WallGeom.Alignment.LEFT), new AlignmentAction(Intl.intl("Align wall to right"), WallGeom.Alignment.RIGHT), new AlignmentAction(Intl.intl("Align wall to center"), WallGeom.Alignment.CENTER)));
    }

    public Class getGeomType() {
        return WallGeom.class;
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
        ValueEditorUtil.configureLocation(editor, Intl.intl("First Point (x,y,z)"));
        ValueEditorUtil.configureOffset(editor, null, Intl.intl("Dimensions (L,W,H)"), Intl.intl("Second Point (x,y,z)"));
    }

    protected void incrementAlignment() {
        this.setAlignment(switch (this.d_alignment) {
            case WallGeom.Alignment.LEFT -> WallGeom.Alignment.RIGHT;
            case WallGeom.Alignment.RIGHT -> WallGeom.Alignment.CENTER;
            default -> WallGeom.Alignment.LEFT;
        });
    }

    protected void setAlignment(WallGeom.Alignment alignment) {
        this.d_alignment = alignment;
        this.updateRoom();
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        this.updateRoom();
        if (history.committedSize() >= 2) {
            this.finish();
        }
        this.repaintSurface();
    }

    private void updateRoom() {
        List<Point3d> points = this.getClickHistory().getAllPoints();
        WallGeom wallGeom = this.d_wall = points.size() < 2 ? null : this.constructGeom(points.get(0), points.get(1));
        if (this.d_wall != null) {
            this.fireUpdate(0, GeomNodeUtil.newNode(this.d_wall), null);
        } else {
            this.fireRemove(0);
        }
    }

    private WallGeom constructGeom(Point3d p1, Point3d p2) {
        if (p1.x == p2.x || p1.y == p2.y) {
            return null;
        }
        DrawProps props = this.getProps();
        double z = p1.z;
        Point3d[] points = new Point3d[]{new Point3d(p1.x, p1.y, z), new Point3d(p2.x, p1.y, z), new Point3d(p2.x, p2.y, z), new Point3d(p1.x, p2.y, z), new Point3d(p1.x, p1.y, z)};
        ICurve curve = DrawRoomTool.newCurve(points);
        return new WallGeom(curve, this.d_alignment, Math.abs(props.get(DrawProps.THICKNESS).getValue(Geometry.LU)), props.get(DrawProps.HEIGHT).getValue(Geometry.LU), 0);
    }

    private static ICurve newCurve(Point3d ... verts) {
        return (verts = Util3D.deleteDupPoints(0.0, false, verts)).length == 2 ? new LineSeg(verts[0], verts[1]) : new PolyLine(verts);
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_wall != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_wall = null;
        super.reset();
    }

    protected class AlignmentAction
    extends BooleanAction {
        private static final long serialVersionUID = 2354631256275798741L;
        private final WallGeom.Alignment d_alignment;

        public AlignmentAction(String desc, WallGeom.Alignment alignment) {
            super(desc, alignment == DrawRoomTool.this.d_alignment);
            this.d_alignment = alignment;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                DrawRoomTool.this.setAlignment(this.d_alignment);
            }
        }
    }
}

