/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Color;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.Grid;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.dependencies.DLink;
import pyrosim.domain.dependencies.DepSnapshot;
import pyrosim.domain.dependencies.Dependency;
import pyrosim.domain.devices.AttachedPointGeom;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.devices.IAttachedPointDevice;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreePointDevice;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.Hole;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.Obstruction;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.output.PlanarSlice;
import pyrosim.domain.output.VolumeSlice;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.domain.zones.Zone;
import pyrosim.geom.Geometry;
import pyrosim.gui.actions.ActionsMesh;
import pyrosim.treeview.TVEntryPoints;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.GeomGroup;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.ICurve;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.PlanarSurface;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.geom.DisplayGeom;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.geom.PropsBuilder;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.Filters;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.LinkedIdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Sets;
import thunderheadeng.util.theUtil;

public class DrawProps {
    public static final Prop<GeomSpace> GEOM_SPACE = new Prop("GEOM_SPACE");
    public static final Prop<UnitDouble> THICKNESS = new Prop("THICKNESS");
    public static final Prop<UnitDouble> LOCATION = new Prop("LOCATION");
    public static final Prop<Vector3d> ORIENTATION = new Prop("ORIENTATION");
    public static final Prop<Vector3d> NORMAL_SOLID = new Prop("NORMAL_SOLID");
    public static final Prop<UnitDouble> HEIGHT = new Prop("HEIGHT");
    public static final Prop<Surface> SURFACE = new Prop("SURFACE");
    public static final Prop<Color> COLOR = new Prop("COLOR");
    public static final Prop<Boolean> THICKEN = new Prop("THICKEN");
    public static final Prop<Boolean> PERMIT_HOLES = new Prop("PERMIT_HOLES");
    public static final Prop<Particle> PARTICLES = new Prop("PARTICLES");
    public static final Prop<PartCloud.IDropletCount> DROP_COUNT = new Prop("DROP_COUNT");
    public static final Prop<Pair<PartCloud.IInsertion, ControlBridge>> INSERTION = new Prop("INSERTION");
    public static final Prop<InitRegion> INIT = new Prop("INIT");
    public static final Prop<IDevice> DEVC = new Prop("DEVC");
    public static final Prop<Map<ObjType, String>> NAME = new Prop("NAME");
    public static final Prop<Boolean> SPECIFY_COLOR = new Prop("SPECIFY_COLOR");
    public static final Prop<Boolean> SPECIFY_SURFACE = new Prop("SPECIFY_SURFACE");
    public static final Prop<Boolean> REMOVE_TEX_UV = new Prop("REMOVE_TEX_UV");
    public static final Prop<Geometry.Axis> AXIS = new Prop("AXIS");
    public static final Prop<Boolean> SLICE_VECTOR = new Prop("SLICE_VECTOR");
    public static final Prop<IQuantity> SLICE_QUANTITY = new Prop("SLICE_QUANTITY");
    public static final Prop<Boolean> SLICE_CENTERED = new Prop("SLICE_CENTERED");
    public static final Prop<MeshCellType> CELL_TYPE = new Prop("CELL_TYPE");
    public static final Prop<int[]> CELL_COUNT = new Prop("CELL_COUNT");
    public static final Prop<UnitDouble[]> CELL_SIZE = new Prop("CELL_SIZE");
    public final PyroMod d_mediator;
    private final Map<String, Object> d_values;
    private final Collection<ChangeListener> d_listeners;

    public DrawProps(PyroMod mediator) {
        this.d_mediator = mediator;
        this.d_values = new HashMap<String, Object>();
        this.d_listeners = new ArrayDeque<ChangeListener>();
        this.reset();
    }

    public void addChangeListener(ChangeListener listener) {
        this.d_listeners.add(listener);
    }

    public void fireStateChanged() {
        ChangeEvent evt = new ChangeEvent(this);
        for (ChangeListener listener : this.d_listeners) {
            listener.stateChanged(evt);
        }
    }

    public void update(Events events) {
        Set<IPyroObject> delObjs;
        IEventRecord<Particle> partevts;
        if (events.getEvents(PyroMod.class, new Class[0]).containsChange(PyroMod.EVT_MODEL_CHANGED)) {
            this.reset();
            return;
        }
        IEventRecord<Surface> surfevts = events.getEvents(Surface.class, new Class[0]);
        if (surfevts.getRemovedObjs().contains(this.get(SURFACE))) {
            this.set(SURFACE, this.d_mediator.getSurfaceMgr().getDefaultSurfaceObj());
        }
        if ((partevts = events.getEvents(Particle.class, new Class[0])).getRemovedObjs().contains(this.get(PARTICLES))) {
            Particle newPart = this.d_mediator.getPartList().flatten().isEmpty() ? null : (Particle)this.d_mediator.getPartList().flatten().iterator().next();
            this.set(PARTICLES, newPart);
        }
        if (partevts.hasAddedObjs() && this.get(PARTICLES) == null) {
            this.set(PARTICLES, (Particle)this.d_mediator.getPartList().flatten().iterator().next());
        }
        if (!(delObjs = events.getEvents(IPyroObject.class, new Class[0]).getRemovedObjs()).isEmpty()) {
            if (!this.validateDeletedReferences(this.get(INIT), delObjs)) {
                this.set(INIT, new InitRegion());
            }
            if (!this.validateDeletedReferences(this.get(DEVC), delObjs)) {
                this.set(DEVC, DrawProps.getDefaultDevc());
            }
            if (delObjs.contains(this.get(DrawProps.INSERTION).v2)) {
                this.set(INSERTION, new Pair<PartCloud.IInsertion, Object>((PartCloud.IInsertion)this.get(DrawProps.INSERTION).v1, null));
            }
        }
    }

    private <T extends IPyroObject> boolean validateDeletedReferences(T obj, Collection<? extends IPyroObject> delObjs) {
        DepSnapshot ds = new DepSnapshot();
        ds.takeSnapshot(obj);
        LinkedIdentityHashSet allToRemove = new LinkedIdentityHashSet();
        LinkedIdentityHashSet<IPyroObject> toRemove = new LinkedIdentityHashSet<IPyroObject>(delObjs);
        while (!toRemove.isEmpty()) {
            allToRemove.addAll(toRemove);
            LinkedIdentityHashSet incidentalDeletes = new LinkedIdentityHashSet();
            for (IPyroObject iPyroObject : toRemove) {
                Set<Dependency> deps = ds.getDependents(iPyroObject);
                for (Dependency dep : deps) {
                    if (dep.link == DLink.REQUIRED) {
                        return false;
                    }
                    if (dep.link == DLink.STRONG && dep.source instanceof IPyroObject && !allToRemove.contains((IPyroObject)((Object)dep.source))) {
                        if (dep.source == obj) {
                            return false;
                        }
                        incidentalDeletes.add((IPyroObject)((Object)dep.source));
                        continue;
                    }
                    dep.source.taskReplaceDep(iPyroObject, null).run();
                }
            }
            toRemove = incidentalDeletes;
        }
        return true;
    }

    public void reset() {
        this.set(GEOM_SPACE, GeomSpace.S3D);
        this.set(LOCATION, new UnitDouble(0.0, SI.METER));
        this.set(ORIENTATION, new Vector3d(0.0, 0.0, -1.0));
        this.set(HEIGHT, new UnitDouble(1.0, SI.METER));
        this.set(THICKNESS, new UnitDouble(0.2, SI.METER));
        this.set(SURFACE, this.d_mediator.getSurfaceMgr().getDefaultSurfaceObj());
        this.set(COLOR, null);
        this.set(THICKEN, false);
        this.set(PERMIT_HOLES, true);
        PartCloud defPC = new PartCloud();
        this.set(INSERTION, new Pair<PartCloud.IInsertion, Object>(defPC.getInsertion(), null));
        this.set(DROP_COUNT, defPC.getInitDrops());
        Particle part = !this.d_mediator.getPartList().flatten().isEmpty() ? (Particle)this.d_mediator.getPartList().flatten().iterator().next() : null;
        this.set(PARTICLES, part);
        this.set(INIT, new InitRegion());
        this.set(DEVC, DrawProps.getDefaultDevc());
        this.set(NORMAL_SOLID, new Vector3d(0.0, 0.0, -1.0));
        this.set(CELL_TYPE, MeshCellType.FIXED_SIZE);
        UnitDouble defCellSize = new UnitDouble(0.2, SI.METER);
        this.set(CELL_SIZE, new UnitDouble[]{defCellSize, defCellSize, defCellSize});
        this.set(CELL_COUNT, new int[]{10, 10, 10});
        this.set(NAME, new HashMap());
        for (ObjType type : ObjType.values()) {
            this.set(new Prop(DrawProps.getNameKey(type)), type.defName);
        }
        this.set(SPECIFY_COLOR, false);
        this.set(SPECIFY_SURFACE, true);
        this.set(REMOVE_TEX_UV, false);
        this.set(AXIS, null);
        this.set(SLICE_QUANTITY, Quantity.TEMPERATURE.create());
        this.set(SLICE_VECTOR, false);
        this.set(SLICE_CENTERED, false);
    }

    private static IDevice getDefaultDevc() {
        return new GasPointMeasurer(Intl.intl("Device"), Quantity.TEMPERATURE.create(), new FreePointLoc());
    }

    public <T> void set(Prop<T> prop, T val) {
        this.d_values.put(prop.key, val);
    }

    public <T> T get(Prop<T> prop) {
        return (T)this.d_values.get(prop.key);
    }

    public static String getNameKey(ObjType type) {
        return type.name() + "_NAME";
    }

    public Predicate<Surface> getSurfFilter(ObjType objType, Class<? extends IGeom> geomType) {
        switch (objType) {
            case OBSTRUCTION: {
                return Obstruction.getSurfaceFilter();
            }
            case VENT: {
                return Vent.getSurfaceFilter();
            }
        }
        return Filters.rejectAll();
    }

    public String getThicknessDesc(ObjType objType, Class<? extends IGeom> geomType) {
        if (AABoxGeom.class.isAssignableFrom(geomType)) {
            return Intl.intl("Size");
        }
        if (WallGeom.class.isAssignableFrom(geomType)) {
            return Intl.intl("Wall Thickness");
        }
        return Intl.intl("Thickness");
    }

    public Set<Prop<?>> getObjPropTypes(ObjType objType) {
        switch (objType) {
            case HOLE: {
                return Sets.fromArrayHS(NAME, SPECIFY_COLOR);
            }
            case OBSTRUCTION: {
                return Sets.fromArrayHS(NAME, SURFACE, COLOR, THICKEN, PERMIT_HOLES);
            }
            case VENT: {
                return Sets.fromArrayHS(NAME, SURFACE, COLOR);
            }
            case HVAC_NODE: {
                return Sets.fromArrayHS(NAME);
            }
            case PART_CLOUD: {
                return Sets.fromArrayHS(NAME, PARTICLES, INSERTION, DROP_COUNT);
            }
            case INIT_REGION: {
                return Sets.fromArrayHS(NAME, INIT);
            }
            case POINT_DEVC: {
                return Sets.fromArrayHS(NAME, DEVC);
            }
            case MESH: {
                return Sets.fromArrayHS(NAME, SPECIFY_COLOR, CELL_TYPE, CELL_COUNT, CELL_SIZE);
            }
            case ZONE: {
                return Sets.fromArrayHS(NAME);
            }
            case MESH_SPLIT: {
                return Sets.fromArrayHS(AXIS);
            }
            case SLICE: {
                return Sets.fromArrayHS(NAME, SLICE_VECTOR, SLICE_CENTERED, SLICE_QUANTITY, AXIS);
            }
            case SLICE3D: {
                return Sets.fromArrayHS(NAME, SLICE_VECTOR, SLICE_CENTERED, SLICE_QUANTITY);
            }
        }
        return Collections.EMPTY_SET;
    }

    public Set<Prop<?>> getGeomPropTypes(Class<? extends IGeom> geomType) {
        if (AABoxGeom.class.isAssignableFrom(geomType) || WallGeom.class.isAssignableFrom(geomType)) {
            return Sets.fromArrayHS(THICKNESS, LOCATION, HEIGHT);
        }
        if (IPolygon.class.isAssignableFrom(geomType)) {
            return Sets.fromArrayHS(LOCATION);
        }
        if (ExtrudedPoly.class.isAssignableFrom(geomType)) {
            return Sets.fromArrayHS(THICKNESS, LOCATION);
        }
        if (Point.class.isAssignableFrom(geomType)) {
            return Sets.fromArrayHS(LOCATION, ORIENTATION, NORMAL_SOLID);
        }
        if (PlanarSurface.class.isAssignableFrom(geomType)) {
            return Sets.fromArrayHS(AXIS);
        }
        return Collections.EMPTY_SET;
    }

    public Set<Prop<?>> getPropTypes(ObjType objType, Class<? extends IGeom> geomType) {
        HashSet props = new HashSet(this.getObjPropTypes(objType));
        props.addAll(this.getGeomPropTypes(geomType));
        return props;
    }

    public IPyroGeomSrc newObject(ObjType type, IGeomNode node) {
        IPyroGeomSrc protoType = type == ObjType.POINT_DEVC ? (IPyroGeomSrc)this.get(DEVC) : null;
        node = this.finalizeGeom(protoType, type, node);
        if (node == null) {
            return null;
        }
        String nameKey = DrawProps.getNameKey(type);
        String name = (String)this.get(new Prop(nameKey));
        IPyroGeomSrc result = null;
        switch (type) {
            case OBSTRUCTION: {
                result = new Obstruction(name, node, new Surface[]{this.get(SURFACE)});
                break;
            }
            case HOLE: {
                result = new Hole(name, node);
                break;
            }
            case VENT: {
                IGeom geom = node.flatten().getLocalGeom();
                assert (geom instanceof AARectangle);
                result = new Vent(name, this.get(SURFACE), (AARectangle)geom);
                break;
            }
            case INIT_REGION: {
                IGeom geom = node.flatten().getLocalGeom();
                assert (geom instanceof AABoxGeom);
                result = new InitRegion(name, (AABoxGeom)geom);
                break;
            }
            case PART_CLOUD: {
                IGeom geom = node.flatten().getLocalGeom();
                assert (geom instanceof AABoxGeom || geom instanceof Point);
                result = new PartCloud(name, this.get(PARTICLES), geom);
                break;
            }
            case POINT_DEVC: {
                IDevice protoDevc = this.get(DEVC);
                if (protoDevc == null) break;
                result = (IDevice)protoDevc.clone();
                break;
            }
            case MESH: {
                IGeom geom = node.flatten().getLocalGeom();
                assert (geom instanceof Grid.GridGeom);
                result = new Grid(name, (Grid.GridGeom)geom);
                break;
            }
            case SLICE: {
                IGeom geom = node.flatten().getLocalGeom();
                assert (geom instanceof PlanarSurface);
                IQuantity quant = this.get(SLICE_QUANTITY);
                result = new PlanarSlice((PlanarSurface)geom, quant, false, false, name);
                break;
            }
            case SLICE3D: {
                IGeom geom = node.flatten().getLocalGeom();
                assert (geom instanceof AABoxGeom);
                IQuantity quant = this.get(SLICE_QUANTITY);
                result = new VolumeSlice(name, geom, quant, false, false);
                break;
            }
            case MESH_SPLIT: {
                result = new GenericGeomSrc(name, node, DisplayGeom.EMPTY.props);
                break;
            }
            case ZONE: {
                IGeom geom = node.flatten().getLocalGeom();
                assert (geom instanceof Point);
                result = new Zone(name, (Point)geom);
                break;
            }
            case HVAC_NODE: {
                assert (node.flatten().getLocalGeom() instanceof Point);
                HvacNode hvacnode = new HvacNode(name);
                hvacnode.setGeom(node);
                result = hvacnode;
                break;
            }
            case HVAC_DUCT: {
                HvacDuct duct = new HvacDuct(name);
                duct.setGeom(node);
                result = duct;
                break;
            }
        }
        if (result != null) {
            result = this.updateObject(result, type);
        }
        return result;
    }

    public IPyroGeomSrc updateObject(IPyroGeomSrc existing, ObjType type) {
        if (existing == null) {
            return null;
        }
        String nameKey = DrawProps.getNameKey(type);
        String name = (String)this.get(new Prop(nameKey));
        if (existing instanceof INamed && TVEntryPoints.ep(existing).canRename(this.d_mediator, existing)) {
            ((INamed)((Object)existing)).setName(name);
        }
        if (existing instanceof ISurfObj) {
            ((ISurfObj)existing).setSurfaces(new Surface[]{this.get(SURFACE)});
        }
        if (existing instanceof FDSObject) {
            ((FDSObject)existing).setColors(this.get(COLOR));
        }
        switch (type) {
            case OBSTRUCTION: {
                Obstruction obst = (Obstruction)existing;
                obst.setOptions(1, this.get(THICKEN));
                obst.setOptions(4, this.get(PERMIT_HOLES));
                break;
            }
            case INIT_REGION: {
                InitRegion cloud = (InitRegion)existing;
                InitRegion template = this.get(INIT);
                cloud.setDensity(template.getDensity());
                cloud.setExtraSpecies(new LinkedIdentityHashMap<ExSpec, UnitDouble>(template.getExtraSpecies()), template.getExtraSpeciesType());
                cloud.setTemperature(template.getTemperature());
                break;
            }
            case PART_CLOUD: {
                PartCloud cloud = (PartCloud)existing;
                cloud.setParticle(this.get(PARTICLES));
                Pair<PartCloud.IInsertion, ControlBridge> insertion = this.get(INSERTION);
                cloud.setInsertion((PartCloud.IInsertion)insertion.v1);
                if (insertion.v2 == null) {
                    cloud.getInputPin().disconnectAll();
                } else {
                    cloud.getInputPin().connect(((ControlBridge)insertion.v2).getOutputPins().get(0));
                }
                cloud.setInitDrops(this.get(DROP_COUNT));
                break;
            }
            case MESH: {
                Grid grid = (Grid)existing;
                grid.setColor(this.get(COLOR));
                break;
            }
            case POINT_DEVC: {
                IDevice protoDevc = this.get(DEVC);
                if (protoDevc == null) break;
                IDevice devc = (IDevice)protoDevc.clone();
                devc.setName(name);
                existing = devc;
                break;
            }
            case SLICE: {
                PlanarSlice slice = (PlanarSlice)existing;
                slice.setQuantity(this.get(SLICE_QUANTITY));
                slice.setIncludeFlowVector(this.get(SLICE_VECTOR));
                slice.setCellCentered(this.get(SLICE_CENTERED));
                break;
            }
            case SLICE3D: {
                VolumeSlice slice = (VolumeSlice)existing;
                IQuantity quant = this.get(SLICE_QUANTITY);
                slice.setName(name);
                slice.setQuantity(quant);
                slice.setIncludeFlowVector(this.get(SLICE_VECTOR));
                slice.setCellCentered(this.get(SLICE_CENTERED));
                break;
            }
            case MESH_SPLIT: {
                GenericGeomSrc src = (GenericGeomSrc)existing;
                IGeomNode geom = src.getGeom();
                IPrimProps.Face faceProps = new IPrimProps.Face(new Color(255, 255, 255, 128), null, 0);
                IPrimProps.Edge edgeProps = new IPrimProps.Edge(new Color(255, 255, 255, 255), 3.0, IPrimProps.DEF_STIPPLE, 0);
                PropsBuilder props = new PropsBuilder();
                for (IPrimitive prim : GeomUtil.explodeToTypes(geom.flatten().getLocalGeom(), 7)) {
                    if (prim instanceof IFace) {
                        props.add(faceProps);
                        continue;
                    }
                    props.add(edgeProps);
                }
                src.setDisplayProps(props.finalizeProps());
                break;
            }
        }
        return existing;
    }

    public IGeomNode finalizeGeom(IPyroGeomSrc existing, ObjType type, IGeomNode node) {
        IGeom geom = node.getLocalGeom();
        switch (type) {
            case POINT_DEVC: {
                assert (geom instanceof Point);
                Point p = (Point)geom;
                if (existing instanceof IFreePointDevice) {
                    IFreePointDevice devc = (IFreePointDevice)existing;
                    FreePointLoc loc = devc.getLocation();
                    Vector3d orientation = this.get(ORIENTATION);
                    if (orientation.equals(new Vector3d(0.0, 0.0, -1.0))) {
                        return GeomNodeUtil.newNode(new FreePointGeom(loc.setGeom(p)));
                    }
                    return GeomNodeUtil.newNode(new FreePointGeom(loc.setGeom(p, orientation)));
                }
                if (existing instanceof IAttachedPointDevice) {
                    IAttachedPointDevice devc = (IAttachedPointDevice)existing;
                    AttachedPointLoc loc = devc.getAttachedLocation();
                    return GeomNodeUtil.newNode(new AttachedPointGeom(new AttachedPointLoc(new UnitPoint3D(p.loc, Geometry.LU), this.get(NORMAL_SOLID), loc.d_rotation)));
                }
            }
            case MESH: {
                assert (geom instanceof AABoxGeom);
                try {
                    int[] counts;
                    AABoxGeom boxGeom = (AABoxGeom)geom;
                    if (boxGeom.min.x == boxGeom.max.x || boxGeom.min.y == boxGeom.max.y || boxGeom.min.z == boxGeom.max.z) {
                        return null;
                    }
                    UnitPoint3D min = new UnitPoint3D(boxGeom.min, Geometry.LU);
                    UnitPoint3D max = new UnitPoint3D(boxGeom.max, Geometry.LU);
                    if (this.get(CELL_TYPE) == MeshCellType.FIXED_COUNT) {
                        counts = this.get(CELL_COUNT);
                    } else {
                        UnitDouble[] sizes = this.get(CELL_SIZE);
                        counts = new int[]{DrawProps.countDivs(sizes[0], boxGeom.min.x, boxGeom.max.x), DrawProps.countDivs(sizes[1], boxGeom.min.y, boxGeom.max.y), DrawProps.countDivs(sizes[2], boxGeom.min.z, boxGeom.max.z)};
                        max = new UnitPoint3D(min.xu().add(sizes[0].scale(counts[0])), min.yu().add(sizes[1].scale(counts[1])), min.zu().add(sizes[2].scale(counts[2])));
                    }
                    if (counts[0] <= 0 || counts[1] <= 0 || counts[2] <= 0) {
                        return null;
                    }
                    Grid.GridGeom ggeom = new Grid.GridGeom(min, max, Grid.makeUniformDivisions(counts[0], min.xu(), max.xu()), Grid.makeUniformDivisions(counts[1], min.yu(), max.yu()), Grid.makeUniformDivisions(counts[2], min.zu(), max.zu()));
                    return GeomNodeUtil.newNode(ggeom);
                }
                catch (Throwable t) {
                    System.out.println(t.getMessage());
                    return null;
                }
            }
            case MESH_SPLIT: {
                List<IGeom> planes = geom instanceof GeomGroup ? ((GeomGroup)geom).children : Arrays.asList(geom);
                ArrayList<IPrimitive> resultGeoms = new ArrayList<IPrimitive>();
                for (Grid grid : PyroSim.getApp().getMediator().getSelectionModel().flatten(Grid.class)) {
                    AABox bounds = grid.getBounds();
                    UnitDouble[][] divs = new UnitDouble[][]{null, null, null};
                    for (PlanarSurface ps : theUtil.filter(planes, PlanarSurface.class)) {
                        UnitDouble pval;
                        int ix;
                        int axis = Util3D.getClosestAxis(ps.plane.getNormal());
                        if (divs[axis] == null) {
                            divs[axis] = grid.getLinePositions(axis);
                        }
                        if ((ix = ActionsMesh.SplitMeshAction.getSplitIndex(divs[axis], pval = new UnitDouble(-ps.plane.w, Geometry.LU))) <= 0 || ix >= divs[axis].length - 1) continue;
                        double[] min = new double[]{bounds.getMinX(), bounds.getMinY(), bounds.getMinZ()};
                        double[] max = new double[]{bounds.getMaxX(), bounds.getMaxY(), bounds.getMaxZ()};
                        min[axis] = max[axis] = divs[axis][ix].getValue(Geometry.LU);
                        AARectangle rect = AARectangle.construct(new Point3d(min), new Point3d(max), 1.0E-9, false);
                        assert (rect != null);
                        resultGeoms.add(rect);
                        ArrayList<ICurve> outline = new ArrayList<ICurve>();
                        rect.getBoundary(outline);
                        resultGeoms.addAll(outline);
                    }
                }
                return GeomNodeUtil.newNode(GeomUtil.group(resultGeoms));
            }
        }
        return node;
    }

    private static int countDivs(UnitDouble size, double min, double max) {
        double sized = size.getValue(Geometry.LU);
        double length = max - min;
        return Math.max(1, (int)Math.round(length / sized));
    }

    public static class Prop<DataT> {
        public final String key;

        public Prop(String key) {
            this.key = key;
        }
    }

    public static enum GeomSpace {
        S0D,
        S1D,
        S2D,
        S3D;

    }

    public static enum MeshCellType {
        FIXED_SIZE,
        FIXED_COUNT;

    }

    public static enum ObjType {
        OBSTRUCTION(Intl.intl("Obstruction")),
        HOLE(Intl.intl("Hole")),
        VENT(Intl.intl("Vent")),
        PART_CLOUD(Intl.intl("Particle Cloud")),
        INIT_REGION(Intl.intl("Init Region")),
        POINT_DEVC(Intl.intl("Device")),
        MESH(Intl.intl("MESH")),
        SLICE(Intl.intl("Slice")),
        SLICE3D(Intl.intl("3D Slice")),
        MESH_SPLIT(""),
        ZONE(Intl.intl("Zone")),
        HVAC_NODE(Intl.intl("Node")),
        HVAC_DUCT(Intl.intl("Duct"));

        public final String defName;

        private ObjType(String defName) {
            this.defName = defName;
        }
    }
}

