/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.EnumSet;
import java.util.List;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.geom.Geometry;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.PyroToolHooks;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.PlanarSurface;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.HoverWindow;
import thunderheadeng.gui.MenuBuilder;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.tools.AdvancedTool;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.scene3d.tools.IToggleListener;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;

public class DrawPlaneGeomTool
extends ADrawTool {
    private final Deque<PlaneLoc> d_planeLocs;
    private final boolean d_multiplePlanes;
    private final IAutoAxisChooser d_autoAxisChooser;
    private PlaneHover d_planeHover;

    public DrawPlaneGeomTool(IToolController mv, DrawProps toolProps, boolean multiplePlanes, boolean axisAligned) {
        this(mv, toolProps, multiplePlanes, axisAligned, null);
    }

    public DrawPlaneGeomTool(IToolController mv, DrawProps toolProps, boolean multiplePlanes, boolean axisAligned, IAutoAxisChooser autoAxisChooser) {
        super(mv, toolProps, (IToolFunction)new ToolFunc(), DrawProps.GeomSpace.S2D);
        this.d_autoAxisChooser = autoAxisChooser;
        this.d_multiplePlanes = multiplePlanes;
        this.d_planeLocs = new ArrayDeque<PlaneLoc>();
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IAdvancedTool tool) {
                DrawPlaneGeomTool.this.setAxis(DrawPlaneGeomTool.this.getNextAxis());
                DrawPlaneGeomTool.this.repaintSurface();
            }
        });
        this.setMenuBuilder(PyroToolHooks.Menu.TOOL_ACTIONS.key, (IAdvancedTool tool, MenuBuilder builder) -> {
            if (this.d_multiplePlanes) {
                builder.add(new FinishAction());
                builder.addSeparator();
            }
            ArrayList<PlaneAction> planeActions = new ArrayList<PlaneAction>();
            for (Geometry.Axis plane : this.getAllowableAxes()) {
                planeActions.add(new PlaneAction(plane));
            }
            builder.addMutuallyExclusive(planeActions);
        });
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return PlanarSurface.class;
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
    }

    protected PlaneHover getHoverWindow() {
        if (this.d_planeHover == null) {
            this.d_planeHover = new PlaneHover(this.getAttachedComponent());
        }
        return this.d_planeHover;
    }

    @Override
    protected boolean getSnapToWorkingPlane() {
        return false;
    }

    @Override
    public void activate() {
        super.activate();
        List<Geometry.Axis> allowableAxes = this.getAllowableAxes();
        if (!allowableAxes.contains((Object)this.getAxis())) {
            this.setAxis(allowableAxes.get(0));
        }
        this.getHoverWindow().attach();
    }

    @Override
    public void deactivate() {
        this.getHoverWindow().detach();
        super.deactivate();
    }

    @Override
    public void reset() {
        this.d_planeLocs.clear();
        this.updateGeom();
        super.reset();
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    private void updateAll() {
        this.updateStatusMessage();
        this.updateHoverWindow();
        this.updateGeom();
    }

    protected void setAxis(Geometry.Axis axis) {
        if (this.getProps().get(DrawProps.AXIS) == axis) {
            return;
        }
        this.getProps().set(DrawProps.AXIS, axis);
        if (!this.d_planeLocs.isEmpty() && !this.d_planeLocs.peekLast().committed) {
            PlaneLoc lastLoc = this.d_planeLocs.removeLast();
            this.d_planeLocs.addLast(new PlaneLoc(this.chooseAxis(lastLoc.p), lastLoc.p, lastLoc.committed));
        }
        this.updateAll();
    }

    protected Geometry.Axis getAxis() {
        return this.getProps().get(DrawProps.AXIS);
    }

    protected void updateHoverWindow() {
        if (this.d_planeLocs.isEmpty()) {
            this.getHoverWindow().setVisible(false);
            return;
        }
        PlaneLoc loc = this.d_planeLocs.peekLast();
        this.getHoverWindow().setPlane(loc.axis, loc.axis.getVal(loc.p));
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        List<Point3d> allPoints;
        if (!this.d_planeLocs.isEmpty() && !this.d_planeLocs.peekLast().committed) {
            this.d_planeLocs.removeLast();
        }
        this.pauseRepaint();
        if (!p.committed && p.dragged && (allPoints = history.getAllPoints()).size() >= 2) {
            Point3d p1 = allPoints.get(allPoints.size() - 2);
            Point3d p2 = allPoints.get(allPoints.size() - 1);
            double[] diffs = new double[]{Math.abs(p1.x - p2.x), Math.abs(p1.y - p2.y), Math.abs(p1.z - p2.z)};
            int minAxis = 0;
            double minDiff = diffs[0];
            for (int m = 1; m < 3; ++m) {
                if (!(diffs[m] < minDiff)) continue;
                minDiff = diffs[m];
                minAxis = m;
            }
            Geometry.Axis newPlane = Geometry.Axis.values()[minAxis];
            if (this.getAxis() != null) {
                this.setAxis(newPlane);
            }
            if (!this.d_planeLocs.isEmpty()) {
                PlaneLoc lastLoc = this.d_planeLocs.removeLast();
                this.d_planeLocs.addLast(new PlaneLoc(newPlane, lastLoc.p, true));
            }
        }
        if (!p.dragged) {
            this.d_planeLocs.add(new PlaneLoc(this.chooseAxis(p.p), p.p, p.committed));
        }
        this.updateAll();
        this.resumeRepaint();
    }

    protected Geometry.Axis chooseAxis(Point3d p) {
        Geometry.Axis result;
        Geometry.Axis axis = this.getAxis();
        if (axis != null) {
            return axis;
        }
        if (this.d_autoAxisChooser != null && (result = this.d_autoAxisChooser.chooseAxis(this, p)) != null) {
            return result;
        }
        System.out.println("Could not determine auto axis");
        return Geometry.Axis.X;
    }

    protected Geometry.Axis getNextAxis() {
        List<Geometry.Axis> planes = this.getAllowableAxes();
        int ix = planes.indexOf((Object)this.getAxis());
        ix = ix < 0 ? 0 : (ix + 1) % planes.size();
        return planes.get(ix);
    }

    public List<Geometry.Axis> getAllowableAxes() {
        EnumSet<Geometry.Axis> allowablePlanes = EnumSet.allOf(Geometry.Axis.class);
        if (this.getView().getCamera() instanceof OrthoCamera) {
            Vector3d dir = Util3D.normalize(this.getView().getCamera().getViewVector());
            int axis = Util3D.getClosestAxis(dir);
            allowablePlanes.remove((Object)Geometry.Axis.values()[axis]);
        }
        ArrayList<Geometry.Axis> result = new ArrayList<Geometry.Axis>();
        if (this.d_autoAxisChooser != null) {
            result.add(null);
        }
        result.addAll(allowablePlanes);
        return result;
    }

    @Override
    public void finish() {
        if (!this.d_planeLocs.isEmpty() && !this.d_planeLocs.getLast().committed) {
            this.d_planeLocs.removeLast();
        }
        this.updateGeom();
        this.fireFinish(!this.d_planeLocs.isEmpty());
        super.finish();
    }

    protected void updateGeom() {
        if (this.d_planeLocs.isEmpty()) {
            this.fireRemove(0);
        } else {
            List<Plane3d> planes = this.getPlanes();
            ArrayList<PlanarSurface> surfs = new ArrayList<PlanarSurface>(planes.size());
            for (Plane3d plane : planes) {
                surfs.add(new PlanarSurface(plane));
            }
            IGeom geom = GeomUtil.group(surfs);
            this.fireUpdate(0, GeomNodeUtil.newNode(geom), null);
        }
    }

    public List<Plane3d> getPlanes() {
        ArrayList<Plane3d> planes = new ArrayList<Plane3d>(this.d_planeLocs.size());
        for (PlaneLoc loc : this.d_planeLocs) {
            UnitDouble val = loc.axis.getVal(loc.p);
            Vector3d vec = loc.axis.toVec();
            Plane3d plane = new Plane3d(vec.x, vec.y, vec.z, -val.getValue(Geometry.LU));
            planes.add(plane);
        }
        return planes;
    }

    @Override
    protected String getStatusMessage() {
        ArrayList<String> messages = new ArrayList<String>();
        if (this.d_multiplePlanes) {
            messages.add(Intl.intl("Multi-click to set locations. Right-click to finish."));
        }
        messages.add(Intl.intl("Click-drag to change orientation"));
        Geometry.Axis nextAxis = this.getNextAxis();
        if (nextAxis != null) {
            messages.add(String.format(Intl.intl("Press CTRL to specify <i>%s axis</i>"), nextAxis.toString()));
        } else {
            messages.add(Intl.intl("Press CTRL to choose axis automatically"));
        }
        Object status = "<html>";
        for (String string : messages) {
            String string2 = "&lt;" + string + "&gt;";
            status = (String)status + string2;
        }
        status = (String)status + "</html>";
        return status;
    }

    private static String getActionName(Geometry.Axis axis) {
        if (axis != null) {
            return String.format(Intl.intl("Set axis to %s"), axis.toString());
        }
        return Intl.intl("Choose axis automatically");
    }

    public static interface IAutoAxisChooser {
        public Geometry.Axis chooseAxis(DrawPlaneGeomTool var1, Point3d var2);
    }

    protected static class ToolFunc
    extends AdvancedTool.ToolFunc<DrawPlaneGeomTool> {
        protected ToolFunc() {
        }

        @Override
        public void mouseReleased(DrawPlaneGeomTool tool, MouseEvent e) {
            super.mouseReleased(tool, e);
            if (!tool.d_multiplePlanes && !tool.d_planeLocs.isEmpty() && tool.d_planeLocs.peekLast().committed) {
                tool.finish();
            }
        }
    }

    private static class PlaneHover
    extends HoverWindow {
        private static final long serialVersionUID = 3419918394404288603L;
        private Geometry.Axis d_axis;
        private UnitDouble d_val;

        public PlaneHover(Component c) {
            super(c);
        }

        public void setPlane(Geometry.Axis axis, UnitDouble val) {
            this.d_axis = axis;
            this.d_val = val;
            this.update();
        }

        public void update() {
            if (this.d_axis == null || this.d_val == null) {
                this.setVisible(false);
                return;
            }
            Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
            String lbl = String.format("%s = %s", this.d_axis.toString(), Global.format(this.d_val.getValue(unit), unit));
            this.getContentPane().removeAll();
            GridBagHelper gb = new GridBagHelper(this.getContentPane());
            gb.addFilledRow(lbl);
            gb.finalizeRows();
            this.pack();
            this.setVisible(true);
            this.repaint();
        }
    }

    private static class PlaneLoc {
        public final Geometry.Axis axis;
        public final Point3d p;
        public final boolean committed;

        public PlaneLoc(Geometry.Axis axis, Point3d p, boolean committed) {
            this.axis = axis;
            this.p = p;
            this.committed = committed;
        }
    }

    public class FinishAction
    extends guiAction {
        private static final long serialVersionUID = -1349713789023524525L;

        public FinishAction() {
            super(Intl.intl("Finish"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DrawPlaneGeomTool.this.finish();
        }
    }

    public class PlaneAction
    extends BooleanAction {
        private static final long serialVersionUID = 446317840765443593L;
        private final Geometry.Axis axis;

        public PlaneAction(Geometry.Axis axis) {
            super(DrawPlaneGeomTool.getActionName(axis), axis == DrawPlaneGeomTool.this.getAxis());
            this.axis = axis;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                DrawPlaneGeomTool.this.setAxis(this.axis);
            }
        }
    }
}

