/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.function.Supplier;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.geom.Geometry;
import pyrosim.mv.ModelView;
import pyrosim.mv.snappers.IGridSnapper;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import pyrosim.mv.tools.PyroToolHooks;
import pyrosim.util.Rectifier;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.Inter3D;
import thunderheadeng.geometry.LineSegRTreeTest;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.geometry.Util;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IFace;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.IPrimitive;
import thunderheadeng.geometry.objs.elem.IPrimElements;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.TransformUtil;
import thunderheadeng.gui.BooleanAction;
import thunderheadeng.gui.MenuBuilder;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.geom.IPrimProps;
import thunderheadeng.scene3d.nativebuffered.OrthoCamera;
import thunderheadeng.scene3d.navtools.CursorTool;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.IToolFunction;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.picking.IIsectCollector;
import thunderheadeng.scene3d.picking.IIsectFilter;
import thunderheadeng.scene3d.picking.IsectInfo;
import thunderheadeng.scene3d.picking.RayPointProx;
import thunderheadeng.scene3d.tools.AdvancedTool;
import thunderheadeng.scene3d.tools.IAdvancedTool;
import thunderheadeng.scene3d.tools.IToggleListener;
import thunderheadeng.scene3d.tools.MouseHistory;
import thunderheadeng.util.Pair;

public class DrawGridCellTool
extends ADrawTool {
    private static final int TEMP_BLOCK_ID = -1;
    private AABoxGeom d_block;
    private IPolygon d_gridCell;
    private final Set<Point3d> d_coordsUsed = new HashSet<Point3d>();
    private final List<AABoxGeom> d_blocksToAdd;
    private boolean d_blockVis = false;
    private Orient d_orient = Orient.TOWARD_CAMERA;

    public DrawGridCellTool(ModelView mv, DrawProps toolProps) {
        super((IToolController)mv, toolProps, (IToolFunction)new Func(), DrawProps.GeomSpace.S3D);
        this.d_blocksToAdd = new ArrayList<AABoxGeom>();
        this.addToggleListener(new IToggleListener(){

            @Override
            public void toolToggled(IAdvancedTool tool) {
                DrawGridCellTool.this.setOrient(DrawGridCellTool.this.d_orient.next());
            }
        });
        this.setMenuBuilder(PyroToolHooks.Menu.TOOL_ACTIONS.key, (IAdvancedTool tool, MenuBuilder builder) -> builder.addMutuallyExclusive(new FlipExtrusion(Orient.AWAYFROM_CAMERA), new FlipExtrusion(Orient.TOWARD_CAMERA)));
    }

    @Override
    protected Pair<SnapMode, IIsectFilter> getSnapInfo() {
        if (this.getView().getCamera() instanceof OrthoCamera) {
            return new Pair<SnapMode, Object>(SnapMode.NONE, null);
        }
        return new Pair<SnapMode, IIsectFilter>(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(GeomType.FACE));
    }

    @Override
    public Point3d getAngledSnapBasis() {
        return null;
    }

    public Class getGeomType() {
        return AABoxGeom.class;
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
    }

    private void showBlock() {
        if (!this.d_blockVis) {
            this.fireUpdate(-1, GeomNodeUtil.newNode(this.d_block), null);
            this.d_blockVis = true;
        }
    }

    private void hideBlock() {
        if (this.d_blockVis) {
            this.fireRemove(-1);
            this.d_blockVis = false;
        }
    }

    private void updateBlock() {
        Pair<AABox, IPolygon> result = this.getBlockCoordsGeom();
        if (result != null) {
            AABox box = (AABox)result.v1;
            this.d_block = new AABoxGeom(box.getMin(), box.getMax());
            this.d_gridCell = (IPolygon)result.v2;
            this.fireUpdate(-1, GeomNodeUtil.newNode(this.d_block), null);
        }
    }

    @Override
    public void activate() {
        this.d_block = new AABoxGeom(new Point3d(0.0, 0.0, 0.0), new Point3d(0.0, 0.0, 0.0));
        this.d_gridCell = null;
        super.activate();
    }

    private Pair<AABox, IPolygon> getBlockCoordsGeom() {
        IPolygon cell;
        IPrimitive prim;
        Unit u = Geometry.LU;
        DrawProps props = this.getProps();
        double depthMin = props.get(DrawProps.LOCATION).getValue(u);
        double height = props.get(DrawProps.HEIGHT).getValue(u);
        double halfThickness = props.get(DrawProps.THICKNESS).getValue(u) * 0.5;
        CursorTool.Ray pickRay = this.getPickRay();
        if (this.getView().getCamera() instanceof OrthoCamera) {
            Vector3d extrudeDir;
            AABox bounds;
            IPolygon pickedCell = null;
            IsectInfo cellIsect = this.pickGridCell(pickRay.begin, pickRay.dir);
            if (cellIsect != null) {
                assert (cellIsect.getPrim != null);
                IPrimitive prim2 = cellIsect.getPrim.get();
                assert (prim2 instanceof IPolygon);
                IPolygon poly = (IPolygon)prim2;
                bounds = poly.getBoundingBox(new AABox());
                extrudeDir = poly.getNormal(true);
                pickedCell = poly;
            } else {
                extrudeDir = new Vector3d(this.getView().getCamera().getViewVector());
                extrudeDir.normalize();
                Plane3d isectPlane = new Plane3d(extrudeDir.x, extrudeDir.y, extrudeDir.z, 0.0);
                Point3d pisect = Inter3D.linePlaneIntersection(pickRay.begin, pickRay.dir, isectPlane, 1.0E-6);
                if (pisect == null) {
                    return null;
                }
                bounds = new AABox(pisect.x - halfThickness, pisect.y - halfThickness, pisect.z - halfThickness, pisect.x + halfThickness, pisect.y + halfThickness, pisect.z + halfThickness);
            }
            Point3d min = bounds.getMin();
            Point3d max = bounds.getMax();
            int closestAxis = Util.getClosestAxis(extrudeDir);
            DrawGridCellTool.convertPointFromDepth(min, depthMin, closestAxis);
            DrawGridCellTool.convertPointFromDepth(max, depthMin + height, closestAxis);
            Rectifier.rectify(min, max);
            return new Pair<AABox, IPolygon>(new AABox(min, max), pickedCell);
        }
        IsectInfo objIsect = null;
        Collection<IsectInfo> objIsects = this.getP1().snaps;
        if (!objIsects.isEmpty()) {
            objIsect = objIsects.iterator().next();
        }
        Point3d loc = this.getP1().referenceSnap;
        Vector3d projDir = new Vector3d(0.0, 0.0, -1.0);
        if (objIsect != null && objIsect.getPrim != null && (prim = objIsect.getPrim.get()) instanceof IPolygon) {
            Vector3d normal = ((IPolygon)prim).getNormal(true);
            int projAxis = Util3D.getClosestAxis(normal);
            switch (projAxis) {
                case 0: {
                    projDir = new Vector3d(1.0, 0.0, 0.0);
                    break;
                }
                case 1: {
                    projDir = new Vector3d(0.0, 1.0, 0.0);
                    break;
                }
                default: {
                    projDir = new Vector3d(0.0, 0.0, 1.0);
                }
            }
        }
        IsectInfo cellIsect = this.pickGridCell(loc, projDir);
        IPolygon pickedCell = null;
        if (cellIsect != null && cellIsect.getPrim != null) {
            IPrimitive prim3 = cellIsect.getPrim.get();
            assert (prim3 instanceof IPolygon);
            pickedCell = cell = (IPolygon)prim3;
            Vector3d moveVec = Util3D.vector(cellIsect.isectPoint, loc);
            ITransform xform = TransformUtil.translate(moveVec.x, moveVec.y, moveVec.z);
            cell = cell.transform(xform.getInfo(), 0);
        } else {
            Point3d p = loc;
            cell = Math.abs(projDir.x) == 1.0 ? new AARectangle(0, p.x, p.y - halfThickness, p.z - halfThickness, p.y + halfThickness, p.z + halfThickness, false) : (Math.abs(projDir.y) == 1.0 ? new AARectangle(1, p.y, p.x - halfThickness, p.z - halfThickness, p.x + halfThickness, p.z + halfThickness, false) : new AARectangle(2, p.z, p.x - halfThickness, p.y - halfThickness, p.x + halfThickness, p.y + halfThickness, false));
        }
        Vector3d normal = cell.getNormal(true);
        Vector3d extrudeDir = Util3D.normalize(normal);
        double dot = extrudeDir.dot(pickRay.dir);
        if (dot > 0.0 && this.d_orient == Orient.TOWARD_CAMERA || dot < 0.0 && this.d_orient == Orient.AWAYFROM_CAMERA) {
            extrudeDir.negate();
        }
        extrudeDir.scale(height);
        ExtrudedPoly epoly = new ExtrudedPoly(cell, extrudeDir);
        return new Pair<AABox, IPolygon>(epoly.getBoundingBox(new AABox()), pickedCell);
    }

    protected static void convertPointFromDepth(Point3d point, double depth, int axis) {
        switch (axis) {
            case 0: {
                point.set(depth, point.y, point.z);
                break;
            }
            case 1: {
                point.set(point.x, depth, point.z);
                break;
            }
            case 2: {
                point.set(point.x, point.y, depth);
            }
        }
    }

    protected void setOrient(Orient orient) {
        this.d_orient = orient;
        this.updateBlock();
        this.repaintSurface();
    }

    protected IsectInfo pickGridCell(final Point3d rayBegin, final Vector3d rayDir) {
        IGridSnapper gridSnapper = ((ModelView)this.getModelView()).getCurrentSnapperObj();
        if (gridSnapper == null) {
            return null;
        }
        Point3d sc = this.getView().worldToScreen(rayBegin);
        sc.z = 1.0;
        Point3d p2 = this.getView().screenToWorld(sc);
        final ArrayList isects = new ArrayList();
        IIsectCollector isectsColl = new IIsectCollector(){

            @Override
            public void addFace(Object obj, Point3d p, int primIx, Supplier<IFace> getPrim, Supplier<Vector3d> getNormal, IPrimElements faceElements, IPrimProps props) {
                double zDist = Util3D.tOnLine(rayBegin, rayDir, p);
                isects.add(new IsectInfo(GeomType.FACE, obj, p, getPrim, getNormal, faceElements, props, new RayPointProx(zDist, 0.0)));
            }

            @Override
            public void addNonFace(Object obj, Point3d p, GeomType type, int primIx, IPrimElements primElements) {
                assert (false);
            }

            @Override
            public void addInfinite(Object obj, Point3d p, GeomType type, IPrimitive prim) {
                assert (false);
            }

            @Override
            public void validate() throws CancellationException {
            }
        };
        gridSnapper.pickCells(isectsColl, rayBegin, rayDir, new LineSegRTreeTest(rayBegin, p2));
        if (isects.isEmpty()) {
            return null;
        }
        Collections.sort(isects, new Comparator<IsectInfo>(this){

            @Override
            public int compare(IsectInfo o1, IsectInfo o2) {
                return o1.prox.compareTo(o2.prox);
            }
        });
        return (IsectInfo)isects.iterator().next();
    }

    private void addBlock() {
        AABox bounds = this.d_gridCell != null ? this.d_gridCell.getBoundingBox(new AABox()) : this.d_block.getBoundingBox(new AABox());
        Point3d min = bounds.getMin();
        if (this.d_coordsUsed.contains(min)) {
            return;
        }
        this.d_coordsUsed.add(min);
        AABoxGeom newBlock = this.d_block;
        this.fireUpdate(this.d_blocksToAdd.size(), GeomNodeUtil.newNode(newBlock), null);
        this.d_blocksToAdd.add(newBlock);
    }

    @Override
    protected String getStatusMessage() {
        Pair<AABox, IPolygon> result = this.getBlockCoordsGeom();
        return result == null ? "" : String.format(Intl.intl("Grid cell: %1$s -> %2$s [%3$s x %4$s x %5$s]"), this.toString(((AABox)result.v1).getMin()), this.toString(((AABox)result.v1).getMax()), this.toString(((AABox)result.v1).getWidth()), this.toString(((AABox)result.v1).getDepth()), this.toString(((AABox)result.v1).getHeight()));
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
    }

    protected static class Func
    extends AdvancedTool.ToolFunc<DrawGridCellTool> {
        protected Func() {
        }

        @Override
        public void mouseEntered(DrawGridCellTool tool, MouseEvent e) {
            super.mouseEntered(tool, e);
            tool.showBlock();
            tool.updateBlock();
            tool.repaintSurface();
        }

        @Override
        public void mouseExited(DrawGridCellTool tool, MouseEvent e) {
            super.mouseExited(tool, e);
            tool.hideBlock();
            tool.repaintSurface();
        }

        @Override
        public void mouseMoved(DrawGridCellTool tool, MouseEvent e) {
            super.mouseMoved(tool, e);
            tool.updateBlock();
            tool.repaintSurface();
        }

        @Override
        public void mousePressed(DrawGridCellTool tool, MouseEvent e) {
            super.mousePressed(tool, e);
            if (e.getButton() != 1) {
                return;
            }
            tool.setConsumeEvents(true);
            tool.addBlock();
            tool.repaintSurface();
        }

        @Override
        public void mouseReleased(DrawGridCellTool tool, MouseEvent e) {
            super.mouseReleased(tool, e);
            if (e.getButton() != 1) {
                return;
            }
            tool.addBlock();
            tool.hideBlock();
            tool.fireFinish(true);
            tool.showBlock();
            for (int m = 0; m < tool.d_blocksToAdd.size(); ++m) {
                tool.fireRemove(m);
            }
            tool.d_blocksToAdd.clear();
            tool.d_coordsUsed.clear();
            tool.setConsumeEvents(false);
            tool.finish();
            tool.repaintSurface();
        }

        @Override
        public void mouseDragged(DrawGridCellTool tool, MouseEvent e) {
            super.mouseDragged(tool, e);
            if (!tool.isDragging(1)) {
                return;
            }
            tool.updateBlock();
            tool.addBlock();
            tool.repaintSurface();
        }
    }

    private static enum Orient {
        TOWARD_CAMERA(Intl.intl("Extrude toward camera")),
        AWAYFROM_CAMERA(Intl.intl("Extrude away from camera"));

        private final String name;

        private Orient(String name) {
            this.name = name;
        }

        public Orient next() {
            switch (this) {
                case TOWARD_CAMERA: {
                    return AWAYFROM_CAMERA;
                }
                case AWAYFROM_CAMERA: {
                    return TOWARD_CAMERA;
                }
            }
            return null;
        }
    }

    protected class FlipExtrusion
    extends BooleanAction {
        private static final long serialVersionUID = 8125427830882845020L;
        private final Orient d_orient;

        public FlipExtrusion(Orient orient) {
            super(orient.name, DrawGridCellTool.this.d_orient == orient);
            this.d_orient = orient;
        }

        @Override
        protected void stateChanged() {
            if (this.isSelected()) {
                DrawGridCellTool.this.setOrient(this.d_orient);
            }
        }
    }
}

