/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.tools;

import pyrosim.Intl;
import pyrosim.mv.gui.ValueEditorUtil;
import pyrosim.mv.tools.ADrawTool;
import pyrosim.mv.tools.DrawProps;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.gui.ValueEditor;
import thunderheadeng.scene3d.navtools.IToolController;
import thunderheadeng.scene3d.navtools.SnapMode;
import thunderheadeng.scene3d.picking.DefaultFilter;
import thunderheadeng.scene3d.picking.GeomType;
import thunderheadeng.scene3d.tools.MouseHistory;

public class DrawDeviceTool
extends ADrawTool {
    private Point d_point = null;

    public DrawDeviceTool(IToolController mv, DrawProps toolProps) {
        super(mv, toolProps, DrawProps.GeomSpace.S0D);
        this.setSnapInfo(SnapMode.FILTERED_ONE_PASS, new DefaultFilter(GeomType.FACE_CENTROID, GeomType.FACE));
    }

    @Override
    public Class<? extends IGeom> getGeomType() {
        return Point.class;
    }

    @Override
    protected void initValueEditor(ValueEditor editor) {
        ValueEditorUtil.configureLocation(editor, Intl.intl("Location (x,y,z)"));
    }

    @Override
    public void finish() {
        this.fireFinish(this.d_point != null);
        super.finish();
    }

    @Override
    public void reset() {
        this.fireRemove(0);
        this.d_point = null;
        super.reset();
    }

    @Override
    public void pointAdded(MouseHistory history, MouseHistory.Point p) {
        this.d_point = new Point(p.p);
        this.fireUpdate(0, GeomNodeUtil.newNode(this.d_point), null);
        if (p.committed) {
            this.finish();
        }
        this.repaintSurface();
    }
}

