/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.manip;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import javax.vecmath.Matrix4d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.gui.actions.Actions;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.displays.IPyroDisplayMgr;
import pyrosim.mv.displays.RenderTarget;
import pyrosim.mv.snappers.ModelGridSnapper;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.manip.IHandle;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.scene3d.tools.transform.ITransformMgr;
import thunderheadeng.scene3d.transformpreview.ITransformPreview;
import thunderheadeng.util.LinkedIdentityHashSet;

public class TransformMgr
implements ITransformMgr {
    private final PyroMod d_domain;
    private final DisplayManager d_dispMgr;
    private final DisplayManager d_xformDispMgr;
    private final ModelView d_mv;
    private Collection<IPyroObject> d_xformObjs;
    private Set<IPyroGeomSrc> d_objSet;
    private ITransform d_xform;
    private boolean d_copyMode;
    private ITransformPreview d_xformer;
    private IDOF d_dof;

    public TransformMgr(PyroMod domain, ModelView mv, DisplayManager dispMgr, DisplayManager xformDispMgr) {
        this.d_domain = domain;
        this.d_dispMgr = dispMgr;
        this.d_mv = mv;
        this.d_xformDispMgr = xformDispMgr;
        this.d_xformObjs = Collections.EMPTY_LIST;
        this.d_objSet = Collections.EMPTY_SET;
        this.d_xform = null;
        this.d_copyMode = false;
    }

    public PyroMod getDomain() {
        return this.d_domain;
    }

    public Collection<IPyroObject> getXformObjects() {
        return this.d_xformObjs;
    }

    public boolean canTransform() {
        return !this.d_domain.getSelectionModel().flatten(IPyroGeomSrc.class).isEmpty();
    }

    @Override
    public boolean isTransforming() {
        return !this.d_xformObjs.isEmpty();
    }

    @Override
    public boolean isTransforming(Object o) {
        return this.isTransforming() && !this.getCopyMode() && this.d_objSet.contains(o);
    }

    @Override
    public Object getProxySource(Object obj) {
        ManipMgr manipMgr;
        if (obj instanceof ModelGridSnapper) {
            return ((ModelGridSnapper)obj).getGrid();
        }
        if (obj instanceof IHandle && (manipMgr = this.d_mv.getManipMgr()).getCurrentHandles().contains(obj)) {
            return manipMgr.getCurrentManipObj();
        }
        return obj;
    }

    @Override
    public boolean isTransformValid() {
        return this.isTransforming() && this.d_xform != null && !this.d_xform.isIdentity();
    }

    @Override
    public IDOF getDOF() {
        if (this.d_dof == null) {
            this.begin();
            this.d_dof = GeomUtil.getDOF(Hierarchy.flatten(this.getXformObjects(), IPyroGeomSrc.class));
        }
        return this.d_dof;
    }

    @Override
    public void setCopyMode(boolean copyMode) {
        if (this.d_copyMode == copyMode) {
            return;
        }
        this.d_copyMode = copyMode;
        if (this.isTransforming()) {
            this.d_xformer.setCopyMode(copyMode);
        }
    }

    @Override
    public boolean getCopyMode() {
        return this.d_copyMode;
    }

    public void begin() {
        if (this.isTransforming()) {
            return;
        }
        PyroSim app = PyroSim.getApp();
        Collection<IPyroObject> objs = Actions.getTransformObjs(app, app.getMediator(), new ArrayList<IPyroObject>(this.d_domain.getSelectionModel().getSelected(IPyroObject.class)));
        this.d_dispMgr.d_dispFilter.filterAllOfType(ManipMgr.FILTER_TYPE);
        this.d_xformObjs = objs;
        Collection<IPyroGeomSrc> flattened = Hierarchy.flatten(this.d_xformObjs, IPyroGeomSrc.class);
        this.d_objSet = new LinkedIdentityHashSet<IPyroGeomSrc>(flattened);
        this.d_xformer = this.d_dispMgr.getTransformPreview(this.d_xformDispMgr, (Collection<? extends Object>)this.d_objSet, this.d_copyMode);
    }

    @Override
    public void modify(IntFunction<ITransform> generator) {
        ITransform xform = generator.apply(0);
        try {
            xform.invert();
        }
        catch (Throwable e) {
            System.err.println("Cannot invert matrix.  Skipping transform.");
            return;
        }
        this.d_xform = xform;
        if (!this.d_xform.isIdentity() && !this.isTransforming()) {
            this.begin();
        }
        if (this.d_xformer != null) {
            Matrix4d mat = this.d_xform.toMatrix(false);
            this.d_xformer.setTransform(mat);
            this.applyToScenes(scene -> scene.setTransform(mat));
        }
    }

    private void reset() {
        for (IPyroDisplayMgr dm : this.d_xformDispMgr.getDispManagers()) {
            dm.removeAll();
        }
        this.applyToScenes(scene -> scene.setTransform(null));
        if (this.d_xformer != null) {
            this.d_xformer.end();
            this.d_xformer = null;
        }
        this.d_xform = null;
        this.d_xformObjs = Collections.EMPTY_LIST;
        this.d_objSet = Collections.EMPTY_SET;
        this.d_copyMode = false;
        this.d_dof = null;
        this.d_dispMgr.d_dispFilter.removeFilter(ManipMgr.FILTER_TYPE);
    }

    @Override
    public void cancel() {
        this.reset();
    }

    @Override
    public void commit(Runnable postOp) {
        TransformTask task = null;
        if (this.d_xform != null && !this.d_xform.isIdentity()) {
            final ITransform xform = this.d_xform;
            int numCopies = this.d_copyMode ? 1 : 0;
            task = new TransformTask(this, this.d_domain, this.d_xformObjs, numCopies){

                @Override
                public ITransform getXFormForIteration(int i) {
                    return xform;
                }
            };
        }
        this.reset();
        if (task != null) {
            this.d_domain.getTaskManager().exec(task, Intl.intl("Transform Objects"), 1);
        }
        postOp.run();
    }

    private void applyToScenes(Consumer<ModelScene> function) {
        for (IPyroDisplayMgr dm : this.d_xformDispMgr.getDispManagers()) {
            for (RenderTarget target : RenderTarget.values()) {
                dm.getScenes().apply(target).ifPresent(function);
            }
        }
    }
}

