/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.mv.manip;

import java.util.Set;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.tasks.AReplaceRefTask;
import pyrosim.geom.Geometry;
import pyrosim.mv.ModelView;
import pyrosim.mv.displays.DisplayFilter;
import pyrosim.mv.displays.DisplayManager;
import pyrosim.mv.displays.HandleDispMgr;
import thunderheadeng.geometry.IMutableGeomSrc;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.scene3d.IDisplayMgr;
import thunderheadeng.scene3d.geom.IDisplayableGeomSrc;
import thunderheadeng.scene3d.manip.HandleGroup;
import thunderheadeng.scene3d.manip.IManipListener;
import thunderheadeng.scene3d.manip.ManipEvent;
import thunderheadeng.scene3d.manip.ManipMgr;
import thunderheadeng.scene3d.nativebuffered.ModelScene;
import thunderheadeng.util.Events;
import thunderheadeng.util.IEventRecord;
import thunderheadeng.util.Task;

public class ManipHook
implements IManipListener {
    private final PyroMod d_domain;
    private final ManipMgr d_manipMgr;

    public ManipHook(PyroMod domain, ModelView mv, DisplayManager dispMgr, ModelScene handleScene, DisplayFilter displayFilter) {
        this.d_domain = domain;
        HandleDispMgr handleDispMgr = new HandleDispMgr(domain, handleScene, displayFilter);
        this.d_manipMgr = new ManipMgr(domain.getEvents(), PyroSim.getApp().getPrefs(), dispMgr, handleDispMgr, new ManipMgr.IAppHook(){

            @Override
            public void updateVisibilityIfNeeded(Events events, IDisplayMgr<HandleGroup> handleDispMgr) {
            }

            @Override
            public void addSearch(IDisplayableGeomSrc obj) {
                ManipHook.this.d_domain.getGeomLocator().add(obj);
            }

            @Override
            public void removeSearch(IDisplayableGeomSrc obj) {
                ManipHook.this.d_domain.getGeomLocator().remove(obj);
            }

            @Override
            public <T> boolean isSelectionEvent(IEventRecord<T> pevts) {
                return pevts.containsChange(PyroMod.EVT_SEL);
            }

            @Override
            public boolean isResetEvent(Events events) {
                IEventRecord<PyroMod> pyroEvts = events.getEvents(PyroMod.class, new Class[0]);
                return pyroEvts.containsChange(PyroMod.EVT_MODEL_CHANGED);
            }

            @Override
            public <T> Set<T> getSelected(Class<T> type) {
                return ManipHook.this.d_domain.getSelectionModel().getSelected(type);
            }
        });
        this.d_manipMgr.addListener(this);
    }

    public ManipMgr getManager() {
        return this.d_manipMgr;
    }

    @Override
    public void manipChanged(ManipEvent evt) {
        ManipEvent.Type type = evt.getType();
        switch (type) {
            case MANIP_STARTED: {
                this.begin();
                break;
            }
            case HANDLES_MODIFIED: {
                break;
            }
            case ACTIVE_HANDLE_CHANGED: {
                break;
            }
            case MANIP_ENDED: {
                this.end();
                if (!evt.isCommitted()) break;
                this.commit(this.d_manipMgr.getCurrentManipObj(), evt.getNewNode());
                break;
            }
        }
    }

    protected void begin() {
    }

    protected void end() {
    }

    protected void commit(final IMutableGeomSrc src, IGeomNode newGeom) {
        newGeom = Geometry.finalize(newGeom, true);
        AReplaceRefTask<IGeomNode> t = new AReplaceRefTask<IGeomNode>(this, (Object)src.getGeom(), (Object)newGeom){

            @Override
            protected void set(IGeomNode obj) {
                src.setGeom(obj);
            }
        };
        this.d_domain.getTaskManager().exec((Task)t, Intl.intl("Edit Object"), 1);
    }
}

