/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.util;

import java.util.Set;
import pyrosim.legacy_2012_1.thunderheadeng.util.AcceptAllFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.IObjectFilter;
import pyrosim.legacy_2012_1.thunderheadeng.util.Sets;

public class Filters {
    public static <T> IObjectFilter<T> acceptNone(T obj) {
        return new AcceptNone(Sets.fromArrayHS(obj));
    }

    public static <T> IObjectFilter<T> acceptNone(Set<T> objs) {
        return new AcceptNone(objs);
    }

    public static <T> IObjectFilter<T> acceptOnly(T obj) {
        return new AcceptOnly(Sets.fromArrayHS(obj));
    }

    public static <T> IObjectFilter<T> acceptOnly(Set<T> objs) {
        return new AcceptOnly(objs);
    }

    public static <T> IObjectFilter<T> invert(IObjectFilter<T> filter) {
        if (filter instanceof InvertFilter) {
            return ((InvertFilter)filter).filter;
        }
        return new InvertFilter<T>(filter);
    }

    public static <T> IObjectFilter<T> acceptAll() {
        return AcceptAllFilter.INSTANCE;
    }

    public static <T> IObjectFilter<T> merge(IObjectFilter<T> f1, IObjectFilter<T> f2) {
        return Filters.merge(f1, f2, Logic.ACCEPT_ALL);
    }

    public static <T> IObjectFilter<T> merge(IObjectFilter<T> f1, IObjectFilter<T> f2, Logic logic) {
        if (f1 == f2) {
            return f1;
        }
        if (f1 == null) {
            return f2;
        }
        if (f2 == null) {
            return f1;
        }
        if (f1 instanceof AcceptAllFilter) {
            if (logic == Logic.ACCEPT_ALL) {
                return f2;
            }
            return f1;
        }
        if (f2 instanceof AcceptAllFilter) {
            if (logic == Logic.ACCEPT_ALL) {
                return f1;
            }
            return f2;
        }
        return new CompoundFilter<T>(f1, f2, logic);
    }

    public static class AcceptNone<T>
    implements IObjectFilter<T> {
        public final Set<?> toExclude;

        public AcceptNone(Set<?> toExclude) {
            this.toExclude = toExclude;
        }

        @Override
        public boolean shouldFilter(T o) {
            return this.toExclude.contains(o);
        }
    }

    public static class AcceptOnly<T>
    implements IObjectFilter<T> {
        public final Set<?> toInclude;

        public AcceptOnly(Set<?> toInclude) {
            this.toInclude = toInclude;
        }

        @Override
        public boolean shouldFilter(T o) {
            return !this.toInclude.contains(o);
        }
    }

    public static class InvertFilter<T>
    implements IObjectFilter<T> {
        public final IObjectFilter<T> filter;

        public InvertFilter(IObjectFilter<T> filter) {
            this.filter = filter;
        }

        @Override
        public boolean shouldFilter(T o) {
            return !this.filter.shouldFilter(o);
        }
    }

    public static enum Logic {
        ACCEPT_ANY,
        ACCEPT_ALL;

    }

    public static class CompoundFilter<T>
    implements IObjectFilter<T> {
        public final IObjectFilter<? super T> f1;
        public final IObjectFilter<? super T> f2;
        public final Logic logic;

        public CompoundFilter(IObjectFilter<? super T> f1, IObjectFilter<? super T> f2) {
            this(f1, f2, Logic.ACCEPT_ALL);
        }

        public CompoundFilter(IObjectFilter<? super T> f1, IObjectFilter<? super T> f2, Logic logic) {
            this.f1 = f1;
            this.f2 = f2;
            this.logic = logic;
        }

        @Override
        public boolean shouldFilter(T o) {
            switch (this.logic) {
                case ACCEPT_ALL: {
                    return this.f1.shouldFilter(o) || this.f2.shouldFilter(o);
                }
            }
            return this.f1.shouldFilter(o) && this.f2.shouldFilter(o);
        }
    }
}

