/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.legacy_2012_1.thunderheadeng.util;

import java.util.Collection;
import pyrosim.legacy_2012_1.thunderheadeng.util.theUtil;

public class PropertyUtil {
    public static final Object NON_UNIFORM = new Object();
    public static final Object NOT_SUPPORTED = new Object();

    public static <ObjT, PropT> Object getProperty(IProp<ObjT, PropT> prop, Collection<?> objs) {
        if (objs.isEmpty()) {
            return NOT_SUPPORTED;
        }
        Object val = NOT_SUPPORTED;
        for (Object obj : objs) {
            if (!prop.getType().isInstance(obj)) continue;
            Object sobj = obj;
            Object val2 = prop.get(sobj);
            if (val2 == NON_UNIFORM) {
                return NON_UNIFORM;
            }
            if (val2 == NOT_SUPPORTED) continue;
            if (val == NOT_SUPPORTED) {
                val = val2;
                continue;
            }
            if (prop.equal(val, val2)) continue;
            return NON_UNIFORM;
        }
        return val;
    }

    public static <ObjT, PropT> void setProperty(IProp<ObjT, PropT> prop, PropT value, Collection<?> objs) {
        for (Object member : objs) {
            if (!prop.getType().isInstance(member)) continue;
            prop.set(member, value);
        }
    }

    public static interface IProp<ObjT, PropT> {
        public Class<ObjT> getType();

        public void set(ObjT var1, PropT var2);

        public Object get(ObjT var1);

        public boolean equal(PropT var1, PropT var2);
    }

    public static abstract class AProp<ObjT, PropT>
    implements IProp<ObjT, PropT> {
        private final Class<ObjT> d_type;

        public AProp(Class<ObjT> type) {
            this.d_type = type;
        }

        @Override
        public Class<ObjT> getType() {
            return this.d_type;
        }

        @Override
        public boolean equal(PropT obj1, PropT obj2) {
            return theUtil.equal(obj1, obj2);
        }
    }
}

